 /*
  * Khoros: $Id: wid_util.c,v 1.4 1991/12/18 09:12:58 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: wid_util.c,v 1.4 1991/12/18 09:12:58 dkhoros Exp $";
#endif

 /*
  * $Log: wid_util.c,v $
 * Revision 1.4  1991/12/18  09:12:58  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "forms.h"
#include "actions.h"
#include "trans_tables.h"
#include "cr_bitmap"

#include	<X11/Xaw/SimpleMenu.h>
#include	<X11/Xaw/SmeBSB.h>
#include	<X11/Xaw/MenuButton.h>


static	Pixmap  cr_pixmap;


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>       	Xvform Widget Utilities			      <<<<
   >>>>                                                       <<<<
   >>>>         These routines are helper utilities to aid    <<<<
   >>>>         xvf_create_xxx routines in creating widgets.  <<<<
   >>>>                                                       <<<<
   >>>>		xvf_init_widgets()			      <<<<
   >>>>                                                       <<<<
   >>>>		Widget xvf_create_formback_widget()	      <<<<
   >>>>         Widget xvf_create_selback_widget()	      <<<<
   >>>>         Widget xvf_create_submenu_widget()	      <<<<
   >>>>         Widget xvf_create_button_widget()	      <<<<
   >>>>         Widget xvf_create_submenu_button_widget()     <<<<
   >>>>         Widget xvf_create_optional_button()	      <<<<
   >>>>         Widget xvf_create_label_widget()	      <<<<
   >>>>         Widget xvf_create_submenu_label_widget()      <<<<
   >>>>         Widget xvf_create_psuedo_label_widget()       <<<<
   >>>>         Widget xvf_create_glyph_widget()	      <<<<
   >>>>         Widget xvf_create_ascii_widget()	      <<<<
   >>>>         Widget xvf_create_cr_pixmap_widget()          <<<<
   >>>>         Widget xvf_create_scroll_widget()             <<<<
   >>>>         Widget xvf_create_wksp_widget()               <<<<
   >>>>                                                       <<<<
   >>>>         The next routines create & initialize an      <<<<
   >>>>         information structure.                        <<<<
   >>>>                                                       <<<<
   >>>>      Callback_Data *xvf_init_cb_data()                <<<<
   >>>>      IntScroll_Data *xvf_init_int_scroll_data()       <<<<
   >>>>      FloatScroll_Data *xvf_init_float_scroll_data()   <<<<
   >>>>                                                       <<<<
   >>>>         The last routine maintains the live sel list  <<<<
   >>>>                                                       <<<<
   >>>>    	      xvf_update_live_sel_list()	      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */


/************************************************************
*
*  Routine Name:  xvf_init_widgets()
*
*      Purpose:   Initializes the actions and translation tables
*		  used by the widget creation routines found in
*		  "createwid.c".  The action definitions and translation
*		  tables are declared in "action.h" and "trans_table.h"
*
*		  This routine also creates the "live" bitmap.  The
*		  cr_pixmap is used to indicate that a selection is
*		  activated when pressing the return key <cr>.
*
*	 Input:   None
*
*       Output:   None
*
*    Called by:   xvf_initialize()
*
*  Written By:    Mark Young & Danielle Argiro
*
*******************************************************************/


xvf_init_widgets()
{
	/*
	 *  Initialize the action tables.
	 */
	XtAppAddActions(xvf_app_context, liveinput_actionTable,
		XtNumber(liveinput_actionTable));
	XtAppAddActions(xvf_app_context, ansinfile_actionTable,
		XtNumber(ansinfile_actionTable));
	XtAppAddActions(xvf_app_context, ansoutfile_actionTable,
		XtNumber(ansoutfile_actionTable));
	XtAppAddActions(xvf_app_context, liveoutput_actionTable, 
		XtNumber(liveoutput_actionTable));
	XtAppAddActions(xvf_app_context, intscroll_actionTable, 
		XtNumber(intscroll_actionTable));
	XtAppAddActions(xvf_app_context, liveint_actionTable, 
		XtNumber(liveint_actionTable));
	XtAppAddActions(xvf_app_context, float_actionTable, 
		XtNumber(float_actionTable));
	XtAppAddActions(xvf_app_context, livefloat_actionTable,
		XtNumber(livefloat_actionTable));
	XtAppAddActions(xvf_app_context, livestring_actionTable,
		XtNumber(livestring_actionTable));

	/*
	 *  Build the translation tables.
	 */
	search_trans       = XtParseTranslationTable(search_trans_table);
	live_infile_trans  = XtParseTranslationTable(live_infile_trans_table);
	ansinfile_trans  = XtParseTranslationTable(ansinfile_trans_table);
	ansoutfile_trans  = XtParseTranslationTable(ansoutfile_trans_table);
	live_outfile_trans = XtParseTranslationTable(live_outfile_trans_table);
	int_scroll_trans   = XtParseTranslationTable(int_scroll_trans_table);
	live_int_trans     = XtParseTranslationTable(live_int_trans_table);
	float_scroll_trans = XtParseTranslationTable(float_scroll_trans_table);
	live_float_trans   = XtParseTranslationTable(live_float_trans_table);
	live_string_trans  = XtParseTranslationTable(live_string_trans_table);

	/*
	 *  Create the "live" bitmap.  This bitmap is used on the form to show
	 *  that a selection is live.  Meaning that the user uses the return
	 *  key to activate the "live" selection.
	 */
	cr_pixmap = XCreateBitmapFromData(xvf_display, 
		    XRootWindow(xvf_display, xvf_screen_num),
		    cr_bitmap_bits, cr_bitmap_width, cr_bitmap_height);

        xvf_cursor = XCreateFontCursor(xvf_display, XC_left_ptr);

}


/************************************************************
*
*  Routine Name:  xvf_create_formback_widget()
*
*      Purpose:   Creates a backplane widget of type formWidgetClass
*		  to be the backplane of a form
*
*	 Input:   parent - parent of the backplane widget
*		  x      - x location (in pixels) of widget
*		  y      - y location (in pixels) of widget
*		  width  - width      (in pixels) of widget
*		  height - height     (in pixels) of widget
*		  name   - name to reference backplane widget
*
*       Output:   returns the backpane widget
*
*  Written By:    Stephanie Hallett & Danielle Argiro
*
*******************************************************************/

Widget xvf_create_formback_widget(parent, x, y, width, height, name, mapped)
Widget parent;
int    x, y, width, height;
char   *name;
int    mapped;
{
   int i;
   Arg arg[MaxArgs];
   Widget back;

   i = 0;

   XtSetArg(arg[i],XtNwidth,(Dimension) width);      			i++;
   XtSetArg(arg[i],XtNheight, (Dimension) height);			i++;  
   XtSetArg(arg[i],XtNhorizDistance, x);  				i++;
   XtSetArg(arg[i],XtNvertDistance,  y);   				i++;

   XtSetArg(arg[i],XtNborderWidth,1);					i++;
   XtSetArg(arg[i],XtNdefaultDistance,4);				i++;
   XtSetArg(arg[i],XtNresizable, True);					i++;
   if (mapped)
   {
       XtSetArg(arg[i],XtNmappedWhenManaged,True);          		i++;
   }
   else
   {
       XtSetArg(arg[i],XtNmappedWhenManaged,False);          		i++;
   }
   back = XtCreateManagedWidget(name,formWidgetClass, parent,arg,i);

   return(back);
   
}



/************************************************************
*
*  Routine Name:  xvf_create_selback_widget()
*
*      Purpose:   Creates a backplane widget of type formWidgetClass
*		  to be the backplane of a selection
*
*	 Input:   parent - parent of the backplane widget
*		  x      - x location (in pixels) of widget
*		  y      - y location (in pixels) of widget
*		  width  - width      (in pixels) of widget
*		  height - height     (in pixels) of widget
*		  name   - name to reference backplane widget
*
*       Output:   returns the backpane widget
*
*  Written By:    Stephanie Hallett & Danielle Argiro
*
*******************************************************************/

Widget xvf_create_selback_widget(parent, x, y, width, height, name)
Widget parent;
int    x, y, width, height;
char   *name;
{
   int i;
   Arg arg[MaxArgs];
   Widget back;
 
   i = 0;
   XtSetArg(arg[i], XtNwidth,  (Dimension) width);        		i++;	
   XtSetArg(arg[i], XtNheight, (Dimension) height);      		i++; 	

   XtSetArg(arg[i], XtNhorizDistance, x);         			i++;
   XtSetArg(arg[i], XtNvertDistance,  y);         			i++;

   XtSetArg(arg[i], XtNresizable, True);				i++;
   XtSetArg(arg[i], XtNmappedWhenManaged,True);          		i++;
   XtSetArg(arg[i], XtNborderWidth,0);                    		i++;
   XtSetArg(arg[i], XtNdefaultDistance,0);				i++;
   back = XtCreateManagedWidget(name, formWidgetClass, parent,arg,i);

   return(back);
}

/************************************************************
*
*  Routine Name:  xvf_create_submenu_widget()
*
*      Purpose:   Creates a submenu widget of type simpleMenuWidgetClass
*		  and one of menuButtonWidgetClass
*
*	 Input:   parent - parent of the backplane widget
*		  x      - x location (in pixels) of widget
*		  y      - y location (in pixels) of widget
*		  width  - width      (in pixels) of widget
*		  height - height     (in pixels) of widget
*		  label  - label to display on button widget
*		  font   - font to be used
*		  name   - name to reference backplane widget
*
*       Output:   returns the button widget
*
*  Written By:    Mark Young & Danielle Argiro
*
*******************************************************************/

Widget xvf_create_submenu_widget(parent, x, y, width, height, 
				  label, font, name)
Widget 	    parent;
int    	     x, y, width, height;
char	    *label;
XFontStruct *font;
char   	    *name;

{
   int    i;
   Arg    arg[MaxArgs];
   Widget menubutton, submenu;

   i = 0;
   XtSetArg(arg[i],XtNlabel, label);					i++;
   XtSetArg(arg[i],XtNmenuName, label); 				i++;
   XtSetArg(arg[i],XtNwidth,  (Dimension) width);   			i++; 	
   XtSetArg(arg[i],XtNheight, (Dimension) height); 			i++;
   XtSetArg(arg[i],XtNfromVert,  NULL);		     	  		i++;
   XtSetArg(arg[i],XtNfromHoriz, NULL);		  	  		i++;
   XtSetArg(arg[i],XtNhorizDistance, x);        			i++;
   XtSetArg(arg[i],XtNvertDistance,  y);     				i++;
   XtSetArg(arg[i],XtNresizable, True);					i++;
   XtSetArg(arg[i],XtNborderWidth, 3);					i++;
   if (font != NULL)
   {
        XtSetArg(arg[i],XtNfont,font);               	     		i++;	
   }
   menubutton = XtCreateManagedWidget(name, menuButtonWidgetClass, parent,
				      arg, i);

   i = 0;
   XtSetArg(arg[i],XtNbottomMargin, 3);					i++;
   XtSetArg(arg[i],XtNtopMargin, 3);					i++;
   if (font != NULL)
   {
        XtSetArg(arg[i],XtNfont,font);               	     		i++;	
   }
   if (xvf_visual != NULL)
   {
        XtSetArg(arg[i],XtNvisual, xvf_visual);				i++;	
   }
   if (xvf_colormap != NULL)
   {
        XtSetArg(arg[i],XtNcolormap, xvf_colormap);			i++;	
   }
   submenu = XtCreatePopupShell(label, simpleMenuWidgetClass, 
				menubutton, arg, i);
   (void) XtCreateManagedWidget("blank", smeObjectClass, submenu, NULL, 0);

   return(submenu);
}

/************************************************************
*
*  Routine Name:  xvf_create_button_widget()
*
*      Purpose:   Creates a button widget of type commandWidgetClass
*
*	 Input:   parent - parent of the backplane widget
*		  x      - x location (in pixels) of widget
*		  y      - y location (in pixels) of widget
*		  width  - width      (in pixels) of widget
*		  height - height     (in pixels) of widget
*		  label  - label to display on button widget
*		  font   - font to be used
*		  name   - name to reference backplane widget
*
*       Output:   returns the button widget
*
*  Written By:    Stephanie Hallett & Danielle Argiro
*
*******************************************************************/

Widget xvf_create_button_widget(parent, x, y, width, height, 
				 label, font, name)
Widget 	    parent;
int    	     x, y, width, height;
char	    *label;
XFontStruct *font;
char   	    *name;

{
   int i;
   Arg arg[MaxArgs];
   Widget button;

   i = 0;
   XtSetArg(arg[i],XtNlabel, label);   					i++;
   XtSetArg(arg[i],XtNwidth,  (Dimension) width);   			i++; 	
   XtSetArg(arg[i],XtNheight, (Dimension) height); 			i++;
   XtSetArg(arg[i],XtNfromVert,  NULL);		     	  		i++;
   XtSetArg(arg[i],XtNfromHoriz, NULL);		  	  		i++;
   XtSetArg(arg[i],XtNhorizDistance, x);        			i++;
   XtSetArg(arg[i],XtNvertDistance,  y);     				i++;
   XtSetArg(arg[i],XtNresizable, True);					i++;
   if (font != NULL)
   {
        XtSetArg(arg[i],XtNfont,font);               	     		i++;	
   }
   button = XtCreateManagedWidget(name, commandWidgetClass, parent,arg,i);
   return(button);
}

/************************************************************
*
*  Routine Name:  xvf_create_submenu_button_widget()
*
*      Purpose:   Creates a button widget of type smeBSBObjectClass
*
*	 Input:   parent - parent of the backplane widget
*		  x      - x location (in pixels) of widget
*		  y      - y location (in pixels) of widget
*		  width  - width      (in pixels) of widget
*		  height - height     (in pixels) of widget
*		  label  - label to display on button widget
*		  font   - font to be used
*		  name   - name to reference backplane widget
*
*       Output:   returns the button widget
*
*  Written By:    Mark Young & Danielle Argiro
*
*******************************************************************/

Widget xvf_create_submenu_button_widget(parent, x, y, width, height, 
				         label, font, name)
Widget 	    parent;
int    	     x, y, width, height;
char	    *label;
XFontStruct *font;
char   	    *name;

{
   int	  i;
   Arg	  arg[MaxArgs];
   Widget button;

   i = 0;
   XtSetArg(arg[i],XtNlabel, label);   					i++;
   XtSetArg(arg[i],XtNleftMargin, 10);					i++;
   XtSetArg(arg[i],XtNrightMargin, 10);					i++;
   XtSetArg(arg[i],XtNvertSpace, 75);					i++;
   XtSetArg(arg[i],XtNresizable, True);					i++;
   if (font != NULL)
   {
        XtSetArg(arg[i],XtNfont,font);               	     		i++;	
   }
   button = XtCreateManagedWidget(name, smeBSBObjectClass, parent, arg, i);
   return(button);
}


/************************************************************
*
*  Routine Name:  xvf_create_optional_button()
*
*      Purpose:   Creates a little square button widget of type 
*		  commandWidgetClass, used for indicating if selections
*		  are optional  
*
*	 Input:   parent - parent of the backplane widget
*		  xpos   - x offset (in pixels) of widget
*		  ypos   - y offset (in pixels) of widget
*		  width  - width    (in pixels) of widget
*		  height - height   (in pixels) of widget
*		  font   - font to be used
*
*       Output:   returns the button widget
*
*  Written By:    Stephanie Hallett & Danielle Argiro
*
*************************************************************/

Widget xvf_create_optional_button(parent, xpos, ypos, width, height)
Widget      parent;
int    	    xpos, ypos, width, height;
{
      Widget  opt_button;
      int     i;
      Arg     arg[MaxArgs];

      i = 0;
      XtSetArg(arg[i],XtNwidth,(Dimension) width);        	i++;
      XtSetArg(arg[i],XtNheight, (Dimension) height); 		i++;
      XtSetArg(arg[i],XtNhorizDistance,xpos);        		i++;
      XtSetArg(arg[i],XtNvertDistance,ypos);			i++;
      XtSetArg(arg[i],XtNlabel," ");                         	i++;	
      XtSetArg(arg[i],XtNresizable, True);			i++;
      opt_button = XtCreateManagedWidget("opt_button",
		   commandWidgetClass, parent,arg,i);
      return(opt_button);
}

/************************************************************
*
*  Routine Name:  xvf_create_boolean_widget()
*
*      Purpose:   Creates a little button widget of type 
*		  commandWidgetClass, used for indicating if a 
*		  logical selection's value is true or false
*
*	 Input:   parent - parent of the backplane widget
*		  xpos   - x offset (in pixels) of widget
*		  ypos   - y offset (in pixels) of widget
*		  height - height   (in pixels) of widget
*		  font   - font to be used
*
*       Output:   returns the button widget
*
*  Written By:    Stephanie Hallett & Danielle Argiro
*
*************************************************************/

Widget xvf_create_boolean_widget(parent, xpos, ypos, width, height, font, title)
Widget      parent;
int    	     xpos, ypos, width, height;
XFontStruct *font;
char	    *title;
{
      int     i;
      Arg     arg[MaxArgs];
      Widget  boolean_button;

      i = 0;
      XtSetArg(arg[i],XtNheight, (Dimension) height); 		i++;
      XtSetArg(arg[i],XtNwidth, (Dimension) width); 		i++;
      XtSetArg(arg[i],XtNhorizDistance,xpos);        		i++;
      XtSetArg(arg[i],XtNvertDistance,ypos);			i++;
      XtSetArg(arg[i],XtNlabel,title);                         	i++;	
      XtSetArg(arg[i],XtNshapeStyle,  XmuShapeOval);		i++;    
      XtSetArg(arg[i],XtNresizable, True);			i++;
      if (font != NULL)
      {
          XtSetArg(arg[i],XtNfont,font);      	            	i++;	
      }
      boolean_button = XtCreateManagedWidget("boolean_button",
		        commandWidgetClass,parent,arg,i);
      return(boolean_button);
}

/************************************************************
*
*  Routine Name:  xvf_create_label_widget()
*
*      Purpose:   Creates a widget of type labelWidgetClass
*		  that is used to label a selection.  
*
*	 Input:   parent - parent of the backplane widget
*		  xpos   - x offset (in pixels) to label
*		  ypos   - y offset (in pixels) to label
*		  width  - width    (in pixels) of label to display 
*		  height - height   (in pixels) of label to display 
*		  label  - label to display in label widget
*		  font   - font to be used
*		  name         - name to reference label widget
*		  left_justify - flag TRUE if label is to be left justified
*				      FALSE if label is to be centered
*		  mapped       - flag TRUE if used for backplane -
*				      will set XtNMappedWhenManaged
*
*       Output:   returns the label widget
*
*  Written By:    Stephanie Hallett & Danielle Argiro
*
*******************************************************************/

Widget xvf_create_label_widget(parent, xpos, ypos, width, height,
				label, font, name, 
				left_justify, mapped)
Widget 	     parent;
int    	     xpos, ypos;
int    	     width, height;
char   	    *label;
XFontStruct *font;
char	    *name;
int	     left_justify, mapped;
{
      int     i;
      Arg     arg[MaxArgs];
      Widget  label_widget;

      i = 0;
      if (label != NULL)
      {
         XtSetArg(arg[i],XtNwidth,  (Dimension) width);			i++;
         XtSetArg(arg[i],XtNheight, (Dimension) height);		i++; 
         XtSetArg(arg[i],XtNlabel,  xvf_strcpy(label));  	    	i++;
      }
      else
      {
         XtSetArg(arg[i],XtNlabel," ");				    	i++;
      }

      XtSetArg(arg[i],XtNfromVert, NULL);                    	    	i++;
      XtSetArg(arg[i],XtNfromHoriz,NULL);                    	    	i++;
      XtSetArg(arg[i],XtNhorizDistance, xpos);      			i++;
      XtSetArg(arg[i],XtNvertDistance,  ypos);   			i++;
      XtSetArg(arg[i],XtNborderWidth,0);                    	    	i++;
      XtSetArg(arg[i],XtNresizable, True);				i++;

      if (left_justify)
      {
         XtSetArg(arg[i],XtNjustify,XtJustifyLeft);                    	i++;
      }

      if (mapped)
      {
         XtSetArg(arg[i],XtNmappedWhenManaged,True);                 	i++;
      }

      if (font != NULL)
      {
          XtSetArg(arg[i],XtNfont,font);               	            	i++;	
      }
      label_widget =   XtCreateManagedWidget(name, labelWidgetClass,
					     parent,arg,i);

      return(label_widget);
}

/************************************************************
*
*  Routine Name:  xvf_create_submenu_label_widget()
*
*      Purpose:   Creates a widget of type labelWidgetClass
*		  that is used to label a selection.  
*
*	 Input:   parent - parent of the backplane widget
*		  xpos   - x offset (in pixels) to label
*		  ypos   - y offset (in pixels) to label
*		  width  - width    (in pixels) of label to display 
*		  height - height   (in pixels) of label to display 
*		  label  - label to display in label widget
*		  font   - font to be used
*		  name         - name to reference label widget
*		  left_justify - flag TRUE if label is to be left justified
*				      FALSE if label is to be centered
*		  mapped       - flag TRUE if used for backplane -
*				      will set XtNMappedWhenManaged
*
*       Output:   returns the label widget
*
*  Written By:    Stephanie Hallett & Danielle Argiro
*
*******************************************************************/

Widget xvf_create_submenu_label_widget(parent, xpos, ypos, width, height,
				       label, font, name, left_justify, mapped)
Widget 	     parent;
int    	     xpos, ypos;
int    	     width, height;
char   	    *label;
XFontStruct *font;
char	    *name;
int	     left_justify, mapped;
{
      int     i;
      Arg     arg[MaxArgs];
      Widget  label_widget;

      i = 0;
      if (label != NULL)
      {
         XtSetArg(arg[i],XtNwidth,  (Dimension) width);			i++;
         XtSetArg(arg[i],XtNheight, (Dimension) height);		i++; 
         XtSetArg(arg[i],XtNlabel,  xvf_strcpy(label));  	    	i++;
      }
      else
      {
         XtSetArg(arg[i],XtNlabel," ");				    	i++;
      }

      if (left_justify)
      {
         XtSetArg(arg[i],XtNjustify,XtJustifyLeft);                    	i++;
      }

      if (font != NULL)
      {
          XtSetArg(arg[i],XtNfont,font);               	            	i++;	
      }
      label_widget =   XtCreateManagedWidget(name, smeObjectClass,
					     parent,arg,i);
      return(label_widget);
}


/************************************************************
*
*  Routine Name:  xvf_create_psuedo_label_widget()
*
*      Purpose:   Creates a "label" widget of type commandWidgetClass
*		  that is used to label a selection.  A special case
*		  for when Input File selections need a command button
*		  as the label so that the browser can be called.
*
*	 Input:   parent - parent of the backplane widget
*		  xpos   - x offset (in pixels) to widget
*		  ypos   - y offset (in pixels) to widget
*		  width  - width    (in pixels) of widget
*		  height - height   (in pixels) of widget
*		  label  - label to display in label widget
*		  font   - font to be used
*		  left_justify - TRUE if label is to be left justified
*				 FALSE if label is to be centered
*
*       Output:   returns the label widget
*
*  Written By:    Stephanie Hallett & Danielle Argiro
*
*******************************************************************/

Widget xvf_create_psuedo_label_widget(parent, xpos, ypos, width, height,
				      label, font, left_justify)
Widget 	     parent;
int    	     xpos, ypos, width, height;
char   	    *label;
XFontStruct *font;
int	     left_justify;
{

      int     i;
      Arg     arg[MaxArgs];
      Widget  label_widget;

      i = 0;
      XtSetArg(arg[i],XtNwidth, (Dimension) width);  		i++;
      XtSetArg(arg[i],XtNheight,(Dimension) height);  		i++; 
      XtSetArg(arg[i],XtNlabel,  label);  	        	i++;
      XtSetArg(arg[i],XtNborderWidth,0);               	    	i++;
      XtSetArg(arg[i],XtNhorizDistance, xpos);     		i++;
      XtSetArg(arg[i],XtNvertDistance,  ypos);    		i++;
      XtSetArg(arg[i],XtNresizable, True);			i++;

      if (left_justify)
      {
         XtSetArg(arg[i],XtNjustify,XtJustifyLeft);           	i++;
      }

      if (font != NULL)
      {
          XtSetArg(arg[i],XtNfont,font);                       	i++;	
      }
      label_widget =   XtCreateManagedWidget("label_button",
			commandWidgetClass,parent,arg,i);
      return(label_widget);
}



/************************************************************
*
*  Routine Name:  xvf_create_glyph_widget()
*
*      Purpose:   Creates a "glyph" widget of type commandWidgetClass
*		  that is used to put the glyphing button on forms
*		  and single subforms.  
*
*	 Input:   parent - parent of the backplane widget
*		  xpos   - x offset (in pixels) to glyph
*		  ypos   - y offset (in pixels) to glyph
*		  width  - width    (in pixels) to glyph
*		  height - height   (in pixels) to glyph
*		  label  - label to display in glyph widget
*		  font   - font to be used
*
*       Output:   returns the label widget
*
*  Written By:    Stephanie Hallett & Danielle Argiro
*
*******************************************************************/

Widget xvf_create_glyph_widget(parent, xpos, ypos, width, 
				height, label, font)
Widget 	     parent;
char   	    *label;
int    	     xpos, ypos;
XFontStruct *font;
{
	int     i;
	Arg     arg[MaxArgs];
	Widget  glyph_button;

	 /* create glyph widget */
   	i = 0;
   	XtSetArg(arg[i],XtNwidth,  (Dimension) width);              i++;
   	XtSetArg(arg[i],XtNheight, (Dimension) height);             i++;
   	XtSetArg(arg[i],XtNfromVert, NULL);                   	    i++;
   	XtSetArg(arg[i],XtNfromHoriz, NULL);                  	    i++;
   	XtSetArg(arg[i],XtNhorizDistance, xpos);                    i++;
   	XtSetArg(arg[i],XtNvertDistance,  ypos);                    i++;
   	XtSetArg(arg[i],XtNlabel, label);                           i++;
        XtSetArg(arg[i],XtNresizable, True);			    i++;

        if (font != NULL)
        {
          XtSetArg(arg[i],XtNfont,font);                       	i++;	
        }

   	glyph_button = XtCreateManagedWidget(label, commandWidgetClass,
					     parent,arg,i);
	return(glyph_button);
}


/************************************************************
*
*  Routine Name:  xvf_create_simple_widget()
*
*      Purpose:   Creates a simple glyph widget of type commandWidgetClass
*		  that is used to put on the glyph that unglyph's a form or
*		  or single subform.  
*
*	 Input:   parent - parent of the backplane widget
*		  xpos   - x offset (in pixels) to glyph
*		  ypos   - y offset (in pixels) to glyph
*		  width  - width    (in pixels) to glyph
*		  height - height   (in pixels) to glyph
*		  label  - label to display in glyph widget
*		  font   - font to be used
*
*       Output:   returns the label widget
*
*  Written By:    Stephanie Hallett & Danielle Argiro
*
*******************************************************************/

Widget xvf_create_simple_widget(parent, xpos, ypos, width,
				height, label, font)
Widget 	     parent;
char   	    *label;
int    	     xpos, ypos, width, height;
XFontStruct *font;
{
	int	i;
	Arg     arg[MaxArgs];
	Widget  glyph_widget;

	/*  create simple glyph widget */
        i = 0;
	XtSetArg(arg[i],XtNwidth, (Dimension) width);		i++;
   	XtSetArg(arg[i],XtNheight, (Dimension) height);         i++;
   	XtSetArg(arg[i],XtNfromVert, NULL);               	i++;
   	XtSetArg(arg[i],XtNfromHoriz, NULL);                  	i++;
   	XtSetArg(arg[i],XtNhorizDistance, xpos);                i++;
   	XtSetArg(arg[i],XtNvertDistance,  ypos);                i++;
	XtSetArg(arg[i],XtNlabel, label);		 	i++;
        XtSetArg(arg[i],XtNresizable, True);			i++;

        if (font != NULL)
        {
          XtSetArg(arg[i],XtNfont,font);                       	i++;	
        }
	glyph_widget = XtCreateManagedWidget(label, commandWidgetClass,
			                     parent, arg, i);
	return(glyph_widget);
}


/************************************************************
*
*  Routine Name:  xvf_create_ascii_widget()
*
*      Purpose:   Creates a parameter box widget of type asciiStringWidgetClass
*		  this type of widget is used for entering strings and values.
*
*	 Input:   parent - parent of the backplane widget
*		  x      - x location (in pixels) of widget
*		  y      - y location (in pixels) of widget
*		  width  - width      (in pixels) of widget
*		  height - height     (in pixels) of widget
*		  def_string  - default string to display on button widget
*		  spec     - flag TRUE for special case if called by
*			     xvf_create_string_sel w/ geometry height > 1.
*			     will set special attributes to scroll, etc.
*		  translations -  the default translations for the ascii
*				  widget.  If NULL then all default trans-
*				  will be used.
*
*       Output:   returns the button widget
*
*  Written By:    Stephanie Hallett & Danielle Argiro
*
*******************************************************************/

Widget xvf_create_ascii_widget(parent, x, y, width, height, 
				def_string, font, spec, translations)
Widget 	    parent;
int    	    x, y, width, height;
char       *def_string;
XFontStruct *font;
int        spec;
XtTranslations translations;
{
	int     i;
	Arg     arg[MaxArgs];
	Widget  ascii_widget;

        i = 0;
      	XtSetArg(arg[i],XtNeditType,XawtextEdit);		i++;
        XtSetArg(arg[i],XtNtype,XawAsciiString);		i++;
        XtSetArg(arg[i],XtNstring, def_string);			i++;
        XtSetArg(arg[i],XtNresizable, True);			i++;
        XtSetArg(arg[i],XtNinsertPosition, xvf_strlen(def_string));	i++;
     	XtSetArg(arg[i],XtNwidth,(Dimension) width);     	i++;
     	XtSetArg(arg[i],XtNheight,(Dimension) height);     	i++;
	XtSetArg(arg[i],XtNhorizDistance, x);			i++;
      	XtSetArg(arg[i],XtNvertDistance,  y);			i++;
        if (font != NULL)
	{
          XtSetArg(arg[i],XtNfont,font);                       	i++;	
	}

 	if (spec)
        {
	     XtSetArg(arg[i], XtNscrollVertical, 
			XawtextScrollWhenNeeded);   		i++;
	}
	else
	{
          XtSetArg(arg[i],XtNpieceSize, 50);			i++;
	}
	ascii_widget = XtCreateManagedWidget("value", asciiTextWidgetClass,
					      parent, arg, i);

	if (translations != NULL)
	   XtOverrideTranslations(ascii_widget, translations);

	return(ascii_widget);
}



/************************************************************
*
*  Routine Name:  xvf_create_cr_pixmap_widget()
*
*      Purpose:   Used for "live" InputFile, OutputFile, and String
*		  selections, this routine creates a small, square widget 
*		  of type labelWidgetClass, containing a pixmap that 
*		  represents a carriage return.
*
*	 Input:   parent - parent of the backplane widget
*		  x      - x location (in pixels) of widget
*
*       Output:   returns the pixmap widget
*
*  Written By:    Danielle Argiro
*
*******************************************************************/

Widget xvf_create_cr_pixmap_widget(parent, offset)
Widget parent;
Widget offset;
{
	Widget  live_pixmap_widget;
	Arg     arg[MaxArgs];
	int     i;

	i = 0;
	XtSetArg(arg[i],XtNwidth,(Dimension) cr_bitmap_width+4);	i++;
	XtSetArg(arg[i],XtNheight,(Dimension) cr_bitmap_height+1); 	i++;
	XtSetArg(arg[i],XtNborderWidth,(Dimension) 0); 	 	        i++;
	XtSetArg(arg[i],XtNbitmap, cr_pixmap); 				i++;
        XtSetArg(arg[i],XtNfromHoriz, offset);	  	  		i++;
        XtSetArg(arg[i],XtNresizable, True);				i++;
	live_pixmap_widget = XtCreateManagedWidget("livepixmap",
               			labelWidgetClass,parent,arg,i);
	return(live_pixmap_widget);
}


/************************************************************
*
*  Routine Name:  xvf_create_scroll_widget()
*
*      Purpose:   Used for "live" selections, this routine creates a 
*		  scroll bar widget of type scrollbarWidgetClass.
*
*	 Input:   parent - parent of the backplane widget
*		  x      - x location (in pixels) of widget
*		  y      - y location (in pixels) of widget
*		  width  - width      (in pixels) of widget
*		  height - height     (in pixels) of widget
*		  percent- percentage of scroll bar initially covered by thumb
*		  name   - name to reference scroll widget by 
*
*       Output:   returns the pixmap widget
*
*  Written By:    Danielle Argiro
*
************************************************************/

Widget xvf_create_scroll_widget(parent, x, y, width, height, percent, name)
Widget parent;
int    x, y, width, height;
float  percent;
char   *name; 
{
	Widget  scroll_widget;
	Arg     arg[MaxArgs];
	int     i;

	i = 0;
	XtSetArg(arg[i], XtNhorizDistance, x);         		i++;
	XtSetArg(arg[i], XtNy, y);             			i++;
	XtSetArg(arg[i], XtNorientation, XtorientHorizontal);  	i++;
	XtSetArg(arg[i], XtNwidth,(Dimension) width);    	i++;
	XtSetArg(arg[i], XtNheight, (Dimension) height);        i++;  
        XtSetArg(arg[i],XtNresizable, True);			i++;

	scroll_widget = XtCreateManagedWidget(name,
               		 scrollbarWidgetClass,parent,arg,i);

	return(scroll_widget);
}


/************************************************************
*
*  Routine Name:  xvf_create_wksp_widget()
*
*      Purpose:   Creates a workspace widget of type formWidgetClass
*		  to be used by the application programmer as desired.
*
*	 Input:   parent - parent of the backplane widget
*		  x      - x location (in pixels) of widget
*		  y      - y location (in pixels) of widget
*		  width  - width      (in pixels) of widget
*		  height - height     (in pixels) of widget
*		  label  - label for the workspace widget
*		  font   - font in which label shall appear
*		  name   - name to reference backplane widget - note that 
*			   this name comes from the variable on the -w line 
*
*       Output:   returns the workspace widget
*
*  Written By:    Stephanie Hallett & Danielle Argiro
*
*******************************************************************/

Widget xvf_create_wksp_widget(parent, width, height, name, vert_offset)
Widget      parent;
int         width, height;
char        *name;
Widget      vert_offset;
{
   int i;
   Arg arg[MaxArgs];
   Widget back;

   i = 0;

   XtSetArg(arg[i],XtNwidth,(Dimension) width);      			i++;
   XtSetArg(arg[i],XtNheight, (Dimension) height);			i++;  
   if (vert_offset != NULL)
   {
      XtSetArg(arg[i],XtNfromVert,  vert_offset); 			i++;
   }
   XtSetArg(arg[i],XtNmappedWhenManaged,True);          		i++;
   XtSetArg(arg[i],XtNborderWidth,1);					i++;
   XtSetArg(arg[i],XtNresizable, True);					i++;

   back = XtCreateManagedWidget(name,formWidgetClass, parent,arg,i);
   return(back);
   
}



/************************************************************
*
*  Routine Name:  xvf_init_cb_data()
*
*      Purpose:   Creates & initializes the Callback Data structure 
*		  for a widget according to parameters that are passed in.
*
*	 Input:   database - pointer to the internal database struct
*		  index - index of the database line that specifies the widget
*			  that will use this cb_data struct
*		  form  - pointer to the form tree that the widget that will
*			  use this cb_data struct appears on
*		  subform  - pointer to the subform structure that the widget 
*			     that will use this cb_data struct appears on
*		  guide - pointer to the guide button struct that contains
*			  the pane struct that the widget that will
*			  use this cb_data struct appears on
*		  selection - pointer to the xvf_selection struct that contains
*			      the widget that will use cb_data struct appears on
*		  toggle_flg - TRUE if the selection that this widget is part
*			       of is part of a toggle
*		  toggle_start - a valid xvf_selection address if the widget
*				 that will use this cb_data is part of a 
*				 selection that is part of a toggle
*		  
*
*       Output:   a pointer to the new Callback data structure
*
*  Written By:    Danielle Argiro
*
*******************************************************************/

Callback_Data *xvf_init_cb_data(form, subform,	guide, selection, 
				toggle_flg, toggle_start)
xvf_form  	 *form; 
xvf_sub_form  	 *subform; 
xvf_guide_button *guide; 
xvf_selection    *selection; 
int		  toggle_flg;
xvf_selection 	 *toggle_start;
{
   Callback_Data *cb_data;

   if (!(cb_data = (Callback_Data *) calloc(1,sizeof(Callback_Data))))
   {
      fprintf(stderr, "\nxvf_create_guide_sel: \n");
      fprintf(stderr, "  Could not allocate room for callback structure\n");
      return(NULL);
   }
   cb_data->formptr      = form;
   cb_data->subformptr   = subform;
   cb_data->guideptr     = guide;
   cb_data->selptr       = selection;
   cb_data->doing_toggle = toggle_flg;
   cb_data->toggle_start = toggle_start;

   return(cb_data);
}


/************************************************************
*
*  Routine Name:  xvf_init_int_scroll_data()
*
*      Purpose:   Creates & initializes the IntScroll_Data structure 
*		  for a widget according to parameters that are passed in.
*
*	 Input:   database - pointer to the internal database struct
*		  index - index of the database line that specifies the widget
*			  that will use this cb_data struct
*		  form  - pointer to the form tree that the widget that will
*			  use this cb_data struct appears on
*		  subform  - pointer to the subform structure that the widget 
*			     that will use this cb_data struct appears on
*		  guide - pointer to the guide button struct that contains
*			  the pane struct that the widget that will
*			  use this cb_data struct appears on
*		  int_min - minimum int value for int scroll bar
*		  int_max - maximum int value for int scroll bar
*		  int_value - current int value for int scroll bar
*		  max_int_length - max # characters integer will be
*		  width   - width (in pixels) of scroll bar
*		  increment - increment (in wc's) for incremental use of scroll
*		  int_val_widget - value widget associated w/ scroll bar
*		  int_scroll - scroll bar widget itself
*
*       Output:   a pointer to the new Callback data structure
*
*    Called by:   xvf_create_int_sel()
*
*  Written By:    Danielle Argiro
*
*******************************************************************/

IntScroll_Data *xvf_init_int_scroll_data(form, subform, guide, selection, 
			 int_min, int_max, int_value, max_int_length,
			 width, int_val_widget, int_scroll) 
xvf_form *form;
xvf_sub_form *subform;
xvf_guide_button *guide;
xvf_selection *selection;
int  int_min, int_max, int_value, max_int_length, width;
Widget int_val_widget, int_scroll;
{
	IntScroll_Data *int_scroll_data;

        if (!(int_scroll_data = (IntScroll_Data *)
                                      calloc(1,sizeof(IntScroll_Data))))
        {
            fprintf(stderr, "\nxvf_create_int_sel: \n");
            fprintf(stderr, "  Could not allocate room for scrollbar callback structure\n");
            return(NULL);
        }
   	int_scroll_data->formptr 	 = form;
   	int_scroll_data->subformptr 	 = subform;
        int_scroll_data->guideptr 	 = guide;
        int_scroll_data->selptr 	 = selection;
        int_scroll_data->int_min 	 = int_min;
        int_scroll_data->int_max    	 = int_max;
        int_scroll_data->int_value  	 = int_value;
        int_scroll_data->max_int_length  = max_int_length;
        int_scroll_data->interval 	 = int_max - int_min;
        int_scroll_data->bar_width 	 = width;
        int_scroll_data->increment	 = 12;
        int_scroll_data->int_val_widget = int_val_widget;
        int_scroll_data->int_scroll     = int_scroll;

	return(int_scroll_data);
}



/************************************************************
*
*  Routine Name:  xvf_init_float_scroll_data()
*
*      Purpose:   Creates & initializes the FloatScroll_Data structure 
*		  for a widget according to parameters that are passed in.
*
*	 Input:   database - pointer to the internal database struct
*		  index - index of the database line that specifies the widget
*			  that will use this cb_data struct
*		  form  - pointer to the form tree that the widget that will
*			  use this cb_data struct appears on
*		  subform  - pointer to the subform structure that the widget 
*			     that will use this cb_data struct appears on
*		  guide - pointer to the guide button struct that contains
*			  the pane struct that the widget that will
*			  use this cb_data struct appears on
*		  float_min - minimum float value for float scroll bar
*		  float_max - maximum float value for float scroll bar
*		  float_value - current int value for float scroll bar
*		  max_float_length - max # characters float will be
*		  width   - width (in pixels) of scroll bar
*		  increment - increment (in wc's) for incremental use of scroll
*		  float_val_widget - value widget associated w/ scroll bar
*		  float_scroll - scroll bar widget itself
*
*       Output:   a pointer to the new Callback data structure
*
*    Called by:   xvf_create_float_sel()
*
*  Written By:    Danielle Argiro
*
*******************************************************************/

FloatScroll_Data *xvf_init_float_scroll_data(form, subform, guide, selection, 
			 float_min, float_max, float_value, 
			 max_float_length, width, float_val_widget, 
			 float_scroll) 
xvf_form *form;
xvf_sub_form *subform;
xvf_guide_button *guide;
xvf_selection *selection;
float  float_min, float_max, float_value; 
int    max_float_length, width;
Widget float_val_widget, float_scroll;
{
	FloatScroll_Data *float_scroll_data;

        if (!(float_scroll_data = (FloatScroll_Data *)
                                      calloc(1,sizeof(FloatScroll_Data))))
        {
            fprintf(stderr, "\nxvf_create_float_sel: \n");
            fprintf(stderr, "  Could not allocate room for scrollbar callback structure\n");
            return(NULL);
        }
   	float_scroll_data->formptr 	 = form;
   	float_scroll_data->subformptr 	 = subform;
        float_scroll_data->guideptr 	 = guide;
        float_scroll_data->selptr 	 = selection;
        float_scroll_data->float_min 	 = float_min;
        float_scroll_data->float_max     = float_max;
        float_scroll_data->float_value   = float_value;
        float_scroll_data->max_float_length  = max_float_length;
        float_scroll_data->interval 	 = float_max - float_min;
        float_scroll_data->bar_width 	 = width;
        float_scroll_data->increment	 = 12;
        float_scroll_data->float_val_widget = float_val_widget;
        float_scroll_data->float_scroll     = float_scroll;

	return(float_scroll_data);
}



/************************************************************
*
*  Routine Name:  xvf_update_live_sel_list()
*
*      Purpose:   updates the live selection list of selections that are
*		  "live".  the list pairs a widget with it's cb data
*		  for use with XtActionProc's.
*
*	 Input:  live_val_widget - value widget associated w/ live selection
*		 cb_data - Callback_Data struct for the value widget 
*
*       Output:   
*
*  Written By:    Danielle Argiro
*
*******************************************************************/

xvf_update_live_sel_list(live_val_widget, cb_data)
Widget	      live_val_widget;
Callback_Data *cb_data;
{
	xvf_live_sel_link *live_sel_ptr;

        if (live_sel_list == NULL)
        {
            live_sel_list = (xvf_live_sel_link *)
                             malloc (sizeof(xvf_live_sel_link));
            live_sel_list->value_widget = live_val_widget;
            live_sel_list->live_data = cb_data;
            live_sel_list->next = NULL;
        }
        else
        {
            live_sel_ptr = live_sel_list;
            while (live_sel_ptr->next != NULL)
                   live_sel_ptr = live_sel_ptr->next;
            live_sel_ptr->next = (xvf_live_sel_link *)
                                  malloc (sizeof(xvf_live_sel_link));
            live_sel_ptr->next->value_widget = live_val_widget;
            live_sel_ptr->next->live_data = cb_data;
            live_sel_ptr->next->next = NULL;
         }
}


/************************************************************
*
*  Routine Name:  xvf_update_live_int_list()
*
*      Purpose:   updates the list of int selections that are
*		  "live".  the list pairs a widget with it's IntScroll data
*		  for use with XtActionProc's.
*
*	 Input:  live_val_widget - value widget associated w/ live selection
*		 int_scroll_data - IntScroll_Data struct for the value widget 
*
*  Written By:    Danielle Argiro
*
*******************************************************************/

xvf_update_live_int_list(live_val_widget, int_scroll_data)
Widget	         live_val_widget;
IntScroll_Data   *int_scroll_data;
{
	xvf_int_scroll_link *live_int_ptr;

        if (int_scroll_list == NULL)
        {
            int_scroll_list = (xvf_int_scroll_link *)
                             malloc (sizeof(xvf_int_scroll_link));
            int_scroll_list->int_value = live_val_widget;
            int_scroll_list->scroll_info = int_scroll_data;
            int_scroll_list->next = NULL;
        }
        else
        {
            live_int_ptr = int_scroll_list;
            while (live_int_ptr->next != NULL)
                   live_int_ptr = live_int_ptr->next;
            live_int_ptr->next = (xvf_int_scroll_link *)
                                  malloc (sizeof(xvf_int_scroll_link));
            live_int_ptr->next->int_value = live_val_widget;
            live_int_ptr->next->scroll_info = int_scroll_data;
            live_int_ptr->next->next = NULL;
         }
}


/************************************************************
*
*  Routine Name:  xvf_update_live_float_list()
*
*      Purpose:   updates the list of float selections that are
*		  "live".  the list pairs a widget with it's FloatScroll data
*		  for use with XtActionProc's.
*
*	 Input:  live_val_widget - value widget associated w/ live selection
*		 float_scroll_data - Callback_Data struct for the value widget 
*
*       Output:   
*
*  Written By:    Danielle Argiro
*
*******************************************************************/

xvf_update_live_float_list(live_val_widget, float_scroll_data)
Widget	         live_val_widget;
FloatScroll_Data *float_scroll_data;
{
	xvf_float_scroll_link *live_float_ptr;

        if (float_scroll_list == NULL)
        {
            float_scroll_list = (xvf_float_scroll_link *)
                             malloc (sizeof(xvf_float_scroll_link));
            float_scroll_list->float_value = live_val_widget;
            float_scroll_list->scroll_info = float_scroll_data;
            float_scroll_list->next = NULL;
        }
        else
        {
            live_float_ptr = float_scroll_list;
            while (live_float_ptr->next != NULL)
                   live_float_ptr = live_float_ptr->next;
            live_float_ptr->next = (xvf_float_scroll_link *)
                                  malloc (sizeof(xvf_float_scroll_link));
            live_float_ptr->next->float_value = live_val_widget;
            live_float_ptr->next->scroll_info = float_scroll_data;
            live_float_ptr->next->next = NULL;
         }
}
