 /*
  * Khoros: $Id: exit.c,v 1.3 1992/03/20 22:49:47 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: exit.c,v 1.3 1992/03/20 22:49:47 dkhoros Exp $";
#endif

 /*
  * $Log: exit.c,v $
 * Revision 1.3  1992/03/20  22:49:47  dkhoros
 * VirtualPatch5
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "xvutils.h"	


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    	    file name: exit.c	                      <<<<
   >>>>                                                       <<<<
   >>>>		  Create an Exit Widget			      <<<<
   >>>>                                                       <<<<
   >>>>                xvf_exit_wait()			      <<<<              
   >>>>                xvf_create_exit()		      <<<<              
   >>>>                xvf_exit_no()		      	      <<<<              
   >>>>                xvf_exit_canc()		      	      <<<<              
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


/************************************************************
*
*  Routine Name:  xvf_exit_wait(stmt,label,button1,button2, button3)
*
*      Purpose:   creates a "exit" form which has three
*                 choises (Yes = 1, NO = 0, Cancel = -1)
*                 NOTE: this routine will grab all events 
*                 while running.  
*
*        Input:   stmt     - string containing information
*			     for the user (may contain \n for
*                            returns, widget will put in
*                            returns as it needs).
*                 label    - short label for top of form.
*                            NULL will indicate use of default "EXITING".
*		  button1  - label for first button
*                            NULL will indicate use of default "Yes".
*		  button2  - label for first button
*                            NULL will indicate use of default "No".
*		  button3  - label for first button
*                            NULL will indicate use of default "Cancel".
*
*       Output:   EXIT_SIG (global variable) returned to caller will be:
*                      1 if user selected button1 (Yes), 
*		       0 if user selected button2 (No), 
*		      -1 if user selected button3 (Cancel).  
*
*		  This routine will NOT return to the calling program until 
*		  either Yes, No, or Cancel is chosen.
*
*    Called By:   the application program
*
*   Written By:   Stephanie Hallett
*
*
*************************************************************/

int xvf_exit_wait(stmt,label,button1,button2,button3)
char *stmt;
char *label;
char *button1,*button2,*button3;
{
   int xvf_create_exit();
   int status;

   EXIT_DONE = false;

   if (xvf_display == NULL)
   {
	fprintf(stderr, "%s\n", stmt);
	return(true);
   }
   status = xvf_create_exit(stmt,label,button1,button2,button3);

   if (status == false)
      return(false);

   while(!EXIT_DONE)
   {
      xvf_process_event();      /* this does XtNextEvent/DispatchEvent*/
   }
   return(EXIT_SIG);
}

/************************************************************
*
*  Routine Name:  xvf_create_exit(exit_string,exit_label,
*				  button1, button2, button3)
*
*      Purpose:   Does the  actual creation of an exit widget. 
*		  The exit widget consists of a form widget with a 
*		  label, text, and and three acknowledgement buttons.
*
*        Input:   exit_string   - the exit message 
*                 exit_label    - short label for top of widget
*                                 NULL will casue default of "EXIT"
*		  button1       - label for acknowledgement button
*                                 NULL will casue default of "Yes"
*		  button2       - label for acknowledgement button
*                                 NULL will casue default of "No"
*		  button3       - label for acknowledgement button
*                                 NULL will casue default of "Cancel"
*
*       Output:   wait for user to acknowledge message.
*
*    Called By:   xvf_exit_wait() or the application program
*
*   Written By:   Danielle Argiro Stephanie Hallett
*
*************************************************************/

#define TEXT_WIDTH  35
#define TEXT_HEIGHT 7

int xvf_create_exit(exit_string,exit_label,button1,button2,button3)
char *exit_string;
char *exit_label;
char *button1,*button2,*button3;
{
   Widget toplevel;	/* toplevel widget for message */
   Widget back;		/* backplane for message */
   Widget label;	/* label describing type of message */
   Widget yes_wid; 	/* button to select to go on (1) */
   Widget no_wid; 	/* button to select to stop action (0) */
   Widget canc_wid; 	/* button to select to cancel action (-1) */
   Arg    arg[25];
   int    i, width, height, total_width = 0;
   char name[MaxLength];
   char *top_name, *cap_top_name;
   void   xvf_exit_yes(), xvf_exit_no(), xvf_exit_canc();

   /*
    * create identifying widget name
    */
   sprintf(name,"%d_exit",Exit_cnt);
   Exit_cnt++;
   top_name = xvf_strcpy(name);
   cap_top_name = xvf_cap_first_letter(top_name);

   if (exit_label == NULL)
      exit_label = xvf_strcpy("EXITING:");

   /*
    * create the exit box's toplevel widget, and add it
    * to the list of toplevels that is used with journal playback.
    */
   i = 0;
   XtSetArg(arg[i], XtNscreen, xvf_screen); 		  i++;
   XtSetArg(arg[i], XtNargc, xvf_ac); 	                  i++;
   XtSetArg(arg[i], XtNargv, xvf_av);	          	  i++; 
   XtSetArg(arg[i], XtNwinGravity, StaticGravity);	  i++; 
   toplevel = XtAppCreateShell(top_name,cap_top_name,
	                       transientShellWidgetClass, xvf_display, arg, i);
   xvf_add_toplevel(toplevel);

   /*
    * create the backplane widget
    */
   i = 0;
   XtSetArg(arg[i],XtNmappedWhenManaged,True);        	i++; 
   XtSetArg(arg[i],XtNborderWidth,1);			i++;
   XtSetArg(arg[i],XtNdefaultDistance,4);		i++;
   back = XtCreateManagedWidget("form_back",
		formWidgetClass, toplevel,arg,i);

   /* 
    * create the label widget 
    */
   i = 0;
   XtSetArg(arg[i],XtNlabel,xvf_strcpy(exit_label)); i++;
   width = (xvf_strlen(exit_label)+1) + LEFT_MARGIN;
   total_width+=width;
   if (xvf_font != NULL)
   {
        XtSetArg(arg[i],XtNfont,xvf_font);              i++;
   }
   XtSetArg(arg[i],XtNmappedWhenManaged,True);		i++;
   XtSetArg(arg[i],XtNwidth,width*xvf_font_width);      i++;
   XtSetArg(arg[i],XtNborderWidth, 0);			i++;
   label = XtCreateManagedWidget("exit_wid",
      	labelWidgetClass,back,arg,i);

   /* 
    * create yes button 
    */
   i = 0;
   XtSetArg(arg[i],XtNfromVert,NULL);			i++;
   XtSetArg(arg[i],XtNfromHoriz,label);			i++;
   if (button1 == NULL)
   {
      width = 4;
      XtSetArg(arg[i],XtNlabel,"Yes");		    	i++;
      total_width+=width;
   }
   else
   {
      XtSetArg(arg[i],XtNlabel,xvf_strcpy(button1));	i++;
      width = (xvf_strlen(button1)+1);
      total_width+=width;
   }
   if (xvf_font != NULL)
   {
        XtSetArg(arg[i],XtNfont,xvf_font);              i++;
   }
   XtSetArg(arg[i],XtNwidth,width*xvf_font_width);      i++;
   yes_wid = XtCreateManagedWidget("yes_wid",
	commandWidgetClass,back,arg,i);
   XtAddCallback(yes_wid,XtNcallback,xvf_exit_yes,toplevel);

   /* 
    * create the no button 
    */
   i = 0;
   XtSetArg(arg[i],XtNfromHoriz,yes_wid);		i++;
   XtSetArg(arg[i],XtNfromVert,NULL);			i++;
   if (button2 == NULL)
   {
      XtSetArg(arg[i],XtNlabel,"No");			i++;
      width = 3;
      total_width+=width;
   }
   else
   {
      XtSetArg(arg[i],XtNlabel,xvf_strcpy(button2));	i++;
      width = (xvf_strlen(button2)+1);
      total_width+=width;
   }
   if (xvf_font != NULL)
   {
        XtSetArg(arg[i],XtNfont,xvf_font);              i++;
   }
   XtSetArg(arg[i],XtNwidth,width*xvf_font_width);	i++;
   no_wid = XtCreateManagedWidget("no_wid",
	commandWidgetClass,back,arg,i);
   XtAddCallback(no_wid,XtNcallback,xvf_exit_no,toplevel);

   /* 
    * create the cancel button 
    */
   i = 0;
   XtSetArg(arg[i],XtNfromHoriz,no_wid);		i++;
   XtSetArg(arg[i],XtNfromVert,NULL);			i++;
   if (button3 == NULL)
   {
      XtSetArg(arg[i],XtNlabel,"Cancel");
      width = 7;				i++;
      total_width+=width;
   }
   else
   {
      XtSetArg(arg[i],XtNlabel,xvf_strcpy(button3));	i++;
      width = (xvf_strlen(button3)+1);
      total_width+=width;
   }
   if (xvf_font != NULL)
   {
        XtSetArg(arg[i],XtNfont,xvf_font);              i++;
   }
   XtSetArg(arg[i],XtNwidth,width*xvf_font_width);      i++;
   canc_wid = XtCreateManagedWidget("canc_wid",
	commandWidgetClass,back,arg,i);
   XtAddCallback(canc_wid,XtNcallback,xvf_exit_canc,toplevel);

   /*
    * create the text widget 
    */
   total_width += 2;
   height = MAX(TEXT_HEIGHT, xvf_figure_height(exit_string, total_width));

   i = 0;
   XtSetArg(arg[i],XtNeditType,XawtextRead);		i++;
   XtSetArg(arg[i],XtNstring,exit_string);		i++;
   XtSetArg(arg[i],XtNresize, XawtextResizeHeight);	i++;
   XtSetArg(arg[i],XtNwrap,   XawtextWrapWord);		i++;
   XtSetArg(arg[i],XtNtype,   XawAsciiString);		i++;
   XtSetArg(arg[i],XtNheight,(Dimension) height*xvf_font_height);	i++;
   XtSetArg(arg[i],XtNwidth ,(Dimension) total_width*xvf_font_width);	i++;
   XtSetArg(arg[i],XtNinsertPosition,0);		i++;
   XtSetArg(arg[i],XtNfromVert,label);			i++;
   XtSetArg(arg[i],XtNleftMargin,LEFT_MARGIN);		i++;
   if (xvf_font != NULL)
   {
        XtSetArg(arg[i],XtNfont,xvf_font);              i++;
   }
   (void) XtCreateManagedWidget("text", asciiTextWidgetClass, back,arg,i);

   xvf_add_protocol_handler(toplevel, "WM_DELETE_WINDOW", xvf_exit_canc,
                            toplevel);

   xvf_place_widget(toplevel, NULL);
   return(true);
}

/*			*/
/* callback routines 	*/
/*			*/

void xvf_exit_yes(widget, clientData, callData)
Widget widget;
caddr_t clientData, callData;
{
   Widget toplevel;

   toplevel = (Widget) clientData;

   /*
    * delete the error box's toplevel from the list 
    * used by journal playback before destroying it
    */
   xvf_delete_toplevel(toplevel);
   XtUnmapWidget(toplevel);
   XtDestroyWidget(toplevel);
   EXIT_DONE = true;
   EXIT_SIG = 1;
}

void xvf_exit_no(widget, clientData, callData)
Widget widget;
caddr_t clientData, callData;
{
   Widget toplevel;

   toplevel = (Widget) clientData;

   xvf_delete_toplevel(toplevel);
   XtUnmapWidget(toplevel);
   XtDestroyWidget(toplevel);
   EXIT_DONE = true;
   EXIT_SIG = 0;
}

void xvf_exit_canc(widget, clientData, callData)
Widget widget;
caddr_t clientData, callData;
{
   Widget toplevel;

   toplevel = (Widget) clientData;

   xvf_remove_protocol_handler(toplevel, "WM_DELETE_WINDOW", 
			       xvf_exit_canc, toplevel);
   xvf_delete_toplevel(toplevel);
   XtUnmapWidget(toplevel);
   XtDestroyWidget(toplevel);
   EXIT_DONE = true;
   EXIT_SIG = -1;
}


