 /*
  * Khoros: $Id: warn.c,v 1.2 1991/12/18 09:17:28 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: warn.c,v 1.2 1991/12/18 09:17:28 dkhoros Exp $";
#endif

 /*
  * $Log: warn.c,v $
 * Revision 1.2  1991/12/18  09:17:28  dkhoros
 * HellPatch3
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "xvutils.h"	


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    	    file name: warn.c                         <<<<
   >>>>                                                       <<<<
   >>>>         Creates a Warning Widget		      <<<<
   >>>>                                                       <<<<
   >>>>                xvf_warn_wait()			      <<<<              
   >>>>                xvf_create_warn()		      <<<<              
   >>>>                xvf_warn_yes()			      <<<<              
   >>>>                xvf_warn_no()			      <<<<              
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */


/************************************************************
*
*  Routine Name:  xvf_warn_wait(warn,label,button1,button2)
*
*      Purpose:   creates a warning form which has two
*		  choises (Yes = 1, NO = 0).
*                 NOTE: this routine will grab all events 
*                 while running.  
*
*        Input:   warning   - warning string (may contain \n for
*		              returns, widget will put in
*			      returns as it needs).
*                 label    - short label for top of warning.
*			     NULL will casue default of "WARNING".
*		  button1  - label for first button
*                            NULL will indicate use of default "Yes".
*                 button2  - label for first button
*                            NULL will indicate use of default "No".
*
*
*       Output:   WARN_SIG (global variable) returned to caller will be:
*		       1 if user selected button1 (Yes),
*                      0 if user selected button2 (No),
*
*                 This routine will NOT return to the calling program until
*                 either Yes or No is chosen.
*
*    Called By:   the application program
*
*   Written By:   Stephanie Hallett
*
*
*************************************************************/

int xvf_warn_wait(warn,label,button1,button2)
char *warn;
char *label;
char *button1,*button2;
{
   int status;
   char resp[MaxLength];

   WARN_DONE = false;

   if (xvf_display == NULL)
   {
	do 
	{
	   fprintf(stderr, "%s\n", warn);
	   if (gets(resp) == NULL)
	   {
	       resp[0] = 'n';
	       break;
	   }
	   if (isupper(resp[0]))
                 resp[0] = tolower(resp[0]);

	} while ((resp[0] != 'y') &&( resp[0] != 'n'));

	if (resp[0] == 'y') return(true);
	else return(false);
   }

   status = xvf_create_warn(warn,label,button1,button2);

   if (status == false)
      return(false);

   while(!WARN_DONE)
   {
      xvf_process_event();      /* this does XtNextEvent/DispatchEvent*/
   }
   return(WARN_SIG);
}

/************************************************************
*
*  Routine Name:  xvf_create_warn(warn_string,warn_label,button1,button2)
*
*      Purpose:   Does the  actual creation of a warning widget. 
*		  The warning widget consists of a form widget with a 
*		  label, text, and two acknowledgement buttons.
*
*        Input:   warn_string  - the warning message 
*                 warn_label   - short label for top of widget
*                                 NULL will cause default of "Warning"
*		  button1       - label for acknowledgement button
*                                 NULL will cause default of "Continue"
*		  button2       - label for acknowledgement button
*                                 NULL will cause default of "Stop"
*
*       Output:   wait to user to acknowledge message.
*
*    Called By:   xvf_error_wait() or the application program
*
*   Written By:   Danielle Argiro Stephanie Hallett
*
*************************************************************/
#define TEXT_WIDTH  30
#define TEXT_HEIGHT 7

int xvf_create_warn(warn_string,warn_label,button1,button2)
char *warn_string;
char *warn_label;
char *button1,*button2;
{
   Widget toplevel;	/* toplevel widget for message */
   Widget back;		/* backplane for message */
   Widget label;	/* label describing type of message */
   Widget cont_wid; 	/* button to select to continue (1) */
   Widget stop_wid; 	/* button to select to stop action (0) */
   Arg    arg[25];
   int    i, width, height, cont_width, stop_width, label_width; 
   char   name[MaxLength];
   char  *top_name, *cap_top_name;

   /*
    * create identifying widget name
    */
   sprintf(name,"%d_warn",Warn_cnt);
   Warn_cnt++;
   top_name = xvf_strcpy(name);
   cap_top_name = xvf_cap_first_letter(top_name);

   if (button1 == NULL)
   {
	button1 = xvf_strcpy("Cont");
        cont_width = xvf_strlen(button1)+1;
   }
   else
        cont_width = (xvf_strlen(button1)+1);

   if (button2 == NULL)
   {
        button2 = xvf_strcpy("Stop");
        stop_width = xvf_strlen(button2)+1;
   }
   else
        stop_width = (xvf_strlen(button2)+1);
   
   if (warn_label == NULL)
   {
	warn_label = xvf_strcpy("Warning:");
        label_width = xvf_strlen(warn_label)+1;
   }
   else
	label_width = (xvf_strlen(warn_label)+1);

   /*
    * create the warning box's toplevel widget and add it
    * to the list of toplevels that is used with journal playback.
    */
   i = 0;
   XtSetArg(arg[i], XtNscreen, xvf_screen);		i++;
   XtSetArg(arg[i], XtNargc, xvf_ac); 	          	i++;
   XtSetArg(arg[i], XtNargv, xvf_av);	          	i++;
   XtSetArg(arg[i], XtNwinGravity, StaticGravity);	i++; 
   toplevel = XtAppCreateShell(top_name, cap_top_name,
			transientShellWidgetClass, xvf_display, arg, i);
   xvf_add_toplevel(toplevel);

   /* 
    * create the backplane widget 
    */
   i = 0;
   XtSetArg(arg[i],XtNmappedWhenManaged,True);          i++;
   XtSetArg(arg[i],XtNborderWidth,1);			i++;
   XtSetArg(arg[i],XtNdefaultDistance,4);		i++;
   back = XtCreateManagedWidget("form_back",
		formWidgetClass, toplevel,arg,i);

   /* 
    * create the label widget 
    */
   width = TEXT_WIDTH + LEFT_MARGIN - stop_width - cont_width - xvf_font_width;
   if (width < label_width) width = label_width;

   i = 0;
   XtSetArg(arg[i],XtNlabel,xvf_strcpy(warn_label)); i++;
   XtSetArg(arg[i],XtNwidth, (Dimension) width*xvf_font_width);  i++;
   XtSetArg(arg[i],XtNmappedWhenManaged,True);		i++;
   XtSetArg(arg[i],XtNborderWidth,0);			i++;
   if (xvf_font != NULL)
   {
        XtSetArg(arg[i],XtNfont,xvf_font);              i++;
   }
   label = XtCreateManagedWidget("warn_wid",
      	labelWidgetClass,back,arg,i);

   /* 
    * create text widget 
    */
   width  = MAX((label_width + stop_width + cont_width), TEXT_WIDTH);
   height = MAX(TEXT_HEIGHT, xvf_figure_height(warn_string, width));

   i = 0;
   XtSetArg(arg[i],XtNeditType,XawtextRead);		i++;
   XtSetArg(arg[i],XtNtype,    XawAsciiString);		i++;
   XtSetArg(arg[i],XtNstring,  warn_string);		i++;
   XtSetArg(arg[i],XtNwidth,  (Dimension) width*xvf_font_width);    i++;
   XtSetArg(arg[i],XtNheight, (Dimension) height*xvf_font_height);  i++; 
   XtSetArg(arg[i],XtNresize,  XawtextResizeHeight);    i++;
   XtSetArg(arg[i],XtNwrap,    XawtextWrapWord);        i++;
   XtSetArg(arg[i],XtNfromVert,label);			i++;
   XtSetArg(arg[i],XtNleftMargin,LEFT_MARGIN);		i++;
   if (xvf_font != NULL)
   {
        XtSetArg(arg[i],XtNfont,xvf_font);              i++;
   }
   (void) XtCreateManagedWidget("text", asciiTextWidgetClass, back,arg,i);

   /* 
    * create "Continue" acknowledgment button 
    */
   i = 0;
   XtSetArg(arg[i],XtNfromVert,NULL);			i++;
   XtSetArg(arg[i],XtNfromHoriz,label);			i++;
   XtSetArg(arg[i],XtNlabel,xvf_strcpy(button1));	i++;
   XtSetArg(arg[i],XtNwidth, (Dimension) cont_width*xvf_font_width);   i++;
   if (xvf_font != NULL)
   {
        XtSetArg(arg[i],XtNfont,xvf_font);              i++;
   }
   cont_wid = XtCreateManagedWidget("cont_wid",
	commandWidgetClass,back,arg,i);
   XtAddCallback(cont_wid,XtNcallback,xvf_warn_yes,toplevel);

   /* 
    * create "Stop" acknowledgment button 
    */
   i = 0;
   XtSetArg(arg[i],XtNfromVert,NULL);			i++;
   XtSetArg(arg[i],XtNfromHoriz,cont_wid);		i++;
   XtSetArg(arg[i],XtNlabel,xvf_strcpy(button2));	i++;
   XtSetArg(arg[i],XtNwidth, (Dimension) stop_width*xvf_font_width);   i++;
   if (xvf_font != NULL)
   {
        XtSetArg(arg[i],XtNfont,xvf_font);              i++;
   }
   stop_wid = XtCreateManagedWidget("stop_wid", 
	commandWidgetClass,back,arg,i);
   XtAddCallback(stop_wid, XtNcallback, xvf_warn_no, toplevel);

   xvf_add_protocol_handler(toplevel, "WM_DELETE_WINDOW", xvf_warn_yes,
                            toplevel);

   xvf_place_widget(toplevel, NULL);
   return(true);
}

/* 					     */
/* callbacks for the warning message buttons */
/* 					     */

void xvf_warn_yes(widget, clientData, callData)
Widget widget;
caddr_t clientData, callData;
{
   Widget toplevel;

   toplevel = (Widget) clientData;

   /*
    * delete the warning box's toplevel from the list 
    * used by journal playback before destroying it
    * and send back the signal indicating user selected "yes"
    */
   xvf_remove_protocol_handler(toplevel, "WM_DELETE_WINDOW", xvf_warn_yes,
                               toplevel);
   xvf_delete_toplevel(toplevel);
   XtUnmapWidget(toplevel);
   XtDestroyWidget(toplevel);
   WARN_DONE = true;
   WARN_SIG = 1;
}

void xvf_warn_no(widget, clientData, callData)
Widget widget;
caddr_t clientData, callData;
{
   Widget toplevel;

   toplevel = (Widget) clientData;

   /*
    * delete the warning box's toplevel from the list 
    * used by journal playback before destroying it
    * and send back the signal indicating user selected "no"
    */
   xvf_delete_toplevel(toplevel);
   XtUnmapWidget(toplevel);
   XtDestroyWidget(toplevel);
   WARN_DONE = true;
   WARN_SIG = 0;
}


