 /*
  * Khoros: $Id: gather.c,v 1.1 1991/05/10 15:58:12 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: gather.c,v 1.1 1991/05/10 15:58:12 khoros Exp $";
#endif

 /*
  * $Log: gather.c,v $
 * Revision 1.1  1991/05/10  15:58:12  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */
#include "composer.h"


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: gather.c
 >>>>
 >>>>      Program Name: composer
 >>>> 
 >>>> Date Last Updated: Sat Jul  7 14:41:44 MDT 1990
 >>>>
 >>>>          Routines: gather()  gets the information out of the pane to
 >>>>				update the information into the gui_spec.
 >>>>
 >>>>		 Author:  John Rasure
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


/********************************************************
*
*  Routine Name:  gather()
*       Purpose:  gets the information out of the pane to
*		  update the information into the gui_spec
*         Input:  info - pointer for the structure for the edit_pane.
*		  line_number - index that specifies specific UI line

*        Output:  global gui_spec is updated.
*
*     Called By:  run_edit_pane()
*
********************************************************/

void
gather(info, line_number)
pane_edit_pane  *info;
int		line_number;
{
    Line_Info 	line_info;
    char  	temp[MaxLength];
    int		type;	/* indicates what kind of line */

    type = xvf_get_line_type(gui_spec[line_number]);
    xvf_clear_line_info(&line_info);
    line_info.write = TRUE;  /* do not deparse value or literal */

    switch (type) {
        case InputFile :
        case OutputFile :
	    line_info.typeflag = type;

	    if (info->button_label == NULL) line_info.title = xvf_strcpy(" ");
	    else line_info.title = xvf_strcpy(info->button_label);

            if (info->usage_string == NULL) 
		line_info.description = xvf_strcpy(" ");
            else line_info.description = xvf_strcpy(info->usage_string);

            if (info->var_name == NULL) line_info.variable = xvf_strcpy("x");
            else line_info.variable = xvf_strcpy(info->var_name);

	    line_info.activate = info->active;
	    line_info.live     = info->live;
/*
	    if (info->optional == 0 && info->opt_selected ==0) {
		line_info.optional = 0;
		line_info.opt_sel  = 1;
	    }
*/

	    line_info.optional = info->optional;
	    line_info.opt_sel  = info->opt_selected;

	    line_info.width    = info->gs_width;
	    line_info.height   = info->gs_height;
	    line_info.x        = info->gs_xoff;
	    line_info.y        = info->gs_yoff;
	    line_info.xpos     = info->ps_xoff;
	    line_info.ypos     = info->ps_yoff;

	    if (info->default_string == NULL) 
	       line_info.filename = line_info.file_def = xvf_strcpy(" ");
	    else line_info.filename = line_info.file_def = xvf_strcpy(info->default_string);

            xvf_gen_deparse(&line_info, gui_spec, line_number);
            break;

        case StringOpt :
	    line_info.typeflag = type;

	    if (info->button_label == NULL) line_info.title = xvf_strcpy(" ");
	    else line_info.title = xvf_strcpy(info->button_label);

            if (info->usage_string == NULL) 
		line_info.description = xvf_strcpy(" ");
            else line_info.description = xvf_strcpy(info->usage_string);

            if (info->var_name == NULL) line_info.variable = xvf_strcpy("x");
            else line_info.variable = xvf_strcpy(info->var_name);

	    line_info.activate = info->active;
	    line_info.optional = info->optional;
	    line_info.live     = info->live;
	    line_info.opt_sel  = info->opt_selected;

	    line_info.width    = info->gs_width;
	    line_info.height   = info->gs_height;
	    line_info.x        = info->gs_xoff;
	    line_info.y        = info->gs_yoff;
	    line_info.xpos     = info->ps_xoff;
	    line_info.ypos     = info->ps_yoff;

	    if (info->default_string == NULL) 
	       line_info.string_def = line_info.string_val = xvf_strcpy(" ");
	    else line_info.string_def = line_info.string_val = xvf_strcpy(info->default_string);

            xvf_gen_deparse(&line_info, gui_spec, line_number);

            break;

        case LogicOpt :
	    line_info.typeflag = type;

	    if (info->button_label == NULL) line_info.title = xvf_strcpy(" ");
	    else line_info.title = xvf_strcpy(info->button_label);

            if (info->usage_string == NULL) 
		line_info.description = xvf_strcpy(" ");
            else line_info.description = xvf_strcpy(info->usage_string);

            if (info->var_name == NULL) line_info.variable = xvf_strcpy("x");
            else line_info.variable = xvf_strcpy(info->var_name);

	    line_info.activate = info->active;
	    line_info.optional = info->optional;
	    line_info.live     = info->live;
	    line_info.opt_sel  = info->opt_selected;

	    line_info.width    = info->gs_width;
	    line_info.height   = info->gs_height;
	    line_info.x        = info->gs_xoff;
	    line_info.y        = info->gs_yoff;
	    line_info.xpos     = info->ps_xoff;
	    line_info.ypos     = info->ps_yoff;

	    line_info.logical_def = line_info.logical_val = info->default_logical;

            if (info->one_label == NULL) line_info.val_labels[1] = xvf_strcpy("TRUE");
            else line_info.val_labels[1] = xvf_strcpy(info->one_label);
            if (info->zero_label == NULL) line_info.val_labels[0] = xvf_strcpy("FALSE");
            else line_info.val_labels[0] = xvf_strcpy(info->zero_label);

            xvf_gen_deparse(&line_info, gui_spec, line_number);

            break;

        case HelpSel :
	    line_info.typeflag = type;

	    if (info->button_label == NULL) line_info.title = xvf_strcpy(" ");
	    else line_info.title = xvf_strcpy(info->button_label);

            if (info->usage_string == NULL) 
		line_info.description = xvf_strcpy(" ");
            else line_info.description = xvf_strcpy(info->usage_string);

	    line_info.activate = info->active;

	    line_info.width    = info->gs_width;
	    line_info.height   = info->gs_height;
	    line_info.x        = info->gs_xoff;
	    line_info.y        = info->gs_yoff;
	    line_info.xpos     = info->ps_xoff;
	    line_info.ypos     = info->ps_yoff;

	    if (info->default_string == NULL) 
	       line_info.help_file = xvf_strcpy(" ");
	    else line_info.help_file = xvf_strcpy(info->default_string);

            xvf_gen_deparse(&line_info, gui_spec, line_number);
            break;

        case QuitForm :
	    line_info.typeflag = type;

	    if (info->button_label == NULL) line_info.title = xvf_strcpy(" ");
	    else line_info.title = xvf_strcpy(info->button_label);

	    line_info.activate = info->active;

	    line_info.width    = info->gs_width;
	    line_info.height   = info->gs_height;
	    line_info.x        = info->gs_xoff;
	    line_info.y        = info->gs_yoff;
	    line_info.xpos     = info->ps_xoff;
	    line_info.ypos     = info->ps_yoff;

            xvf_gen_deparse(&line_info, gui_spec, line_number);
            break;

        case Routine :
	    line_info.typeflag = type;

	    if (info->button_label == NULL) line_info.title = xvf_strcpy(" ");
	    else line_info.title = xvf_strcpy(info->button_label);

	    if (info->default_string == NULL) 
	       line_info.routine = xvf_strcpy(" ");
	    else line_info.routine = xvf_strcpy(info->default_string);

            if (info->usage_string == NULL) 
		line_info.description = xvf_strcpy(" ");
            else line_info.description = xvf_strcpy(info->usage_string);

	    line_info.activate = info->active;

	    line_info.exec_type = 1;    /* run type of rerun */

	    line_info.width    = info->gs_width;
	    line_info.height   = info->gs_height;
	    line_info.x        = info->gs_xoff;
	    line_info.y        = info->gs_yoff;
	    line_info.xpos     = info->ps_xoff;
	    line_info.ypos     = info->ps_yoff;

            xvf_gen_deparse(&line_info, gui_spec, line_number);
            break;

        case PaneAction :
	    line_info.typeflag = type;

	    if (info->button_label == NULL) line_info.title = xvf_strcpy(" ");
	    else line_info.title = xvf_strcpy(info->button_label);

            if (info->usage_string == NULL) 
		line_info.description = xvf_strcpy(" ");
            else line_info.description = xvf_strcpy(info->usage_string);

	    if (info->var_name == NULL) line_info.variable = xvf_strcpy("x");
	    else line_info.variable = xvf_strcpy(info->var_name);

	    line_info.activate = info->active;

	    line_info.width    = info->gs_width;
	    line_info.height   = info->gs_height;
	    line_info.x        = info->gs_xoff;
	    line_info.y        = info->gs_yoff;
	    line_info.xpos     = info->ps_xoff;
	    line_info.ypos     = info->ps_yoff;

            xvf_gen_deparse(&line_info, gui_spec, line_number);
            break;

        case StartPane :
	    line_info.typeflag = type;

	    if (info->button_label == NULL) line_info.title = xvf_strcpy(" ");
	    else line_info.title = xvf_strcpy(info->button_label);

	    if (info->name == NULL) line_info.variable = xvf_strcpy("x");
	    else line_info.variable = xvf_strcpy(info->name);

	    line_info.activate = info->active;

	    line_info.width    = info->gs_width;
	    line_info.height   = info->gs_height;
	    line_info.x        = info->gs_xoff;
	    line_info.y        = info->gs_yoff;
	    line_info.xpos     = info->ps_xoff;
	    line_info.ypos     = info->ps_yoff;

            xvf_gen_deparse(&line_info, gui_spec, line_number);
            break;

        case MutExcl :
	    line_info.typeflag = type;

	    line_info.logical_val = info->optional;

            break;

        case Toggle :
	    /* In the case of a Toggle, there is one item that can not
	       be gathered from the edit pane.  That is the toggle_val
	       which is set by selecting which one the user wants.  So
	       first parse the toggle line, then gather the rest.  */
	    
	    xvf_gen_parse(gui_spec[line_number], &line_info);
    	    line_info.write = TRUE;  /* do not deparse value or literal */

	    if (info->button_label == NULL) line_info.title = xvf_strcpy(" ");
	    else line_info.title = xvf_strcpy(info->button_label);

            if (info->usage_string == NULL) 
		line_info.description = xvf_strcpy(" ");
            else line_info.description = xvf_strcpy(info->usage_string);

            if (info->var_name == NULL) line_info.variable = xvf_strcpy("x");
            else line_info.variable = xvf_strcpy(info->var_name);

	    line_info.activate = info->active;
	    line_info.optional = info->optional;
	    line_info.live     = info->live;
	    line_info.opt_sel  = info->opt_selected;

	    line_info.width    = info->gs_width;
	    line_info.height   = info->gs_height;
	    line_info.x        = info->gs_xoff;
	    line_info.y        = info->gs_yoff;
	    line_info.xpos     = info->ps_xoff;
	    line_info.ypos     = info->ps_yoff;

            xvf_gen_deparse(&line_info, gui_spec, line_number);
            break;

        case Blank :
	    line_info.typeflag = type;

	    if (info->button_label == NULL) line_info.title = xvf_strcpy(" ");
	    else line_info.title = xvf_strcpy(info->button_label);

	    line_info.xpos     = info->ps_xoff;
	    line_info.ypos     = info->ps_yoff;

            xvf_gen_deparse(&line_info, gui_spec, line_number);
            break;

        case FloatOpt :
            line_info.typeflag = type;

            if (info->button_label == NULL) line_info.title = xvf_strcpy(" ");
            else line_info.title = xvf_strcpy(info->button_label);

            if (info->usage_string == NULL) 
		line_info.description = xvf_strcpy(" ");
            else line_info.description = xvf_strcpy(info->usage_string);

            if (info->var_name == NULL) line_info.variable = xvf_strcpy("x");
            else line_info.variable = xvf_strcpy(info->var_name);

	    line_info.activate = info->active;
	    line_info.optional = info->optional;
	    line_info.live     = info->live;
	    line_info.opt_sel  = info->opt_selected;

	    line_info.width    = info->gs_width;
	    line_info.height   = info->gs_height;
	    line_info.x        = info->gs_xoff;
	    line_info.y        = info->gs_yoff;
	    line_info.xpos     = info->ps_xoff;
	    line_info.ypos     = info->ps_yoff;

	    if (info->toggle_range_val == 1) {
                line_info.lower_float = line_info.upper_float = -2.0;
                if (info->default_float < 0.0) 
                    line_info.float_val = 
                    line_info.float_def = info->default_float;
                else line_info.float_val = line_info.float_def = -1.0;
            } else if (info->toggle_range_val == 2) {
                line_info.lower_float = line_info.upper_float = -1.0;
                if (info->default_float <= 0.0) 
                    line_info.float_val = 
                    line_info.float_def = info->default_float;
                else line_info.float_val = line_info.float_def = 0.0;
            } else if (info->toggle_range_val == 3) {
                line_info.lower_float = line_info.upper_float = 2.0;
                if (info->default_float > 0.0) 
                    line_info.float_val = 
                    line_info.float_def = info->default_float;
                else line_info.float_val = line_info.float_def = 1.0;
            } else if (info->toggle_range_val == 4) {
                line_info.lower_float = line_info.upper_float = 1.0;
                if (info->default_float >= 0.0) 
                    line_info.float_val = 
                    line_info.float_def = info->default_float;
                else line_info.float_val = line_info.float_def = 0.0;
            } else if (info->toggle_range_val == 5) {
                line_info.lower_float = info->lower_range;
                line_info.upper_float = info->upper_range;
                line_info.float_val = line_info.float_def = info->default_float;
            } else if (info->toggle_range_val == 6) {
                line_info.lower_float = 0.0;
                line_info.upper_float = 0.0;
                line_info.float_val = line_info.float_def = info->default_float;
            }

            xvf_gen_deparse(&line_info, gui_spec, line_number);
            break;

        case IntegerOpt :
            line_info.typeflag = type;

            if (info->button_label == NULL) line_info.title = xvf_strcpy(" ");
            else line_info.title = xvf_strcpy(info->button_label);

            if (info->usage_string == NULL) 
		line_info.description = xvf_strcpy(" ");
            else line_info.description = xvf_strcpy(info->usage_string);

            if (info->var_name == NULL) line_info.variable = xvf_strcpy("x");
            else line_info.variable = xvf_strcpy(info->var_name);

	    line_info.activate = info->active;
	    line_info.optional = info->optional;
	    line_info.live     = info->live;
	    line_info.opt_sel  = info->opt_selected;

	    line_info.width    = info->gs_width;
	    line_info.height   = info->gs_height;
	    line_info.x        = info->gs_xoff;
	    line_info.y        = info->gs_yoff;
	    line_info.xpos     = info->ps_xoff;
	    line_info.ypos     = info->ps_yoff;

	    if (info->toggle_range_val == 1) {
                line_info.lower_int = line_info.upper_int = -2;
                if (info->default_float < 0.0) 
                    line_info.int_val = 
                    line_info.int_def = (int) info->default_float;
                else line_info.int_val = line_info.int_def = -1;
            } else if (info->toggle_range_val == 2) {
                line_info.lower_int = line_info.upper_int = -1;
                if (info->default_float <= 0.0) 
                    line_info.int_val = 
                    line_info.int_def = (int) info->default_float;
                else line_info.int_val = line_info.int_def = 0;
            } else if (info->toggle_range_val == 3) {
                line_info.lower_int = line_info.upper_int = 2;
                if (info->default_float > 0.0) 
                    line_info.int_val = 
                    line_info.int_def = (int) info->default_float;
                else line_info.int_val = line_info.int_def = 1;
            } else if (info->toggle_range_val == 4) {
                line_info.lower_int = line_info.upper_int = 1;
                if (info->default_float >= 0.0) 
                    line_info.int_val = 
                    line_info.int_def = (int) info->default_float;
                else line_info.int_val = line_info.int_def = 0;
            } else if (info->toggle_range_val == 5) {
                line_info.lower_int = (int) info->lower_range;
                line_info.upper_int = (int) info->upper_range;
                line_info.int_val = line_info.int_def = (int) info->default_float;
            } else if (info->toggle_range_val == 6) {
                line_info.lower_int = 0; 
                line_info.upper_int = 0;
                line_info.int_val = line_info.int_def = (int) info->default_float;
            }

            xvf_gen_deparse(&line_info, gui_spec, line_number);
            break;

        default :
            (void) sprintf(temp, "Unknow user interface specification line type.");
            xvf_error_wait(temp, "COMPOSER WARNING!", "OK");
            break;
    }
}
