 /*
  * Khoros: $Id: run.c,v 1.3 1991/10/02 00:19:24 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: run.c,v 1.3 1991/10/02 00:19:24 khoros Exp $";
#endif

 /*
  * $Log: run.c,v $
 * Revision 1.3  1991/10/02  00:19:24  khoros
 * HellPatch2
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	    file name: run.c                                  <<<<
   >>>>                                                       <<<<
   >>>>   description: this file includes the drivers for the <<<<
   >>>> 		the subforms edit & conf_manage.      <<<<
   >>>>                                                       <<<<
   >>>>      routines: run_*()				      <<<<
   >>>>			display_demo_form()
   >>>>			process_line()
   >>>>			process_group()
   >>>>			update_line()
   >>>>                                                       <<<<
   >>>> modifications:					      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "composer.h"

#undef  MAX_LIST
#define MAX_LIST 100

#define UPDATE_LINE_ONLY -2
#define UPDATE_DISPLAY   -1


/********************************************************
*
*  Routine Name:  run_pane
*
*       Purpose:  drives the subform 'pane'
*
*         Input:  form - pointer to the form tree 
*		  pane_info  - information structure for subform 'pane'
*        Output:  action of the application program
*
*     Called By:  run_Composer()
*
*   Automatically Generated By:  conductor
*
********************************************************/


run_pane(form, pane_info)

xvf_form *form;
Composer_pane *pane_info;
{

	_xvf_get_pane(form, pane_info);

	/*
	 * action came from the 'edit_pane' pane
	 */
	if (pane_info->edit_pane_selected)
	    run_edit_pane(form, pane_info->edit_pane);


}   /* end run_pane */


/********************************************************
*
*  Routine Name:  run_edit_pane
*
*       Purpose:  drives the pane 'edit_pane'
*
*         Input:  form - pointer to the form tree 
*		  edit_pane_info  - information structure for pane 'edit_pane'
*        Output:  action of the application program
*
*     Called By:  run_pane()
*
*   Automatically Generated By:  conductor
*
********************************************************/


run_edit_pane(form, edit_pane_info)

xvf_form *form;
pane_edit_pane *edit_pane_info;
{
	char    	warning[MaxLength];
	char    	temp[MaxLength];
	static int	current_selection = NONE_SELECTED;
	int		type_of_line;
	Line_Info	line_info;

	int 	i, num_items, line_index;   
	char    *list[MAX_LIST];           /*  list for widget */
	int     item_location[MAX_LIST];   /* map between list widget items
						and *gui_spec[]  */
        int     current, num_col = 1;      /* stuff for xvf_run_list */
	XawListReturnStruct    *entry;
	char    *label  = "Click on CANCEL if you do not wish to edit any item";

	_xvf_get_edit_pane(form, edit_pane_info);

	/*
	 * user clicked on pane action button 'read_pane'
	 */
	if (edit_pane_info->read_pane) {
	    if (valid_pane_file == TRUE) {
		 (void) sprintf(warning, "You are currently editing a valid pane file, do you wish to read in a new file before saving?  If you wish to CONTINUE, click on READ, if you wish to SAVE the current file, click on CANCEL and then save the current pane file");
		if ( !xvf_warn_wait(warning, "COMPOSER WARNING!",
					      "READ", "CANCEL")) {
		    return;
		}
	    }
            if ( !get_pane(edit_pane_info->pane_file)) {
		(void) sprintf(warning, "Pane specification %s is incorrect.",
			edit_pane_info->pane_file);
		xvf_error_wait(warning, "COMPOSER WARNING!", "OK");
		return;
	    }
	    else {
	        valid_pane_file = TRUE;
		/* update global so panes can be updated next run_form */
	        glob_pane_name = xvf_strcpy(edit_pane_info->pane_file);
		current_selection = NONE_SELECTED;
		ok_pane_edit(form, edit_pane_info);
	        display_demo_form();
	    }
	}

	/*
	 * user clicked on pane action button 'save_pane'
	 */
	else if (edit_pane_info->save_pane) {
	    if (valid_pane_file == FALSE) {
		 (void) sprintf(warning, "There is not currently a valid pane file being edited.");
		xvf_error_wait(warning, "COMPOSER WARNING!", "OK");
		return;
	    }
	    if (current_selection != NONE_SELECTED) {
	        gather(edit_pane_info, current_selection);
	        display_demo_form();
            }

            if ( !put_pane(edit_pane_info->pane_file)) {
		(void) sprintf(warning, "Pane specification %s was not written.",
			edit_pane_info->pane_file);
		xvf_error_wait(warning, "COMPOSER WARNING!", "OK");
	    }
	    else {
	        glob_pane_name = xvf_strcpy(edit_pane_info->pane_file);
	    }
	}

	/*
	 * user clicked on pane action button 'select_I'
	 */
	else if (edit_pane_info->select_I) {
	    process_line(&current_selection, InputFile, form, edit_pane_info);
	}

	/*
	 * user clicked on pane action button 'select_O'
	 */
	else if (edit_pane_info->select_O) {
	    process_line(&current_selection, OutputFile, form, edit_pane_info);
	}

	/*
	 * user clicked on pane action button 'select_f'
	 */
	else if (edit_pane_info->select_f) {
	    process_line(&current_selection, FloatOpt, form, edit_pane_info);
	}

	/*
	 * user clicked on pane action button 'select_i'
	 */
	else if (edit_pane_info->select_i) {
	    process_line(&current_selection, IntegerOpt, form, edit_pane_info);
	}

	/*
	 * user clicked on pane action button 'select_l'
	 */
	else if (edit_pane_info->select_l) {
	    process_line(&current_selection, LogicOpt, form, edit_pane_info);
	}

	/*
	 * user clicked on pane action button 'select_s'
	 */
	else if (edit_pane_info->select_s) {
	    process_line(&current_selection, StringOpt, form, edit_pane_info);
	}

	/*
	 * user clicked on pane action button 'select_b'
	 */
	else if (edit_pane_info->select_b) {
	    process_line(&current_selection, Blank, form, edit_pane_info);
	}

	/*
	 * user clicked on pane action button 'select_T'
	 */
	else if (edit_pane_info->select_T) {
	    process_line(&current_selection, Toggle, form, edit_pane_info);
	}

	/*
	 * user clicked on pane action button 'select_C'
	 */
	else if (edit_pane_info->select_C) {
	    process_line(&current_selection, MutExcl, form, edit_pane_info);
	}

	/*
	 * user clicked on pane action button 'select_P'
	 */
	else if (edit_pane_info->select_P) {
	    process_line(&current_selection, StartPane, form, edit_pane_info);
	}

	/*
	 * user clicked on pane action button 'select_a'
	 */
	else if (edit_pane_info->select_a) {
	    process_line(&current_selection, PaneAction, form, edit_pane_info);
	}

	/*
	 * user clicked on pane action button 'select_H'
	 */
	else if (edit_pane_info->select_H) {
	    process_line(&current_selection, HelpSel, form, edit_pane_info);
	}

	/*
	 * user clicked on pane action button 'select_Q'
	 */
	else if (edit_pane_info->select_Q) {
	    process_line(&current_selection, QuitForm, form, edit_pane_info);
	}

	/*
	 * user clicked on pane action button 'select_R'
	 */
	else if (edit_pane_info->select_R) {
	    process_line(&current_selection, Routine, form, edit_pane_info);
	}

	/*
	 * user clicked on pane action button 'delete'
	 */
	else if (edit_pane_info->delete) {
	    if (current_selection != NONE_SELECTED) 
                                  gather(edit_pane_info, current_selection);
	    if (valid_pane_file == TRUE) {
		/* build list of all seletections in the UIS */
		num_items = 0;
	        for (line_index=1; line_index<gui_spec_lines-1; line_index++) {
		    type_of_line = xvf_get_line_type(gui_spec[line_index]);
		    if ( !(type_of_line == StartPane ||
                        type_of_line == StartSubForm || type_of_line == End)) {
		        item_location[num_items] = line_index;
		        list[num_items] = xvf_strcpy(gui_spec[line_index]);
		        num_items++;
                        if (num_items >= MAX_LIST) {
		            (void) sprintf(warning, "Too many items selected for list.");
	    	            xvf_error_wait(warning, "COMPOSER ERROR!", "OK");
		            --num_items;
		        }
	            }
	        }  /* there is now a list of possible lines to delete */
		if (num_items == 0) {
	            (void) sprintf(warning, "There are no lines available for deleteing.");
                    xvf_error_wait(warning, "COMPOSER ERROR!", "OK");
	            return;
		}

		/* pop up list of candidate items */
		if (entry = xvf_run_list_wait(list, num_items, num_col, 
		            "Select the item that you wish to delete:", label, 
				      &current, FALSE)) {

		    current_selection = item_location[entry->list_index];
		    type_of_line = xvf_get_line_type(gui_spec[current_selection]);
		    /* delete the currently selected line */
		    for (i = current_selection; i < gui_spec_lines-1; i++) {
			gui_spec[i] = gui_spec[i+1];
		    }
		    gui_spec_lines--;   /* one less line */

		    if (type_of_line == Toggle || type_of_line == MutExcl){
			while (End != 
			    xvf_get_line_type(gui_spec[current_selection])) {
			    current_selection++;
			}
		        for (i = current_selection; i < gui_spec_lines-1; i++) {
			gui_spec[i] = gui_spec[i+1];
		        }
		        gui_spec_lines--;   /* one less line */
		    }

	            current_selection = NONE_SELECTED;
	            fill_pane(form, edit_pane_info, current_selection);
                    display_demo_form();
		}
		else return;  /* no items selected */
	    }
	    else {
		(void) sprintf(warning, "A User Interface Specification has not been created or READ so no items can be deleted.");
		xvf_error_wait(warning, "COMPOSER WARNING!", "OK");
		return;
	    }
	}

	/*
	 * user clicked on pane action button 'copy'
	 */
	else if (edit_pane_info->copy) {
	    if (current_selection != NONE_SELECTED) 
                                  gather(edit_pane_info, current_selection);
	    if (valid_pane_file == TRUE) {
		/* build list of all seletections in the UIS */
		num_items = 0;
	        for (line_index=1; line_index<gui_spec_lines-1; line_index++) {
		    type_of_line = xvf_get_line_type(gui_spec[line_index]);
		    if ( !(type_of_line == StartPane || 
	    	        type_of_line == Toggle || type_of_line == MutExcl ||
                        type_of_line == StartSubForm || type_of_line == End)) {
		        item_location[num_items] = line_index;
		        list[num_items] = xvf_strcpy(gui_spec[line_index]);
		        num_items++;
                        if (num_items >= MAX_LIST) {
		            (void) sprintf(warning, "Too many items selected for list.");
	    	            xvf_error_wait(warning, "COMPOSER ERROR!", "OK");
		            --num_items;
		        }
	            }
	        }  /* there is now a list of possible lines to copy */
		if (num_items == 0) {
	            (void) sprintf(warning, "There are no lines available for copying. Add a new line of the desired type.");
                    xvf_error_wait(warning, "COMPOSER ERROR!", "OK");
	            return;
		}

		/* pop up list of candidate items */
		if (entry = xvf_run_list_wait(list, num_items, num_col, 
		            "Select the item that you wish to copy:", label, 
				      &current, FALSE)) {

		    current_selection = item_location[entry->list_index];
		    type_of_line = xvf_get_line_type(gui_spec[current_selection]);
		    /* copy the currently selected line */
	            for (i = gui_spec_lines-1; i != current_selection-1; i--){
	                gui_spec[i+1] = gui_spec[i];
	            }
                    i++;
	            /* insert new line above current_selection
                       i.e.  current_selection will stay in same place */
	            gui_spec[i] = xvf_strcpy(gui_spec[current_selection+1]);
		    current_selection = i;
		    if(!(type_of_line == Blank || type_of_line == MutExcl)) {
			xvf_clear_line_info(&line_info);
			xvf_gen_parse(gui_spec[i], &line_info);
			line_info.y = line_info.y +1;
			line_info.write = TRUE;
			xvf_gen_deparse(&line_info, gui_spec, i);
		    }
	            gui_spec_lines++;  /* one more line in spec */

	    	    if (type_of_line == Toggle || type_of_line == MutExcl) {
			    /* Insert a matching -E line */
		        for (i = gui_spec_lines-1; i != current_selection; i--){
		            gui_spec[i+1] = gui_spec[i];
		        }
                        i++;
	                gui_spec[i] = xvf_strcpy("-E");
	                gui_spec_lines++;  /* one more line in spec */
	            }

	            fill_pane(form, edit_pane_info, current_selection);
                    display_demo_form();
		}
		else return;  /* no items selected */
	    }
	    else {
		(void) sprintf(warning, "A User Interface Specification has not been created or READ so no items can be copied. Please READ a UIS or create one by clicking on PANE PARAMS.");
		xvf_error_wait(warning, "COMPOSER WARNING!", "OK");
		return;
	    }
	}

	/*
	 * user clicked on 'live' string selection 'button_label'
	 */
	else if (edit_pane_info->button_label_selected) {
	    if (current_selection != NONE_SELECTED) {
		type_of_line = xvf_get_line_type(gui_spec[current_selection]); 
		if (type_of_line == InputFile || type_of_line == OutputFile ||
		    type_of_line == StringOpt || type_of_line == FloatOpt || 
		    type_of_line == IntegerOpt|| type_of_line == LogicOpt ||
		    type_of_line == PaneAction|| type_of_line == Routine  ||
		    type_of_line == HelpSel   || type_of_line == QuitForm ||
		    type_of_line == Blank ) {
	            update_edit_pane(current_selection, edit_pane_info,
	                     xvf_title_chng, edit_pane_info->button_label);
		}
		else 
	            update_edit_pane(current_selection, edit_pane_info,
	                     UPDATE_DISPLAY, NULL);
	    }
	    else {
	        update_edit_pane(current_selection, edit_pane_info,
	                     UPDATE_LINE_ONLY, NULL);
	    }
	}

	/*
	 * user clicked on 'live' string selection 'default_string'
	 */
	else if (edit_pane_info->default_string_selected)
	{
	    if (current_selection != NONE_SELECTED) {
		type_of_line = xvf_get_line_type(gui_spec[current_selection]); 
		if ( type_of_line == InputFile )
	                update_edit_pane(current_selection, edit_pane_info,
	                   xvf_inputfile_chng, edit_pane_info->default_string);
		else if ( type_of_line == OutputFile )
	                update_edit_pane(current_selection, edit_pane_info,
	                   xvf_outputfile_chng, edit_pane_info->default_string);
		else if ( type_of_line == StringOpt )
	                update_edit_pane(current_selection, edit_pane_info,
	                   xvf_stringval_chng, edit_pane_info->default_string);
		else 
	                update_edit_pane(current_selection, edit_pane_info,
	                     UPDATE_DISPLAY, NULL);
	    }
	    else {
	        update_edit_pane(current_selection, edit_pane_info,
	                     UPDATE_LINE_ONLY, NULL);
	    }
	}

	/*
	 * user clicked on 'live' logical selection 'active'
	 */
	if (edit_pane_info->active_selected) {
	    if (current_selection != NONE_SELECTED) {
	        (void) sprintf(temp, "%d", edit_pane_info->active);
	        update_edit_pane(current_selection, edit_pane_info,
	                         xvf_activation_chng, temp);
		}
	    else {
	        update_edit_pane(current_selection, edit_pane_info,
	                     UPDATE_LINE_ONLY, NULL);
	    }
	}

	/*
	 * user clicked on 'live' logical selection 'live'
	 */
	if (edit_pane_info->live_selected) {
	    update_edit_pane(current_selection, edit_pane_info,
	                     UPDATE_DISPLAY, NULL);
	}

	/*
	 * user clicked on 'live' logical selection 'optional'
	 */
	if (edit_pane_info->optional_selected) {
	    if (edit_pane_info->opt_selected == 0) {
		(void) sprintf(warning, "You are not allowed to make an OPTIONAL, NOT-SELECTED item into a REQUIRED item, please first make it SELECTED.");
		xvf_error_wait(warning, "COMPOSER WARNING!", "OK");
                xvf_change_input(form, edit_pane_info->optional_index,
                       xvf_logicalval_chng, "1", 0);
		return;
	    }
	    else update_edit_pane(current_selection, edit_pane_info,
	                     UPDATE_DISPLAY, NULL);
	}

	/*
	 * user clicked on 'live' logical selection 'opt_selected'
	 */
	if (edit_pane_info->opt_selected_selected) {
	    if (edit_pane_info->optional == 0) {
		(void) sprintf(warning, "You are not allowed to make a NOT-OPTIONAL, SELECTED item into a NOT-SELECTED item, please first make it OPTIONAL.");
		xvf_error_wait(warning, "COMPOSER WARNING!", "OK");
                xvf_change_input(form, edit_pane_info->opt_selected_index,
                       xvf_logicalval_chng, "1", 0);
		return;
	    }
	    else {
	        (void) sprintf(temp, "%d", edit_pane_info->opt_selected);
	        update_edit_pane(current_selection, edit_pane_info,
	                     xvf_optsel_chng, temp);
	    }
	}

	/*
	 * user clicked on 'live' integer selection 'gs_width'
	 */
	else if (edit_pane_info->gs_width_selected) {
	    update_edit_pane(current_selection, edit_pane_info,
	                     UPDATE_DISPLAY, NULL);
	}

	/*
	 * user clicked on 'live' integer selection 'gs_height'
	 */
	else if (edit_pane_info->gs_height_selected) {
	    if (current_selection != NONE_SELECTED) {
		type_of_line = xvf_get_line_type(gui_spec[current_selection]); 
		if ( type_of_line == Toggle || type_of_line == MutExcl || 
                     type_of_line == StartPane)
	            update_edit_pane(current_selection, edit_pane_info,
	                     UPDATE_DISPLAY, NULL);
                else {
	            (void) sprintf(temp, "%d", edit_pane_info->gs_height);
	            update_edit_pane(current_selection, edit_pane_info,
	                     xvf_height_chng, temp);
		}
	    }
	    else {
	        update_edit_pane(current_selection, edit_pane_info,
	                     UPDATE_LINE_ONLY, NULL);
	    }
	}

	/*
	 * user clicked on 'live' integer selection 'gs_xoff'
	 */
	else if (edit_pane_info->gs_xoff_selected) {
	    if (current_selection != NONE_SELECTED) {
		type_of_line = xvf_get_line_type(gui_spec[current_selection]); 
		if ( type_of_line == Toggle || type_of_line == MutExcl || 
                     type_of_line == StartPane)
	            update_edit_pane(current_selection, edit_pane_info,
	                     UPDATE_DISPLAY, NULL);
                else {
	            (void) sprintf(temp, "%d", edit_pane_info->gs_xoff);
	            update_edit_pane(current_selection, edit_pane_info,
	                     xvf_x_chng, temp);
		}
	    }
	    else {
	        update_edit_pane(current_selection, edit_pane_info,
	                     UPDATE_LINE_ONLY, NULL);
	    }
	}

	/*
	 * user clicked on 'live' integer selection 'gs_yoff'
	 */
	else if (edit_pane_info->gs_yoff_selected) {
	    if (current_selection != NONE_SELECTED) {
		type_of_line = xvf_get_line_type(gui_spec[current_selection]); 
		if ( type_of_line == Toggle || type_of_line == MutExcl || 
                     type_of_line == StartPane)
	            update_edit_pane(current_selection, edit_pane_info,
	                     UPDATE_DISPLAY, NULL);
                else {
	            (void) sprintf(temp, "%d", edit_pane_info->gs_yoff);
	            update_edit_pane(current_selection, edit_pane_info,
	                     xvf_y_chng, temp);
		}
	    }
	    else {
	        update_edit_pane(current_selection, edit_pane_info,
	                     UPDATE_LINE_ONLY, NULL);
	    }
	}

	/*
	 * user clicked on 'live' integer selection 'ps_xoff'
	 */
	else if (edit_pane_info->ps_xoff_selected) {
	    update_edit_pane(current_selection, edit_pane_info,
	                     UPDATE_DISPLAY, NULL);
	}

	/*
	 * user clicked on 'live' integer selection 'ps_yoff'
	 */
	else if (edit_pane_info->ps_yoff_selected) {
	    update_edit_pane(current_selection, edit_pane_info,
	                     UPDATE_DISPLAY, NULL);
	}

	/*
	 * user clicked on 'live' toggle selection 'toggle_range'
	 */
	else if (edit_pane_info->toggle_range_selected) {
	    update_edit_pane(current_selection, edit_pane_info,
	                     UPDATE_DISPLAY, NULL);
	}

	/*
	 * user clicked on 'live' float selection 'default_float'
	 */
	else if (edit_pane_info->default_float_selected) { 
	    if (current_selection != NONE_SELECTED) {
		type_of_line = xvf_get_line_type(gui_spec[current_selection]); 
		if ( type_of_line == FloatOpt ) {
	            (void) sprintf(temp, "%g", edit_pane_info->default_float);
	            update_edit_pane(current_selection, edit_pane_info,
	                   xvf_floatval_chng, temp);
		}
		else if ( type_of_line == IntegerOpt ) {
	            (void) sprintf(temp, "%d", (int) edit_pane_info->default_float);
	            update_edit_pane(current_selection, edit_pane_info,
	                   xvf_intval_chng, temp);
		}
		else 
	            update_edit_pane(current_selection, edit_pane_info,
	                     UPDATE_DISPLAY, NULL);
            }
	    else {
	        update_edit_pane(current_selection, edit_pane_info,
	                     UPDATE_LINE_ONLY, NULL);
	    }
	}

	/*
	 * user clicked on 'live' string selection 'zero_label'
	 */
	else if (edit_pane_info->zero_label_selected) {
	    update_edit_pane(current_selection, edit_pane_info,
	                     UPDATE_DISPLAY, NULL);
	}

	/*
	 * user clicked on 'live' string selection 'one_label'
	 */
	else if (edit_pane_info->one_label_selected) {
	    update_edit_pane(current_selection, edit_pane_info,
	                     UPDATE_DISPLAY, NULL);
	}

	/*
	 * user clicked on 'live' logical selection 'default_logical'
	 */
	if (edit_pane_info->default_logical_selected) {
	    (void) sprintf(temp, "%d", edit_pane_info->default_logical);
	    update_edit_pane(current_selection, edit_pane_info,
	                     xvf_logicalval_chng, temp);
	}
}


/********************************************************
*
*  Routine Name:  run_prog
*
*       Purpose:  drives the subform 'prog'
*
*         Input:  form - pointer to the form tree 
*		  prog_info  - information structure for subform 'prog'
*        Output:  action of the application program
*
*     Called By:  run_Composer()
*
*   Automatically Generated By:  conductor
*
********************************************************/


run_prog(form, prog_info)

xvf_form *form;
Composer_prog *prog_info;
{

	_xvf_get_prog(form, prog_info);

	/*
	 * action came from the 'edit_prog' pane
	 */
	if (prog_info->edit_prog_selected)
	    run_edit_prog(form, prog_info->edit_prog);


}   /* end run_prog */

/********************************************************
*
*  Routine Name:  run_edit_prog
*
*       Purpose:  drives the pane 'edit_prog'
*
*         Input:  form - pointer to the form tree 
*		  edit_prog_info  - information structure for pane 'edit_prog'
*        Output:  action of the application program
*
*     Called By:  run_prog()
*
*   Automatically Generated By:  conductor
*
********************************************************/


run_edit_prog(form, edit_prog_info)
xvf_form *form;
prog_edit_prog *edit_prog_info;
{
	char   	warning[MaxLength];
	int	i;
	char    **keynames[2];

	_xvf_get_edit_prog(form, edit_prog_info);

	/*
	 * user clicked on pane action button 'read_prog'
	 */
	if (edit_prog_info->read_prog) {
	    if (valid_prog_file == TRUE) {
		 (void) sprintf(warning, "You are currently editing a valid program specification file, do you wish to read in a new file before saving?  If you wish to CONTINUE, click on READ, if you wish to SAVE the current file, click on CANCEL and then save the current prog file");
		if ( !xvf_warn_wait(warning, "COMPOSER WARNING!",
					      "READ", "CANCEL")) {
		    return;
		}
	    }
            if ( !get_prog(edit_prog_info->prog_file)) {
		(void) sprintf(warning, "Program specification %s is incorrect.",
			edit_prog_info->prog_file);
		xvf_error_wait(warning, "COMPOSER WARNING!", "OK");
		return;
	    }
	    else {
	        valid_prog_file = TRUE;
		/* update global so panes can be updated next run_form */
	        glob_prog_name = xvf_strcpy(edit_prog_info->prog_file);
	        xvf_change_input(form, edit_prog_info->prog_text_index,
                          xvf_stringval_chng, ex_prog_spec[Authors], 0);
	    }
	}

	/*
	 * user clicked on pane action button 'save_prog'
	 */
	else if (edit_prog_info->save_prog) {
	    if (valid_prog_file == FALSE) {
		 (void) sprintf(warning, "There is not currently a valid programspecification file being edited.");
		xvf_error_wait(warning, "COMPOSER WARNING!", "OK");
		return;
	    }
            if ( !put_prog(edit_prog_info->prog_file)) {
		(void) sprintf(warning, "Program specification %s was not written.",
			edit_prog_info->prog_file);
		xvf_error_wait(warning, "COMPOSER WARNING!", "OK");
	    }
	    else {
	        glob_prog_name = xvf_strcpy(edit_prog_info->prog_file);
	    }
	}

	else if (valid_prog_file == FALSE || prog_spec == NULL) {  
            prog_spec = (caddr_t *) calloc(1,sizeof(char *)*MaxProgSpecSize);
	    if (prog_spec == NULL) {
	        (void) sprintf(warning, "Out of Memory, Cannot allocate space for Program Specificaation.");
                xvf_error_wait(warning, "COMPOSER ERROR!", "OK");
	        return;
	    }
            for (i = 0; i < MaxProgSpecSize; i++) prog_spec[i] = NULL;
	    gw_init_keynames(keynames);

	    valid_prog_file = TRUE;
	}

	/*
	 * user clicked on pane action button 'authors'
	 */
	if (edit_prog_info->authors) {
	    xvf_change_input(form, edit_prog_info->prog_text_index,
                          xvf_stringval_chng, ex_prog_spec[Authors], 0);
	    comp_text_wait(Authors);
	}

	/*
	 * user clicked on pane action button 'short_prog_description'
	 */
	else if (edit_prog_info->short_prog_description) {
	    xvf_change_input(form, edit_prog_info->prog_text_index,
                          xvf_stringval_chng, ex_prog_spec[ShortProgDesc], 0);
	    comp_text_wait(ShortProgDesc);
	}

	/*
	 * user clicked on pane action button 'man1_long_description'
	 */
	else if (edit_prog_info->man1_long_description) {
	    xvf_change_input(form, edit_prog_info->prog_text_index,
                          xvf_stringval_chng, ex_prog_spec[Man1LongDesc], 0);
	    comp_text_wait(Man1LongDesc);
	}

	/*
	 * user clicked on pane action button 'man1_examples'
	 */
	else if (edit_prog_info->man1_examples) {
	    xvf_change_input(form, edit_prog_info->prog_text_index,
                          xvf_stringval_chng, ex_prog_spec[Man1Examples], 0);
	    comp_text_wait(Man1Examples);
	}

	/*
	 * user clicked on pane action button 'man1_restrictions'
	 */
	else if (edit_prog_info->man1_restrictions) {
	    xvf_change_input(form, edit_prog_info->prog_text_index,
                         xvf_stringval_chng, ex_prog_spec[Man1Restrictions], 0);
	   comp_text_wait(Man1Restrictions);
	}

	/*
	 * user clicked on pane action button 'man1_see_also'
	 */
	else if (edit_prog_info->man1_see_also) {
	    xvf_change_input(form, edit_prog_info->prog_text_index,
                          xvf_stringval_chng, ex_prog_spec[Man1SeeAlso], 0);
	   comp_text_wait(Man1SeeAlso);
	}

	/*
	 * user clicked on pane action button 'usage_additions'
	 */
	else if (edit_prog_info->usage_additions) {
	    xvf_change_input(form, edit_prog_info->prog_text_index,
                          xvf_stringval_chng, ex_prog_spec[UsageAdd], 0);
	   comp_text_wait(UsageAdd);
	}

	/*
	 * user clicked on pane action button 'include_includes'
	 */
	else if (edit_prog_info->include_includes) {
	    xvf_change_input(form, edit_prog_info->prog_text_index,
                          xvf_stringval_chng, ex_prog_spec[IncludeIncludes], 0);
	   comp_text_wait(IncludeIncludes);
	}

	/*
	 * user clicked on pane action button 'include_additions'
	 */
	else if (edit_prog_info->include_additions) {
	    xvf_change_input(form, edit_prog_info->prog_text_index,
                          xvf_stringval_chng, ex_prog_spec[IncludeAdd], 0);
	   comp_text_wait(IncludeAdd);
	}

	/*
	 * user clicked on pane action button 'include_macros'
	 */
	else if (edit_prog_info->include_macros) {
	    xvf_change_input(form, edit_prog_info->prog_text_index,
                          xvf_stringval_chng, ex_prog_spec[IncludeMacros], 0);
	   comp_text_wait(IncludeMacros);
	}

	/*
	 * user clicked on pane action button 'main_variable_list'
	 */
	else if (edit_prog_info->main_variable_list) {
	    xvf_change_input(form, edit_prog_info->prog_text_index,
                          xvf_stringval_chng, ex_prog_spec[MainVariables], 0);
	   comp_text_wait(MainVariables);
	}

	/*
	 * user clicked on pane action button 'main_before_lib_call'
	 */
	else if (edit_prog_info->main_before_lib_call) {
	    xvf_change_input(form, edit_prog_info->prog_text_index,
                          xvf_stringval_chng, ex_prog_spec[MainBeforeLib], 0);
	   comp_text_wait(MainBeforeLib);
	}

	/*
	 * user clicked on pane action button 'main_library_call'
	 */
	else if (edit_prog_info->main_library_call) {
	    xvf_change_input(form, edit_prog_info->prog_text_index,
                          xvf_stringval_chng, ex_prog_spec[MainLibCall], 0);
	   comp_text_wait(MainLibCall);
	}

	/*
	 * user clicked on pane action button 'main_after_lib_call'
	 */
	else if (edit_prog_info->main_after_lib_call) {
	    xvf_change_input(form, edit_prog_info->prog_text_index,
                          xvf_stringval_chng, ex_prog_spec[MainAfterLib], 0);
	   comp_text_wait(MainAfterLib);
	}

	/*
	 * user clicked on pane action button 'library_def'
	 */
	else if (edit_prog_info->library_def) {
	    xvf_change_input(form, edit_prog_info->prog_text_index,
                          xvf_stringval_chng, ex_prog_spec[LibraryDef], 0);
	   comp_text_wait(LibraryDef);
	}

	/*
	 * user clicked on pane action button 'library_includes'
	 */
	else if (edit_prog_info->library_includes) {
	    xvf_change_input(form, edit_prog_info->prog_text_index,
                          xvf_stringval_chng, ex_prog_spec[LibraryIncludes], 0);
	   comp_text_wait(LibraryIncludes);
	}

	/*
	 * user clicked on pane action button 'library_code'
	 */
	else if (edit_prog_info->library_code) {
	    xvf_change_input(form, edit_prog_info->prog_text_index,
                          xvf_stringval_chng, ex_prog_spec[LibraryCode], 0);
	   comp_text_wait(LibraryCode);
	}

	/*
	 * user clicked on pane action button 'short_lib_description'
	 */
	else if (edit_prog_info->short_lib_description) {
	    xvf_change_input(form, edit_prog_info->prog_text_index,
                          xvf_stringval_chng, ex_prog_spec[ShortLibDesc], 0);
	   comp_text_wait(ShortLibDesc);
	}

	/*
	 * user clicked on pane action button 'man3_long_description'
	 */
	else if (edit_prog_info->man3_long_description) {
	    xvf_change_input(form, edit_prog_info->prog_text_index,
                          xvf_stringval_chng, ex_prog_spec[Man3LongDesc], 0);
	   comp_text_wait(Man3LongDesc);
	}

	/*
	 * user clicked on pane action button 'man3_see_also'
	 */
	else if (edit_prog_info->man3_see_also) {
	    xvf_change_input(form, edit_prog_info->prog_text_index,
                          xvf_stringval_chng, ex_prog_spec[Man3SeeAlso], 0);
	   comp_text_wait(Man3SeeAlso);
	}

	/*
	 * user clicked on pane action button 'man3_restrictions'
	 */
	else if (edit_prog_info->man3_restrictions) {
	    xvf_change_input(form, edit_prog_info->prog_text_index,
                          xvf_stringval_chng, ex_prog_spec[Man3Restrictions], 0);
	   comp_text_wait(Man3Restrictions);
	}

	/*
	 * user clicked on pane action button 'library_mods'
	 */
	else if (edit_prog_info->library_mods) {
	    xvf_change_input(form, edit_prog_info->prog_text_index,
                          xvf_stringval_chng, ex_prog_spec[LibraryMods], 0);
	   comp_text_wait(LibraryMods);
	}

	/*
	 * user clicked on pane action button 'library_input'
	 */
	else if (edit_prog_info->library_input) {
	    xvf_change_input(form, edit_prog_info->prog_text_index,
                          xvf_stringval_chng, ex_prog_spec[LibraryInput], 0);
	   comp_text_wait(LibraryInput);
	}

	/*
	 * user clicked on pane action button 'library_output'
	 */
	else if (edit_prog_info->library_output) {
	    xvf_change_input(form, edit_prog_info->prog_text_index,
                          xvf_stringval_chng, ex_prog_spec[LibraryOutput], 0);
	   comp_text_wait(LibraryOutput);
	}
}


/********************************************************
*
*  Routine Name:  run_conf_manage
*
*       Purpose:  drives the subform 'conf_manage'
*
*         Input:  form - pointer to the form tree 
*		  conf_manage_info  - information structure for subform 'conf_manage'
*        Output:  action of the application program
*
*     Called By:  run_Composer()
*
*   Automatically Generated By:  conductor -i /research/devel/khaos/repos/composer/composer.form -l 3 -b
*
********************************************************/


run_conf_manage(form, conf_manage_info)

xvf_form *form;
Composer_conf_manage *conf_manage_info;
{

	_xvf_get_conf_manage(form, conf_manage_info);

	/*
	 * action came from the 'ghost_routines' pane
	 */
	if (conf_manage_info->ghost_routines_selected)
	    run_ghost_routines(form, conf_manage_info->ghost_routines);


}   /* end run_conf_manage */

/********************************************************
*
*  Routine Name:  run_ghost_routines
*
*       Purpose:  drives the pane 'ghost_routines'
*
*         Input:  form - pointer to the form tree 
*		  ghost_routines_info  - information structure for pane 'ghost_routines'
*        Output:  action of the application program
*
*     Called By:  run_conf_manage()
*
*   Automatically Generated By:  conductor -i /research/devel/khaos/repos/composer/composer.form -l 3 -b
*
********************************************************/


run_ghost_routines(form, ghost_routines_info)

xvf_form *form;
conf_manage_ghost_routines *ghost_routines_info;
{
	char 	temp[MaxLength];
	char    warning[MaxLength];
	char 	*temp_file;
	char 	*toolbox, *status;


	_xvf_get_ghost_routines(form, ghost_routines_info);

	/*
	 * user clicked on pane action button 'exec_ghostcheck'
	 */

	/*
	 * Check that a valid program name and a valid toolbox have
	 * been specified.
	 */


	/* 
	 *  If the string returned from the form is not a valid toolbox,
	 *  then do not use -toolbox line. 
	 */

	if (ghost_routines_info->project != NULL) {
	    toolbox = vupper_string(ghost_routines_info->project, NULL);
	    status  = vtoolbox_path(toolbox);
	    free(toolbox);
	    if (status == NULL) {
	        (void) sprintf(warning,
                  "The toolbox name %s is not a valid toolbox. If you do not intend to install your program immediately, you may leave the toolbox name blank until you are ready to run kinstall. Once you specify a valid toolbox, you will need to remove the Imakefile and run ghostwriter again.", 
		ghost_routines_info->project);
	        xvf_error_wait(warning, "COMPOSER WARNING!", "OK");
	        return;
	    }
	} 
	else status = NULL;  /* no toolbox was specified */

	if (ghost_routines_info->exec_ghostcheck) {
	    temp_file = vtempnam("composer");
	    (void) sprintf(temp, 
                 "/bin/csh -cf \"ghostcheck -name %s -config %d  >& %s\"",
                 ghost_routines_info->name, ghost_routines_info->con_file, 
                 temp_file);
	    system(temp);
	    (void) printf("command: %s", temp);	
	    xvf_create_view(temp_file, "GHOSTCHECK", "GHOSTCHECK"); 
	    unlink(temp_file);
	}

	/*
	 * user clicked on pane action button 'exec_ghostreader'
	 */
	else if (ghost_routines_info->exec_ghostreader) {
	    temp_file = vtempnam("composer");
	    (void) sprintf(temp, 
                 "/bin/csh -cf \"ghostreader -name %s -config %d -lib %d -man3 %d -install %d -prog 0 -format 1 -force 1  >& %s\"",
                 ghost_routines_info->name,
	         ghost_routines_info->con_file,
                 ghost_routines_info->lib, 
	         ghost_routines_info->man3,
                 ghost_routines_info->install, 
	         temp_file);
	    system(temp);
	    (void) printf("command: %s", temp);	
	    xvf_create_view(temp_file, "GHOSTREADER", "GHOSTREADER"); 
	    unlink(temp_file);
	}

	/*
	 * user clicked on pane action button 'exec_ghost'
	 */
	else if (ghost_routines_info->exec_ghost) {
	    temp_file = vtempnam("composer");
	    if (status == NULL) {  /* do not use toolbox */
                (void) sprintf(temp, 
                 "/bin/csh -cf \"ghostwriter -name %s -config %d -lib %d -man3 %d -install %d -debug 0 -format 1 -tag 1 -force 1 >& %s\"",
                 ghost_routines_info->name, 
		 ghost_routines_info->con_file,
                 ghost_routines_info->lib, 
		 ghost_routines_info->man3,
                 ghost_routines_info->install,
		 temp_file);
	    }
	    else {
                (void) sprintf(temp, 
                 "/bin/csh -cf \"ghostwriter -name %s -config %d -toolbox %s -lib %d -man3 %d -install %d -debug 0 -format 1 -tag 1 -force 1 >& %s\"",
                 ghost_routines_info->name, 
		 ghost_routines_info->con_file,
                 ghost_routines_info->project,
                 ghost_routines_info->lib, 
		 ghost_routines_info->man3,
                 ghost_routines_info->install,
		 temp_file);
	    }
	    system(temp);
	    (void) printf("command: %s", temp);	
	    xvf_create_view(temp_file, "GHOSTWRITER", "GHOSTWRITER"); 
	    unlink(temp_file);
	}

	/*
	 * user clicked on pane action button 'exec_make'
	 */
	else if (ghost_routines_info->exec_make) {
	    temp_file = vtempnam("composer");
            (void) sprintf(temp,"/bin/csh -cf \"make >& %s\"", temp_file);
	    system(temp);
	    (void) printf("command: %s", temp);	
	    xvf_create_view(temp_file, "MAKE", "MAKE"); 
	    unlink(temp_file);
	}

	/*
	 * user clicked on pane action button 'exec_kinstall'
	 */
	else if (ghost_routines_info->exec_kinstall) {
	    if (status == NULL) {  /* do not use toolbox */
                (void) sprintf(temp,"xterm -display %s -e /bin/csh -cf 'kinstall -name %s -conf %s.conf ; sleep 10' &",
		display->display_name,     /* "host:display" string used */
                ghost_routines_info->name, 
		ghost_routines_info->name);
	    }
	    else {
                (void) sprintf(temp,"xterm -display %s -e /bin/csh -cf 'kinstall -name %s -conf %s.conf -toolbox %s ; sleep 10' &",
		display->display_name,     /* "host:display" string used */
                ghost_routines_info->name, 
		ghost_routines_info->name,
                ghost_routines_info->project);
	    }
	    system(temp);
	    (void) printf("command: %s", temp);	
	}
	glob_routine_name = xvf_strcpy(ghost_routines_info->name);
}

/********************************************************
*
*  Routine Name:  process_line
*
*       Purpose:  process the selected line
*		After a line type is selected in the form, gather, display
*		and fill.
*
*         Input:  global form structure demo_form and global gui_spec
*		line_number - pointer to the curently selected line
*		line_type   - type flag of line to be selected
*		form        - form structure
*		edit_pane_info - structure for the edit pane
*        Output:  form being edited is displayed
*		line_number - pointer to the new curently selected line
*
*     Called By:  run_edit_pane
*
*   Written By:  John Rasure
*
********************************************************/

process_line(line_number, line_type, form, edit_pane_info)
int	*line_number;
int	line_type;
xvf_form *form;
pane_edit_pane *edit_pane_info;
{
	int		line_index;
	int		current_selection;
	char    	warning[MaxLength];

	int i, num_items = 0;   /* number of items in the list widget*/

	char    *list[MAX_LIST];           /*  list for widget */
	int     item_location[MAX_LIST];   /* map between list widget items
							  and *gui_spec[]  */

	int     current, num_col = 1;      /* stuff for xvf_run_list */
	XawListReturnStruct    *entry;
	char	*label  = "Click on CANCEL if you do not wish to edit any item",
		*prompt = "Select a user interface line to edit:";

	current_selection = *line_number;

	/* a pane file has not been read in, create one */

	if (valid_pane_file == FALSE || gui_spec == NULL) {  

	    /* allocate global UI spec for editing */
	    gui_spec = (caddr_t *) calloc(1,sizeof(char *)*MaxDBSize);
	    if (gui_spec == NULL) {
	        (void) sprintf(warning, "Out of Memory, Cannot allocate space for User Interface Specificaation.");
                xvf_error_wait(warning, "COMPOSER ERROR!", "OK");
	        return;
	    }

	    gui_spec_lines = 0;
	    gui_spec[gui_spec_lines++] = xvf_strcpy(line_template[StartForm]);
	    gui_spec[gui_spec_lines++] = xvf_strcpy(line_template[StartSubForm]);
	    current_selection = gui_spec_lines;
	    gui_spec[gui_spec_lines++] = xvf_strcpy(line_template[StartPane]);

	    gui_spec[gui_spec_lines++] = xvf_strcpy("-E");
	    gui_spec[gui_spec_lines++] = xvf_strcpy("-E");
	    gui_spec[gui_spec_lines++] = xvf_strcpy("-E");

    	    /* The calls of init_pane_edit() and ok_pane_edit() in active.c
		are used to force the user to first edit a -P line, if
		a UI spec is not read in 
	    */
	    ok_pane_edit(form, edit_pane_info);

	    /* Fill the form out with the created line */
	    fill_pane(form, edit_pane_info, current_selection);
       
            valid_pane_file = TRUE;

	    *line_number = current_selection;
            display_demo_form();
    	    return;
        }

	/* 
	   if there is a valid pane file, then:
	1. gather all information from the form.
	2. build a list of the selected line type
	3. If there are none, create a line of the selected type
	4. Put the line information into pane for editing.
	*/
	    
	/* gather information from pane and put into currently 
	   selected line of gui_spec */

	if (current_selection != NONE_SELECTED) gather(edit_pane_info, current_selection);

	display_demo_form();

	for (line_index = 1; line_index < gui_spec_lines-1; line_index++) {
	    /* build list of selected lines */
	    if (xvf_get_line_type(gui_spec[line_index]) == line_type) {
		item_location[num_items] = line_index;
		list[num_items] = xvf_strcpy(gui_spec[line_index]);
		num_items++;
                if (num_items >= MAX_LIST) {
		    (void) sprintf(warning, "Too many items selected for list.");
	    	    xvf_error_wait(warning, "COMPOSER ERROR!", "OK");
		    --num_items;
		}
	    }
	}
	/* It has been insured that there is at least one -P line.
	  It is possible that there are no items in the list, if so one
	  will be added.  
	  A new item (template) is added to the bottom of the list.
	*/
	if (line_type != StartPane) {  /* there can only be one */
	    list[num_items] = xvf_strcpy(line_template[line_type]);
	    num_items++;
	}

	if (entry = xvf_run_list_wait(list, num_items, num_col, prompt,
				      label, &current, FALSE)) {
	    /* if the new item on the bottom was selected, then add it */
	    if (entry->list_index == num_items-1 && line_type != StartPane) {
		/* insert the new line into the gui_spec */
	        for (line_index = gui_spec_lines-1; 
                        xvf_get_line_type(gui_spec[line_index]) != StartPane; 
                        line_index--){
	            gui_spec[line_index+1] = gui_spec[line_index];
	        }
                line_index++;
	        gui_spec[line_index] = xvf_strcpy(line_template[line_type]);
		current_selection = line_index;
	        gui_spec_lines++;  /* one more line in spec */
	        if (line_type == Toggle || line_type == MutExcl) {
		    /* Insert a matching -E line */
		    for (i = gui_spec_lines-1; i != line_index; i--){
		        gui_spec[i+1] = gui_spec[i];
		    }
                    i++;
	            gui_spec[i] = xvf_strcpy("-E");
	            gui_spec_lines++;  /* one more line in spec */
		}
	    }
	    else 
	        current_selection = item_location[entry->list_index];

	    free(entry);
	    for (i=0; i< num_items; i++) free(list[i]);

	    active(form, edit_pane_info, line_type);
	    fill_pane(form, edit_pane_info, current_selection);

	    if (line_type == Toggle || line_type == MutExcl) {
	        process_group(&current_selection, form, edit_pane_info);
	        display_demo_form();
	        *line_number = current_selection;
	    }

	    else {
	        display_demo_form();
		*line_number = current_selection;
	    }
	}
	else {
	    current_selection = NONE_SELECTED;
	    *line_number = current_selection;
	    return;  /*cancel was selected on list*/
	}
}

/********************************************************
*
*  Routine Name:  process_group
*
*       Purpose:  Select a group of lines after a -T or -C has been selected.
*
*         Input:  global form structure demo_form and global gui_spec
*		line_number - the curently selected line
*		form        - form structure
*		edit_pane_info - structure for the edit pane
*        Output:  the global gui_spec is rearranged for the toggle or 
*			mutually exclusive group
*
*     Called By:  run_edit_pane
*
*   Written By:  John Rasure
*
********************************************************/

process_group(current_selection, form, edit_pane_info)
int	*current_selection;
xvf_form *form;
pane_edit_pane *edit_pane_info;
{
	Line_Info 	line_info;
	int		i, line_number, line_index;
	int		line_type, toggle_type;
	int		rel_pos;  /* marks if line is before or after T or C */
	int		position;  /* marks position of line */
	float 		toggle_min, toggle_max;
	char    	warning[MaxLength];

	int num_items = 0;   /* number of items in the list widget  */
	int num_sels = 0;   /* number of items selected in the list widget*/


	char    *list[MAX_LIST];           /*  list for widget */
	char    *sel_list[MAX_LIST];
	int     item_location[MAX_LIST];   /* map between list widget items
							  and *gui_spec[]  */

	int     current, num_col = 1;      /* stuff for xvf_run_list */
	XawListReturnStruct    *entry;
	XawListReturnStruct    **entries;
	char *label = "Click on CANCEL if you do not wish to select any items",
	     *prompt = "Select the list of lines to be grouped:";
	char *label2 = "Click on CANCEL if you do not wish to select type",
	     *prompt2 = "Select the type of line that you wish to toggle:";
	char *label3 = "Click on CANCEL if you do not wish to select default.",
	     *prompt3 = "Select the default item in the group:";
	int  duplicate_entries = FALSE;
	int  user_defined = FALSE;

	/* 
	   if -T or -C has been selected, then:
	0. gather information from form
	1. build a list all lines that could go in a group
	2. If there are none, return
	3. Put the line information into pane for editing.
	*/
	    
	line_number = *current_selection;
	line_type = xvf_get_line_type(gui_spec[line_number]);
	    if (line_type == Toggle) {  /* user select what type of lines */
		toggle_type = xvf_get_line_type(gui_spec[line_number+1]);
		if (toggle_type == End) {   /* nothing in toggle so select */
		    num_items = 0;
	            /* build list of lines of possible choices */
		    list[num_items++] = xvf_strcpy("Input  Files  ");
		    list[num_items++] = xvf_strcpy("Output Files  ");
		    list[num_items++] = xvf_strcpy("Float   Inputs");
		    list[num_items++] = xvf_strcpy("Integer Inputs");
		    list[num_items++] = xvf_strcpy("String  Inputs");
		    list[num_items++] = xvf_strcpy("Logical Inputs");

	            if (entry = xvf_run_list_wait(list, num_items, num_col, 
			prompt2, label2, &current, FALSE)) {
		        if (entry->list_index == 0) toggle_type = InputFile;
		        else if (entry->list_index == 1) toggle_type=OutputFile;
		        else if (entry->list_index == 2) toggle_type=FloatOpt;
		        else if (entry->list_index == 3) toggle_type=IntegerOpt;
		        else if (entry->list_index == 4) toggle_type=StringOpt;
		        else if (entry->list_index == 5) toggle_type=LogicOpt;
		        else toggle_type = LogicOpt;

	                free(entry);
	                for (i=0; i< num_items; i++) free(list[i]);
		    }
		    else return;  /* user selected cancel */
		}

		num_items = 0;
	        for (line_index=1; line_index<gui_spec_lines-1; line_index++) {
	            if (xvf_get_line_type(gui_spec[line_index])==toggle_type) {
		        item_location[num_items] = line_index;
		        list[num_items] = xvf_strcpy(gui_spec[line_index]);
		        num_items++;
                        if (num_items >= MAX_LIST) {
		            (void) sprintf(warning, "Too many items selected for list.");
	    	            xvf_error_wait(warning, "COMPOSER ERROR!", "OK");
		            --num_items;
		        }
	            }
	        }  /* there is now a list of possible lines for the toggle */
		if (num_items <= 1) {
	            (void) sprintf(warning, "There are not enough lines for the grouping that was requested. Add another line of the proper type.");
                    xvf_error_wait(warning, "COMPOSER ERROR!", "OK");
	            return;
		}
		/* pop up the list */
		entries = xvf_run_list_multsel_wait(list, num_items, 
			       num_col, prompt, label, user_defined, 
			       duplicate_entries, &num_sels);
		if (entries == NULL) return;  /* no items selected */
		/* move lines into the Toggle */
		toggle_min = XV_MAXFLOAT; toggle_max = -XV_MAXFLOAT;
		for (i = 0; i < num_sels; i++) {
		    /* current selection points to toggle line
		       insert one of group after Toggle line */
		    for (line_index = gui_spec_lines-1; line_index != line_number; line_index--){
		        gui_spec[line_index+1] = gui_spec[line_index];
		    }
                    line_index++;
		    position = item_location[entries[i]->list_index];
		    if(position > line_number) rel_pos = 1;
		    else rel_pos = -i;
	            gui_spec[line_index]=xvf_strcpy(gui_spec[rel_pos+position]);

	            /* change optional and opt_selected fields to 10 */
		    xvf_clear_line_info(&line_info);
		    xvf_gen_parse(gui_spec[line_index], &line_info);
		    line_info.optional = 1;
		    line_info.opt_sel= 0;
		    line_info.write = TRUE;

		    /* if it is a float or integer, find the range */
		    if (line_info.typeflag == FloatOpt) {
		        toggle_min = MIN(toggle_min, line_info.float_def);
		        toggle_max = MAX(toggle_max, line_info.float_def);
		    }
		    if (line_info.typeflag == IntegerOpt) {
		        toggle_min = MIN(toggle_min, line_info.int_def);
		        toggle_max = MAX(toggle_max, line_info.int_def);
		    }

		    xvf_gen_deparse(&line_info, gui_spec, line_index);

		    sel_list[i] = xvf_strcpy(gui_spec[line_index]);

		    /* delete the line that was just inserted */
		    for (line_index = rel_pos + position;
				   line_index < gui_spec_lines; line_index++) {
			gui_spec[line_index] = gui_spec[line_index+1];
		    }
	 	    if(rel_pos != 1) line_number=line_number-1;
		    free(list[i]);
		}
		*current_selection = line_number;
		free(entries);

		/* pop up list of only selected items and ask for default */
	        if (entry = xvf_run_list_wait(sel_list, num_sels, 
                            num_col, prompt3, label3, &current, FALSE)) {
		    xvf_clear_line_info(&line_info);
		    xvf_gen_parse(gui_spec[line_number], &line_info);
		    line_info.toggle_def = line_info.toggle_val = 
				num_sels - entry->list_index;
		    line_info.write = TRUE;
		    xvf_gen_deparse(&line_info, gui_spec, line_number);

	            /* change optional and opt_selected fields from 10 to 11 */
		    xvf_clear_line_info(&line_info);
		    xvf_gen_parse(gui_spec[line_number+num_sels-entry->list_index], &line_info);
		    line_info.opt_sel = 1;
		    line_info.write = TRUE;
		    xvf_gen_deparse(&line_info, gui_spec, line_number+num_sels-entry->list_index);

		    /* if it is a float or integer, set the range */
		    if (line_info.typeflag == FloatOpt) {
			for (i=line_number+1; i < line_number+1+num_sels; i++) {
			    xvf_clear_line_info(&line_info);
			    xvf_gen_parse(gui_spec[i], &line_info);
		            line_info.lower_float = toggle_min;
		            line_info.upper_float = toggle_max;
		            line_info.write = TRUE;
			    xvf_gen_deparse(&line_info, gui_spec, i);
			}
		    }
		    if (line_info.typeflag == IntegerOpt) {
			for (i=line_number+1; i < line_number+1+num_sels; i++) {
			    xvf_clear_line_info(&line_info);
			    xvf_gen_parse(gui_spec[i], &line_info);
		            line_info.lower_int = toggle_min;
		            line_info.upper_int = toggle_max;
		            line_info.write = TRUE;
			    xvf_gen_deparse(&line_info, gui_spec, i);
			}
		    }

	            free(entry);
	            for (i=0; i< num_sels; i++) free(sel_list[i]);
		}
		else return;  /* user selected cancel */
	    }
	    else { /* group for mut exclusive , so all lines ok */
		num_items = 0;
	        for (line_index=1; line_index<gui_spec_lines-1; line_index++) {
		    toggle_type = xvf_get_line_type(gui_spec[line_index]);
		    if (toggle_type == InputFile || toggle_type == OutputFile ||
		        toggle_type == FloatOpt || toggle_type == IntegerOpt ||
		        toggle_type == StringOpt || toggle_type == LogicOpt) {
		        item_location[num_items] = line_index;
		        list[num_items] = xvf_strcpy(gui_spec[line_index]);
		        num_items++;
                        if (num_items >= MAX_LIST) {
		            (void) sprintf(warning, "Too many items selected for list.");
	    	            xvf_error_wait(warning, "COMPOSER ERROR!", "OK");
		            --num_items;
		        }
	            }
	        }  /* there is now a list of possible lines for the Mut Excl */
		if (num_items <= 1) {
	            (void) sprintf(warning, "There are not enough lines for the grouping that was requested. Add another line of the proper type.");
                    xvf_error_wait(warning, "COMPOSER ERROR!", "OK");
	            return;
		}

		/* pop up list of candidate items */
		entries = xvf_run_list_multsel_wait(list, num_items, 
			       num_col, prompt, label, user_defined, 
			       duplicate_entries, &num_sels);
		if (entries == NULL) return;  /* no items selected */
		/* move lines into the Mut Excl */
		for (i = 0; i < num_sels; i++) {
		    /* current selection points to -C line
		       insert one of group after Mutexcl line */
		    for (line_index = gui_spec_lines-1; line_index != line_number; line_index--){
		        gui_spec[line_index+1] = gui_spec[line_index];
		    }
                    line_index++;
		    position = item_location[entries[i]->list_index];
		    if(position > line_number) rel_pos = 1;
		    else rel_pos = -i;
	            gui_spec[line_index]=xvf_strcpy(gui_spec[rel_pos+position]);

		    /* change optional and opt_selected fields to 10 */
		    xvf_clear_line_info(&line_info);
		    xvf_gen_parse(gui_spec[line_index], &line_info);
		    line_info.optional = 1;
		    line_info.opt_sel= 0;
		    line_info.write = TRUE;
		    xvf_gen_deparse(&line_info, gui_spec, line_index);

		    sel_list[i] = xvf_strcpy(gui_spec[line_index]);

		    /* delete the line that was just inserted */
		    for (line_index = rel_pos + position;
				    line_index < gui_spec_lines; line_index++) {
			gui_spec[line_index] = gui_spec[line_index+1];
		    }
		    if(rel_pos != 1) line_number=line_number-1;
		    free(list[i]);
		}
		*current_selection = line_number;
		free(entries);
		/* pop up list of only selected items and ask for default */
		if (entry = xvf_run_list_wait(sel_list, num_sels,
			    num_col, prompt3, label3, &current, FALSE)) {
		    /* change optional and opt_selected fields from 10 to 11 */
		    xvf_clear_line_info(&line_info);
		    xvf_gen_parse(gui_spec[line_number+num_sels-entry->list_index], &line_info);
		    line_info.opt_sel = 1;
		    line_info.write = TRUE;
		    xvf_gen_deparse(&line_info, gui_spec, line_number+num_sels-entry->list_index);

		    free(entry);
		    for (i=0; i< num_sels; i++) free(sel_list[i]);
		}
	        else return;  /* user selected cancel */
	    }
}

/********************************************************
*
*  Routine Name:  update_edit_pane
*
*       Purpose:  updates the pane according to a live selection
*		Uses current selected line to gather and then display.
*
*         Input:  global form structure demo_form and global gui_spec
*               line_number    - the curently selected line
*               edit_pane_info - structure for the edit pane
*               chage_code     - the code for xvf_change_input
*				UPDATE_LINE_ONLY = -2:    this code says 
*					that a visible change was not made
*				UPDATE_DISPLAY =  -1:  this code says 
*					that a visible change was made, but 
*					there is not currently a change_code
*               string         - the string to be used for xvf_change_input
*				 Can not be NULL for a valid change code
*        Output:  form being edited is displayed
*               and line in gui_spec is updated
*
*     Called By:  run_edit_pane
*
*   Written By:  John Rasure
*
********************************************************/

update_edit_pane(line_number, edit_pane_info, change_code, string)
int		line_number;
pane_edit_pane *edit_pane_info;
int		change_code;
char		*string;
{
	char    	warning[MaxLength];

	/* a pane file has not been read in, so warn and return */

	if (valid_pane_file == FALSE || gui_spec == NULL) {  
	    (void) sprintf(warning, "You have not read in a User Interface Specificaation file.  Either select a line type to begin a new user interface or read in a UI Specification file.");
            xvf_error_wait(warning, "COMPOSER ERROR!", "OK");
	    return;
        }
	    
	/* gather information from pane and put into currently 
	   selected line of gui_spec */

	if (line_number != NONE_SELECTED) gather(edit_pane_info, line_number);

	else {  
	    (void) sprintf(warning, "You have not selected a specific line in the User Interface Specificaation.  Either select a line type to edit or read a new UI Specification file.");
            xvf_error_wait(warning, "COMPOSER ERROR!", "OK");
	    return;
        }

	/* if the change code is not known or isn't supported yet, do
	   a normal recreation of the demo_form, else just update using 
	   the change code */
	if ( change_code != UPDATE_LINE_ONLY) {
	    if ( change_code == UPDATE_DISPLAY) display_demo_form();
	    else xvf_change_input(demo_form, line_number, 
                                        change_code, string, 0);
	}
}


/********************************************************
*
*  Routine Name:  display_demo_form
*
*       Purpose:  destroy old form and map new one
*
*         Input:  global form structure demo_form and global gui_spec
*        Output:  form being edited is displayed
*
*     Called By:  run_edit_pane
*
*   Written By:  John Rasure
*
********************************************************/

display_demo_form()
{
	xvf_form  *xvf_build_form();
	char	**xvf_copy_database(), **spec;
	char    warning[MaxLength];

        int  x, y, width, height;

	if (demo_form != NULL) {
	   if (demo_form->toplevel != NULL)
	      xvf_form_geometry(demo_form, &x, &y, &width, &height);
	   else
	      xvf_subform_geometry(demo_form->subform, &x, &y, &width, &height);

	   xvf_destroy_form(demo_form);
	}
	else x = y = -1;

	spec = xvf_copy_database(gui_spec);
	if (spec == NULL) {
	    (void) sprintf(warning, "Unable to copy user interface specification");
	    xvf_error_wait(warning, "COMPOSER WARNING!", "OK");
	    return;
	}

	if (!(demo_form = xvf_build_form(spec, gui_spec_lines, gui_spec_size,
					 av, ac, SIMPLE, NULL,x,y))) {
	    (void) sprintf(warning, "Unable to build forms to preview the user interface specification");
	    xvf_error_wait(warning, "COMPOSER WARNING!", "OK");
	}
	else {
	    xvf_change_active (demo_form, true);
	}
}

/********************************************************
*
*  Routine Name:  comp_text_wait
*
*       Purpose:  calls xvf_text_wait with checks and post processing.
*
*         Input:  prog_field - code indicating which field of the prog
		specification to edit.
		prog_spec is global
*		  
*        Output:  The edited string global prog_spec.  
*
*     Called By:  run_edit_prog()
*
********************************************************/


int comp_text_wait(prog_field)
int 	prog_field;
{
	int 	size;
	char    *temp;
	char    *label  = "Composer Program Specification Editor";

	if (prog_spec[prog_field] == NULL) 
	      temp = xvf_text_wait(" ", label, prog_inst[prog_field]);
	else temp =
	    xvf_text_wait(prog_spec[prog_field], label, prog_inst[prog_field]);
	
	size = xvf_strlen(temp);

	if  (size > 0) {
	    if  (temp[size-1] != '\n') 
               prog_spec[prog_field] = VStrcat(temp, "\n");
	    else prog_spec[prog_field] = xvf_strcpy(temp);
        }

}   /* end comp_text_wait */
