 /*
  * Khoros: $Id: run_kraft.c,v 1.4 1992/03/20 22:52:43 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: run_kraft.c,v 1.4 1992/03/20 22:52:43 dkhoros Exp $";
#endif

 /*
  * $Log: run_kraft.c,v $
 * Revision 1.4  1992/03/20  22:52:43  dkhoros
 * VirtualPatch5
 *
  */

/*
 *---------------------------------------------------------------------
 *            Copyright 1990 University of New Mexico
 * 
 * Permission to copy and modify this software and its documen- 
 * tation only for internal use in your organization is hereby 
 * granted, provided that this notice is retained thereon and 
 * on all copies.  UNM makes no representations as too the sui- 
 * tability and operability of this software for any purpose. 
 * It is provided 'as is' without express or implied warranty. 
 *  
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, 
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT- 
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL, 
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT- 
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS 
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER- 
 * FORMANCE OF THIS SOFTWARE. 
 *  
 * No other rights, including for example, the right to redis- 
 * tribute this software and its documentation or the right to 
 * prepare derivative works, are granted unless specifically 
 * provided in a separate license agreement. 
 * 
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"	/* Copyright 1990 by UNM */
#include "kraftsman.h"

/********************************************************
*
*  Routine Name:  run_Kraftsman
*
*       Purpose:  drives the subform 'Kraftsman'
*
*         Input:  form - pointer to the form tree 
*		  Kraftsman_info - information structure for subform 'Kraftsman'
*        Output:  action of the application program
*
*     Called By:  run_Master()
*
*   Automatically Generated By:  conductor -i kraftsman.form -l 1 -b
*
********************************************************/


run_Kraftsman(form, Kraftsman_info)

xvf_form *form;
Master_Kraftsman *Kraftsman_info;
{

	char **tools_list, *errmsg, *errmsg1;
	int scnt;
	XawListReturnStruct *name;
        Khoros_toolboxes *tentry;

	/*
	 * user clicked on subform action button 'delete'
	 */
	if (Kraftsman_info->delete || Kraftsman_info->remove)
	{
		tools_list = vtoolbox_list2strlist(&scnt);
		errmsg = (Kraftsman_info->delete) ?
				VStrcpy("Choose A Toolbox to Delete"):
				VStrcpy("Choose A Toolbox to Remove");
		name = (scnt > 0) ? xvf_run_list_wait(tools_list, scnt, 1,
				    errmsg, "Toolbox List", NULL, false)
				  : NULL;
		free(errmsg);
		if (name == NULL)
		  {
		    if (scnt <= 0)
		      xvf_error_wait("No toolboxes exist", "Kraftsman Notice", 
				     "ok");
		    vfreelist(tools_list,scnt);
		    return;
		  }
		tentry = vtoolbox_entry(name->string);
		errmsg1 = VStrcpy(tentry->path);
		vtoolbox_delete(tentry->variable);
		vtoolbox_write("$KHOROS_TOOLBOX");
		if (Kraftsman_info->remove)
		  {
		    free(errmsg1);
		    vfreelist(tools_list,scnt);
		    return;
		  }
		errmsg = VStr3cat("This action will DELETE this toolbox, and all the files in ",errmsg1,".  Are you SURE you want to do this?  Click on Cont to continue with delete.");
		if (xvf_warn_wait(errmsg,"DELETE WARNING",NULL,NULL) == 0)
		  {
		    free(errmsg);
		    free(errmsg1);
		    vfreelist(tools_list,scnt);
		    return;
		  }
/*		dcmd = VStrcat("/bin/rm -rf ",errmsg1);
		xvf_fork(dcmd,NULL,NULL);
		free(dcmd); */
		vrmdir(errmsg1);
		free(errmsg1);
		free(errmsg);
	}

	/*
	 * action came from the 'create' pane
	 */
	else if (Kraftsman_info->create_selected)
	    run_create(form, Kraftsman_info->create);

	/*
	 * action came from the 'configure' pane
	 */
	else if (Kraftsman_info->configure_selected)
	    run_configure(form, Kraftsman_info->configure);


}   /* end run_Kraftsman */





/********************************************************
*
*  Routine Name:  run_create
*
*       Purpose:  drives the pane 'create'
*
*         Input:  form - pointer to the form tree 
*		  create_info  - information structure for pane 'create'
*        Output:  action of the application program
*
*     Called By:  run_Kraftsman()
*
*   Automatically Generated By:  conductor -i kraftsman.form -l 1 -b
*
********************************************************/


run_create(form, create_info)

xvf_form *form;
Kraftsman_create *create_info;
{

	char *toolbox = NULL, *utoolbox;
	char *path, *author, *user, *title, *des, *info;
	int status1 = TRUE;
	static int _update_pane = TRUE;

	/*
	 * This whole first section figures out the true toolbox name
	 */
	if (create_info->toolbox == NULL)
	  {
	    xvf_error_wait("run_Kraftsman: Toolbox name can not be empty","Kraftsman Error", "ok");
	    deactivate_create(form);
	    return;
	  }
	else if ((toolbox = vcleanup_string(create_info->toolbox,NULL)) == NULL)
	  {
	    xvf_error_wait("run_Kraftsman: Toolbox name can not be empty","Kraftsman Error", "ok");
	    deactivate_create(form);
	    return;
	  }
	else if (vtoolbox_entry(toolbox) !=  NULL)
	  {
	    xvf_error_wait("run_Kraftsman:  Toolbox already exists, delete current toolbox, or enter a new toolbox name","Kraftsman Error", "ok");
	    deactivate_create(form);
	    return;
	  }

	/*
	 * user clicked on 'live' string selection 'toolbox'
	 */
	if (create_info->toolbox_selected && _update_pane == TRUE)
	{
	  if (vstrpbrk(toolbox,"!\"#$%&'()*+,-./[\\]^`~{}|") != NULL)
	    {
	      xvf_error_wait("run_Kraftsman: Error, toolbox name has some odd characters in it.  Users may only use alpha-numeric and '_' characters", "Kraftsman Error", "ok");
	      return;
	    }
	  generate_def_create(toolbox,&path,&author,&user,&title,&des,&info);
	  activate_create(form, path, author, user, title, des, info);
	  free(path);
	  free(author);
	  free(user);
	  free(title);
	  free(des);
	  free(info);
	  _update_pane = FALSE;
	}

	/*
	 * user clicked on pane action button 'create'
	 */
	else if (create_info->create || create_info->add)
	{
	  utoolbox = (char *) vupper_string(toolbox,NULL);
	  path = vcleanup_string(create_info->toolpath,NULL);
	  author = vcleanup_string(create_info->author,NULL);
	  user = vcleanup_string(create_info->user,NULL);
	  title = vcleanup_string(create_info->title,NULL);
	  des = vcleanup_string(create_info->sdescript,NULL);
	  info = vcleanup_string(create_info->info,NULL);
	  if (getpwnam(user) == NULL)
	    xvf_error_wait("run_create: User field must be a valid login name",
			   "Kraftsman Error", "ok");
	  else
	    {
	      if (create_info->create)
	        status1 = create_toolbox(utoolbox, path, user, info);
	      status1 = (status1 == TRUE) ? add_toolbox(utoolbox, path, author,
							title, des, info)
					  : FALSE;
	      if (create_info->create && status1 == TRUE)
		xvf_error_wait("Toolbox Created", "Creation Update",
				"ok");
	      else if (status1 == TRUE)
		xvf_error_wait("Toolbox Added", "Addition Update",
				"ok");
	      deactivate_create(form);
	      xvf_change_input(form,Master_info.Kraftsman->configure->toolbox_index, xvf_stringval_chng, utoolbox, 0);
	      _update_pane = TRUE;
	    }
	  kfree(utoolbox);
	  kfree(path);
	  kfree(author);
	  kfree(user);
	  kfree(title);
	  kfree(des);
	  kfree(info);
	}

	free(toolbox);
}




/********************************************************
*
*  Routine Name:  run_configure
*
*       Purpose:  drives the pane 'configure'
*
*         Input:  form - pointer to the form tree 
*		  configure_info  - information structure for pane 'configure'
*        Output:  action of the application program
*
*     Called By:  run_Kraftsman()
*
*   Automatically Generated By:  conductor -i kraftsman.form -l 1 -b
*
********************************************************/


run_configure(form, configure_info)

xvf_form *form;
Kraftsman_configure *configure_info;
{
	char *toolbox = NULL, *temp, *temp1, *temp2, *value = NULL;
        int scnt, i, j = 0;
	int index = Master_info.Kraftsman->configure->libdir_index;
	char **tools_list;
	Khoros_toolboxes *entry;
	XawListReturnStruct *name;
	char *comparekey = NULL;
	Line_Info line_info;
	CFG_ENTRY *tmp_list = NULL;
	static CFG_ENTRY *entry_list = NULL;
	static int entry_cnt = 0;
	static char **imakefile = NULL;
	static char *def_filename = NULL;
	static char *last_toolbox = NULL;
	static char *endkey = "xlib";

	/*
	 * user clicked on pane action button 'tselect'
	 */

        if (entry_list == NULL)
	  entry_list = config2list(&entry_cnt,
			Master_info.Kraftsman->configure->libdir_index);
	if (configure_info->tselect)
	  {
	    if (vtoolbox_list() == NULL)
	      {
		xvf_error_wait("run_Kraftsman:  No toolboxes in list to configure", "Kraftsman Error", "ok");
		return;
	      }
	    tools_list = vtoolbox_list2strlist(&scnt); 
	    name = (scnt > 0) ? xvf_run_list_wait(tools_list, scnt, 1,
				"Choose A Toolbox to Delete", "Toolbox List",
				NULL, false) : NULL;
	    if (name == NULL)
	      {
		if (scnt <= 0)
		  xvf_error_wait("No toolboxes exist", "Kraftsman Notice","ok");
		vfreelist(tools_list,scnt);
		return;
	      }
	    toolbox = VStrcpy(name->string);
	    xvf_change_input(form,
			     Master_info.Kraftsman->configure->toolbox_index,
			     xvf_stringval_chng, toolbox);
	  }
	else if (configure_info->toolbox == NULL)
	  {
	    xvf_error_wait("run_Kraftsman: Toolbox name can not be empty","Kraftsman Error", "ok");
	    deactivate_config(form);
	    return;
	  }
	else if ((toolbox=vcleanup_string(configure_info->toolbox,NULL))==NULL)
	  {
	    xvf_error_wait("run_Kraftsman: Toolbox name can not be empty","Kraftsman Error", "ok");
	    deactivate_config(form);
	    return;
	  }

	if ((entry = vtoolbox_entry(toolbox)) == NULL)
	  {
	    xvf_error_wait("run_Kraftsman: Toolbox doesn't exist, you must create one first", "Kraftsman Error", "ok");
	    deactivate_config(form);
	    return;
	  }

	/*
	 * user clicked on 'live' string selection 'toolbox'
	 */
	if (configure_info->toolbox_selected || configure_info->tselect)
	{
	  if (last_toolbox == NULL || VStrcmp(toolbox, last_toolbox) != 0)
	    {
	      kfree(def_filename);
	      temp = VStrcat(entry->path, "/repos/config/imake_conf/");
	      temp1 = vlower_string(entry->variable,NULL);
	      temp2 = VStrcat(temp1,".def");
	      def_filename = vfullpath(temp2, temp, NULL);
	      free(temp);
	      free(temp1);
	      free(temp2);
	      for (i = 0; i < entry_cnt; i++)
	        clear_var_vals(&ENTRYLST(entry_list[i]),
			      &ENTRYCNT(entry_list[i]));
	      if (imakefile != NULL)
		{
		  i = 0;
		  while (imakefile[i] != NULL)
		    free(imakefile[i++]);
		  free(imakefile);
		  imakefile = NULL;
		}
	      if ((tmp_list = parsefile(entry_list, entry_cnt, def_filename,
				&imakefile)) == NULL)
	        return;
	      entry_list = tmp_list;
	    }
	    
	  generate_config(form, entry_list);
	  activate_config(form);
	}

	/*
	 * user clicked on pane action button 'configure'
	 */
	else if (configure_info->configure)
	{
	  xvf_clear_line_info(&line_info);
	  while (comparekey == NULL || VStrcmp(comparekey,endkey) != 0)
	    {
	      kfree(comparekey);
	      xvf_parse_string_line(form->db[index], &line_info);
	      j = 0;
	      while (VStrcmp(FORMVAR(entry_list[j]),line_info.variable) != 0)
		j++;
	      clear_var_vals(&ENTRYLST(entry_list[j]),&ENTRYCNT(entry_list[j]));
	      value = VStrcpy(line_info.string_val);
	      temp = (value == NULL) ? NULL : vstrtok(value, " \n");
	      while (temp != NULL)
		{
		  temp1 = vcleanup_string(temp,NULL);
		  if (temp1 != NULL)
		    add_entry(entry_list[j], temp1);
		  kfree(temp1);
		  temp = vstrtok(NULL, " \n");
		}
	      kfree(value);
	      comparekey = VStrcpy(line_info.variable);
	      index++;
	    }

	  cfg2output(entry_list, entry_cnt, def_filename, imakefile);
	  xvf_error_wait("Toolbox configured","Kraftsman Update","ok");
	  deactivate_config(form);

	}

	free (toolbox);
}
