 /*
  * Khoros: $Id: run_cmap.c,v 1.1 1991/05/10 15:59:03 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: run_cmap.c,v 1.1 1991/05/10 15:59:03 khoros Exp $";
#endif

 /*
  * $Log: run_cmap.c,v $
 * Revision 1.1  1991/05/10  15:59:03  khoros
 * Initial revision
 *
  */ 

/*
 *---------------------------------------------------------------------
 *            Copyright 1990 University of New Mexico
 * 
 * Permission to copy and modify this software and its documen- 
 * tation only for internal use in your organization is hereby 
 * granted, provided that this notice is retained thereon and 
 * on all copies.  UNM makes no representations as too the sui- 
 * tability and operability of this software for any purpose. 
 * It is provided 'as is' without express or implied warranty. 
 *  
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, 
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT- 
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL, 
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT- 
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS 
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER- 
 * FORMANCE OF THIS SOFTWARE. 
 *  
 * No other rights, including for example, the right to redis- 
 * tribute this software and its documentation or the right to 
 * prepare derivative works, are granted unless specifically 
 * provided in a separate license agreement. 
 * 
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"
#include "viewimage.h"


/********************************************************
*
*  Routine Name:  run_colormap_subform
*
*       Purpose:  drives the subform 'colormap_subform'
*
*         Input:  form - pointer to the form tree 
*		  colormap_subform_info  - information structure for subform 'colormap_subform'
*        Output:  action of the application program
*
*     Called By:  run_view()
*
*   Automatically Generated By:  conductor -i viewimage.form -l 3 -b
*
********************************************************/


run_colormap_subform(form, colormap_subform_info)

xvf_form *form;
view_colormap_subform *colormap_subform_info;
{

	_xvf_get_colormap_subform(form, colormap_subform_info);

	/*
	 * action came from the 'colormap' pane
	 */
	if (colormap_subform_info->colormap_selected)
	    run_colormap(form, colormap_subform_info->colormap);


}   /* end run_colormap_subform */



/********************************************************
*
*  Routine Name:  run_colormap
*
*       Purpose:  drives the pane 'colormap'
*
*         Input:  form - pointer to the form tree 
*		  colormap_info  - information structure for pane 'colormap'
*        Output:  action of the application program
*
*     Called By:  run_colormap_subform()
*
*   Automatically Generated By:  conductor -i viewimage.form -l 3 -b
*
********************************************************/


run_colormap(form, colormap_info)

xvf_form *form;
colormap_subform_colormap *colormap_info;
{

	_xvf_get_colormap(form, colormap_info);

	/*
	 * user clicked on 'live' toggle selection 'color_type'
	 */
	if (colormap_info->color_type_selected)
	{
  	   xvd_autocolor(xvdisplay, colormap_info->color_type_val);
	}
}
