 /*
  * Khoros: $Id: run_file.c,v 1.2 1992/03/20 22:51:39 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: run_file.c,v 1.2 1992/03/20 22:51:39 dkhoros Exp $";
#endif

 /*
  * $Log: run_file.c,v $
 * Revision 1.2  1992/03/20  22:51:39  dkhoros
 * VirtualPatch5
 *
  */ 

/*
 *---------------------------------------------------------------------
 *            Copyright 1990 University of New Mexico
 * 
 * Permission to copy and modify this software and its documen- 
 * tation only for internal use in your organization is hereby 
 * granted, provided that this notice is retained thereon and 
 * on all copies.  UNM makes no representations as too the sui- 
 * tability and operability of this software for any purpose. 
 * It is provided 'as is' without express or implied warranty. 
 *  
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, 
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT- 
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL, 
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT- 
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS 
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER- 
 * FORMANCE OF THIS SOFTWARE. 
 *  
 * No other rights, including for example, the right to redis- 
 * tribute this software and its documentation or the right to 
 * prepare derivative works, are granted unless specifically 
 * provided in a separate license agreement. 
 * 
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"
#include "viewimage.h"


/********************************************************
*
*  Routine Name:  run_files_subform
*
*       Purpose:  drives the subform 'files_subform'
*
*         Input:  form - pointer to the form tree 
*		  files_subform_info  - information structure for subform 'files_subform'
*        Output:  action of the application program
*
*     Called By:  run_view()
*
*   Automatically Generated By:  conductor -i viewimage.form -l 3 -b
*
********************************************************/


run_files_subform(form, files_subform_info)

xvf_form *form;
view_files_subform *files_subform_info;
{

	_xvf_get_files_subform(form, files_subform_info);

	/*
	 * action came from the 'file' pane
	 */
	if (files_subform_info->file_selected)
	    run_file(form, files_subform_info->file);


}   /* end run_files_subform */





/********************************************************
*
*  Routine Name:  run_file
*
*       Purpose:  drives the pane 'file'
*
*         Input:  form - pointer to the form tree 
*		  file_info  - information structure for pane 'file'
*        Output:  action of the application program
*
*     Called By:  run_files_subform()
*
*   Automatically Generated By:  conductor -i viewimage.form -l 3 -b
*
********************************************************/


run_file(form, file_info)

xvf_form *form;
files_subform_file *file_info;
{
	char  temp[MaxLength];


	_xvf_get_file(form, file_info);

	/*
	 * user clicked on 'live' input file selection 'image'
	 */
	if (file_info->image_selected)
	{
	    input_new_image(file_info->image);
	}

	/*
	 * user clicked on 'live' input file selection 'elevation'
	 */
	else if (file_info->elev_selected)
	{
	    input_new_elevation(file_info->elev);
	}

	/*
	 * user clicked on 'live' input file selection 'colormap'
	 */
	else if (file_info->colormap_selected)
	{
	    input_new_colormap(file_info->image);
	}

	/*
	 * user clicked on 'live' output file selection 'outfile'
	 */
	else if (file_info->outfile_selected)
	{
	    output_image(file_info->outfile);
	}
}



/************************************************************
*
*  Module Name: input_new_image
*
*      Purpose: Input a new image that will be used as the new
*		imagery data.
*
*        Input: infile - name of input file in which to get the
*			 get imagery data.
*
*       Output: None
*
*   Written By: Mark Young
*
*
*************************************************************/


input_new_image(infile)

char	*infile;
{
}



/************************************************************
*
*  Module Name: input_new_elevation
*
*      Purpose: Input a new image that will be used as the new
*		elevation data.
*
*        Input: infile - name of input file in which to get the
*			 get elevation data.
*
*       Output: None
*
*   Written By: Mark Young
*
*
*************************************************************/


input_new_elevation(infile)

char	*infile;
{
}



/************************************************************
*
*  Module Name: input_new_colormap
*
*      Purpose: Input a new image that will be used as the new
*		colormap
*
*        Input: infile - name of input file in which to get the
*			 get colormap
*
*       Output: None
*
*   Written By: Mark Young
*
*
*************************************************************/


input_new_colormap(infile)

char	*infile;
{
}



/************************************************************
*
*  Module Name: output_image
*
*      Purpose: Get a screendump of the current plot window and
*		output it as a viff image.
*
*        Input: outfile - name of output file to place the screen
*			  dump
*
*       Output: create the output viff image
*
*   Written By: Mark Young
*
*
*************************************************************/


output_image(outfile)

char	*outfile;
{
	char   temp[MaxLength], *filename;
	struct xvimage *image, *create_pixmap_image();

	Display *display = XtDisplay(plot->workspace);
	Window  window   = XtWindow(plot->workspace);
	int	screen   = XDefaultScreen(display);


	image = create_pixmap_image(display, screen, window, 0, 0, 0, 0, 0);
	if (image == NULL)
	{
	   xvf_error_wait("Could not create output image.  Therefore no \
image will be outputed.", "run_file",NULL);
	   return;
	}

	filename = vfullpath(outfile, global_outdir, NULL);
	if (!writeimage(filename, image))
	{
	   (void) sprintf(temp,"Unable to write image file '%s'\n", filename);
	   xvf_error_wait(temp, "run_file", NULL);
	}
	else
	{
	   (void) sprintf(temp,"Output image created in '%s'\n", filename);
	   xvf_error_wait(temp, "run_file", NULL);
	}
	free(filename);
	freeimage(image);
}
