 /*
  * Khoros: $Id: viewimage.c,v 1.1 1991/05/10 15:59:03 khoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: viewimage.c,v 1.1 1991/05/10 15:59:03 khoros Exp $";
#endif

 /*
  * $Log: viewimage.c,v $
 * Revision 1.1  1991/05/10  15:59:03  khoros
 * Initial revision
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1991, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1991 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: viewimage.c
 >>>>
 >>>>      Program Name: viewimage
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	interactive imagery/elevation display package
 >>>>	
 >>>>	
 >>>>            Author: Mark Young
 >>>>
 >>>> Date Last Updated: Fri Apr 26 11:06:24 1991
 >>>>
 >>>>          Routines: main- the main program for viewimage
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "viewimage.h"


/****************************************************************
 *
 * Routine Name:  main program for viewimage
 *
 *       Input:  
 *           -i  input image filename 
 *
 *
 *           [-e] image with alternate elevation coordinates
 *           [-x] x value of upper-left corner of image  (-1 < value < 1000)
 *           [-y] y value of upper-left corner of image  (-1 < value < 1000)
 *           [-update] initial update time  (value > 0.0)
 *           [-display] host:display.screen
 *           [-cmap_image] image with alternate colormap filename
 *           [-use_cmap] use colormap?
 *           [-prop] use proportional plotting (makes the data be a unit cube)
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
        float   update = 0.0;
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
        consolidate_args();
/* -main_before_lib_call_end */

/* -main_library_call */

        if (viewimage->update_flag)
           update = viewimage->update;

        if (!lviewimage(viewimage->i, viewimage->e, 
              viewimage->cmap_image, viewimage->use_cmap, update,
              viewimage->display, viewimage->x, viewimage->y, viewimage->prop))
        {
           (void) fprintf(stderr, "viewimage failed\n");
           exit(1);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for viewimage 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "viewimage :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tinteractive imagery/elevation display package\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image filename  (infile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-e]  image with alternate elevation coordinates (infile) [null]\n");
	fprintf(stderr,"\t[-x]  x value of upper-left corner of image (integer, -1 to 1000) [-1]\n");
	fprintf(stderr,"\t[-y]  y value of upper-left corner of image (integer, -1 to 1000) [-1]\n");
	fprintf(stderr,"\t[-update]  initial update time (float, > 0.0) [2]\n");
	fprintf(stderr,"\t[-display]  host:display.screen (string) [null]\n");
	fprintf(stderr,"\t[-cmap_image]  image with alternate colormap filename (infile) [null]\n");
	fprintf(stderr,"\t[-use_cmap]  use colormap? (boolean) [true]\n");
	fprintf(stderr,"\t[-prop]  use proportional plotting (makes the data be a unit cube) (boolean) [true]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-jr filename.jp] creates a journal recording\n");
	fprintf(stderr, "\t[-jp filename.jp] executes a journal playback \n");
	fprintf(stderr, "\t[-fn] specifies the font for viewimage\n");
	fprintf(stderr, "\t[-V] Gives the version for viewimage\n");
	fprintf(stderr, "\t[-U] Gives the usage for viewimage\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called viewimage.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses viewimage.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for viewimage
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image filename \n        {infile}: "; 
char	*e_pstr = 
	"\nEnter: (e) image with alternate elevation coordinates \n        {infile}: "; 
char	*x_pstr = 
	"\nEnter: (x) x value of upper-left corner of image \n        {integer, -1 to 1000 [-1] }: "; 
char	*y_pstr = 
	"\nEnter: (y) y value of upper-left corner of image \n        {integer, -1 to 1000 [-1] }: "; 
char	*update_pstr = 
	"\nEnter: (update) initial update time \n        {float, > 0.0 [2.000000] }: "; 
char	*display_pstr = 
	"\nEnter: (display) host:display.screen \n        {string}: "; 
char	*display_def = NULL;
char	*cmap_image_pstr = 
	"\nEnter: (cmap_image) image with alternate colormap filename \n        {infile}: "; 
char	*use_cmap_pstr = 
	"\nEnter: (use_cmap) use colormap? \n        {boolean, (y/n)  [yes] }: "; 
char	*prop_pstr = 
	"\nEnter: (prop) use proportional plotting (makes the data be a unit cube) \n        {boolean, (y/n)  [yes] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "viewimage", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "viewimage.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "viewimage: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "viewimage.ans");
		}

	     }

	}

	/*
	 * allocate the viewimage structure
	 */
	viewimage = (viewimage_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (viewimage_struct));

	/*
	 * get required arguments for viewimage
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(viewimage->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(viewimage->i))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(viewimage->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    viewimage->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(viewimage->i))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for viewimage
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	viewimage->e_flag = vget_infile(fid, prompt_flag,
	"-e", e_pstr, &(viewimage->e))
;

	viewimage->x_flag = vget_int(fid, prompt_flag,
	"-x", x_pstr, &(viewimage->x),
	-1, -1, 1000);

	viewimage->y_flag = vget_int(fid, prompt_flag,
	"-y", y_pstr, &(viewimage->y),
	-1, -1, 1000);

	viewimage->update_flag = vget_float(fid, prompt_flag,
	"-update", update_pstr, &(viewimage->update),
	2.000000, 2.000000, 2.000000);

	viewimage->display_flag = vget_string(fid, prompt_flag,
	"-display", display_pstr, &(viewimage->display),
	display_def);

	if (prompt_flag == FALSE)
	{
	    if ((viewimage->display_flag == 1)&&(viewimage->display == NULL))
    	{
		fprintf(stderr, "viewimage:\n");
		fprintf(stderr, "you must specify a name following '-display'\n");
		gw_usage();
		exit(1);
		}
	}
	viewimage->cmap_image_flag = vget_infile(fid, prompt_flag,
	"-cmap_image", cmap_image_pstr, &(viewimage->cmap_image))
;

	viewimage->use_cmap_flag = vget_logic(fid, prompt_flag,
	"-use_cmap", use_cmap_pstr, &(viewimage->use_cmap), 1);

	viewimage->prop_flag = vget_logic(fid, prompt_flag,
	"-prop", prop_pstr, &(viewimage->prop), 1);


}



