 /*
  * Khoros: $Id: form_info.c,v 1.3 1991/12/18 08:57:57 dkhoros Exp $
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id: form_info.c,v 1.3 1991/12/18 08:57:57 dkhoros Exp $";
#endif

 /*
  * $Log: form_info.c,v $
 * Revision 1.3  1991/12/18  08:57:57  dkhoros
 * HellPatch3
 *
  */

/*
 *---------------------------------------------------------------------
 *            Copyright 1990 University of New Mexico
 * 
 * Permission to copy and modify this software and its documen- 
 * tation only for internal use in your organization is hereby 
 * granted, provided that this notice is retained thereon and 
 * on all copies.  UNM makes no representations as too the sui- 
 * tability and operability of this software for any purpose. 
 * It is provided 'as is' without express or implied warranty. 
 *  
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, 
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT- 
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL, 
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT- 
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER 
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS 
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER- 
 * FORMANCE OF THIS SOFTWARE. 
 *  
 * No other rights, including for example, the right to redis- 
 * tribute this software and its documentation or the right to 
 * prepare derivative works, are granted unless specifically 
 * provided in a separate license agreement. 
 * 
 *---------------------------------------------------------------------
 */
#include "unmcopyright.h"
#include "xvforms.h"
#include "form_info.h"


/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name:  form_info.c
 >>>>
 >>>>      Program Desc:  code to extract values
 >>>>                     from the graphical user interface 
 >>>>
 >>>>            Author:  automatically generated by conductor
 >>>>
 >>>> Date Last Updated:  Thu Dec 12 13:43:18 1991
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


/********************************************************
*
*  Routine Name: xvf_get_Master
*
*       Purpose: Fills in the user-specified
*                'Master'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                forminfo - pointer to the user-specified
*                'Master'
*
*       Output:  current values stored in  Master
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_Master(formptr, forminfo)

xvf_form *formptr;
Master *forminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;

	/***** getting 'Master' Form Information structure *****/


	index = 7;

	xvf_parse_master_action_line(database[index], &line_info);
	forminfo->info = line_info.selected;

	index = 8;

	xvf_parse_master_action_line(database[index], &line_info);
	forminfo->refresh = line_info.selected;

	index = 9;

	xvf_parse_master_action_line(database[index], &line_info);
	forminfo->clear = line_info.selected;

	index = 10;

	xvf_parse_master_action_line(database[index], &line_info);
	forminfo->hide = line_info.selected;

	index = 11;

	xvf_parse_master_action_line(database[index], &line_info);
	forminfo->delete = line_info.selected;

	index = 12;

	xvf_parse_master_action_line(database[index], &line_info);
	forminfo->reset_axes = line_info.selected;

	index = 15;

	xvf_parse_quit_line(database[index], &line_info);
	forminfo->quit = line_info.selected;

	index = 16;

	xvf_parse_workspace_line(database[index], &line_info);
	forminfo->canvas = line_info.workspace;

	index = 18;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->xprism_selected = line_info.selected;

	index = 103;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->options_selected = line_info.selected;

	index = 236;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->xvoverlay_selected = line_info.selected;

	index = 323;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->output_selected = line_info.selected;

	index = 410;

	xvf_parse_startsubform_line(database[index], &line_info);
	forminfo->answer_selected = line_info.selected;

}

/********************************************************
*
*  Routine Name: xvf_get_xprism
*
*       Purpose: Fills in the user-specified
*                'Master_xprism'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'Master_xprism'
*
*       Output:  current values stored in  'Master_xprism'
*
*    Called By:  the application program when appropriate

*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_xprism(formptr, subforminfo)

xvf_form *formptr;
Master_xprism *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 19;


	/*** extracting 'Master->xprism'
 	   Subform Information structure ***/


	index = 25;

	xvf_parse_quit_line(database[index], &line_info);
	subforminfo->quit = line_info.selected;

	index = 27;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->input_file_selected = line_info.selected;

	index = 60;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->input_function_selected = line_info.selected;

	index = 83;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->transforms_selected = line_info.selected;

	index = 94;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->environment_selected = line_info.selected;

}



/********************************************************
*
*  Routine Name: xvf_get_options
*
*       Purpose: Fills in the user-specified
*                'Master_options'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'Master_options'
*
*       Output:  current values stored in  'Master_options'
*
*    Called By:  the application program when appropriate

*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_options(formptr, subforminfo)

xvf_form *formptr;
Master_options *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 104;


	/*** extracting 'Master->options'
 	   Subform Information structure ***/


	index = 111;

	xvf_parse_quit_line(database[index], &line_info);
	subforminfo->quit = line_info.selected;

	index = 113;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->tics_selected = line_info.selected;

	index = 141;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->attributes_selected = line_info.selected;

	index = 183;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->label_selected = line_info.selected;

	index = 204;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->colors_selected = line_info.selected;

	index = 226;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->plot_data_selected = line_info.selected;

}



/********************************************************
*
*  Routine Name: xvf_get_xvoverlay
*
*       Purpose: Fills in the user-specified
*                'Master_xvoverlay'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'Master_xvoverlay'
*
*       Output:  current values stored in  'Master_xvoverlay'
*
*    Called By:  the application program when appropriate

*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_xvoverlay(formptr, subforminfo)

xvf_form *formptr;
Master_xvoverlay *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 237;


	/*** extracting 'Master->xvoverlay'
 	   Subform Information structure ***/


	index = 238;

	xvf_parse_subform_action_line(database[index], &line_info);
	subforminfo->delete = line_info.selected;

	index = 239;

	xvf_parse_subform_action_line(database[index], &line_info);
	subforminfo->copy = line_info.selected;

	index = 240;

	xvf_parse_subform_action_line(database[index], &line_info);
	subforminfo->raise = line_info.selected;

	index = 241;

	xvf_parse_subform_action_line(database[index], &line_info);
	subforminfo->lower = line_info.selected;

	index = 249;

	xvf_parse_quit_line(database[index], &line_info);
	subforminfo->quit = line_info.selected;

	index = 251;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->ovfile_selected = line_info.selected;

	index = 258;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->text_selected = line_info.selected;

	index = 271;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->circle_selected = line_info.selected;

	index = 286;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->rectangle_selected = line_info.selected;

	index = 301;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->line_selected = line_info.selected;

	index = 315;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->polygon_selected = line_info.selected;

}



/********************************************************
*
*  Routine Name: xvf_get_output
*
*       Purpose: Fills in the user-specified
*                'Master_output'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'Master_output'
*
*       Output:  current values stored in  'Master_output'
*
*    Called By:  the application program when appropriate

*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_output(formptr, subforminfo)

xvf_form *formptr;
Master_output *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 324;


	/*** extracting 'Master->output'
 	   Subform Information structure ***/


	index = 331;

	xvf_parse_quit_line(database[index], &line_info);
	subforminfo->quit = line_info.selected;

	index = 333;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->file_selected = line_info.selected;

	index = 348;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->postscr_selected = line_info.selected;

	index = 368;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->imagen_selected = line_info.selected;

	index = 386;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->hpgl_selected = line_info.selected;

	index = 401;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->ln03_selected = line_info.selected;

}



/********************************************************
*
*  Routine Name: xvf_get_answer
*
*       Purpose: Fills in the user-specified
*                'Master_answer'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                subforminfo - pointer to the user-specified
*                'Master_answer'
*
*       Output:  current values stored in  'Master_answer'
*
*    Called By:  the application program when appropriate

*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_answer(formptr, subforminfo)

xvf_form *formptr;
Master_answer *subforminfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 411;


	/*** extracting 'Master->answer'
 	   Subform Information structure ***/


	index = 411;
	xvf_parse_startpane_line(database[index], &line_info);
	subforminfo->ans_file_selected = line_info.selected;

}



/********************************************************
*
*  Routine Name: xvf_get_input_file
*
*       Purpose: Fills in the user-specified
*                'xprism_input_file'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'xprism_input_file'
*
*       Output:  current values stored in  'xprism_input_file'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_input_file(formptr, paneinfo)

xvf_form *formptr;
xprism_input_file *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 28;


	/* extracting 'Master->xprism->input_file'
 	   Pane Information structure */

	xvf_parse_input_line(database[index], &line_info);
	if (line_info.filename != NULL) {
	   paneinfo->filename = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->filename = NULL;

	index++;

	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->step_size = line_info.int_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->begin_point = line_info.int_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->end_point = line_info.int_val;
	index++;

	index++;

	index++;

	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->change_plot_type_val = line_info.toggle_val;
	index++;

	index = 42;
	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->data_format_val = line_info.toggle_val;
	index++;

	index = 46;
	index++;

	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->data_type_val = line_info.toggle_val;
	index++;

	index = 53;
	index++;

	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->machine_type = line_info.selected;
	index++;

	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->plot_file = line_info.selected;
	index++;

	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_input_function
*
*       Purpose: Fills in the user-specified
*                'xprism_input_function'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'xprism_input_function'
*
*       Output:  current values stored in  'xprism_input_function'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_input_function(formptr, paneinfo)

xvf_form *formptr;
xprism_input_function *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 61;


	/* extracting 'Master->xprism->input_function'
 	   Pane Information structure */

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->function = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->function = NULL;

	index++;

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->x_min = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->x_min = NULL;

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->x_max = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->x_max = NULL;

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->xnum_pts = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->xnum_pts = NULL;

	index++;

	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->step_size = line_info.int_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->begin_point = line_info.int_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->end_point = line_info.int_val;
	index++;

	index++;

	index++;

	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->change_plot_type_val = line_info.toggle_val;
	index++;

	index = 80;
	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->plot_function = line_info.selected;
	index++;

	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_transforms
*
*       Purpose: Fills in the user-specified
*                'xprism_transforms'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'xprism_transforms'
*
*       Output:  current values stored in  'xprism_transforms'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_transforms(formptr, paneinfo)

xvf_form *formptr;
xprism_transforms *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 84;


	/* extracting 'Master->xprism->transforms'
 	   Pane Information structure */

	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->trans_type_val = line_info.toggle_val;
	index++;

	index = 89;
	xvf_parse_float_line(database[index], &line_info);
	paneinfo->x_val = line_info.float_val;
	index++;

	xvf_parse_float_line(database[index], &line_info);
	paneinfo->y_val = line_info.float_val;
	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->transform_plots = line_info.selected;
	index++;

	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_environment
*
*       Purpose: Fills in the user-specified
*                'xprism_environment'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'xprism_environment'
*
*       Output:  current values stored in  'xprism_environment'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_environment(formptr, paneinfo)

xvf_form *formptr;
xprism_environment *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 95;


	/* extracting 'Master->xprism->environment'
 	   Pane Information structure */

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->input_path = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->input_path = NULL;

	paneinfo->input_path_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->output_path = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->output_path = NULL;

	paneinfo->output_path_selected = line_info.selected;
	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->option = line_info.selected;
	index++;

	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_tics
*
*       Purpose: Fills in the user-specified
*                'options_tics'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'options_tics'
*
*       Output:  current values stored in  'options_tics'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_tics(formptr, paneinfo)

xvf_form *formptr;
options_tics *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 114;


	/* extracting 'Master->options->tics'
 	   Pane Information structure */

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->grid = line_info.logical_val;
	paneinfo->grid_selected = line_info.selected;
	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->box = line_info.logical_val;
	paneinfo->box_selected = line_info.selected;
	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->legend = line_info.logical_val;
	paneinfo->legend_selected = line_info.selected;
	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->auto_scale = line_info.logical_val;
	paneinfo->auto_scale_selected = line_info.selected;
	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->axes = line_info.logical_val;
	paneinfo->axes_selected = line_info.selected;
	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->num_labels = line_info.logical_val;
	paneinfo->num_labels_selected = line_info.selected;
	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->clear_labels = line_info.logical_val;
	paneinfo->clear_labels_selected = line_info.selected;
	index++;

	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->change_labeling_val = line_info.toggle_val;
	paneinfo->change_labeling_selected = line_info.selected;
	index++;

	index = 125;
	index++;

	index++;

	xvf_parse_float_line(database[index], &line_info);
	paneinfo->min_xpt = line_info.float_val;
	index++;

	xvf_parse_float_line(database[index], &line_info);
	paneinfo->min_ypt = line_info.float_val;
	index++;

	xvf_parse_float_line(database[index], &line_info);
	paneinfo->max_xpt = line_info.float_val;
	index++;

	xvf_parse_float_line(database[index], &line_info);
	paneinfo->max_ypt = line_info.float_val;
	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->change_max_min = line_info.selected;
	index++;

	index++;

	index++;

	xvf_parse_float_line(database[index], &line_info);
	paneinfo->major_xintv = line_info.float_val;
	index++;

	xvf_parse_float_line(database[index], &line_info);
	paneinfo->major_yintv = line_info.float_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->minor_xtics = line_info.int_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->minor_ytics = line_info.int_val;
	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->change_interval = line_info.selected;
	index++;

	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_attributes
*
*       Purpose: Fills in the user-specified
*                'options_attributes'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'options_attributes'
*
*       Output:  current values stored in  'options_attributes'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_attributes(formptr, paneinfo)

xvf_form *formptr;
options_attributes *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 142;


	/* extracting 'Master->options->attributes'
 	   Pane Information structure */

	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->change_plot_type_val = line_info.toggle_val;
	paneinfo->change_plot_type_selected = line_info.selected;
	index++;

	index = 149;
	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->change_line_type_val = line_info.toggle_val;
	paneinfo->change_line_type_selected = line_info.selected;
	index++;

	index = 157;
	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->change_marker_type_val = line_info.toggle_val;
	paneinfo->change_marker_type_selected = line_info.selected;
	index++;

	index = 174;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->step_size = line_info.int_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->begin_point = line_info.int_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->end_point = line_info.int_val;
	index++;

	index++;

	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->data_sampling = line_info.selected;
	index++;

	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_label
*
*       Purpose: Fills in the user-specified
*                'options_label'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'options_label'
*
*       Output:  current values stored in  'options_label'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_label(formptr, paneinfo)

xvf_form *formptr;
options_label *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 184;


	/* extracting 'Master->options->label'
 	   Pane Information structure */

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->title = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->title = NULL;

	paneinfo->title_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->xaxis = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->xaxis = NULL;

	paneinfo->xaxis_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->yaxis = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->yaxis = NULL;

	paneinfo->yaxis_selected = line_info.selected;
	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->change_legend = line_info.selected;
	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->title_font = line_info.selected;
	index++;

	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->xaxis_font = line_info.selected;
	index++;

	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->yaxis_font = line_info.selected;
	index++;

	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->num_font = line_info.selected;
	index++;

	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->legend_font = line_info.selected;
	index++;

	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->all_fonts = line_info.selected;
	index++;

	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_colors
*
*       Purpose: Fills in the user-specified
*                'options_colors'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'options_colors'
*
*       Output:  current values stored in  'options_colors'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_colors(formptr, paneinfo)

xvf_form *formptr;
options_colors *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 205;


	/* extracting 'Master->options->colors'
 	   Pane Information structure */

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->title = line_info.selected;
	index++;

	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->xaxis_label = line_info.selected;
	index++;

	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->yaxis_label = line_info.selected;
	index++;

	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->xaxis = line_info.selected;
	index++;

	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->yaxis = line_info.selected;
	index++;

	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->xaxis_nums = line_info.selected;
	index++;

	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->yaxis_nums = line_info.selected;
	index++;

	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->grid = line_info.selected;
	index++;

	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->legend = line_info.selected;
	index++;

	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->plots = line_info.selected;
	index++;

	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_plot_data
*
*       Purpose: Fills in the user-specified
*                'options_plot_data'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'options_plot_data'
*
*       Output:  current values stored in  'options_plot_data'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_plot_data(formptr, paneinfo)

xvf_form *formptr;
options_plot_data *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 227;


	/* extracting 'Master->options->plot_data'
 	   Pane Information structure */

	index++;

	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->xband = line_info.logical_val;
	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->yband = line_info.logical_val;
	index++;

	xvf_parse_float_line(database[index], &line_info);
	paneinfo->constant = line_info.float_val;
	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->dimensions = line_info.selected;
	index++;

	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_ovfile
*
*       Purpose: Fills in the user-specified
*                'xvoverlay_ovfile'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'xvoverlay_ovfile'
*
*       Output:  current values stored in  'xvoverlay_ovfile'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_ovfile(formptr, paneinfo)

xvf_form *formptr;
xvoverlay_ovfile *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 252;


	/* extracting 'Master->xvoverlay->ovfile'
 	   Pane Information structure */

	index++;

	xvf_parse_input_line(database[index], &line_info);
	if (line_info.filename != NULL) {
	   paneinfo->ov_input = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->ov_input = NULL;

	paneinfo->ov_input_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_output_line(database[index], &line_info);
	if (line_info.filename != NULL) {

	   paneinfo->ov_output = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->ov_output = NULL;

	paneinfo->ov_output_selected = line_info.selected;
	index++;

	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_text
*
*       Purpose: Fills in the user-specified
*                'xvoverlay_text'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'xvoverlay_text'
*
*       Output:  current values stored in  'xvoverlay_text'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_text(formptr, paneinfo)

xvf_form *formptr;
xvoverlay_text *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 259;


	/* extracting 'Master->xvoverlay->text'
 	   Pane Information structure */

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->color = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->color = NULL;

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->font = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->font = NULL;

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->text = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->text = NULL;

	index++;

	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->place_val = line_info.toggle_val;
	index++;

	index = 266;
	xvf_parse_int_line(database[index], &line_info);
	paneinfo->x = line_info.int_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->y = line_info.int_val;
	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->create = line_info.selected;
	index++;

	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_circle
*
*       Purpose: Fills in the user-specified
*                'xvoverlay_circle'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'xvoverlay_circle'
*
*       Output:  current values stored in  'xvoverlay_circle'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_circle(formptr, paneinfo)

xvf_form *formptr;
xvoverlay_circle *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 272;


	/* extracting 'Master->xvoverlay->circle'
 	   Pane Information structure */

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->color = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->color = NULL;

	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->width = line_info.int_val;
	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->filled = line_info.logical_val;
	index++;

	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->place_val = line_info.toggle_val;
	index++;

	index = 279;
	xvf_parse_int_line(database[index], &line_info);
	paneinfo->x = line_info.int_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->y = line_info.int_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->x_edge = line_info.int_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->y_edge = line_info.int_val;
	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->create = line_info.selected;
	index++;

	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_rectangle
*
*       Purpose: Fills in the user-specified
*                'xvoverlay_rectangle'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'xvoverlay_rectangle'
*
*       Output:  current values stored in  'xvoverlay_rectangle'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_rectangle(formptr, paneinfo)

xvf_form *formptr;
xvoverlay_rectangle *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 287;


	/* extracting 'Master->xvoverlay->rectangle'
 	   Pane Information structure */

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->color = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->color = NULL;

	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->width = line_info.int_val;
	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->filled = line_info.logical_val;
	index++;

	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->place_val = line_info.toggle_val;
	index++;

	index = 294;
	xvf_parse_int_line(database[index], &line_info);
	paneinfo->x = line_info.int_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->y = line_info.int_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->x_corner = line_info.int_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->y_corner = line_info.int_val;
	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->create = line_info.selected;
	index++;

	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_line
*
*       Purpose: Fills in the user-specified
*                'xvoverlay_line'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'xvoverlay_line'
*
*       Output:  current values stored in  'xvoverlay_line'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_line(formptr, paneinfo)

xvf_form *formptr;
xvoverlay_line *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 302;


	/* extracting 'Master->xvoverlay->line'
 	   Pane Information structure */

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->color = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->color = NULL;

	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->width = line_info.int_val;
	index++;

	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->place_val = line_info.toggle_val;
	index++;

	index = 308;
	xvf_parse_int_line(database[index], &line_info);
	paneinfo->x = line_info.int_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->y = line_info.int_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->x_end = line_info.int_val;
	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->y_end = line_info.int_val;
	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->create = line_info.selected;
	index++;

	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_polygon
*
*       Purpose: Fills in the user-specified
*                'xvoverlay_polygon'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'xvoverlay_polygon'
*
*       Output:  current values stored in  'xvoverlay_polygon'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_polygon(formptr, paneinfo)

xvf_form *formptr;
xvoverlay_polygon *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 316;


	/* extracting 'Master->xvoverlay->polygon'
 	   Pane Information structure */

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->color = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->color = NULL;

	index++;

	xvf_parse_int_line(database[index], &line_info);
	paneinfo->width = line_info.int_val;
	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->filled = line_info.logical_val;
	index++;

	xvf_parse_pane_action_line(database[index], &line_info);
	paneinfo->create = line_info.selected;
	index++;

	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_file
*
*       Purpose: Fills in the user-specified
*                'output_file'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'output_file'
*
*       Output:  current values stored in  'output_file'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_file(formptr, paneinfo)

xvf_form *formptr;
output_file *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 334;


	/* extracting 'Master->output->file'
 	   Pane Information structure */

	index++;

	index++;

	xvf_parse_output_line(database[index], &line_info);
	if (line_info.filename != NULL) {

	   paneinfo->expl_filename = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->expl_filename = NULL;

	paneinfo->expl_filename_selected = line_info.selected;
	index++;

	index++;

	index++;

	xvf_parse_output_line(database[index], &line_info);
	if (line_info.filename != NULL) {

	   paneinfo->impl_filename = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->impl_filename = NULL;

	paneinfo->impl_filename_selected = line_info.selected;
	index++;

	index++;

	index++;

	xvf_parse_output_line(database[index], &line_info);
	if (line_info.filename != NULL) {

	   paneinfo->cm_filename = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->cm_filename = NULL;

	paneinfo->cm_filename_selected = line_info.selected;
	index++;

	index++;

	index++;

	xvf_parse_output_line(database[index], &line_info);
	if (line_info.filename != NULL) {

	   paneinfo->dump_filename = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->dump_filename = NULL;

	paneinfo->dump_filename_selected = line_info.selected;
	index++;

	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_postscr
*
*       Purpose: Fills in the user-specified
*                'output_postscr'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'output_postscr'
*
*       Output:  current values stored in  'output_postscr'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_postscr(formptr, paneinfo)

xvf_form *formptr;
output_postscr *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 349;


	/* extracting 'Master->output->postscr'
 	   Pane Information structure */

	index++;

	xvf_parse_float_line(database[index], &line_info);
	paneinfo->width = line_info.float_val;
	index++;

	xvf_parse_float_line(database[index], &line_info);
	paneinfo->height = line_info.float_val;
	index++;

	xvf_parse_float_line(database[index], &line_info);
	paneinfo->x_offset = line_info.float_val;
	index++;

	xvf_parse_float_line(database[index], &line_info);
	paneinfo->y_offset = line_info.float_val;
	index++;

	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->flush = line_info.logical_val;
	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->invert = line_info.logical_val;
	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->mono = line_info.logical_val;
	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->landscape = line_info.logical_val;
	index++;

	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->output_type_val = line_info.toggle_val;
	index++;

	index = 363;
	xvf_parse_output_line(database[index], &line_info);
	if (line_info.filename != NULL) {

	   paneinfo->filename = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->filename = NULL;

	paneinfo->filename_selected = line_info.selected;
	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->printer_cmd = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->printer_cmd = NULL;

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->printer = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->printer = NULL;

	paneinfo->printer_selected = line_info.selected;
	index++;

	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_imagen
*
*       Purpose: Fills in the user-specified
*                'output_imagen'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'output_imagen'
*
*       Output:  current values stored in  'output_imagen'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_imagen(formptr, paneinfo)

xvf_form *formptr;
output_imagen *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 369;


	/* extracting 'Master->output->imagen'
 	   Pane Information structure */

	index++;

	xvf_parse_float_line(database[index], &line_info);
	paneinfo->width = line_info.float_val;
	index++;

	xvf_parse_float_line(database[index], &line_info);
	paneinfo->height = line_info.float_val;
	index++;

	xvf_parse_float_line(database[index], &line_info);
	paneinfo->x_offset = line_info.float_val;
	index++;

	xvf_parse_float_line(database[index], &line_info);
	paneinfo->y_offset = line_info.float_val;
	index++;

	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->flush = line_info.logical_val;
	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->invert = line_info.logical_val;
	index++;

	xvf_parse_toggle_line(database[index], &line_info);
	paneinfo->output_type_val = line_info.toggle_val;
	index++;

	index = 381;
	xvf_parse_output_line(database[index], &line_info);
	if (line_info.filename != NULL) {

	   paneinfo->filename = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->filename = NULL;

	paneinfo->filename_selected = line_info.selected;
	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->printer_cmd = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->printer_cmd = NULL;

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->printer = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->printer = NULL;

	paneinfo->printer_selected = line_info.selected;
	index++;

	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_hpgl
*
*       Purpose: Fills in the user-specified
*                'output_hpgl'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'output_hpgl'
*
*       Output:  current values stored in  'output_hpgl'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_hpgl(formptr, paneinfo)

xvf_form *formptr;
output_hpgl *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 387;


	/* extracting 'Master->output->hpgl'
 	   Pane Information structure */

	index++;

	xvf_parse_float_line(database[index], &line_info);
	paneinfo->width = line_info.float_val;
	index++;

	xvf_parse_float_line(database[index], &line_info);
	paneinfo->height = line_info.float_val;
	index++;

	xvf_parse_float_line(database[index], &line_info);
	paneinfo->x_offset = line_info.float_val;
	index++;

	xvf_parse_float_line(database[index], &line_info);
	paneinfo->y_offset = line_info.float_val;
	index++;

	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->flush = line_info.logical_val;
	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->landscape = line_info.logical_val;
	index++;

	index++;

	xvf_parse_output_line(database[index], &line_info);
	if (line_info.filename != NULL) {

	   paneinfo->filename = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->filename = NULL;

	paneinfo->filename_selected = line_info.selected;
	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->printer_cmd = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->printer_cmd = NULL;

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->printer = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->printer = NULL;

	paneinfo->printer_selected = line_info.selected;
	index++;

	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_ln03
*
*       Purpose: Fills in the user-specified
*                'output_ln03'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'output_ln03'
*
*       Output:  current values stored in  'output_ln03'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_ln03(formptr, paneinfo)

xvf_form *formptr;
output_ln03 *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 402;


	/* extracting 'Master->output->ln03'
 	   Pane Information structure */

	index++;

	xvf_parse_logic_line(database[index], &line_info);
	paneinfo->invert = line_info.logical_val;
	index++;

	xvf_parse_output_line(database[index], &line_info);
	if (line_info.filename != NULL) {

	   paneinfo->filename = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->filename = NULL;

	paneinfo->filename_selected = line_info.selected;
	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->printer_cmd = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->printer_cmd = NULL;

	index++;

	xvf_parse_string_line(database[index], &line_info);
	if (line_info.string_val != NULL) {
	   paneinfo->printer = 
		xvf_strcpy(line_info.string_val);
	}
	else  paneinfo->printer = NULL;

	paneinfo->printer_selected = line_info.selected;
	index++;

	index++;



}


/********************************************************
*
*  Routine Name: xvf_get_ans_file
*
*       Purpose: Fills in the user-specified
*                'answer_ans_file'
*                 structure according to the info currently
*                stored in the database by xvforms.
*
*        Input:  formptr - pointer to the xvf_form structure
*                paneinfo - pointer to the user-specified
*                'answer_ans_file'
*
*       Output:  current values stored in  'answer_ans_file'
*
*    Called By:  the application program when appropriate
*
*   Automatically Generated By:  conductor*
********************************************************/


_xvf_get_ans_file(formptr, paneinfo)

xvf_form *formptr;
answer_ans_file *paneinfo;
{
	int index;
	Line_Info line_info;
	char **database;

	xvf_clear_line_info(&line_info);

	database = formptr->db;
	index = 412;


	/* extracting 'Master->answer->ans_file'
 	   Pane Information structure */

	index++;

	xvf_parse_output_line(database[index], &line_info);
	if (line_info.filename != NULL) {

	   paneinfo->out_answer_file = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->out_answer_file = NULL;

	paneinfo->out_answer_file_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_input_line(database[index], &line_info);
	if (line_info.filename != NULL) {
	   paneinfo->in_answer_file = 
		xvf_strcpy(line_info.filename);
	}
	else  paneinfo->in_answer_file = NULL;

	paneinfo->in_answer_file_selected = line_info.selected;
	index++;

	index++;

	xvf_parse_quit_line(database[index], &line_info);
	paneinfo->quit = line_info.selected;
	index++;



}


