.\" @(#)flush.3t	1.2 5/2/90
.\"
.\" Copyright (c) 1990 by Sam Leffler.
.\" All rights reserved.
.\"
.\" This file is provided for unrestricted use provided that this
.\" legend is included on all tape media and as a part of the
.\" software program in whole or part.  Users may copy, modify or
.\" distribute this file at will.
.\"
.TH TIFFFlush 3T "May 2, 1990"
.SH NAME
TIFFFlush, TIFFFlushData \- flush pending writes to an open
.SM TIFF
file
.SH SYNOPSIS
.B "#include <tiffio.h>"
.br
.B "int TIFFFlush(TIFF* tif)"
.sp
.B "int TIFFFlushData(TIFF* tif)"
.SH DESCRIPTION
.IR TIFFFlush ()
causes any pending writes for the specified file (including writes
for the current directory)
to be done.
0 is returned if an error is encountered, otherwise 1.
In normal operation this call is never needed \- the library
automatically does any flushing required.
.PP
.IR TIFFFlushData ()
flushes any pending data writes for the specified file (i.e.
no directory information).
0 is returned if an error is encountered, otherwise 1.
In normal operation this call is never needed \- the library
automatically does any flushing required.
.SH DIAGNOSTICS
All error messages are directed to the
.IR TIFFError (3T)
routine.
.SH "SEE ALSO"
.IR intro (3T),
.IR TIFFOpen (3T),
.IR TIFFWriteEncodedStrip (3T),
.IR TIFFWriteRawStrip (3T),
.IR TIFFWriteScanline (3T)
