 /*
  * Khoros: $Id$
  */

#if !defined(lint) && !defined(SABER)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1992, University of New Mexico.  All rights reserved.
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as to the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including, for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *---------------------------------------------------------------------
 */

#include "unmcopyright.h"        /* Copyright 1992 by UNM */

/*>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>  <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
 >>>>
 >>>>         File Name: vhough.c
 >>>>
 >>>>      Program Name: vhough
 >>>>
 >>>>      Program Desc: 
 >>>>	
 >>>>	Fast Hough (Grey level) and Inverse Transforms.
 >>>>	
 >>>>	

 >>>>            Author: Patrick Arnoul, Jean-Pierre Guerin, Jean-Francois Larue
 >>>>
 >>>> Date Last Updated: Thu Mar 26 10:42:34 1992
 >>>>
 >>>>          Routines: main- the main program for vhough
 >>>> 		 gw_usage - gives usage of the program
 >>>> 		 gw_args  - gets arguments of program from command line
 >>>>
 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>   <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<*/


#include "vhough.h"


/****************************************************************
 *
 * Routine Name:  main program for vhough
 *
 *       Input:  
 *        -i  input image to be transformed 
 *        -o  resulting output image 
 *
 *
 *        [-d] Selects one (Direct or Forward) or Inverse Transform
 *        [-b] draw 4 lines surrounding the inverse transformed image
 *        [-n] selects one (Normalization) or zero
 *
 *
 *
 ****************************************************************/


main(argc, argv)
int argc;
char *argv[];
{

/* -main_variable_list */
struct  xvimage *image1, *image2, *readimage(), *writeimage();
long vff_type;
 
/* -main_variable_list_end */

	program = VStrcpy(argv[0]);
	ac = argc;
	av = argv;

	khoros_init();

	gw_get_args();

/* -main_before_lib_call */
READINPUT (image1);
CHECKINPUT (program, image1);

if ( image1->col_size != image1->row_size )
    {
    (void)fprintf(stderr,"%s : Image must be square ( col_size = row_size ) ...\n",program);
    exit(1);
    }
 
if ( vhough->d_logic == 0 )
    vff_type = VVF_HOUGH_TYP;     /* do direct transform ==> type image*/
else
    vff_type = OUT_INV_VVF_TYP;     /* do inverse transform */

image2 = createimage(image1->col_size, image1->row_size, 
                     vff_type, 1,
                     1,"", 0, 0, VFF_MS_NONE,
                     VFF_MAPTYP_NONE, VFF_LOC_IMPLICIT, 0);
   
/* -main_before_lib_call_end */

/* -main_library_call */

  if (!lvhough(image1,image2,vhough->d_logic,vhough->b_logic,vhough->n_logic ))
    {
        (void) fprintf (stderr,"%s: lvhough failed ...\n", program);
        exit (1);
    }
  
/* -main_library_call_end */

/* -main_after_lib_call */
WRITEOUTPUT(image2); 
/* -main_after_lib_call_end */


	khoros_close();
}


/****************************************************************
*
* Routine Name:  gw_usage 
*
*
* Purpose:  prints out the usage for vhough 
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_usage()
{
	fprintf(stderr, "vhough :\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\tFast Hough (Grey level) and Inverse Transforms.\n");
	fprintf(stderr, "\t\n");
	fprintf(stderr, "\t\n");

/* -usage_additions */
/* -usage_additions_end */

	fprintf(stderr,"\t-i  input image to be transformed  (infile)\n");
	fprintf(stderr,"\t-o  resulting output image  (outfile)\n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\n");
	fprintf(stderr,"\t[-d]  Selects one (Direct or Forward) or Inverse Transform (boolean) [true]\n");
	fprintf(stderr,"\t[-b]  draw 4 lines surrounding the inverse transformed image (boolean) [false]\n");
	fprintf(stderr,"\t[-n]  selects one (Normalization) or zero (boolean) [true]\n");
	fprintf(stderr, " \n");
	fprintf(stderr, "\n");
	fprintf(stderr, "\t[-V] Gives the version for vhough\n");
	fprintf(stderr, "\t[-U] Gives the usage for vhough\n");
	fprintf(stderr, "\t[-P] Prompts for command line options\n");
	fprintf(stderr, "\t[-A [file1]] Creates the answer file called vhough.ans or file1 \n");
	fprintf(stderr, "\t[-a [file1]] Uses vhough.ans or file1 as the answer file \n\n\n");

}


/****************************************************************
*
* Routine Name:  gw_getargs 
*
*
* Purpose:  gets arguments off command line for vhough
*
* Input:  none 
*
* Output:  none 
*
* Written By:  automatically generated by ghostwriter
*
****************************************************************/


gw_get_args()
{

char	*i_pstr = 
	"\nEnter: (i) input image to be transformed \n        {infile}: "; 
char	*o_pstr = 
	"\nEnter: (o) resulting output image \n        {outfile}: "; 
char	*d_pstr = 
	"\nEnter: (d) Selects one (Direct or Forward) or Inverse Transform \n        {boolean, (y/n)  [yes] }: "; 
char	*b_pstr = 
	"\nEnter: (b) draw 4 lines surrounding the inverse transformed image \n        {boolean, (y/n)  [no] }: "; 
char	*n_pstr = 
	"\nEnter: (n) selects one (Normalization) or zero \n        {boolean, (y/n)  [yes] }: "; 
char  answer_file[512], temp[512];



int	fid = -1,
	error, query, ok, count;
	int prompt_flag = FALSE;

	/*
	 * print version if necessary
	 */
	vgparml(fid, "-V", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    printf ("\n%s: %s: Version %d.%d\n\n",
	    "vhough", RELEASE_NAME, RELEASE_MAJOR, RELEASE_MINOR);
	    exit(1);
	}

	/*
	 * print usage if necessary
	 */
	vgparml(fid, "-U", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	{
	    gw_usage();
	    exit(1);
	}

	/*
	 * see if interactive prompting is desired
	 */
	vgparml(fid, "-P", "noprompt", &query, 0, 0, &error);
	if (error == 0)
	    prompt_flag = TRUE;

	/*
	 * see if answer file is to be used
	 */
	vgparms(fid, "-a", "noprompt", answer_file, 0, 0, &error);
	if (error == 0)
	{
	     if (VStrlen(answer_file) == 0)
		sprintf(answer_file, "vhough.ans");
	     while (fid < 0)
	     {
		if ((fid = open(answer_file, O_RDONLY, 0666))== -1)
		{
		    fprintf(stderr, "vhough: can't open answer file \"%s\"",
			    answer_file); 
		    fprintf(stderr, "please re-enter: ");
		    (void) gets(answer_file);
		    if (VStrlen(answer_file) == 0)
			sprintf(answer_file, "vhough.ans");
		}

	     }

	}

	/*
	 * allocate the vhough structure
	 */
	vhough = (vhough_struct *) 
	       calloc((unsigned)1, (unsigned) sizeof (vhough_struct));

	/*
	 * get required arguments for vhough
	 */
	if (prompt_flag == TRUE)
	    fprintf(stderr,"\nRequired Arguments:\n\n");

	if (!(vhough->i_flag = vget_infile(fid, prompt_flag,
			"-i", i_pstr, &(vhough->i_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vhough->i_flag))
		{
		    fprintf(stderr, "\t\ti is required, please re-enter: \n");
		    vhough->i_flag = vget_infile(fid, prompt_flag,
		    "-i", i_pstr, &(vhough->i_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-i' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	if (!(vhough->o_flag = vget_outfile(fid, prompt_flag,
			"-o", o_pstr, &(vhough->o_file))
))
	{
	    if (prompt_flag == TRUE)
	    {
		while(!(vhough->o_flag))
		{
		    fprintf(stderr, "\t\to is required, please re-enter: \n");
		    vhough->o_flag = vget_outfile(fid, prompt_flag,
		    "-o", o_pstr, &(vhough->o_file))
;

		}
	    }
	    else
	    {
		fprintf(stderr, "Error: '-o' is a required argument\n");
		gw_usage();
		exit(1);
	    }
	}

	/*
	 * get optional arguments for vhough
	 */
	if (prompt_flag == TRUE)
	   fprintf(stderr,"\nOptional Arguments:\n\n");

	vhough->d_flag = vget_logic(fid, prompt_flag,
	"-d", d_pstr, &(vhough->d_logic), 1);

	vhough->b_flag = vget_logic(fid, prompt_flag,
	"-b", b_pstr, &(vhough->b_logic), 0);

	vhough->n_flag = vget_logic(fid, prompt_flag,
	"-n", n_pstr, &(vhough->n_logic), 1);


}



