/*******************************************************************************
+
+  LEDA  3.0
+
+
+  template.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/


#ifndef LEDA_TEMPLATE_H
#define LEDA_TEMPLATE_H

#define LEDA_WITH_TEMPLATES

// GNU and Borland C++ allow template arguments as base classes, cfront 
//(currently) does not. However, the former  have problems with function
// templates.

#if defined(__TURBOC__) || defined(__GNUG__)
#define __TEMPLATE_ARGS_AS_BASE__
#else
#define __TEMPLATE_FUNCTIONS__
#endif


/*  if template functions do not work correctly we cannot define default 
 *  template functions and therefore have to use the LEDA_TYPE_PARAMETER 
 *  macro for using non-pointer types as actual type parameters
 */

#if defined(__TEMPLATE_FUNCTIONS__)


// default versions of compare, Int_Type, Type_Name, Print, Read, ...

template <class T>
inline int compare(const T&, const T&) 
{ error_handler(1,"compare undefined");  
  return 0;
 }

template <class T>
inline int Int_Type(T*) { return 0; }

template <class T>
inline char* Type_Name(T*) { return "unknown"; }


/*
template <class T>
inline void Print(const T& x, ostream& out) { out << x; }

template <class T>
inline void Read(T& x, istream& in) { in >> x; }
*/


template <class T>
inline void Init(T&) {}


template <class T>
inline void Clear(T& x) 
{ if (sizeof(T) == sizeof(GenPtr)) 
     x=x; // to avoid cfront's "not used" warning
  else
     delete &x; 
 }


template <class T>
inline GenPtr Copy(const T& x) 
{ if (sizeof(T) == sizeof(GenPtr)) 
     return *(GenPtr*)&x;
  else 
     return  new T(x);
 }



template <class T>
inline GenPtr Convert(T& x) 
{ if (sizeof(T) == sizeof(GenPtr)) 
     return *(GenPtr*)&x;
  else 
     return GenPtr(&x);
}



template <class T>
inline T& Access(T*, const GenPtr& p) 
{ if (sizeof(T) <= sizeof(GenPtr)) 
     return *(T*)&p;
  else 
     return *(T*)p;
}


#endif

#endif
