#include <LEDA/dictionary.h>

#include <LEDA/impl/avl_tree.h>
#include <LEDA/impl/rs_tree.h>
#include <LEDA/impl/rb_tree.h>
#include <LEDA/impl/skiplist.h>
#include <LEDA/impl/ab_tree.h>
#include <LEDA/impl/bb_tree.h>


#if !defined(__TEMPLATE_ARGS_AS_BASE__)
declare3(_dictionary,int,int,avl_tree)
declare3(_dictionary,int,int,rb_tree)
declare3(_dictionary,int,int,skiplist)
declare3(_dictionary,int,int,ab_tree)
declare3(_dictionary,int,int,bb_tree)

declare3(_dictionary,float,float,avl_tree)
declare3(_dictionary,float,float,rb_tree)
declare3(_dictionary,float,float,skiplist)
declare3(_dictionary,float,float,ab_tree)
declare3(_dictionary,float,float,bb_tree)
#endif


void dic_test(dictionary<int,int>& D, int N, int* A, char* name)
{ 
  cout << string("%-12s",name);
  cout.flush();

  float T;
  float T0 = T = used_time();

  for(int i=0; i<N; i++)  D.insert(A[i],0);
  cout << string("%10.2f",used_time(T));
  cout.flush();

  for(i=0; i<N; i++)  
  { dic_item it = D.lookup(A[i]);
    if (it == nil || D.key(it) != A[i]) cout << "error in lookup\n";
   }

  cout << string("%10.2f",used_time(T));
  cout.flush();

  for(i=0; i<N; i++)  D.del(A[i]);
  cout << string("%10.2f",used_time(T));

  cout << string("%10.2f",used_time(T0));

  if (!D.empty()) cout << " NOT EMPTY !!\n";	

  newline;

}


void dic_test(dictionary<float,float>& D, int N, float* A, char* name)
{ 
  cout << string("%-12s",name);
  cout.flush();

  float T;
  float T0 = T = used_time();


  for(int i=0; i<N; i++)  D.insert(A[i],0);
  cout << string("%10.2f",used_time(T));
  cout.flush();

  for(i=0; i<N; i++)  D.lookup(A[i]);
  cout << string("%10.2f",used_time(T));
  cout.flush();

  for(i=0; i<N; i++)  D.del(A[i]);
  cout << string("%10.2f",used_time(T));

  cout << string("%10.2f",used_time(T0));
  newline;
}



main()
{
  dictionary<int,int>           RS_DIC;
  dictionary<float,float>       RS_DIC1;

#if defined(__TEMPLATE_ARGS_AS_BASE__)
  _dictionary<int,int,avl_tree> AVL_DIC;
  _dictionary<int,int,rb_tree>  RB_DIC;
  _dictionary<int,int,skiplist> SK_DIC;
  _dictionary<int,int,ab_tree>  AB_DIC;
  _dictionary<int,int,bb_tree>  BB_DIC;

  _dictionary<float,float,avl_tree> AVL_DIC1;
  _dictionary<float,float,rb_tree>  RB_DIC1;
  _dictionary<float,float,skiplist> SK_DIC1;
  _dictionary<float,float,ab_tree>  AB_DIC1;
  _dictionary<float,float,bb_tree>  BB_DIC1;
#else
  _dictionary(int,int,avl_tree) AVL_DIC;
  _dictionary(int,int,rb_tree)  RB_DIC;
  _dictionary(int,int,skiplist) SK_DIC;
  _dictionary(int,int,ab_tree)  AB_DIC;
  _dictionary(int,int,bb_tree)  BB_DIC;

  _dictionary(float,float,avl_tree) AVL_DIC1;
  _dictionary(float,float,rb_tree)  RB_DIC1;
  _dictionary(float,float,skiplist) SK_DIC1;
  _dictionary(float,float,ab_tree)  AB_DIC1;
  _dictionary(float,float,bb_tree)  BB_DIC1;
#endif


  int    N     = read_int("# keys = ");
  int*   Int   = new int[N];
  float* Float = new float[N];

  for(int i=0; i<N; i++) Float[i] = Int[i] = random(0,200000)-100000;

  newline;
  cout << "                insert    lookup    delete     total\n";
  newline;

  dic_test(RS_DIC,N,Int,"rs_tree");
  dic_test(SK_DIC,N,Int,"skiplist");
  dic_test(RB_DIC,N,Int,"rb_tree");
  dic_test(AVL_DIC,N,Int,"avl_tree");
  dic_test(AB_DIC,N,Int,"ab_tree");
  dic_test(BB_DIC,N,Int,"bb_tree");
  newline;

  dic_test(RS_DIC1,N,Float,"rs_tree");
  dic_test(SK_DIC1,N,Float,"skiplist");
  dic_test(RB_DIC1,N,Float,"rb_tree");
  dic_test(AVL_DIC1,N,Float,"avl_tree");
  dic_test(AB_DIC1,N,Float,"ab_tree");
  dic_test(BB_DIC1,N,Float,"bb_tree");
  newline;
 
  return 0;
}


