#include <math.h>
#include <LEDA/graph.h>
#include <LEDA/window.h>


void rotate(float alpha1,float alpha2, vector& p)
{ 
  // rotate 3d-point p about the origin
  // by alpha2 in yz-plane and alpha1 in xy-plane

    double R  = hypot(p[1],p[2]);
    double phi = asin(p[1]/R);
  
    if (p[2] < 0) phi = M_PI - phi;
  
    p[1]  = ((R != 0) ? R*sin(phi+alpha2) : 0);
    p[2]  = ((R != 0) ? R*cos(phi+alpha2) : 0);

    R   = hypot(p[0],p[2]);
    phi = asin(p[0]/R);

    if (p[2] < 0) phi = M_PI - phi;
  
    p[0]  = ((R != 0) ? R*sin(phi+alpha1) : 0);
    p[2]  = ((R != 0) ? R*cos(phi+alpha1) : 0);
}


point project(vector p)   // project p into xy-plane
{
  return point(p[0],p[1]); 
 }


void draw_poly(window& W, GRAPH<vector,int>& poly)
{ edge e;
  forall_edges(e,poly) 
  { point a = project(poly[source(e)]);
    point b = project(poly[target(e)]);
    W.draw_segment(a,b,blue);
   }
 }



main()
{ 
  window W(700,700);

  W.init(-250,250,-250);
  W.set_node_width(4);
  W.set_mode(xor_mode);

  node v;

  int     N = 5;
  int speed = 40;
  bool  ran = false;

  panel P("Rotate Polyhedron");

 P.text_item("");
 P.text_item("This program creates and rotates a 3-dimensional polyhedron.");
 P.text_item("Direction and duration of the rotation is controled by the");
 P.text_item("left mouse button.");
 P.text_item("");
 P.bool_item("random",ran);
 P.int_item("speed",speed,1,80);
 P.int_item("# vertices",N,3,32);



 for(;;)
 {
    P.open(W);

    W.clear();

    // define a polyhedron in 3d space
  
    GRAPH<vector,int> poly;
  
    node* L = new node[N];
    node* R = new node[N];
  
    float d = 2*M_PI/N;
  
    for(int i=0; i<N; i++)
    { point origin(0,0);
      point p = origin.translate(i*d,100);
      L[i] = poly.new_node(vector(p.xcoord(),p.ycoord(), 120));
      R[i] = poly.new_node(vector(p.xcoord(),p.ycoord(),-120));
     }

    node v0 = poly.new_node(vector(0,0,-30));
  
    for(i=1; i<N; i++)
    { poly.new_edge(L[i],L[i-1]);
      poly.new_edge(R[i],R[i-1]);
      poly.new_edge(L[i],R[i]);
      poly.new_edge(v0,R[i]);
     }
  
    poly.new_edge(L[0],L[N-1]);
    poly.new_edge(R[0],R[N-1]);
    poly.new_edge(L[0],R[0]);
    poly.new_edge(v0,R[0]);
  
  
    // compute an interior point M and move the origin to this point
  
    vector M(3);
  
    forall_nodes(v,poly)
    {  M[0] += poly[v][0];
       M[1] += poly[v][1];
       M[2] += poly[v][2];
     }
  
  
    M[0] /= poly.number_of_nodes();
    M[1] /= poly.number_of_nodes();
    M[2] /= poly.number_of_nodes();
  
  
    forall_nodes(v,poly)
    { poly[v][0] -= M[0];
      poly[v][1] -= M[1];
      poly[v][2] -= M[2];
     }
  
  
    forall_nodes(v,poly) rotate(1.5,0.7,poly[v]);
  
    W.draw_point(0,0);
  
    draw_poly(W,poly);
  
    GRAPH<vector,int> poly0 = poly;
  
    for(;;)
    { vector dir(2);   // direction and duration of rotation

      if (ran)
      { dir[0] = random(-200,200);
        dir[1] = random(-200,200);
        if (W.get_button() != 0) break;
       }
      else
      { int but = W.read_mouse(dir[0],dir[1]);
        if (but == 3) break;
       }
  
      int steps = int(dir.length()*W.scale())/5;
  
      dir = dir.norm()*(speed/500.0);

      while (steps--)
      {  
        forall_nodes(v,poly) rotate(dir[0],dir[1],poly[v]);
   
        draw_poly(W,poly);   // draw new position
        draw_poly(W,poly0);  // erase old position  (xor_mode !!)
  
        // poly0 = poly;
  
        node w = poly.first_node();
        forall_nodes(v,poly0) 
        { poly0[v] = poly[w];
          w = poly.succ_node(w);
         }
      }
    }

  }
}
