/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Name : IPEG.h
Type : header file
Written on   : 26-Apr-92     By : A. Etemadi
Modified on  :               By : 
Directory    : ~atae/ORT/Incs

All Constants are in uppercase. 
All Macro names start with the letters MAC

----------------------------------------------------------------------------*/
/*
 Constants
*/
#define MAXTRIPLETS 12          /* The max. number of sides of
                                   polygon is MAXTRIPLETS - 4 */
#define MAXSEGMENTS 3*MAXTRIPLETS

/*
 Triplet
*/

  struct ORTTriplet {
       int    ID;			/* ID number associated with triplet */
       int    *SegmentID;		/* IDs of lines forming triplet */
	struct ORTPoint *Junction;  /* The junctions along the triplet */
	struct ORTPoint Start;      /* Start point of the triplet */
	struct ORTPoint End;		/* End point of the triplet */
	double Length;		/* Total length of segments */
	double VirtualLength;	/* Total length of triplet inc. gaps */
	double Quality;		/* Associated quality factor */

  };

/*
 Corner
*/

  struct ORTCorner {
	int    ID;		/* ID number associated with corner */
       int    *SegmentID;	/* ID numbers of lines forming corner */
	double Radius;	/* Radius of circle enclosing junction point */
	double Quality; 	/* EXP(-(Radius/Mean_Length_Of_Lines)) */
	struct ORTPoint Center;	/* Center of circle enclosing junction point */
  };

/* 
 Open Polygon

*/

  struct ORTOpenPolygon {
	int    Start;
	int    Middle;
	int    End;
       int    NumID;				/* Number of triplets forming open polygon */
       int    TripletID[MAXTRIPLETS+1];   /* ID numbers of triplets forming open polygon */
  };

/* 
 Closed Polygon

*/

  struct ORTClosedPolygon {
       int    NumSeg;	/* Number of segments forming closed polygon */
       int    NumJct;	/* Number of junctions forming closed polygon */
       int    SegmentID[MAXSEGMENTS+1];   	/* ID numbers of segments forming closed polygon */
       struct ORTPoint JunctionPt[MAXSEGMENTS+1];/* Junction points along the polygon */
	double Quality;
  };

/* 
 				FUNCTIONS

*/ 
long SortByIDVLJunctions();
long SortCornersByQuality();
long SortTripletsByID();
long SortPolygonsByNumSeg();
int  CreateLPEGLists();
int  InterceptPt();

