

/* ****************************************************************** */
/* Function : DestElmList.c
 * 
 * Author   : J.Paul Schmidt.
 * 
 * Cree le  : 88/04/12 Version  : 1.2
 * 
 * Modifications : 90/01/18 Author   : Reason   :
 * 
 * Implemented functionality : Remove from the list the first found instance of
 * the input parameter.
 * 
 * Input parameters : List identifier. (Ptr to 1st element). Element to remove
 * value.
 * 
 * Output parameter : None. ( or error if unfound element ) */
/* ****************************************************************** */

#include "ListeP.h"

long DestElmList (
#if NeedFunctionPrototypes
  Liste s_idlist,		/* list to process indentifier */
  long el			/* element to remove from the list */
)
#else
s_idlist, el)
  Liste s_idlist ;		/* list to process indentifier */
  long el ;			/* element to remove from the list */
#endif

{
  ty_list *p_firstelem;		/* Pointer to the list to process */
  ty_node *p_curent, *p_next;

#ifdef debug
  (void) fprintf (stderr, " Function : DestElmList \n");
#endif

  /* Parameter transformation */
  p_firstelem = (ty_list *) s_idlist;
  Lst_TestPar (p_firstelem, "NULL POINTER AS PARAMETER \n", ERRNU);

  /* Test if the list is empty */
  Lst_TestPar (p_firstelem->p_first, "EMPTY LIST \n", ERRVI);

#ifdef debug
  (void) fprintf (stderr, " DestElmList : all right none empty list \n");
#endif

  p_next = p_firstelem->p_first;
  if (p_next->s_elem == el) {	/* case of the first element */
    p_firstelem->p_first = p_next->p_suiv;
    if (p_firstelem->p_cur == p_next) p_firstelem->p_cur = p_next->p_suiv;
    if (p_firstelem->p_last == p_next) p_firstelem->p_last = NULL;
    free (p_next);
    p_firstelem->num--;

#ifdef debug
    (void) fprintf (stderr, " none empty list, DestElm \n ");
    (void) fprintf (stderr, " End of : DestElmList \n");
#endif

    return (PASERR);
  };				/* End of the if p_next->s_elem == el) */

  /* case of any element */
  while ((p_next != NULL) && (p_next->s_elem != el)) {

#ifdef debug
    (void) fprintf (stderr, " none empty list, DestElm \n ");
#endif

    p_curent = p_next;
    p_next = p_next->p_suiv;
  };				/* End of the while ((p_next != NULL) && (elem
				 * != el) */
  if (p_next == NULL) {		/* The element isn't in the list */

#ifdef debug
    (void) fprintf (stderr, " End of : DestElmList (erreur empty list or unfound el.)\n");
#endif

    /* update error unfound element */
    return (ERRVI);
  };				/* End of the if p_next == NULL */

  /* element is found */
  p_curent->p_suiv = p_next->p_suiv;	/* chain updating */
  if (p_firstelem->p_cur == p_next) p_firstelem->p_cur = p_curent;
  if (p_firstelem->p_last == p_next) p_firstelem->p_last = p_curent;
  free (p_next);
  p_firstelem->num--;

#ifdef debug
  (void) fprintf (stderr, " End of : DestElmList \n");
#endif

  return (PASERR);

}				/* End of DestElmList */
