

/* ****************************************************************** */
/* Function : DestList.c
 * 
 * Author   : J.Paul Schmidt.
 * 
 * Cree le  : 88/04/12 Version  : 1.2
 * 
 * Modifications : 90/01/18 Author   : Reason   :
 * 
 * Implemented functionality : List of interger destruction.
 * 
 * Input parameters : List indentifier address. Output parameter : None. */
/* ****************************************************************** */

#include "ListeP.h"

long DestList (
#if NeedFunctionPrototypes
  Liste *s_idlist /* address of the list to process indentifier */
/* RETOUR */
)
#else
s_idlist)
  Liste *s_idlist ; /* address of the list to process indentifier */
#endif

{
  ty_list *p_firstelem;		/* Pointer to the list to process */
  ty_node *p_next, *p_curent;

#ifdef debug
  (void) fprintf (stderr, " Function : DestList \n");
#endif

  /* Parameter transformation */
  p_firstelem = (ty_list *) * s_idlist;

  /* Prarameters checking */
  Lst_TestPar (p_firstelem, "NULL POINTER AS PARAMETER \n", ERRNU);

  /* Deletion of all the elements of the list */
  p_curent = p_firstelem->p_first;
  free (p_firstelem);
  *s_idlist = NULL;		/* Update identifier */

  while (p_curent != NULL) {
    p_next = p_curent->p_suiv;
    free (p_curent);
    p_curent = p_next;
  };

#ifdef debug
  (void) fprintf (stderr, " End of : DestList \n");
#endif

  return (PASERR);

}				/* End of DestList */
