#!points_wish
# points.tcl - Tcl front end for point repulsion simulation
#
# $Id: points.tcl,v 1.2 96/02/11 21:33:24 leech Exp $
#
# Copyright (C) 1996, Jonathan P. Leech
#
# This software may be freely copied, modified, and redistributed,
# provided that this copyright notice is preserved on all copies.
#
# There is no warranty or other guarantee of fitness for this software,
# it is provided solely "as is". Bug reports or fixes may be sent
# to the author, who may or may not act on them as he desires.
#
# You may not include this software in a program or other software product
# without supplying the source, or without informing the end-user that the
# source is available for no extra charge.
#
# If you modify this software, you should include a notice giving the
# name of the person performing the modification, the date of modification,
# and the reason for such modification.
#
set __rcslog {
$Log:	points.tcl,v $
Revision 1.2  96/02/11  21:33:24  leech
Added -save and -vrml options.

Revision 1.1  96/02/09	16:41:25  leech
Initial revision

}

# Set to noop if no [incr Tcl]
proc itcl { args } {
    eval $args
}

source util.tcl
source ui.tcl
source vec.tcl

itcl source Varedit.tcl

proc points_help { args } {
    global argv0
    puts stderr "$argv0: $args"
    puts stderr "Usage: $argv0 \[options\]\nOptions are:"
    puts stderr \
{	-nbody	    nbody   set # of points
	-critical	    enable critical damping
	-damping    lambda  set damping coefficient (1)
	-dt	    tau     set timestep (.01)
	-softening  s	    set softening parameter (.05)
	-k	    k	    set force coefficient (1)
	-load	    file    load configuration from file
	-save	    file    save configuration to file
	-vrml	    file    save VRML of convex hull to file
}
    exit 1
}

proc points_parseargs { model argv } {
    set setDt 0

    set narg [llength $argv]
    for { set i 0 } { $i < $narg } { incr i } {
	set arg [lindex $argv $i]
	set nextarg [lindex $argv [expr $i + 1]]
	switch -regexp -- $arg {
	    -nbody {
		incr i
		$model nbody $nextarg
	    }
	    -critical {
		$model critdamp 1
	    }
	    -damping {
		incr i
		$model critdamp 0
		$model damping $nextarg
	    }
	    -dt {
		set setDt 1
		incr i
		$model timestep $nextarg
	    }
	    -softening {
		incr i
		$model softening $nextarg
	    }
	    -k {
		incr i
		$model kforce $nextarg
	    }
	    -load {
		incr i
		$model read $nextarg
		set modinfo($model,loadfile) $nextarg
	    }
	    -save {
		incr i
		set modinfo($model,savefile) $nextarg
	    }
	    -vrml {
		incr i
		set modinfo($model,vrmlfile) $nextarg
	    }
	    default {
		puts stderr "Unknown argument $arg"
		points_help
	    }
	}
    }

    if { $setDt } {
	return 1
    } else {
	$model timestep [$model idealtimestep]
	return 0
    }

    # Options affecting how to run and terminate simulation
    #	-kestop     ke
    #	-pestop     pe
    #	-vstop	    vmax
    #	-rstop	    distratio	;# default: stop when ratio < 1.6
    #	-neverstop
    #	-steps n
    # Others
    #	-save	    file
}

# Create point model with 12 points (icosahedron) initially
spherestate @model
@model nbody 12

# Set up some defaults for save/load filenames
global modinfo
set modinfo(@model,loadfile) "points.load"
set modinfo(@model,savefile) "points.save"
set modinfo(@model,vrmlfile) "points.vrml"

# Parse arguments
set user_dt [points_parseargs @model $argv]

# Create the GUI and run simulation
points_gui .model @model $user_dt
