/*
 * Determines whether a polygon is convex in O(n) time and O(1) space.
 * Points maybe repeated and collinear.
 * Author: Peter Schorn, schorn@inf.ethz.ch
 * 29-Oct-92
 */

#include <stdio.h>

#define TRUE (-1)
#define FALSE (0)

typedef struct Point2d { double x, y; } Point2d;

int WhichSide(p, q, r)
Point2d p, q, r;
{
 double result;
 result = (p.x - q.x) * (q.y - r.y) - (p.y - q.y) * (q.x - r.x);
 if (result > 0) return 1;
 if (result < 0) return -1;
 return 0;
}

int Compare(p, q)
Point2d p, q;
{
 if (p.x < q.x) return -1;
 if (p.x > q.x) return 1;
 if (p.y < q.y) return -1;
 if (p.y > q.y) return 1;
 return 0;
}

int GetPoint(f, p)
 FILE *f;
 Point2d *p;
 {
  return !feof(f) && (2 == fscanf(f, " %lf %lf", &(p->x), &(p->y)));
 }

int GetDifferentPoint(f, previous, next)
 FILE *f;
 Point2d previous, *next;
 {
  int eof;
  while ((eof = GetPoint(f, next)) && (Compare(previous, *next) == 0));
  return eof;
 }

#define CheckTriple \
  if (((thisDir = Compare(second, third)) == -curDir) && \
      (++dirChanges > 2)) return FALSE; \
  curDir = thisDir; \
  if (thisSign = WhichSide(third, second, first)) \
  { \
   if (angleSign == -thisSign) return FALSE; \
   angleSign = thisSign; \
  } \
  first = second; \
  second = third;

int IsPolygonConvex(f)
 FILE *f;
 {
  int curDir, thisDir, thisSign, angleSign = 0, dirChanges = 0;
  Point2d first, second, third, saveFirst, saveSecond;

  if (!GetPoint(f, &first) ||
      !GetDifferentPoint(f, first, &second)) return TRUE;
  saveFirst = first; saveSecond = second;
  curDir = Compare(first, second);
  while (GetDifferentPoint(f, second, &third))
  {
   CheckTriple;
  }
  if (Compare(second, saveFirst))
   {
    third = saveFirst;
    CheckTriple;
   }
  third = saveSecond;
  CheckTriple;
  return TRUE;
 }


int main()
{
 if (IsPolygonConvex(stdin))
  { fprintf(stdout,"CONVEX AND SIMPLE\n");        exit(0); }
 else
  { fprintf(stdout,"NOT CONVEX OR NOT SIMPLE\n"); exit(-1); }
}
