
/*  @(#)libpbm.h 1.1 91/12/28
 *
 *  PBM/PGM/PPM definitions used by the popi program.
 *
 *  Popi was originally written by Gerard J. Holzmann - AT&T Bell Labs.
 *  This version is based on the code in his Prentice Hall book,
 *  "Beyond Photography - the digital darkroom," ISBN 0-13-074410-7,
 *  which is copyright (c) 1988 by Bell Telephone Laboratories, Inc.
 *
 *  Permission is given to distribute these extensions, as long as these
 *  introductory messages are not removed, and no monies are exchanged.
 *
 *  No responsibility is taken for any errors or inaccuracies inherent
 *  either to the comments or the code of this program, but if reported
 *  (see README file) then an attempt will be made to fix them.
 */

/*  Based on definitions from the PBMPLUS utility libraries.
 *
 *  Copyright (C) 1989 by Jef Poskanzer.
 *
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted, provided
 *  that the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation.  This software is provided "as is" without express or
 *  implied warranty.
 */

typedef unsigned char bit ;
typedef unsigned char gray ;
typedef gray          pixval ;

typedef struct {
  pixval r, g, b ;
} pixel ;

#define  OLD_POPI_FORMAT  -1

#define  PBM_WHITE      0
#define  PBM_BLACK      1

#define  PBM_MAGIC1     'P'
#define  PBM_MAGIC2     '1'
#define  RPBM_MAGIC2    '4'
#define  PBM_FORMAT     (PBM_MAGIC1 * 256 + PBM_MAGIC2)
#define  RPBM_FORMAT    (PBM_MAGIC1 * 256 + RPBM_MAGIC2) 
#define  PPM_PBMMAXVAL  1

#define  PGM_MAGIC1     'P'
#define  PGM_MAGIC2     '2'
#define  RPGM_MAGIC2    '5'
#define  PGM_FORMAT     (PGM_MAGIC1 * 256 + PGM_MAGIC2)
#define  RPGM_FORMAT    (PGM_MAGIC1 * 256 + RPGM_MAGIC2)
#define  PGM_MAXMAXVAL  255

#define  PPM_MAGIC1     'P'
#define  PPM_MAGIC2     '3'
#define  RPPM_MAGIC2    '6'
#define  PPM_FORMAT     (PPM_MAGIC1 * 256 + PPM_MAGIC2)
#define  RPPM_FORMAT    (PPM_MAGIC1 * 256 + RPPM_MAGIC2)
#define  PPM_MAXMAXVAL  PGM_MAXMAXVAL

/* Macros for turning a format number into a type number. */

#define  PPM_FORMAT_TYPE(f)  ((f) == PPM_FORMAT || (f) == RPPM_FORMAT \
                              ? PPM_FORMAT : PGM_FORMAT_TYPE(f))
#define  PGM_FORMAT_TYPE(f)  ((f) == PGM_FORMAT || (f) == RPGM_FORMAT \
                              ? PGM_FORMAT : PBM_FORMAT_TYPE(f))
#define  PBM_FORMAT_TYPE(f)  ((f) == PBM_FORMAT || (f) == RPBM_FORMAT \
                              ? PBM_FORMAT : -1)

#define  pbm_allocrow(cols)     ((bit *)   pm_allocrow(cols, sizeof(bit)))
#define  pgm_allocrow(cols)     ((gray *)  pm_allocrow(cols, sizeof(gray)))
#define  ppm_allocrow(cols)     ((pixel *) pm_allocrow(cols, sizeof(pixel)))

#define  pgm_freerow(grayrow)   pm_freerow((char *) grayrow)
#define  ppm_freerow(pixelrow)  pm_freerow((char *) pixelrow)

#define  pm_bitstomaxval(bits)  ((1 << bits) - 1)

#define  PPM_GETR(p)            ((p).r)
#define  PPM_GETG(p)            ((p).g)
#define  PPM_GETB(p)            ((p).b)
#define  PPM_ASSIGN(p, red, grn, blu) \
         (p).r = (red), (p).g = (grn), (p).b = (blu)

/* Color scaling macro -- to make writing ppmtowhatever easier. */

#define  PPM_DEPTH(newp,p,oldmaxval,newmaxval) \
         PPM_ASSIGN( (newp), \
           (int) PPM_GETR(p) * (newmaxval) / (oldmaxval), \
           (int) PPM_GETG(p) * (newmaxval) / (oldmaxval), \
           (int) PPM_GETB(p) * (newmaxval) / (oldmaxval) )

char *pm_allocrow P(( int, int )) ;

int pm_maxvaltobits   P((int)) ;

void pgm_readpgmrow   P(( FILE *, gray *, int, int , int )) ;
void pgm_writepgminit P(( FILE *, int, int, int )) ;
void pgm_writepgmrow  P(( FILE *, gray *, int,  int )) ;
void pm_freerow       P(( char * )) ;
void pm_error() ;
void pm_message() ;
void ppm_readppminit  P(( FILE *, int *, int *, pixval *, int * )) ;
void ppm_readppmrow   P(( FILE *, pixel *, int, int, int )) ;
void ppm_writeppminit P(( FILE *, int, int, int )) ;
void ppm_writeppmrow  P(( FILE *, pixel *, int, int )) ;
