/**********************************************************************/
/* amb.c                                                              */
/* Misc. code for progressive refinement scene display                */
/*  - ambient term apptroximation code                                */
/*                                                                    */
/* Copyright (C) 1992, Bernard Kwok                                   */
/* All rights reserved.                                               */
/* Revision 1.0                                                       */
/* May, 1992                                                          */
/**********************************************************************/
#include <stdio.h>
#include <math.h>
#include "geo.h"
#include "io.h"
#include "struct.h"
#include "rad.h"
#include "display.h"

extern RadParams ReadLog;
extern Scene RadScene;
Colour Pr_Add_Ambient();

/*====================================================================*/
/* Progessive Refinment ambient term -- only for display purposes     */
/*====================================================================*/
/**********************************************************************/
/* Approximation of patch ff as it's area over total area in scene */
/**********************************************************************/
double Pr_FF_Approx(patch)
     Polygon *patch;
{ return (patch->area / ReadLog.totalArea); }

/**********************************************************************/
/* From reflectance * area for all polys */
/**********************************************************************/
Spectra Pr_PTotal_Area()
{
  int i,j,k,l;
  Objectt *optr;
  Mesh *mptr;
  Polygon *pptr;
  Scene *sptr = &RadScene;
  Spectra ptotal_area;
  Spectra poly_p;
  double poly_a;

  for(l=0;l<MAX_SPECTRA_SAMPLES;l++) 
    ptotal_area.samples[l] = 0.0;
  for(i=0, optr=sptr->objects;i<sptr->num_objects;i++, optr++) 
    for(j=0, mptr=optr->meshes;j<optr->num_meshes;j++, mptr++) 
      for(k=0, pptr=mptr->polys;k<mptr->num_polys;k++, pptr++) {
	poly_p = poly_reflect(pptr);
	poly_a = pptr->area;
	for(l=0;l<MAX_SPECTRA_SAMPLES;l++) 
	  ptotal_area.samples[l] += poly_a * poly_p.samples[l];
      }
  return ptotal_area;
}

/**********************************************************************/
/* Inter-reflection factor */
/**********************************************************************/
double Pr_Interreflect_Factor(pavg)
     double pavg;
{ return (1.0 / ( 1.0 - pavg)); }

/**********************************************************************/
/* Computer "ambient term" for display purposes */
/**********************************************************************/
Spectra Pr_Ambient_Term()
{
  int i,j,k,l;
  Spectra ambient_term;
  Spectra pavg;
  Objectt *optr;
  Mesh *mptr;
  Polygon *pptr;
  Scene *sptr = &RadScene;

  for(l=0;l<MAX_SPECTRA_SAMPLES;l++) 
    ambient_term.samples[l] = 0.0;
  
  if (ReadLog.ptotalArea.samples[0] < 0.0)
    ReadLog.ptotalArea = Pr_PTotal_Area();
  for(l=0;l<MAX_SPECTRA_SAMPLES;l++) 
    pavg.samples[l] = ReadLog.ptotalArea.samples[l] / ReadLog.totalArea;
  for(i=0, optr=sptr->objects;i<sptr->num_objects;i++, optr++) 
    for(j=0, mptr=optr->meshes;j<optr->num_meshes;j++, mptr++) 
      for(k=0, pptr=mptr->polys;k<mptr->num_polys;k++, pptr++)
	for(l=0;l<MAX_SPECTRA_SAMPLES;l++) 
	  ambient_term.samples[l] +=
	    pptr->unshot_B.samples[l] * Pr_FF_Approx(pptr);

  for(l=0;l<MAX_SPECTRA_SAMPLES;l++) 
    ambient_term.samples[l] *= Pr_Interreflect_Factor(pavg.samples[l]);  
  return ambient_term;
}

/**********************************************************************/
/* Add ambient term for display                                       */
/* - currently use scaled ambient term.                               */
/**********************************************************************/
Colour Pr_Add_Ambient(vtx_Col, polyp)
     Colour vtx_Col;
     Spectra polyp;
{
  Colour vtx_Col_dsp;

  vtx_Col_dsp.r = vtx_Col.r + 
    (polyp.samples[0] * ReadLog.ambient_term.samples[0] / 5.0);
  /* if (vtx_Col_dsp.r > 1.0)
     vtx_Col_dsp.r = 1.0; */
  vtx_Col_dsp.g = vtx_Col.g + 
    (polyp.samples[1] * ReadLog.ambient_term.samples[1] / 5.0) ;
  /* if (vtx_Col_dsp.g > 1.0)
     vtx_Col_dsp.g = 1.0; */
  vtx_Col_dsp.b = vtx_Col.b + 
    (polyp.samples[2] * ReadLog.ambient_term.samples[2] / 5.0);
  /* if (vtx_Col_dsp.b > 1.0)
     vtx_Col_dsp.b = 1.0; */

  return vtx_Col_dsp;
}


