/**********************************************************************/
/* io.h : i/o options                                                 */
/*                                                                    */
/* Modified from Optik v(1.2e) (C) 1987 John Amanatides & Andrew Woo  */
/*                                                                    */
/* Copyright (C) 1992, Bernard Kwok                                   */
/* All rights reserved.                                               */
/* Revision 1.0                                                       */
/* May, 1992                                                          */
/**********************************************************************/
#ifndef IO_H
#define IO_H

/* output devices */
#define PRINT		1
#define FILES		2

/* options */
#define DEBUG		1
#define NO_DEBUG	2
#define GRID		3
#define NO_GRID		4
#define JITTER		5
#define NO_JITTER	6
#define ORTHO		7
#define PERSP		8
#define RAY_TRACE	9
#define RAY_CAST	10
#define FORM_FACTOR	11
#define SHADOW		12
#define NO_SHADOW	13
#define STATISTICS	14
#define NO_STATISTICS	15
#define TRANSFORM	16
#define NO_TRANSFORM	17

/**********************************************************************/
typedef struct {
  int debug;		/* if true, debug data may be printed        */
  int statistics;	/* If true, print grid statistics            */
  int tablelog;         /* Write results as table                    */
  char *tablelogstr;    /* Table name                                */
  int show_pr_steps;    /* If true, show progressive refinement steps*/
  int print_scene;      /* Print input and output logs to files      */
  int write_result;     /* Output results of program                 */

  int ff_raytrace;      /* Hemicube or ray trace form factors       */
  int grid;		/* if TRUE, then use object bounding volume 
			   hierarchy for intersection reduction      */
  int poly_grid;        /* if TRUE use poly + object bounding volume
			   hierarchy */
  int rayTransform;	/* if TRUE: transform ray to model space 
			   before doing intersect calc, else do 
			   intersection test in world space */
  int visibility;	/* either RAY_TRACE, RAY_CAST or FORM_FACTOR */
  int shadow;		/* if TRUE then shadows computed             */

  int rad_interp_type;  /* How to interpolate radiosity             */ 
  int ambient;          /* of TRUE, use an ambient term             */

  int device;		/* for the various devices                  */
  char *meshfilename;   /* Input mesh                               */ 
  char *textfilename;   /* Input textures                           */ 
  char *viewfilename;   /* Input viewfile                           */
  char *DebugFilename;  /* Log of statistics                        */
  char *InLogFilename;  /* Log of input scene                       */
  char *OutLogFilename; /* Log of output scene                      */
  FILE *StatFile;       /* Log of statistics                        */
  char *StatFilename;   
  char *OutSceneFilename; /* Output scene                           */
  int VCRmode;          /* mode for VCR                             */
  int UseVCR;           /* Record stuff on VCR                      */

  int alpha;		/* if TRUE, the alpha channel is used       */
  int perspective;	/* TRUE or FALSE                            */
} OptionType;

#endif /* IO_H */
