/**********************************************************************/
/* vcr.h                                                              */
/*                                                                    */
/* Copyright (C) 1992, Bernard Kwok                                   */
/* All rights reserved.                                               */
/* Revision 1.0                                                       */
/* May, 1992                                                          */
/**********************************************************************/
#ifndef VCR_H
#define VCR_H

/* possible screen modes */
#define FULL 1                     /* Full screen */
#define NTSC 2                     /* NTCS size screen */
#define REC  3                     /* NTSC mode */

typedef struct {
  int mode;
  int width, height;
} Vcr_params;

extern void vcr_set_mode();
extern void vcr_start_record();
extern void vcr_setup_window();
extern void vcr_start_video();
extern void vcr_grab();
extern void vcr_stop_record();
extern void vcr_end_video();

#endif /* VCR_H */
