/**********************************************************************/
/* Geometric primitives (general)                                     */
/*                                                                    */
/* Copyright (C) 1992, Bernard Kwok                                   */
/* All rights reserved.                                               */
/* Revision 1.0                                                       */
/* May, 1992                                                          */
/**********************************************************************/
#ifndef GEO_H
#define GEO_H

#ifndef IRIS4D
typedef float Matrix[4][4];              /* 4x4 transformation matrix */
static Matrix Identity = {
  1.0, 0.0, 0.0, 0.0,
  0.0, 1.0, 0.0, 0.0,
  0.0, 0.0, 1.0, 0.0,
  0.0, 0.0, 0.0, 1.0
  };
#endif 

typedef struct { double x,y,z; } Vector; /* 3D Vector */
typedef struct { double x,y,z; } point3; /* 3D Point */
typedef struct {double x,y,z,h;} point4; /* 4D Point */
typedef struct {  
  Vector n;                      /* normal */
  Vector p;                      /* point on plane */
  double d;                      /* distance from origin to plane */
} Plane;                         /* A plane */

typedef struct {               
  point3 start;                  /* Start point */
  Vector dir;                    /* vector direction */
} Line;                          /* A line */

typedef struct {
  Vector min, max;              /* Upper and lower bounds of box */
} BoundingBoxType;               /* bounding box (axis aligned) */

/**********************************************************************/
double dot();                    /* dot product */
Vector cross();                  /* cross product */
double norm();                   /* vector normalization */
double geo_line();               /* vector from 2 pts */
Vector *vadd();                  /* vector add */
Vector *vsub();                  /* vector subtract */
Vector *vcomb();                 /* linear combination of 2 vectors */
double vdist();
Vector polynorm();               /* polygon normal from vertices */
double Power();                  /* fast power function for positive ints */

void copymatrix();               /* copy matrices */
void multmatrix();               /* multiply 2 matrices */
Vector vtransform();             /* Matrix * vector */
static int invertmatrix();       /* Invert matrix */

void print_vector();             /* print 3D vector */
void print_matrix();             /* print a 4x4 matrix */

#endif /* GEO_H */


