/**************************************************************************
  Copyright (C) 1992 Guy Moreillon
  All rights reserved.

  This software may be freely copied, modified, and redistributed
  provided that this copyright notice is preserved on all copies.

  You may not distribute this software, in whole or in part, as part of
  any commercial product without the express consent of the authors.

  There is no warranty or other guarantee of fitness of this software
  for any purpose.  It is provided solely "as is".
**************************************************************************/
/**************************************************************************

				RAD
		       (Interactive Radiosity)
		    	    Version 1.0
			       1992		    	    
		    	    
		  
		    	  Guy Moreillon
		    	  
**************************************************************************/

/**************************************************************************
  Fichier	: misc.h
  Description	: Declaractions de fonctions diverses
**************************************************************************/

#ifndef misc_h
#define misc_h

extern	float	texprops[];

extern	void *arr_realloc(void	*array,
			  int	cur,
			  int	*tot,
			  int	el_size,
			  int	blck_sz);

extern	float get_min_size(SCENE_OP scene);

extern	void init_poly(TRIANGLEP    poly,
		       VECTOR	    a,
		       VECTOR	    b,
		       VECTOR	    c);

extern	void M4D_mul(Matrix res, Matrix left, Matrix right);

extern	void M4D_transform_point(VECTOR res,
				 VECTOR vector,
				 Matrix matrix);

extern	void M4D_transform_point_4D(VECTOR_4D res,
				    VECTOR vector,
				    Matrix matrix);

extern	BOOLEAN M4D_invert(Matrix inverse,
			   Matrix mat);

extern	void clip_rgb(VECTOR	co,
		      VECTOR	ci);

extern	void find_shooting_p(SHOOT_PP shoot,
			     SCENE_OP scene,
			     OBJECT_OP object);

extern	char *get_short_name(STR name);

extern	int new_texture(STR filename, SCENE_OP scene);

extern	int add_texture(SCENE_OP scene);

#endif
