/**************************************************************************
  Copyright (C) 1992 Guy Moreillon
  All rights reserved.

  This software may be freely copied, modified, and redistributed
  provided that this copyright notice is preserved on all copies.

  You may not distribute this software, in whole or in part, as part of
  any commercial product without the express consent of the authors.

  There is no warranty or other guarantee of fitness of this software
  for any purpose.  It is provided solely "as is".
**************************************************************************/
/* Form definition file generated with fdesign. */

#include "forms.h"
#include "picture.h"
#include "panels.h"

FL_FORM *Control_Panel;

FL_OBJECT
        *Translation_Slider,
        *Rotation_Slider,
        *Aperture_Slider,
        *Update_Rate_Slider,
        *Load_Button,
        *Save_Button,
        *Hold_Button,
        *Quit_Button,
        *Activity_Dial;

void create_form_Control_Panel()
{
  FL_OBJECT *obj;
  Control_Panel = fl_bgn_form(FL_NO_BOX,330.0,250.0);
  obj = fl_add_box(FL_UP_BOX,0.0,0.0,330.0,250.0,"");
  Translation_Slider = obj = fl_add_valslider(FL_HOR_FILL_SLIDER,20.0,20.0,140.0,20.0,"Translation");
    fl_set_object_color(obj,47,67);
    fl_set_object_align(obj,FL_ALIGN_TOP);
  Rotation_Slider = obj = fl_add_valslider(FL_HOR_FILL_SLIDER,170.0,20.0,140.0,20.0,"Rotation");
    fl_set_object_color(obj,47,67);
    fl_set_object_align(obj,FL_ALIGN_TOP);
  Aperture_Slider = obj = fl_add_valslider(FL_HOR_FILL_SLIDER,20.0,60.0,220.0,20.0,"Aperture");
    fl_set_object_color(obj,47,82);
    fl_set_object_align(obj,FL_ALIGN_TOP);
  Update_Rate_Slider = obj = fl_add_valslider(FL_HOR_FILL_SLIDER,20.0,100.0,220.0,20.0,"Update Rate");
    fl_set_object_color(obj,47,12);
    fl_set_object_align(obj,FL_ALIGN_TOP);
  Load_Button = obj = fl_add_button(FL_NORMAL_BUTTON,20.0,200.0,140.0,30.0,"Load");
    fl_set_object_lcol(obj,5);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
  Save_Button = obj = fl_add_button(FL_NORMAL_BUTTON,170.0,200.0,140.0,30.0,"Save");
    fl_set_object_lcol(obj,4);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
  Hold_Button = obj = fl_add_button(FL_NORMAL_BUTTON,20.0,160.0,140.0,30.0,"Hold");
    fl_set_object_lcol(obj,4);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
  Quit_Button = obj = fl_add_button(FL_NORMAL_BUTTON,170.0,160.0,140.0,30.0,"Quit");
    fl_set_object_lcol(obj,1);
    fl_set_object_lstyle(obj,FL_BOLD_STYLE);
  Activity_Dial = obj = fl_add_dial(FL_LINE_DIAL,250.0,60.0,60.0,60.0,"Activity");
    fl_set_object_boxtype(obj,FL_UP_BOX);
    fl_set_object_color(obj,47,0);
    fl_set_object_align(obj,FL_ALIGN_TOP);
    fl_set_object_lstyle(obj,FL_ITALIC_STYLE);
  fl_end_form();
}

/*---------------------------------------*/

FL_FORM *Edit_Panel;

FL_OBJECT
        *Red_Slider,
        *Green_Slider,
        *Blue_Slider,
        *Color_Box,
        *Edit_Reflectivity_Input,
        *Edit_Emissivity_Input,
        *Ok_to_modify_object_Button,
        *Add_Texture_Button;

void create_form_Edit_Panel()
{
  FL_OBJECT *obj;
  Edit_Panel = fl_bgn_form(FL_NO_BOX,330.0,240.0);
  obj = fl_add_box(FL_UP_BOX,0.0,0.0,330.0,240.0,"");
  Red_Slider = obj = fl_add_valslider(FL_HOR_FILL_SLIDER,20.0,190.0,200.0,20.0,"Red");
    fl_set_object_color(obj,47,3);
    fl_set_object_align(obj,FL_ALIGN_TOP);
  Green_Slider = obj = fl_add_valslider(FL_HOR_FILL_SLIDER,20.0,150.0,200.0,20.0,"Green");
    fl_set_object_color(obj,47,60);
    fl_set_object_align(obj,FL_ALIGN_TOP);
  Blue_Slider = obj = fl_add_valslider(FL_HOR_FILL_SLIDER,20.0,110.0,200.0,20.0,"Blue");
    fl_set_object_color(obj,47,12);
    fl_set_object_align(obj,FL_ALIGN_TOP);
  Color_Box = obj = fl_add_box(FL_DOWN_BOX,230.0,110.0,80.0,100.0,"");
    fl_set_object_color(obj,640,47);
  Edit_Reflectivity_Input = obj = fl_add_input(FL_FLOAT_INPUT,20.0,60.0,140.0,20.0,"Reflectivity");
    fl_set_object_color(obj,39,47);
    fl_set_object_align(obj,FL_ALIGN_TOP);
  Edit_Emissivity_Input = obj = fl_add_input(FL_FLOAT_INPUT,170.0,60.0,140.0,20.0,"Emissivity");
    fl_set_object_color(obj,39,47);
    fl_set_object_align(obj,FL_ALIGN_TOP);
  Ok_to_modify_object_Button = obj = fl_add_button(FL_NORMAL_BUTTON,20.0,20.0,140.0,30.0,"Ok to modify object");
    fl_set_object_lcol(obj,60);
  Add_Texture_Button = obj = fl_add_button(FL_NORMAL_BUTTON,170.0,20.0,140.0,30.0,"Add Texture");
    fl_set_object_lcol(obj,112);
  fl_end_form();
}

/*---------------------------------------*/

FL_FORM *Texture_Panel;

FL_OBJECT
        *Texture_Name_Browser,
        *Scale_Input,
        *Tex_Reflectivity_Input,
        *Tex_Emissivity_Input,
        *Bind_and_Modify_Button,
        *No_Texture_Button,
        *Texture_Box,
	*Texture_Pict;

void create_form_Texture_Panel()
{
  FL_OBJECT *obj;
  Texture_Panel = fl_bgn_form(FL_NO_BOX,330.0,260.0);
  obj = fl_add_box(FL_UP_BOX,0.0,0.0,330.0,260.0,"");
  Texture_Name_Browser = obj = fl_add_browser(FL_HOLD_BROWSER,20.0,110.0,150.0,120.0,"Texture Name");
    fl_set_object_color(obj,47,52);
    fl_set_object_align(obj,FL_ALIGN_TOP);
  Scale_Input = obj = fl_add_input(FL_FLOAT_INPUT,190.0,110.0,120.0,20.0,"Scale");
    fl_set_object_color(obj,39,47);
    fl_set_object_align(obj,FL_ALIGN_TOP);
  Tex_Reflectivity_Input = obj = fl_add_input(FL_FLOAT_INPUT,20.0,60.0,140.0,20.0,"Reflectivity");
    fl_set_object_color(obj,39,47);
    fl_set_object_align(obj,FL_ALIGN_TOP);
  Tex_Emissivity_Input = obj = fl_add_input(FL_FLOAT_INPUT,170.0,60.0,140.0,20.0,"Emissivity");
    fl_set_object_color(obj,39,47);
    fl_set_object_align(obj,FL_ALIGN_TOP);
  Bind_and_Modify_Button = obj = fl_add_button(FL_NORMAL_BUTTON,20.0,20.0,140.0,30.0,"Bind & Modify");
    fl_set_object_lcol(obj,60);
  No_Texture_Button = obj = fl_add_button(FL_NORMAL_BUTTON,170.0,20.0,140.0,30.0,"No Texture");
    fl_set_object_lcol(obj,112);
  Texture_Box = obj = fl_add_box(FL_DOWN_BOX,214.0,160.0,70.0,70.0,"");
    fl_set_object_color(obj,0,47);
  Texture_Pict = obj = 
    fl_add_free(FL_SLEEPING_FREE,
	        (float)Texture_Box->x, (float)Texture_Box->y,
		(float)Texture_Box->w, (float)Texture_Box->h,
		"",
		picture_handle);

  fl_end_form();
}

/*---------------------------------------*/

FL_FORM *Radiosity_Panel;

FL_OBJECT
        *Rad_Red_Text,
        *Rad_Green_Text,
        *Rad_Blue_Text;

void create_form_Radiosity_Panel()
{
  FL_OBJECT *obj;
  Radiosity_Panel = fl_bgn_form(FL_NO_BOX,330.0,120.0);
  obj = fl_add_box(FL_UP_BOX,0.0,0.0,330.0,120.0,"");
  Rad_Red_Text = obj = fl_add_text(FL_NORMAL_TEXT,20.0,80.0,290.0,20.0,"Radiosity");
    fl_set_object_boxtype(obj,FL_FRAME_BOX);
    fl_set_object_color(obj,261,47);
  Rad_Green_Text = obj = fl_add_text(FL_NORMAL_TEXT,20.0,50.0,290.0,20.0,"Radiosity");
    fl_set_object_boxtype(obj,FL_FRAME_BOX);
    fl_set_object_color(obj,59,47);
  Rad_Blue_Text = obj = fl_add_text(FL_NORMAL_TEXT,20.0,20.0,290.0,20.0,"Radiosity");
    fl_set_object_boxtype(obj,FL_FRAME_BOX);
    fl_set_object_color(obj,138,47);
  fl_end_form();
}

/*---------------------------------------*/

void create_the_forms()
{
  create_form_Control_Panel();
  create_form_Edit_Panel();
  create_form_Texture_Panel();
  create_form_Radiosity_Panel();
}

