/**************************************************************************
  Copyright (C) 1992 Guy Moreillon
  All rights reserved.

  This software may be freely copied, modified, and redistributed
  provided that this copyright notice is preserved on all copies.

  You may not distribute this software, in whole or in part, as part of
  any commercial product without the express consent of the authors.

  There is no warranty or other guarantee of fitness of this software
  for any purpose.  It is provided solely "as is".
**************************************************************************/
/**************************************************************************

				RAD
		       (Interactive Radiosity)
		    	    Version 1.0
			       1992		    	    
		    	    
		  
		    	  Guy Moreillon
		    	  
**************************************************************************/

/**************************************************************************
  Fichier	: picture.c
  Description	: Routines de gestion de l'objet libre Picture
**************************************************************************/

#include <stdio.h>
#include <gl.h>
#include "types.h"
#include "macros.h"
#include "forms.h"
#include "picture.h"

#define	IM_W	100	/* Max size actually, not real size */
#define IM_H	100	/* Max size actually, not real size */

typedef	struct {
	unsigned long	*image;
	int		width;
	int		height;
	} PICTURE;

static	PICTURE	    pict;

void set_picture(unsigned long *image, int width, int height)
/**************************************************************************
  But 	: Defini l'image courante
  Entree: image	    : l'image
	  width	    : largeur de l'image
	  height    : hauteur de l'image
  Sortie: neant
**************************************************************************/
{
  pict.image	= image;
  pict.width	= width;
  pict.height	= height;
}

int picture_handle(FL_OBJECT *obj, int event, float mx, float my, char key)
/**************************************************************************
  But 	: Routine de traitement des evenements recu par l'objet libre
  Entree: obj	    : l'objet
	  event	    : l'evenement
	  mx, my    : la position de la souris
	  key	    : la touche enfoncee
  Sortie: Toujours FALSE
**************************************************************************/
{
  static unsigned long	*old = NULL;
  static unsigned long	new[(IM_W*IM_H)];

  switch(event){
    case FL_DRAW:
      if (pict.image != NULL)
        {
	  if (old != pict.image)
            soft_zoom(pict.image, new,
		      pict.width, pict.height, 4,
		      (int)obj->w - 8,  (int)obj->h - 8);
          lrectwrite((Screencoord)obj->x+4,
		     (Screencoord)obj->y+4,
		     (Screencoord)(obj->x + obj->w - 5),
		     (Screencoord)(obj->y + obj->h - 5),
		     new);
          old = pict.image;
        }
      break;
    default:
      break;
  }

  return FALSE;
}
