/**************************************************************************
  Copyright (C) 1992 Guy Moreillon
  All rights reserved.

  This software may be freely copied, modified, and redistributed
  provided that this copyright notice is preserved on all copies.

  You may not distribute this software, in whole or in part, as part of
  any commercial product without the express consent of the authors.

  There is no warranty or other guarantee of fitness of this software
  for any purpose.  It is provided solely "as is".
**************************************************************************/
/**************************************************************************

				RAD
		       (Interactive Radiosity)
		    	    Version 1.0
			       1992		    	    
		    	    
		  
		    	  Guy Moreillon
		    	  
**************************************************************************/

/**************************************************************************
  Fichier	: select.c
  Description	: Routines de management de la selection
**************************************************************************/

#include <stdio.h>
#include "types.h"
#include "macros.h"
#include "ray.h"
#include "misc.h"
#include "select.h"

void select_obj(SCENE_OP scene, SELECTIONP select, VECTOR point)
/**************************************************************************
  But	: Determine l'objet touche par le rayon compris entre les points
	  start et end
  Entree: scene	    : la scene
	  select    : la selection (rendue)
	  point	    : l'origine du rayon dans l'espace ecran
  Sortie: neant
**************************************************************************/
{
  RAY	    ray;
  float	    max_dis;
  VECTOR    start, end;

  point[2] = -1.0;
  M4D_transform_point(start, point, scene->state.visu.unif2world);

  point[2] = 1.0;
  M4D_transform_point(end, point, scene->state.visu.unif2world);

  select->pure = NULL;
  select->tri  = NULL;
  select->elem = NULL;

  V_sub(ray.dir, end, start);
  max_dis = V_norm(ray.dir);
  V_normalize(ray.dir, ray.dir);
  V_copy(ray.org, start);

  if (!object_in_sight(select, &ray, scene, max_dis))
    {
      select->pure = NULL;
      select->tri  = NULL;
      select->elem = NULL;
    }
}

