/* transform.h,v 1.1.1.1 1995/02/27 07:38:27 explorer Exp */

/*
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */

#ifndef TRANSFORM_H
#define TRANSFORM_H

typedef voidstar TransRef;
typedef TransRef TransCreateFunc();

/*
 * Transformation 'matrix'.
 */
typedef struct RSMatrix {
  Float matrix[3][3];		/* Rotation matrix */
  Vector translate;		/* Translation */
} RSMatrix;

typedef struct {
  TransRef	(*create)();		/* Create it... */
  void		(*propagate)();		/* Propagate changes to parameters */
} TransMethods;

/* 
 * Transformation structure
 */
typedef struct Trans {
  TransRef tr;			/* transform data */
  TransMethods *methods;	/* transform methods */
  ExprAssoc *assoc;		/* animated parameters */
  short	animated;		/* is the transformation animated? */
  RSMatrix trans;		/* object space --> world space */
  RSMatrix itrans;	        /* worldspace --> object space */
  struct Trans *next, *prev;
} Trans;

/*
 * in transform.c
 */
extern void     VecTransform _PROTO((Vector *, RSMatrix *));
extern void     PointTransform _PROTO((Vector *, RSMatrix *));
extern void     NormalTransform _PROTO((Vector *, RSMatrix *));
void            ArbitraryMatrix _PROTO((Float, Float, Float, Float, Float,
					Float, Float, Float, Float, Float,
					Float, Float, RSMatrix *));
void            CoordSysTransform _PROTO((Vector *, Vector *, Float, Float,
					  Trans *));
extern Float	RayTransform _PROTO((Ray *, RSMatrix *));

extern Float	Lipschitz _PROTO((Float[3]));

extern int      MatrixEigenvalues _PROTO((RSMatrix *, Float[3]));
extern int      MatrixScaling _PROTO((RSMatrix *, Float[3]));
extern void	MatrixMult _PROTO((RSMatrix *, RSMatrix *, RSMatrix *));
extern void     MatrixCopy _PROTO((RSMatrix *, RSMatrix *));
extern void     MatrixInit _PROTO((RSMatrix *));
extern void     MatrixInvert _PROTO((RSMatrix *, RSMatrix *));
extern RSMatrix	*MatrixCreate _PROTO((void));

extern int      Uniform _PROTO((Float[3]));

extern void     TransResolveAssoc _PROTO((Trans *));
extern void     TransFree _PROTO((Trans *));
extern void     TransAssoc _PROTO((Trans *, Float *, Expr *));
extern void     TransPropagate _PROTO((Trans *));
extern void     TransComposeList _PROTO((Trans *, Trans *));
extern void     TransCopy _PROTO((Trans *, Trans *));
extern void     TransInit _PROTO((Trans *));
extern void     TransInvert _PROTO((Trans *, Trans *));
extern void     TransCompose _PROTO((Trans *, Trans *, Trans *));
extern Trans	*TransCreate _PROTO((TransRef, TransMethods *));

#endif /* TRANSFORM_H */
