/* cone.h,v 1.1.1.1 1995/02/27 07:38:31 explorer Exp */

/*
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */

#ifndef CONE_H
#define CONE_H

#define GeomConeCreate(c,a,r1,r2) GeomCreate((GeomRef)ConeCreate(c,a,r1,r2), \
					ConeMethods())

/*
 * Cone
 */
typedef struct cone {
  Float start_dist;
  Trans trans;
} Cone;

extern GeomRef  ConeCreate _PROTO((Float, Vector *, Float, Vector *));
extern Methods	*ConeMethods METHODS_PROTO;
extern int	ConeIntersect INTERSECT_PROTO;
extern int      ConeNormal NORMAL_PROTO;
extern int      ConeEnter ENTER_PROTO;
extern void     ConeUV UV_PROTO;
extern void	ConeBounds BOUNDS_PROTO;
extern char	*ConeName NAME_PROTO;
extern void     ConeStats STATS_PROTO;
extern void     ConeMethodRegister _PROTO((UserMethodType));

#endif /* CONE_H */
