/* csg.h,v 1.1.1.1 1995/02/27 07:38:31 explorer Exp */

/*
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */

#ifndef CSG_H
#define CSG_H

#define GeomCsgCreate(t)	GeomCreate((GeomRef)CsgCreate(t), CsgMethods())

/*
 * CSG (Constructive Solid Geometry)
 */
#define CSG_UNION	0
#define CSG_INTERSECT	1
#define CSG_DIFFERENCE	2

typedef struct Csg {
  char operator;		/* Union, Intersect, or Difference */
  struct Geom *obj1, *obj2;
  int (*intmeth)();		/* Intersection method. */
  Float bounds[2][3];
} Csg;

extern GeomRef  CsgCreate _PROTO((int));
extern Methods	*CsgMethods METHODS_PROTO;
extern char	*CsgName NAME_PROTO;
extern void	CsgBounds BOUNDS_PROTO;
extern int      CsgConvert CONVERT_PROTO;
extern int	CsgIntersect INTERSECT_PROTO;
extern void     CsgMethodRegister _PROTO((UserMethodType));

extern int	FirstCSGGeom _PROTO((HitList *));

#endif /* CSG_H */
