/* list.h,v 1.1.1.1 1995/02/27 07:38:34 explorer Exp */

/*
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */

#ifndef LIST_H
#define LIST_H

#define GeomListCreate()	GeomCreate((GeomRef)ListCreate(), ListMethods())

/*
 * List object
 */
typedef struct {
  struct Geom *list;		/* List of prims/objs. in object */
  struct Geom *unbounded;	/* List of unbounded prims. */
  Float bounds[2][3];		/* Bounding box of object */
} List;

extern GeomRef  ListCreate _PROTO((void));
extern char	*ListName NAME_PROTO;
extern int      ListConvert CONVERT_PROTO;
extern int	ListIntersect INTERSECT_PROTO;
extern Methods	*ListMethods METHODS_PROTO;
extern void	ListBounds BOUNDS_PROTO;
extern void     ListMethodRegister _PROTO((UserMethodType));

#endif /* LIST_H */
