/* gradient.h,v 1.2 1995/03/30 07:13:19 explorer Exp */

/*
 *
 * Copyright (C) 1989, 1991, Craig E. Kolb, 1992, Lawrence Coffin
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 * 
 */

#ifndef GRADIENT_H
#define GRADIENT_H

#define TextGradientCreate(s1,s2,S,d1,d2,T,R) \
		TextCreate((TextRef)GradientCreate(s1,s2,S,d1,d2,T,R),GradientApply)



typedef struct {
  Surface *surf1, *surf2;
  Float start, stop;
  int type, shape, rand;
} Gradient;

#define LINEAR		0
#define LOG		1
#define REVLOG		2

#define PLANAR		0
#define RADIAL		1
#define SPHERICAL	2

#define NO 0
#define YES 1

extern Gradient *GradientCreate _PROTO((Surface *, Surface *, int, Float,
					Float, int, int));
extern void GradientApply _PROTO((Gradient *, Geom *, Ray *, Vector *,
				  Vector *, Vector *, Surface *));

#endif /* GRADIENT_H */
