/* mapping.h,v 1.1.1.1 1995/02/27 07:38:42 explorer Exp */

/*
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */

#ifndef MAPPING_H
#define MAPPING_H

#define PRIMSPACE	01	/* Mapping uses data in prim space */
#define OBJSPACE	02	/* Mapping uses data in object space */

typedef struct Mapping {
	int flags;		/* mapping flags */
	Vector center, uaxis, vaxis, norm;
	Float dist;
	RSMatrix m;
	void (*method)();
} Mapping;

extern Mapping *UVMappingCreate _PROTO((void));
extern Mapping *SphereMappingCreate _PROTO((Vector *, Vector *, Vector *));
extern Mapping *CylMappingCreate _PROTO((Vector *, Vector *, Vector *));
extern Mapping *LinearMappingCreate _PROTO((Vector *, Vector *, Vector *));

#endif /* MAPPING_H */
