/* builtin.c,v 1.2 1995/04/08 19:53:00 explorer Exp */

/*
 * Copyright (C) 1989, 1991, Craig E. Kolb, Rod G. Bogart
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 * 
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */

#include "rayshade.h"
#include "builtin.h"

Float
SumExpr(a, b)
     Float a, b;
{
  return a + b;
}

Float
DiffExpr(a, b)
     Float a, b;
{
  return a - b;
}

Float
MultExpr(a, b)
     Float a, b;
{
  return a * b;
}

Float
DivideExpr(a, b)
     Float a, b;
{
  return a / b;
}

Float
ModExpr(a, b)
     Float a, b;
{
  return (Float)((int)a % (int)b);
}

Float
NegateExpr(a)
     Float a;
{
  return -a;
}

Float
LinearTime(starttime, startval, endtime, endval)
     Float starttime, endtime, startval, endval;
{
  if (TimeGet() < starttime)
    return startval;
  if (TimeGet() > endtime)
    return endval;
  if (equal(endtime, starttime))
    return startval;
  return startval + (endval - startval) * 
		(TimeGet() - starttime) / (endtime - starttime);
}

Float
CondExpr(cond, a, b)
  Float	cond, a, b;
{
  if (cond)
    return a;
  else
    return b;
}

Float
EqualExpr(a, b)
  Float	a, b;
{
  return (Float)equal(a, b);
}

Float
UnequalExpr(a, b)
  Float	a, b;
{
  return (Float)(!equal(a, b));
}

Float
LessExpr(a, b)
  Float	a, b;
{
  return (Float)(a <= (b - EPSILON));
}

Float
LessEqualExpr(a, b)
  Float	a, b;
{
  return (Float)(a < (b + EPSILON));
}

Float
GreaterExpr(a, b)
  Float	a, b;
{
  return (Float)(a >= (b + EPSILON));
}

Float
GreaterEqualExpr(a, b)
  Float	a, b;
{
  return (Float)(a > (b - EPSILON));
}

Float
AndExpr(a, b)
  Float	a, b;
{
  return (Float)(a && b);
}

Float
OrExpr(a, b)
  Float	a, b;
{
  return (Float)(a || b);
}


/******************************************************************************
 * These are the standard modes available.
 * Each mode function will be called with a value between 0 and 1 and should
 * return a value which is 0 when called with 0, and 1 when called with 1.
 * In between, values may be anything (but between 0 and 1 is normal).
 */

/* Linearly goes from (0,0) to (1,1) */
Float
LinearMode(t)
  Float	t;
{
  return t;
}

/* Accelerates */
Float
AccelMode(t)
  Float	t;
{
  return t * t;
}

/* Decelerates */
Float
DecelMode(t)
  Float	t;
{
  return t * (2 - t);
}

/* Accelerates/Decelerates */
Float
AccelDecelMode(t)
  Float	t;
{
  if (t < 0.5)
    return 2 * t * t;
  else
    return -2 * t * t + 4 * t - 1;
}

/* Is only 0 when called with 0, 1 otherwise.
 * If you need a jump function which is always 0, except in 1, just use
 * something like:
 *	define	jump0	0
 *	define	var	10 jump0 20
 */
Float
JumpMode(t)
  Float	t;
{
  return !equal(t, 0.0);
}


