/* options.h,v 1.1.1.1 1995/02/27 07:38:46 explorer Exp */

/*
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */

#ifndef OPTIONS_H
#define OPTIONS_H

/*
 * Constants for Stereo mode
 */
#define LEFT		1
#define RIGHT		2

/*
 * Options
 */
typedef struct RSOptions {
  int	stereo;			/* Stereo mode? */
  int   verbose;		/* Babbling mode? */
  int   quiet;			/* Don't complain? */
  int   jitter;			/* use jittered sampling? */
  int   samples;		/* Sqrt of # of samples */
  int   maxdepth;		/* Maximum ray tree depth */
  int   report_freq;		/* Frequency, in lines, of report */
  int   no_shadows;		/* Trace shadow rays? */
  int   shadowtransp;		/* ... through transparent objects? */
  int   cache;			/* Cache shadowing info? */
  int   appending;		/* Append to image file? */
  int   resolution_set;		/* resolution set on command line */
  int   contrast_set;		/* contrast overridden ... */
  int   samples_set;		/* samples overridden ... */
  int   cutoff_set;		/* cutoff ... */
  int   maxdepth_set;		/* adaptive depth ... */
  int   window_set;		/* subwindow ... */
  int   crop_set;		/* crop window ... */
  int   freq_set;		/* report frequency ... */
  int   jitter_set;		/* use jittering */
  int   eyesep_set;		/* eye separation ... */
  int   csg;			/* CSG object someplace in world */
  int   flipnorm;		/* flip normals of polygonal objs */
  int   samplemap;		/* output sample map? */
  int   gaussian;		/* Use gaussian pixel filter? */
  int   framenum;		/* current frame number */
  int   startframe;		/* Starting frame number. */
  int   endframe;		/* ending frame number */
  int   totalframes;		/* total # of frames */
  int   totalframes_set;	/* set on command line? */
  int   cpp;			/* run CPP? */
  int   zbufprint;              /* print Zbuf stats? */
#ifdef URT
  int	alpha;			/* Write alpha channel? */
  int	exp_output;		/* Write exponential RLE file? */
#endif
  Float	eyesep;			/* Eye separation (for Stereo mode) */
  Float gamma;			/* Gamma value (0 == no correction) */
  Float starttime;		/* Think about it ... */
  Float shutterspeed;		/* time shutter is open */
  Float framestart;		/* start time of the current frame */
  Float framelength;		/* length of the current frame */
  Float filterwidth;		/* Pixel filter width. */
  Color	contrast;		/* Max. allowable contrast */
  Color cutoff;			/* Ray tree depth control */
  Color ambient;		/* Ambient light multiplier */
  char	*progname;		/* argv[0] */
  char  *statsname;		/* Name of stats file. */
  char  *imgname;		/* Name of output image file */
  char  *inputname;		/* Name of input file, NULL == stdin */
  char  *cppargs;               /* arguments to pass to cpp */
  char  *zbufname;              /* Name of Z buffer file (if any) */
  int	window[2][2];		/* Subwindow corners */
  Float	crop[2][2];		/* Crop window, lo/hi normalized */
#ifdef LINDA
  int	workers;		/* # of worker processes */
  int   workernum;		/* worker #, 0 == supervisor */
  int   verbose_worker;		/* Babble while you work? */
#endif
  FILE	*pictfile;		/* output file pointer */
#ifdef AMIGA
  int	SAScpp;
#endif
#ifdef NSPARALLEL
  int   mode;                 /* MODE_{STANDALONE,SERVER,CLIENT} */
  char  *hostfile;            /* name of server list file */
  int   tcpport;              /* port number to use for server mode */
  int   tcpfd;                /* file descriptor of our connection to client */
#endif
} RSOptions;

extern RSOptions Options;

extern void RSOptionsList _PROTO((void));
extern void RSOptionsSet _PROTO((int argc, char *argv[]));

#ifdef NSPARALLEL
#define MODE_STANDALONE 0
#define MODE_SERVER     1
#define MODE_CLIENT     2
#endif

#endif /* OPTIONS_H */
