/*
 * sipptypes.h - typdefs in sipp not needed to be public.
 *
 * (c) Jonas Yngvesson 1989-12-04
 */

#ifndef SIPPTYPES_H
#define SIPPTYPES_H


/*
 * Temporary storage of transformed vertices.
 */
typedef struct view_coord_3d {
    int                   y;
    double                x, z;        /* Transformed vertex coordinates */
    double                nx, ny, nz;  /* average normal */
    double                u, v, w;     /* texture parameters */
    struct view_coord_3d *next;        /* next vertex in the list */
} View_coord;


/*
 * Entry in the edge list used in rendering.
 */
typedef struct edges_3d {
    int              y, y_stop;   /* Current point and interpolation steps */
    double           x, xstep;            
    double           z, zstep;
    double           nx, nxstep;  /* Current normal and interp. steps */
    double           ny, nystep;
    double           nz, nzstep;
    double           u, ustep;    /* Current texture coordinates and */
    double           v, vstep;    /* interp. steps                   */
    double           w, wstep;
    int              polygon;     /* Uniqe polygon id of the polygon to */
                                  /* which the edge belongs */
    Surface         *surface;     /* Surface that the edge belongs to */
    struct edges_3d *next;        /* Next edge on this scanline */
} Edge;


/*
 * Objects installed in the database for rendering are kept
 * in a binary tree, internal to sipp. This database will
 * automatically contain all top level objects, but the user
 * can also force objects in or out of it.
 */
typedef struct inst_obj_t {
    Object *object;
    struct inst_obj_t *big;
    struct inst_obj_t *sml;
} Inst_object;


#endif /* SIPPTYPES_H */
