/**
 ** sipp - SImple Polygon Processor
 **
 **  A general 3d graphic package
 **
 **  Copyright Jonas Yngvesson  (jonas-y@isy.liu.se) 1988/89/90/91
 **            Inge Wallin      (ingwa@isy.liu.se)         1990/91
 **
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 1, or any later version.
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 ** You can receive a copy of the GNU General Public License from the
 ** Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 **/

/**
 ** lightsource.c - Functions that handles lightsources.
 **/

#include <geometric.h>
#include <lightsource.h>
#include <sipp.h>
#include <smalloc.h>


Lightsource  *lightsrc_stack;  /* Stack of installed lightsources. */


/*
 * Define a new lightsource in the scene.
 */
void
lightsource_push(x, y, z, intensity)
    double  x, y, z, intensity;
{
    double       norm;
    Lightsource *lp;

    norm = sqrt(x * x + y * y + z * z);
    lp = (Lightsource *)smalloc(sizeof(Lightsource));
    lp->dir.x = x / norm;
    lp->dir.y = y / norm;
    lp->dir.z = z / norm;
    lp->intensity = intensity;
    lp->next = lightsrc_stack;
    lightsrc_stack = lp;
}


