#ifndef lint
static char rcsid[] = "$Header: /usr/people/sam/tiff/libtiff/RCS/tif_apple.c,v 1.2 92/09/01 15:44:19 sam Exp $";
#endif

/*
 * Copyright (c) 1988, 1989, 1990, 1991, 1992 Sam Leffler
 * Copyright (c) 1991, 1992 Silicon Graphics, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Sam Leffler and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Sam Leffler and Silicon Graphics.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 * IN NO EVENT SHALL SAM LEFFLER OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 */

/*
 * TIFF Library Apple-specific Routines.
 */
#include "tiffioP.h"

static int
_tiffReadProc(int fd, char* buf, int size)
{
	return (read(fd, buf, size));
}

static int
_tiffWriteProc(int fd, char* buf, int size)
{
	return (write(fd, buf, size));
}

#ifdef applec
#include <ioctl.h>
#include <Files.h>

static long
_tiffSeekProc(int fd, long offset, int whence)
{
	long filepos, filesize, newpos;
	short macfd;
	
	if ((filepos = lseek(fd, 0, SEEK_CUR)) < 0 ||
	    (filesize = lseek(fd, 0, SEEK_END)) < 0)
		return (EOF);
	newpos = offset + (whence == SEEK_SET ? 0 : 
			   whence == SEEK_CUR ? filepos :
						filesize);
	if (newpos > filesize)
		if (ioctl(fd, FIOREFNUM, &macfd) == -1 ||
		    SetEOF(macfd, newpos) != 0)
			return (EOF);
	return (lseek(fd, newpos, SEEK_SET));
}
#else /* THINK_C */
static long
_tiffSeekProc(int fd, long off, int whence)
{
	return (lseek(fd, off, whence));
}
#endif /* THINK_C */

static int
_tiffMapProc(int fd, char **pbase, long *psize)
{
	return (0);
}

static void
_tiffUnmapProc(int fd, char *base, long size)
{
}

static int
_tiffCloseProc(int fd)
{
	return (close(fd));
}

static long
_tiffSizeProc(int fd)
{
	long pos = _tiffSeekProc(fd, 0, SEEK_CUR);
	long eof = _tiffSeekProc(fd, 0, SEEK_END);
	_tiffSeekProc(fd, pos, SEEK_SET);
	return(eof);
}

/*
 * Open a TIFF file descriptor for read/writing.
 */
TIFF *
TIFFFdOpen(fd, name, mode)
	int fd;
	const char *name, *mode;
{
	TIFF *tif;

	tif = TIFFClientOpen(name, mode,
	    (void*) fd,
	    _tiffReadProc, _tiffWriteProc, _tiffSeekProc, _tiffCloseProc,
	    _tiffSizeProc, _tiffMapProc, _tiffUnmapProc);
	if (tif)
		tif->tif_fd = fd;
	return (tif);
}

/*
 * Open a TIFF file for read/writing.
 */
TIFF *
TIFFOpen(name, mode)
	const char *name, *mode;
{
	static char module[] = "TIFFOpen";
	int m, fd;

	m = _TIFFgetMode(mode, module);
	if (m == -1)
		return ((TIFF *)0);
	fd = open(name, m);
	if (fd < 0) {
		TIFFError(module, "%s: Cannot open", name);
		return ((TIFF *)0);
	}
	return (TIFFFdOpen(fd, name, mode));
}

#if defined(THINK_C)
extern	void *malloc(size_t size);
extern	void *realloc(void *ptr, size_t size);
#endif

void *
_TIFFmalloc(s)
	size_t s;
{
	return (malloc(s));
}

void
_TIFFfree(p)
	void *p;
{
	free(p);
}

void *
_TIFFrealloc(p, s)
	void *p;
	size_t s;
{
	return (realloc(p, s));
}
