/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



/*
 *                  File: C_constants.h
 *                Author: Lisa Sobierajski & Rick Avila
 *                  Date:
 *           Description:
 *  Modification History:
 *
 *         who?         when?           why?
 *    -----------------------------------------------------------
 *
 */

/************************************************************************/
/*									*/
/*			Miscellaneous Constants				*/
/*									*/
/************************************************************************/
/*	Booleans						*/
#define FALSE			0
#define TRUE			1

/*      Is this a slave process?				*/
#ifdef C_SLAVE
#define C_MASTER_PROCESS	FALSE
#endif
#ifndef C_SLAVE
#define C_MASTER_PROCESS	TRUE
#endif

/*	Return Flags For Procedures & Programs			*/
#define C_ERROR			-1
#define C_OK			0

/*	Return Flag For No Match On Name Lookup			*/
#define C_NO_MATCH		-1	

/* Constants For Motif Windows */
#define C_APPLICATION_NAME      "VolVis 0.1"


/*	Maximum Images In The C_ImageTable			*/
#define C_MAX_IMAGES		20

/*	Maximum String Size					*/
#define C_MAX_STRING		256

#define C_MAX_GLOBAL_CUTS	5 

#define C_MAX_LOCAL_CUTS	5

/* 	Maximum Volume & Light Name Size (in chars)		*/
#define	C_NAME_SIZE		16

/*	Number Of Faces Of A Cube				*/
#define C_NUM_FACES		6

/*	Number Of Values Within A C_Voxel (See C_typedefs.h)	*/
/*	equal to pow(2.0, 8.0*sizeof(C_Voxel))			*/
#define C_VOXEL_SIZE		256

/*	Number Of Values Within A C_Byte (See C_typedefs.h)	*/
/*	equal to pow(2.0, 8.0*sizeof(C_Byte))			*/
#define C_BYTE_SIZE		256

/*	Number of entries in the geo_table - equal to           */
/*	pow(2.0, 8.0*sizeof(C_Geo_Index))			*/
#define C_GEO_TABLE_SIZE	256

/*      Large Floating Point Number                             */
#define C_BIG_FLOAT             1e10 


/*	Define the masked used to access the upper bits of a    */
/*	color. (For indexing the array shading model, we need   */
/*	to access the high order 3 bits of red and green, and   */
/*	the high order two bits of blue, and form a number out  */
/*	of them.						*/
#define	C_RED_SHADE_MASK	0xd0
#define	C_GREEN_SHADE_MASK	0xd0
#define C_BLUE_SHADE_MASK	0xb0

	

/************************************************************************/
/*									*/
/*			Environment Constants				*/
/*									*/
/************************************************************************/
/*   This places a limit of 10 light sources in the scene	*/
#define C_MAX_LIGHTS		10

/*   This places a limit of 10 volumes (other that light	*/
/*   sources) in the scene					*/
#define C_MAX_VOLUMES		30

/************************************************************************/
/*									*/
/*			Projection Constants				*/
/*									*/
/************************************************************************/
/*   Binary search limit for finding an intersection with	*/
/*   scanned data						*/
#define C_BINSEARCH_LIMIT	8

#define C_PARALLEL_FOV		0.0
#define C_PERSPECTIVE_FOV	60.0

#define C_MAX_SAMPLES		16	

#define C_NUM_LOW_SAMPLES	4
#define C_NUM_MEDIUM_SAMPLES	8
#define C_NUM_HIGH_SAMPLES	16

#define C_MAX_PIXEL_DIFF	30

/************************************************************************/
/*									*/
/*			File Name Extension Constants			*/
/*									*/
/************************************************************************/
#define	C_CONFOCAL_EXTENSION	"cnf"
#define	C_SLICE_EXTENSION	"slc"
#define	C_CFB_EXTENSION		"cfb"
#define	C_GDL_EXTENSION		"gdl"

/************************************************************************/
/*									*/
/*			File Format Constants				*/
/*									*/
/************************************************************************/
/*	Confocal Header Size In Bytes				*/
#define C_CNF_HEADER_SIZE	76

/************************************************************************/
/*                                                                      */
/*                      Magic Numbers For File I/O                      */
/*                                                                      */
/************************************************************************/
#define C_SLICE_MAGIC		11111
#define C_IMAGE_MAGIC		22222	
#define C_ANIMATION_MAGIC	33333
#define C_TEXTURE_MAGIC		44444
#define C_FUNCTION_MAGIC	55555

# define        C_NUM_VOXELS    100


