/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/



/*
 *			File: C_volvis.c
 *		      Author: Rick Avila
 *			Date: 01/18/92
 *		 Description: Main & Initialization Routines Of VolVis
 *	Modification History:
 *
 *		Who?		When?		Why?
 *	--------------------------------------------------------------------
 *
 */
#include <stdio.h>
#include <fcntl.h>
#include <string.h>
#include <math.h>

#include "C_volvis.h"
#include "C_navigator.h"
#include "C_help.h"

extern C_identity3D();

extern C_World		world;
extern C_View		view;
extern C_ImageTable	image_table;

char		*help_file_name[C_NUM_HELP_OPTIONS];

C_initialize_volvis()
{
	extern C_NavInfo	nav_info;
	extern void 		C_update_world_extent();
/***
	extern void		C_initialize_indirect_lighting();
***/
	extern void		C_initialize_navigator();
	void			C_initialize_help();

	int		c_status;
	C_Volume	*tmp;
	C_Image		image;

	C_initialize_world( &world );

	C_initialize_view( &view );

	C_initialize_image_table( &image_table );

/***
	C_initialize_indirect_lighting();
***/

	C_initialize_navigator( &nav_info );

	C_initialize_help();

	C_update_world_extent();

}

void C_initialize_help()
{

	help_file_name[C_FIO_HELP] = 
		(char *) malloc( strlen("fio_help") + 1 );
	strcpy( help_file_name[C_FIO_HELP], 
		"fio_help" ); 

	help_file_name[C_FIO_LOAD_HELP] = 
		(char *) malloc( strlen("fio_load_help") + 1 );
	strcpy( help_file_name[C_FIO_LOAD_HELP], 
		"fio_load_help" ); 
	
	help_file_name[C_FIO_SAVE_HELP] = 
		(char *) malloc( strlen("fio_save_help") + 1 );
	strcpy( help_file_name[C_FIO_SAVE_HELP], 
		"fio_save_help" ); 
	
	help_file_name[C_HLP_HELP] = 
		(char *) malloc( strlen("hlp_help") + 1 );
	strcpy( help_file_name[C_HLP_HELP], 
		"hlp_help" ); 
	
	help_file_name[C_OCO_HELP] = 
		(char *) malloc( strlen("oco_help") + 1 );
	strcpy( help_file_name[C_OCO_HELP], 
		"oco_help" ); 
	
	help_file_name[C_OCO_MODIFY_WORLD_HELP] = 
		(char *) malloc( strlen("oco_modify_world_help") + 1 );
	strcpy( help_file_name[C_OCO_MODIFY_WORLD_HELP], 
		"oco_modify_world_help" ); 
	
	help_file_name[C_OCO_MODIFY_VIEW_HELP] = 
		(char *) malloc( strlen("oco_modify_view_help") + 1 );
	strcpy( help_file_name[C_OCO_MODIFY_VIEW_HELP], 
		"oco_modify_view_help" ); 
	
	help_file_name[C_OCO_MODIFY_VOLUME_HELP] = 
		(char *) malloc( strlen("oco_modify_volume_help") + 1 );
	strcpy( help_file_name[C_OCO_MODIFY_VOLUME_HELP], 
		"oco_modify_volume_help" ); 
	
	help_file_name[C_OCO_MODIFY_VOLUME_COLOR_HELP] = 
		(char *) malloc( strlen("oco_modify_volume_color_help") + 1 );
	strcpy( help_file_name[C_OCO_MODIFY_VOLUME_COLOR_HELP], 
		"oco_modify_volume_color_help" ); 
	
	help_file_name[C_OCO_MODIFY_VOLUME_SHADE_HELP] = 
		(char *) malloc( strlen("oco_modify_volume_shade_help") + 1 );
	strcpy( help_file_name[C_OCO_MODIFY_VOLUME_SHADE_HELP], 
		"oco_modify_volume_shade_help" ); 
	
	help_file_name[C_OCO_MODIFY_VOLUME_TEXTURE_HELP] = 
		(char *) malloc( strlen("oco_modify_volume_texture_help") + 1 );
	strcpy( help_file_name[C_OCO_MODIFY_VOLUME_TEXTURE_HELP], 
		"oco_modify_volume_texture_help" ); 
	
	help_file_name[C_OCO_MODIFY_VOLUME_DATA_HELP] = 
		(char *) malloc( strlen("oco_modify_volume_data_help") + 1 );
	strcpy( help_file_name[C_OCO_MODIFY_VOLUME_DATA_HELP], 
		"oco_modify_volume_data_help" ); 
	
	help_file_name[C_OCO_MODIFY_LIGHT_HELP] = 
		(char *) malloc( strlen("oco_modify_light_help") + 1 );
	strcpy( help_file_name[C_OCO_MODIFY_LIGHT_HELP], 
		"oco_modify_light_help" ); 
	
	help_file_name[C_OCO_CREATE_GEO_HELP] = 
		(char *) malloc( strlen("oco_create_geo_help") + 1 );
	strcpy( help_file_name[C_OCO_CREATE_GEO_HELP], 
		"oco_create_geo_help" ); 
	
	help_file_name[C_OCO_CREATE_LIGHT_HELP] = 
		(char *) malloc( strlen("oco_create_light_help") + 1 );
	strcpy( help_file_name[C_OCO_CREATE_LIGHT_HELP], 
		"oco_create_light_help" ); 
	
	help_file_name[C_OCO_CREATE_HELP] = 
		(char *) malloc( strlen("oco_create_help") + 1 );
	strcpy( help_file_name[C_OCO_CREATE_HELP], 
		"oco_create_help" ); 
	
	help_file_name[C_OCO_CONTROL_HELP] = 
		(char *) malloc( strlen("oco_control_help") + 1 );
	strcpy( help_file_name[C_OCO_CONTROL_HELP], 
		"oco_control_help" ); 

	help_file_name[C_OCO_VOLUME_X_SLICES_HELP] = 
		(char *) malloc( strlen("oco_volume_x_slices_help") + 1 );
	strcpy( help_file_name[C_OCO_VOLUME_X_SLICES_HELP], 
		"oco_volume_x_slices_help" ); 

	help_file_name[C_OCO_VOLUME_Y_SLICES_HELP] = 
		(char *) malloc( strlen("oco_volume_y_slices_help") + 1 );
	strcpy( help_file_name[C_OCO_VOLUME_Y_SLICES_HELP], 
		"oco_volume_y_slices_help" ); 

	help_file_name[C_OCO_VOLUME_Z_SLICES_HELP] = 
		(char *) malloc( strlen("oco_volume_z_slices_help") + 1 );
	strcpy( help_file_name[C_OCO_VOLUME_Z_SLICES_HELP], 
		"oco_volume_z_slices_help" ); 

        help_file_name[C_IDE_PANEL_HELP] =
                (char *) malloc( strlen("ide_panel_help") + 1 );
        strcpy( help_file_name[C_IDE_PANEL_HELP],
                "ide_panel_help");

        help_file_name[C_IDE_RD_MOUSE_HELP] =
                (char *) malloc( strlen("ide_rd_mouse_help") + 1 );
        strcpy( help_file_name[C_IDE_RD_MOUSE_HELP],
                "ide_rd_mouse_help");

        help_file_name[C_IDE_RD_SPACEBALL_HELP] =
                (char *) malloc( strlen("ide_rd_spaceball_help") + 1 );
        strcpy( help_file_name[C_IDE_RD_SPACEBALL_HELP],
                "ide_rd_spaceball_help");

        help_file_name[C_IDE_RD_KEYBOARD_HELP] =
                (char *) malloc( strlen("ide_rd_keyboard_help") + 1 );
        strcpy( help_file_name[C_IDE_RD_KEYBOARD_HELP],
                "ide_rd_keyboard_help");

        help_file_name[C_IDE_RD_MAP_HELP] =
                (char *) malloc( strlen("ide_rd_map_help") + 1 );
        strcpy( help_file_name[C_IDE_RD_MAP_HELP],
                "ide_rd_map_help");

        help_file_name[C_IDE_VD_HELP] =
                (char *) malloc( strlen("ide_vd_help") + 1 );
        strcpy( help_file_name[C_IDE_VD_HELP],
                "ide_vd_help");

        help_file_name[C_IDE_CONFIGURATION_HELP] =
                (char *) malloc( strlen("ide_configuration_help") + 1 );
        strcpy( help_file_name[C_IDE_CONFIGURATION_HELP],
                "ide_configuration_help");

        help_file_name[C_IDE_SELECTION_HELP] =
                (char *) malloc( strlen("ide_selection_help") + 1 );
        strcpy( help_file_name[C_IDE_SELECTION_HELP],
                "ide_selection_help");
	
	help_file_name[C_IVI_HELP] = 
		(char *) malloc( strlen("ivi_help") + 1 );
	strcpy( help_file_name[C_IVI_HELP], 
		"ivi_help" ); 
	
	help_file_name[C_REN_HELP] = 
		(char *) malloc( strlen("ren_help") + 1 );
	strcpy( help_file_name[C_REN_HELP], 
		"ren_help" ); 
	
	help_file_name[C_REN_SETUP_HELP] = 
		(char *) malloc( strlen("ren_setup_help") + 1 );
	strcpy( help_file_name[C_REN_SETUP_HELP], 
		"ren_setup_help" ); 
	
	help_file_name[C_NAV_HELP] = 
		(char *) malloc( strlen("nav_help") + 1 );
	strcpy( help_file_name[C_NAV_HELP], 
		"nav_help" ); 
	
	help_file_name[C_NAV_MANUAL_HELP] = 
		(char *) malloc( strlen("nav_manual_help") + 1 );
	strcpy( help_file_name[C_NAV_MANUAL_HELP], 
		"nav_manual_help" ); 
	
	help_file_name[C_NAV_WIREFRAME_HELP] = 
		(char *) malloc( strlen("nav_wireframe_help") + 1 );
	strcpy( help_file_name[C_NAV_WIREFRAME_HELP], 
		"nav_wireframe_help" ); 
	
	help_file_name[C_NAV_PROJECTION_HELP] = 
		(char *) malloc( strlen("nav_projection_help") + 1 );
	strcpy( help_file_name[C_NAV_PROJECTION_HELP], 
		"nav_projection_help" ); 
	
	help_file_name[C_NAV_PROJECTION_OPTIONS_HELP] = 
		(char *) malloc( strlen("nav_projection_options_help") + 1 );
	strcpy( help_file_name[C_NAV_PROJECTION_OPTIONS_HELP], 
		"nav_projection_options_help" ); 
	
	help_file_name[C_ANI_HELP] = 
		(char *) malloc( strlen("ani_help") + 1 );
	strcpy( help_file_name[C_ANI_HELP], 
		"ani_help" ); 
	
	help_file_name[C_ANI_MANUAL_HELP] = 
		(char *) malloc( strlen("ani_manual_help") + 1 );
	strcpy( help_file_name[C_ANI_MANUAL_HELP], 
		"ani_manual_help" ); 
	
	help_file_name[C_ANI_FLIGHT_HELP] = 
		(char *) malloc( strlen("ani_flight_help") + 1 );
	strcpy( help_file_name[C_ANI_FLIGHT_HELP], 
		"ani_flight_help" ); 
	
	help_file_name[C_ANI_VIEW_HELP] = 
		(char *) malloc( strlen("ani_view_help") + 1 );
	strcpy( help_file_name[C_ANI_VIEW_HELP], 
		"ani_view_help" ); 
	
	help_file_name[C_MEA_HELP] = 
		(char *) malloc( strlen("mea_help") + 1 );
	strcpy( help_file_name[C_MEA_HELP], 
		"mea_help" ); 
	
	help_file_name[C_IDE_HELP] = 
		(char *) malloc( strlen("ide_help") + 1 );
	strcpy( help_file_name[C_IDE_HELP], 
		"ide_help" ); 
	
	help_file_name[C_MES_HELP] = 
		(char *) malloc( strlen("mes_help") + 1 );
	strcpy( help_file_name[C_MES_HELP], 
		"mes_help" ); 
	
	help_file_name[C_PRE_HELP] = 
		(char *) malloc( strlen("pre_help") + 1 );
	strcpy( help_file_name[C_PRE_HELP], 
		"pre_help" ); 
	
}

C_initialize_world( world )
C_World		*world;
{
	int	i;

	/* Set World Empty */
	world->num_lights	= 0;
	world->num_volumes	= 0;

	/* Initialize Volume Pointers */
	for( i=0; i<C_MAX_VOLUMES; i++ )
		world->volume[i] = NULL;

	for( i=0; i<C_MAX_LIGHTS; i++ )
		world->light[i]	 = NULL;

	/* Initialize World Coordinate System */
	C_Set_Orig( world->orig_c_sys, 0.0, 0.0, 0.0 );

	C_Set_Axes( world->orig_c_sys, 
		    1.0, 0.0, 0.0, 
		    0.0, 1.0, 0.0, 
		    0.0, 0.0, 1.0 );

	/* Initialize World Shading Model */
	world->world_shade.ambient_coef  = 0.1;
	C_Set_Color( world->world_shade.ambient_color, 255, 255, 255 );
	C_Set_Color( world->world_shade.bkgrnd_color, 0, 0, 0 );

	world->num_lights = 2;
	world->light[0] = C_New( C_Light );

	world->light[0]->light_type = C_POINT_LIGHT;
	world->light[0]->light.light_point = C_New( C_PointLight );

	world->light[0]->light.light_point->orig_light_pos.x = 50.0;
	world->light[0]->light.light_point->orig_light_pos.y = 50.0;
	world->light[0]->light.light_point->orig_light_pos.z = -150.0;

	world->light[0]->light.light_point->light_pos.x = 50.0;
	world->light[0]->light.light_point->light_pos.y = 50.0;
	world->light[0]->light.light_point->light_pos.z = -150.0;

	world->light[0]->light_name = (char *) malloc( 11 );
	strcpy( world->light[0]->light_name, "PointLight1" );

	world->light[0]->visible = TRUE;
	world->light[0]->modifiable = FALSE;

	C_identity3D( &(world->light[0]->light.light_point->transform) );

	world->light[0]->light.light_point->light_color.red = 250;
	world->light[0]->light.light_point->light_color.green = 250;
	world->light[0]->light.light_point->light_color.blue = 250;
	world->light[0]->light.light_point->light_intensity = 150.0;
	

	world->light[1] = C_New( C_Light );

	world->light[1]->light_type = C_POINT_LIGHT;
	world->light[1]->light.light_point = C_New( C_PointLight );

	world->light[1]->light.light_point->orig_light_pos.x = 50.0;
	world->light[1]->light.light_point->orig_light_pos.y = 50.0;
	world->light[1]->light.light_point->orig_light_pos.z = 150.0;

	world->light[1]->light.light_point->light_pos.x = 50.0;
	world->light[1]->light.light_point->light_pos.y = 50.0;
	world->light[1]->light.light_point->light_pos.z = 150.0;

	world->light[1]->light_name = (char *) malloc( 10 );
	strcpy( world->light[1]->light_name, "PointLight2" );

	world->light[1]->visible = TRUE;
	world->light[1]->modifiable = FALSE;

	C_identity3D( &(world->light[1]->light.light_point->transform) );

	world->light[1]->light.light_point->light_color.red = 250;
	world->light[1]->light.light_point->light_color.green = 250;
	world->light[1]->light.light_point->light_color.blue = 250;
	world->light[1]->light.light_point->light_intensity = 150.0;
}

C_initialize_view( view )
C_View		*view;
{
	/* Initial View Is Set To View A 256x256xZ Data Set */

	/* Initialize Original View Coordinate System */
	C_Set_Orig( view->orig_c_sys, 50.0, 50.0, -400.0 );
	C_Set_Axes( view->orig_c_sys, 
		    1.0, 0.0, 0.0, 
		    0.0, 1.0, 0.0, 
		    0.0, 0.0, 1.0 );

	/* Initialize Current View Coordinate System */
	C_Set_Orig( view->c_sys, 50.0, 50.0, -400.0 );
	C_Set_Axes( view->c_sys, 
		    1.0, 0.0, 0.0, 
		    0.0, 1.0, 0.0, 
		    0.0, 0.0, 1.0 );

	/* Initialize The Transform To Reflect Mapping From The	*/
	/* Original C.S. To The Current C.S.			*/
	C_identity3D( &(view->transform ) );

	/* Set The Field Of View. Initialize To Parallel Projection */
	view->fov = C_Deg_To_Rad( 60.0 );

	/* Initialize The Pixel Width & Height Of View */
	view->width_pixels	=	300;
	view->height_pixels	=       300;

	view->projection_type = C_RAY_TRACE;
	view->supersample_type = C_NO_SUPER_SAMPLE;
	view->display_during_projection = 50;
	view->shadows_enabled = FALSE;
	view->max_reflect_ray_level = 0;
	view->max_transmit_ray_level = 0;
	view->max_indirect_light_level = 0;
	view->image_accuracy = C_HIGH_IMAGE_ACCURACY;
	view->modifiable = FALSE;

	/* Set The Viewing Window Matrices */
	C_create_view_matrices( view );
}

void C_initialize_navigator( nav_info )
C_NavInfo	*nav_info;
{
	int				i;
	C_NavProjectionWinInfo		*pj_win_info;
	C_NavWireframeWinInfo		*wf_win_info;
	C_NavWireframeKeyWinInfo	*wf_key_win_info;
	C_NavProjectionOptionsInfo	*pj_opt_win_info;

	/* Initialize Pointers */
	pj_win_info 			= &(nav_info->pj_win_info);
	wf_win_info 			= &(nav_info->wf_win_info);
	wf_key_win_info			= &(nav_info->wf_key_win_info);
	pj_opt_win_info			= &(nav_info->pj_opt_win_info);

	/**********************************************/
	/* Initialize The Navigator Projection Window */
	/**********************************************/
	pj_win_info->drawing_area 	= NULL;
	pj_win_info->slider_frame 	= NULL;
	pj_win_info->button_frame 	= NULL;
	pj_win_info->velocity_slider	= NULL;

	pj_win_info->fildes 		= NULL;	/* For Starbase */

	pj_win_info->gc 		= NULL;	/* For X Graphics */

	pj_win_info->width_pixels	= view.width_pixels;
	pj_win_info->height_pixels	= view.height_pixels;

	pj_win_info->max_zbuf		= 0;
	pj_win_info->min_zbuf 		= 0;

	for( i=0; i<C_MAX_VOLUMES; i++ )
	{
	   pj_win_info->near_plane[i] 	= 0.0;
	   pj_win_info->far_plane[i]	= 0.0;
	   pj_win_info->zfront[i] 	= NULL;
	   pj_win_info->zback[i] 	= NULL;
	}

	/*********************************************/
	/* Initialize The Navigator Wireframe Window */
	/*********************************************/
	wf_win_info->drawing_area 	= NULL;

	wf_win_info->fildes 		= NULL;	/* For Starbase */

	wf_win_info->gc 		= NULL;	/* For X Graphics */

	C_initialize_view( &(wf_win_info->view) );

	wf_win_info->view.width_pixels	= 600;
	wf_win_info->view.height_pixels	= 300;

	C_create_view_matrices( &(wf_win_info->view) );

	C_rotate_view_world( &(wf_win_info->view), C_Y_AXIS, 
			     C_Deg_To_Rad(-20.0), &(world.orig_c_sys.origin) );

	wf_win_info->max_zbuf		= 0;

	/*************************************************/
	/* Initialize The Navigator Wireframe Key Window */
	/*************************************************/
	wf_key_win_info->drawing_area	= NULL;

	wf_key_win_info->fildes		= NULL; /* For Starbase */

	wf_key_win_info->gc		= NULL; /* For X Graphics */

	wf_key_win_info->max_zbuf	= 0;

	wf_key_win_info->width_pixels	= 600;
	wf_key_win_info->height_pixels	= 100;

	/******************************************************/
	/* Initialize The Navigator Projection Options Window */
	/******************************************************/
	for( i=0; i<C_MAX_VOLUMES; i++ )
	{
		pj_opt_win_info->vol[i]	= NULL;
	}
	pj_opt_win_info->pulldown	= NULL;
	pj_opt_win_info->sub_menu	= NULL;

	pj_opt_win_info->current_volume	= -1;
	pj_opt_win_info->previous_vol	= -1;
	pj_opt_win_info->current_side	=  0;
	pj_opt_win_info->num_volumes	=  0;

	/*************************************/
	/* Initialize Additional Information */
	/*************************************/
	nav_info->fly_speed 		= C_NAV_INIT_FLY_SPEED;
	nav_info->speed_step		= C_NAV_INIT_FLY_SPEED_STEP;
	nav_info->rotate_step		= C_NAV_INIT_FLY_ROTATE_STEP;
	nav_info->save_next_flight	= FALSE;
}

C_initialize_image_table( image_table )
C_ImageTable		*image_table;
{
	int	loop;
	C_Image *temp;
	int	fd;
	int	junk;

	/* Initialize the number of images in the table to 0	*/
	image_table->num_images = 0;

	/* Since there are no images, there is no active_image  */
	image_table->active_image = -1;

	image_table->colormap = NULL;

	for (loop = 0; loop < C_MAX_IMAGES; loop++)
		image_table->image_entry[loop] = NULL;
}


C_create_volume( volume_ptr_ptr, color_type, shade_type )
C_Volume	**volume_ptr_ptr;
C_ColorType	color_type;
C_ShadeType	shade_type;
{
	int		i;
	C_Volume	*tmp_volume;

	tmp_volume = C_New(C_Volume);
	if( tmp_volume == NULL )
	{
		C_error_message("Not Enough Memory To Create Volume\n");
		return( C_ERROR );
	}

	/* Initialize Original Volume Coordinate System */
	C_Set_Orig( tmp_volume->orig_c_sys, 0.0, 0.0, 0.0 );
	C_Set_Axes( tmp_volume->orig_c_sys,
			1.0, 0.0, 0.0,
			0.0, 1.0, 0.0,
			0.0, 0.0, 1.0 );

	/* Initialize Current Volume Coordinate System */
	C_Set_Orig( tmp_volume->c_sys, 0.0, 0.0, 0.0 );
	C_Set_Axes( tmp_volume->c_sys,
			1.0, 0.0, 0.0,
			0.0, 1.0, 0.0,
			0.0, 0.0, 1.0 );

	/* Initialize The Transform To Reflect Mapping From The	*/
	/* Original C.S. To The Current C.S.			*/
	C_identity3D( &(tmp_volume->transform) );

	tmp_volume->x_size_voxels	= 0;
	tmp_volume->y_size_voxels	= 0;
	tmp_volume->z_size_voxels	= 0;

	tmp_volume->x_size_units	= 0;
	tmp_volume->y_size_units	= 0;
	tmp_volume->z_size_units	= 0;

	tmp_volume->unit_type		= C_METER_UNIT;

	C_identity3D( &(tmp_volume->wtol_voxels) );
	C_identity3D( &(tmp_volume->ltow_voxels) );
	C_identity3D( &(tmp_volume->wtol_units) );
	C_identity3D( &(tmp_volume->ltow_units) );

	/* Clear Out Plane Equation Values */
	for( i=0; i<C_NUM_FACES; i++ )
	{
		(tmp_volume->plane_equation[i]).a = 0.0;
		(tmp_volume->plane_equation[i]).b = 0.0;
		(tmp_volume->plane_equation[i]).c = 0.0;
		(tmp_volume->plane_equation[i]).d = 0.0;
	}

	tmp_volume->data_type 		= C_SCALAR_DATA_8BIT;

	tmp_volume->data.scalar_data_8bit 	= NULL;


	tmp_volume->texture_type	= C_NO_TEXTURE;

	tmp_volume->color_type = color_type;
	tmp_volume->color_data.single_color = C_New( C_Color );

if ( world.num_volumes == 0 )
{ 
		tmp_volume->color_data.single_color->red   = 250;
		tmp_volume->color_data.single_color->green = 100;
		tmp_volume->color_data.single_color->blue  = 200;
}
else if ( world.num_volumes == 1 )
{
		tmp_volume->color_data.single_color->red   = 25;
		tmp_volume->color_data.single_color->green = 220;
		tmp_volume->color_data.single_color->blue  = 20;
}
else if ( world.num_volumes == 2 )
{
		tmp_volume->color_data.single_color->red   = 255;
		tmp_volume->color_data.single_color->green = 0;
		tmp_volume->color_data.single_color->blue  = 0;
}
else
{
		tmp_volume->color_data.single_color->red   = 255;
		tmp_volume->color_data.single_color->green = 0;
		tmp_volume->color_data.single_color->blue  = 255;
}
	tmp_volume->color_data.color_array = C_New( C_ColorArray );

	for( i=0; i<256; i++ )
	{
	    tmp_volume->color_data.color_array->color[i].red = i;
	    tmp_volume->color_data.color_array->color[i].green = 
		(i<128)?(i/2):(255 - i/2);
	    tmp_volume->color_data.color_array->color[i].blue = 255-i;
	}

	tmp_volume->shade_type = shade_type;
	tmp_volume->local_shade.simple_shade = C_New( C_SimpleShade );
	tmp_volume->local_shade.array_shade = C_New( C_ArrayShade );
					

if ( world.num_volumes == 0 )
{
	tmp_volume->local_shade.simple_shade->diffuse_coef   = 0.8;
	tmp_volume->local_shade.simple_shade->specular_coef  = 0.2;
	tmp_volume->local_shade.simple_shade->specular_power = 30.0;
	tmp_volume->local_shade.simple_shade->transmit_coef  = 0.0;
	tmp_volume->local_shade.simple_shade->transmissitivity = 1.0;
	tmp_volume->local_shade.simple_shade->index_of_refraction= 2.5;

	for (i = 0; i < C_BYTE_SIZE; i++)
	{
	   tmp_volume->local_shade.array_shade->diff_coef_array[i] = 0.8; 
	   tmp_volume->local_shade.array_shade->spec_coef_array[i] = 0.2;
	   tmp_volume->local_shade.array_shade->spec_pow_array[i]  = 30.0;
	   tmp_volume->local_shade.array_shade->tran_coef_array[i] = 0.0;
	   tmp_volume->local_shade.array_shade->ref_index_array[i] = 1.0;
	   tmp_volume->local_shade.array_shade->transmiss_array[i] = 2.5;
	}


}
else if ( world.num_volumes == 1 )
{
	tmp_volume->local_shade.simple_shade->diffuse_coef   = 1.0;
	tmp_volume->local_shade.simple_shade->specular_coef  = 0.0;
	tmp_volume->local_shade.simple_shade->specular_power = 30.0;
	tmp_volume->local_shade.simple_shade->transmit_coef  = 0.0;
	tmp_volume->local_shade.simple_shade->transmissitivity  = 1.0;
	tmp_volume->local_shade.simple_shade->index_of_refraction= 1.0;

	for ( i = 0; i < C_BYTE_SIZE; i++)
        {
           tmp_volume->local_shade.array_shade->diff_coef_array[i] = 1.0;
           tmp_volume->local_shade.array_shade->spec_coef_array[i] = 0.0;
           tmp_volume->local_shade.array_shade->spec_pow_array[i]  = 30.0;
           tmp_volume->local_shade.array_shade->tran_coef_array[i] = 0.0;
           tmp_volume->local_shade.array_shade->ref_index_array[i] = 1.0;
           tmp_volume->local_shade.array_shade->transmiss_array[i] = 1.0;
        }
	
}
else
{
	tmp_volume->local_shade.simple_shade->diffuse_coef   = 1.0;
	tmp_volume->local_shade.simple_shade->specular_coef  = 0.0;
	tmp_volume->local_shade.simple_shade->specular_power = 50.0;
	tmp_volume->local_shade.simple_shade->transmit_coef  = 0.0;
	tmp_volume->local_shade.simple_shade->transmissitivity  = 1.0;
	tmp_volume->local_shade.simple_shade->index_of_refraction= 1.03;
	
	for ( i = 0; i < C_BYTE_SIZE; i++)  
        {       
           tmp_volume->local_shade.array_shade->diff_coef_array[i] = 0.5;
           tmp_volume->local_shade.array_shade->spec_coef_array[i] = 0.5;
           tmp_volume->local_shade.array_shade->spec_pow_array[i]  = 50.0;
           tmp_volume->local_shade.array_shade->tran_coef_array[i] = 0.0;
           tmp_volume->local_shade.array_shade->ref_index_array[i] = 1.0;
           tmp_volume->local_shade.array_shade->transmiss_array[i] = 1.0;
        }       

}


	tmp_volume->visible	= TRUE;
	tmp_volume->modifiable	= TRUE;
	tmp_volume->volume_name = NULL;
	tmp_volume->file_name   = NULL;
	tmp_volume->icon_8bit	= NULL;
	tmp_volume->icon_24bit	= NULL;

	/* PARC Subdivision Data Has Not Been Created Yet */
	tmp_volume->p_info	= NULL;

	tmp_volume->num_cuts 	= 0;

	*volume_ptr_ptr = tmp_volume;


	return( C_OK );
}

