/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *			File: GL_nav_proj_geom.c
 *		      Author: 
 *			Date: 
 *		 Description: GL Drawing Routines For The Navigator 
 *			      Projection Drawing Areas - Displays
 *			      Volumes Of Type C_GEOMETRIC_DATA
 *	Modification History:
 *
 *		Who?		When?		Why?
 *	--------------------------------------------------------------------
 *
 */

#include <stdio.h>
#include <math.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/DrawingA.h>
#include <X11/Xirisw/GlxMDraw.h>
#include <gl/gl.h>
#include <gl/sphere.h>

#include "C_volvis.h"
#include "C_navigator.h"

extern	C_World		world;
extern	C_View		view;
extern	C_NavInfo	nav_info;


void nav_project_geo_volume( ed_info, volume )
C_ExtraDrawInfo	ed_info;
C_Volume	*volume;
{
	extern		C_transform_fposition();

	float		params[4];
	C_FPosition	pos, new_pos;
	C_GeoData	*geo_data;
	C_FPosition	*vptr;
	C_Polygon	*polygon;
	float		vert[3];
	int		loop;

	geo_data = volume->data.geo_data;

	switch ( geo_data->geo_type )
	{
	  case C_SPHERE:

		pos.x = volume->x_size_units / 2.0;
		pos.y = volume->y_size_units / 2.0;
		pos.z = volume->z_size_units / 2.0;

		C_transform_fposition( &pos, &new_pos, &(volume->ltow_units) );

		/* Specify The Center Of The Sphere */
		params[0] =  pos.x;
		params[1] =  pos.y;
		params[2] =  pos.z;

		/* Specify The Radius Of The Sphere */
		params[3] =  (volume->x_size_units * 1.1) / 2.0;

		sphdraw( params );

		break;

	  case C_POLYGON:
	
		polygon = geo_data->geo_object.polygon;
		vptr = polygon->vertices;

		bgnpolygon();
		
		for (loop = 0; loop < polygon->num_vertices; loop++ )
		{
			C_transform_fposition( vptr, &new_pos, 
				&(volume->ltow_voxels) );
			vert[0] = vptr->x * volume->x_size_units;
			vert[1] = vptr->y * volume->y_size_units;
			vert[2] = vptr->z * volume->z_size_units;
			v3f( vert );
			vptr++;
		}

		endpolygon();
			
		break;

	  default:
		printf("Can't project that type of geo data!!! %d \n",geo_data->geo_type );
	}

}

