/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *			File: MOTIF_oco_control.c
 *		      Author: Rick Avila
 *			Date: 03/07/92
 *		 Description: Motif Windowing Routines For 
 *				Object Control Settings
 *	Modification History:
 *
 *		Who?		When?		Why?
 *	--------------------------------------------------------------------
 *
 */

#include <stdio.h>
#include <string.h>
#include <strings.h>
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/BulletinB.h>
#include <Xm/LabelG.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>
#include <Xm/DrawingA.h>
#include <Xm/SeparatoG.h>
#include <Xm/Frame.h>

#include "C_volvis.h"
#include "MOTIF_windefs.h"
#include "C_help.h"
#include "C_oco.h"

/* Global Variables For Motif Windowing */
extern Widget		vv_toplevel;	/* VolVis toplevel Shell Widget */
extern C_WindowDefs	window_defs;

extern C_World		world;
extern C_View		view;

void	oco_volume_vis_CB();
void	oco_volume_mod_CB();
void	oco_light_vis_CB();
void	oco_light_mod_CB();
void	oco_view_mod_CB();

void oco_control_callback( w, client_data, call_data )
Widget          w;
XtPointer       client_data;
XtPointer       call_data;
{
	extern C_ObjectControlInfo	oco_info;
        void    create_oco_control_window();
	void	update_oco_control_window();

        /* Determine If The Object Control Bboard Dialog Should Be Created */
        if( !oco_info.control_window )
                create_oco_control_window();

        /* This Pops Up The Dialog - Use XtUnmanageChild To Pop Down! */
        XtManageChild( oco_info.control_window );

	update_oco_control_window();
}

void update_oco_control_window()
{
	extern C_ObjectControlInfo	oco_info;
	void 		create_oco_control_window();
	extern void     oco_control_create_view_frame();
	extern void	oco_control_create_volume_frame();
	extern void	oco_control_create_light_frame();
	extern void	oco_control_create_button_frame();

	if( oco_info.control_window )
	{
		XtDestroyWidget( oco_info.view_frame );
		XtDestroyWidget( oco_info.volume_frame );
		XtDestroyWidget( oco_info.light_frame );
		XtDestroyWidget( oco_info.button_frame );
		oco_control_create_view_frame();
		oco_control_create_volume_frame();
		oco_control_create_light_frame();
		oco_control_create_button_frame();
	}
}

void create_oco_control_window()
{
	extern C_ObjectControlInfo	oco_info;
	extern void			oco_control_create_frames();

	Arg		args[20];	/* Argument List */
	int		n;		/* Argument Count */
	int		i, j;
	int		xpos, ypos;	/* Pixel Position Of Toggle Widget */
	XmString	label_string;
	Widget		frame;		/* Frame To Hold Widgets */
	Widget		label;		/* Column Label Widget */
	Widget		toggle;		/* Toggle Button Widget */
	Widget		button;		/* Regular Button Widget */
	Widget		separator;	/* Separate Volumes & Lights */

	/* Create The Object Control Bulletin Board */
	n=0;
	XtSetArg( args[n], XmNx, 0 ); n++;
	XtSetArg( args[n], XmNy, 0 ); n++;
	XtSetArg( args[n], XmNautoUnmanage, False ); n++;
	C_Set_Color_Dialog( args, n, window_defs );
        label_string = XmStringCreate( "Object Control Settings", 
					XmSTRING_DEFAULT_CHARSET);
        XtSetArg( args[n], XmNdialogTitle, label_string ); n++;
	oco_info.control_window = XmCreateBulletinBoardDialog( vv_toplevel,
		       "Object Control Settings", args, n );

	/* Create The Visible Column Label */
	n=0;
	XtSetArg( args[n], XmNx, 150 ); n++;
	XtSetArg( args[n], XmNy, 10 ); n++;
	C_Set_Color_Label( args, n, window_defs );
	label = XmCreateLabel( oco_info.control_window, "Visible", args, n);
	XtManageChild( label );

	/* Create The Modifiable Column Label */
	n=0;
	XtSetArg( args[n], XmNx, 230 ); n++;
	XtSetArg( args[n], XmNy, 10 ); n++;
	C_Set_Color_Label( args, n, window_defs );
	label = XmCreateLabel( oco_info.control_window, "Modifiable", args, n);
	XtManageChild( label );

	XtManageChild( oco_info.control_window );

	/****************************************/
	/* Create The Internal Frames Of Window */
	/****************************************/
	oco_control_create_frames();

}

void oco_control_create_frames()
{
	extern void	oco_control_create_view_frame();
	extern void	oco_control_create_volume_frame();
	extern void	oco_control_create_light_frame();
	extern void	oco_control_create_button_frame();

	oco_control_create_view_frame();
	oco_control_create_volume_frame();
	oco_control_create_light_frame();
	oco_control_create_button_frame();
}

void oco_control_create_view_frame()
{
	int	n;
	Arg	args[20];
	Widget	frame;
	Widget	bboard;
	Widget	label;
	Widget	toggle;

	extern C_ObjectControlInfo	oco_info;

	/* Create The Frame For The VIEW */
	n=0;
	XtSetArg( args[n], XmNx, 0 ); n++;
	XtSetArg( args[n], XmNy, 40 ); n++;
	C_Set_Color_Frame( args, n, window_defs );
	frame = XmCreateFrame( oco_info.control_window, "frame", args, n );

	oco_info.view_frame = frame;

	n=0;
	C_Set_Color_Bboard( args, n, window_defs );
	bboard = XmCreateBulletinBoard( frame, "bboard", args, n );
	XtManageChild( bboard );

	/* Create The Label For The VIEW */
	n=0;
	XtSetArg( args[n], XmNx, 0 ); n++;
	XtSetArg( args[n], XmNy, 0 ); n++;
	C_Set_Color_Label( args, n, window_defs );
	label = XmCreateLabel(bboard, "VIEW", args, n);
	XtManageChild( label );

	/* Create The Toggle For Modifiability */
	n=0;
	XtSetArg( args[n], XmNx, 255 ); n++;
	XtSetArg( args[n], XmNy, 0 ); n++;
	C_Set_Color_ToggleGadget( args, n, window_defs );
	XtSetArg( args[n], XmNset, (view.modifiable) ); n++;
	toggle = XmCreateToggleButtonGadget( bboard, "", args, n );

	XtAddCallback( toggle, XmNvalueChangedCallback, 
				oco_view_mod_CB, NULL );

	XtManageChild( toggle );

	XtManageChild( frame );
}

void oco_control_create_volume_frame()
{
	int	n;
	Arg	args[20];
	int	j;
	int	xpos;
	int	ypos;
	Widget	label;
	Widget	frame;
	Widget	bboard;
	Widget	toggle;

	char	object_name[C_NAME_SIZE];

	extern C_ObjectControlInfo	oco_info;

	/* Create The Frame For The Volumes */
	n=0;
	XtSetArg( args[n], XmNx, 0 ); n++;
	XtSetArg( args[n], XmNy, 100 ); n++;
	C_Set_Color_Frame( args, n, window_defs );
	frame = XmCreateFrame( oco_info.control_window, "frame", args, n );

	oco_info.volume_frame = frame;

	n=0;
	C_Set_Color_Bboard( args, n, window_defs );
	bboard = XmCreateBulletinBoard( frame, "bboard", args, n );
	XtManageChild( bboard );

	ypos = 0;

	/* Create The Label For All VOLUMES */
	n=0;
	XtSetArg( args[n], XmNx, 0 ); n++;
	XtSetArg( args[n], XmNy, ypos ); n++;
	C_Set_Color_Label( args, n, window_defs );
	label = XmCreateLabel(bboard, "VOLUMES", args, n);
	XtManageChild( label );

	ypos += 30;

	for( j=0; j< world.num_volumes; j++ )
	{
		/* Get The Name Of The Volume */
		strcpy( object_name, (world.volume[j])->volume_name  );

		/* Create The Label For Row */
		n=0;
		XtSetArg( args[n], XmNx, 0 ); n++;
		XtSetArg( args[n], XmNy, ypos ); n++;
		C_Set_Color_Label( args, n, window_defs );
		label = XmCreateLabel(bboard, object_name, args, n);
		XtManageChild( label );

		/* Create Visible Toggle Button */
		xpos = 160;
		n=0;
		XtSetArg( args[n], XmNx, xpos ); n++;
		XtSetArg( args[n], XmNy, ypos ); n++;
		C_Set_Color_ToggleGadget( args, n, window_defs );
		XtSetArg( args[n], XmNset, (world.volume[j])->visible ); n++;
		toggle = XmCreateToggleButtonGadget( bboard, "", args, n );
		XtAddCallback( toggle, XmNvalueChangedCallback, 
					oco_volume_vis_CB, j );
		XtManageChild( toggle );

		/* Create Modifiable Toggle Button */
		xpos = 255;
		n=0;
		XtSetArg( args[n], XmNx, xpos ); n++;
		XtSetArg( args[n], XmNy, ypos ); n++;
		C_Set_Color_ToggleGadget( args, n, window_defs );
		XtSetArg( args[n], XmNset,(world.volume[j])->modifiable); n++;
		toggle = XmCreateToggleButtonGadget( bboard, "", args, n );
		XtAddCallback( toggle, XmNvalueChangedCallback, 
					oco_volume_mod_CB, j );
		XtManageChild( toggle );

		/* Move Down A Line */
		ypos += 30;
	}

	XtManageChild( frame );
}

void oco_control_create_light_frame()
{
	int	n;
	Arg	args[20];
	int	j;
	Position  yval;
	Dimension height;
	int	xpos;
	int	ypos;
	Widget	frame;
	Widget	bboard;
	Widget	label;
	Widget	toggle;

	char	object_name[C_NAME_SIZE];

	extern C_ObjectControlInfo	oco_info;

	/* Get Y Pos Height Of Widget Above */
	n=0;
	XtSetArg( args[n], XmNy, &yval ); n++;
	XtSetArg( args[n], XmNheight, &height ); n++;
	XtGetValues( oco_info.volume_frame, args, n );

	/* Create The Frame For The Lights */
	n=0;
	XtSetArg( args[n], XmNx, 0 ); n++;
	XtSetArg( args[n], XmNy, (int)yval + (int)height + 10 ); n++;
	C_Set_Color_Frame( args, n, window_defs );
	frame = XmCreateFrame( oco_info.control_window, "frame", args, n );

	oco_info.light_frame = frame;

	n=0;
	C_Set_Color_Bboard( args, n, window_defs );
	bboard = XmCreateBulletinBoard( frame, "bboard", args, n );
	XtManageChild( bboard );

	ypos = 0;

	/* Create The Label For All LIGHTS */
	n=0;
	XtSetArg( args[n], XmNx, 0 ); n++;
	XtSetArg( args[n], XmNy, ypos ); n++;
	C_Set_Color_Label( args, n, window_defs );
	label = XmCreateLabel(bboard, "LIGHTS", args, n);
	XtManageChild( label );

	ypos += 30;

	/* Show The Lights */
	for( j=0; j< world.num_lights; j++ )
	{
		/* Get The Name Of The Light */
		strcpy( object_name, (world.light[j])->light_name  );

		/* Create The Label For Row */
		n=0;
		XtSetArg( args[n], XmNx, 0 ); n++;
		XtSetArg( args[n], XmNy, ypos ); n++;
		C_Set_Color_Label( args, n, window_defs );
		label = XmCreateLabel(bboard, object_name, args, n);
		XtManageChild( label );

		/* Create Visible Toggle Button */
		xpos = 160;
		n=0;
		XtSetArg( args[n], XmNx, xpos ); n++;
		XtSetArg( args[n], XmNy, ypos ); n++;
		C_Set_Color_ToggleGadget( args, n, window_defs );
		XtSetArg( args[n], XmNset, (world.light[j])->visible ); n++;
		toggle = XmCreateToggleButtonGadget( bboard, "", args, n );
		XtAddCallback( toggle, XmNvalueChangedCallback, 
					oco_light_vis_CB, j );
		XtManageChild( toggle );

		/* Create Modifiable Toggle Button */
		xpos = 255;
		n=0;
		XtSetArg( args[n], XmNx, xpos ); n++;
		XtSetArg( args[n], XmNy, ypos ); n++;
		C_Set_Color_ToggleGadget( args, n, window_defs );
		XtSetArg( args[n], XmNset, (world.light[j])->modifiable ); n++;
		toggle = XmCreateToggleButtonGadget( bboard, "", args, n );
		XtAddCallback( toggle, XmNvalueChangedCallback, 
					oco_light_mod_CB, j );
		XtManageChild( toggle );

		/* Move Down A Line */
		ypos += 30;
	}

	XtManageChild( frame );
}

void oco_control_create_button_frame()
{
	int	n;
	Arg	args[20];
	int	j;
	int	xpos;
	int	ypos;
	Position  yval;
	Dimension height;
	int	height1;
	int	height2;
	Widget	frame;
	Widget	button;
	Widget	bboard;
	Widget	label;

	extern C_ObjectControlInfo	oco_info;
	extern void			close_callback();
	extern void			help_callback();

	/* Get Y Pos Height Of Widget Above */
	n=0;
	XtSetArg( args[n], XmNy, &yval ); n++;
	XtSetArg( args[n], XmNheight, &height ); n++;
	XtGetValues( oco_info.light_frame, args, n );

	/* Create The Frame For The Bottom Buttons */
	n=0;
	XtSetArg( args[n], XmNx, 0 ); n++;
	XtSetArg( args[n], XmNy, (int)yval + (int)height + 10 ); n++;
	C_Set_Color_Frame( args, n, window_defs );
	frame = XmCreateFrame( oco_info.control_window, "frame", args, n );

	oco_info.button_frame = frame;

	n=0;
	C_Set_Color_Bboard( args, n, window_defs );
	bboard = XmCreateBulletinBoard( frame, "bboard", args, n );
	XtManageChild( bboard );

	/***************************/
	/* Create The Close Button */
	/***************************/
        n=0;
        XtSetArg( args[n], XmNx, 10 ); n++;
        XtSetArg( args[n], XmNy, 0 ); n++;
        C_Set_Color_Button( args, n, window_defs );
        button = XtCreateManagedWidget( "Close",
                xmPushButtonWidgetClass, bboard, args, n );
        XtAddCallback( button, XmNactivateCallback,
                       close_callback, oco_info.control_window );

        /******************************/
        /*     Create The Help Button */
        /******************************/
        n=0;
        XtSetArg( args[n], XmNx, 110 ); n++;
        XtSetArg( args[n], XmNy, 0 ); n++;
        C_Set_Color_Button( args, n, window_defs );
        button = XtCreateManagedWidget( "Help",
                xmPushButtonWidgetClass, bboard, args, n );
        XtAddCallback( button, XmNactivateCallback,
                       help_callback, C_OCO_CONTROL_HELP );

	XtManageChild( frame );
}

/* Changes The Visibility Flag Of A Volume */
void oco_volume_vis_CB( w, client_data, call_data )
Widget				w;
int				client_data;
XmToggleButtonCallbackStruct	*call_data;
{
	extern void	C_update_system();

	world.volume[client_data]->visible = call_data->set;

	C_update_system( C_VOLUME_MODIFIED );
}

/* Changes The Modifiability Flag Of A Volume */
void oco_volume_mod_CB( w, client_data, call_data )
Widget				w;
int				client_data;
XmToggleButtonCallbackStruct	*call_data;
{
	extern void	C_update_system();

	world.volume[client_data]->modifiable = call_data->set;

	C_update_system( C_VOLUME_MODIFIED );
}

/* Changes The Visibility Flag Of A Light */
void oco_light_vis_CB( w, client_data, call_data )
Widget				w;
int				client_data;
XmToggleButtonCallbackStruct	*call_data;
{
	extern void	C_update_system();

	world.light[client_data]->visible = call_data->set;

	C_update_system( C_LIGHT_MODIFIED );
}

/* Changes The Modifiability Flag Of A Light */
void oco_light_mod_CB( w, client_data, call_data )
Widget				w;
int				client_data;
XmToggleButtonCallbackStruct	*call_data;
{
	extern void	C_update_system();

	world.light[client_data]->modifiable = call_data->set;

	C_update_system( C_LIGHT_MODIFIED );
}

/* Changes The Modifiability Flag Of The View */
void oco_view_mod_CB( w, client_data, call_data )
Widget				w;
int				client_data;
XmToggleButtonCallbackStruct	*call_data;
{
	extern void	C_update_system();

	view.modifiable = call_data->set;

	C_update_system( C_VIEW_MODIFIED );
}

