/****************************************************************************/
/*                                                                          */
/*  VolVis is a volume visualization system for investigating, manipulating */
/*  and rendering geometric and volumetric data.                            */
/*                                                                          */
/*  Copyright (C) 1993 by the Research Foundation of the State University   */
/*                            of New York                                   */
/*                                                                          */
/*  This program is free software; you can redistribute it and/or modify    */
/*  it under the terms of the GNU General Public License as published by    */
/*  the Free Software Foundation; either version 1, or (at your option)     */
/*  any later version.                                                      */
/*                                                                          */
/*  This program is distributed in the hope that it will be useful,         */
/*  but WITHOUT ANY WARRANTY; without even the implied warranty of          */
/*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           */
/*  GNU General Public License for more details.                            */
/*                                                                          */
/*  You should have received a copy of the GNU General Public License       */
/*  along with this program; if not, write to the Free Software             */
/*  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.               */
/*                                                                          */
/*  For information on VolVis, contact us at:                               */
/*                                                                          */
/*                volvis@cs.sunysb.edu                         (email)      */
/*                                                                          */
/*                Lisa Sobierajski & Ricardo Avila             (US Mail)    */
/*                Department of Computer Science                            */
/*                State University of New York at Stony Brook               */
/*                Stony Brook, New York  11794-4400                         */
/*                                                                          */
/****************************************************************************/




/*
 *			File: MOTIF_oco_ui.c
 *		      Author: Lisa Sobierajski 
 *			Date: 03/07/92
 *		 Description: Motif Windowing Routines Of The Object Properties 
 *	Modification History:
 *
 *		Who?		When?		Why?
 *	--------------------------------------------------------------------
 *
 */

#include <stdio.h>
#include <math.h>
#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <X11/StringDefs.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/BulletinB.h>
#include <Xm/LabelG.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/DrawingA.h>
#include <Xm/Frame.h>
#include <Xm/Scale.h>

#include "C_volvis.h"
#include "MOTIF_windefs.h"
#include "C_help.h"
#include "C_oco.h"

/* Global Variables For Motif Windowing */




void oco_create_volume_display( volume_index )
int			volume_index;
{
	extern void	close_callback();
	extern void	help_callback();

	extern Widget			vv_toplevel;
	extern C_WindowDefs		window_defs;
	extern C_World			world;
	extern C_ObjectControlInfo	oco_info;

	void		oco_update_volume_display();
	void		oco_accept_volume_properties();
	void		oco_reset_volume_properties();
	extern void	oco_data_prop_callback();
	extern void	oco_modify_volume_color_callback();
	extern void     oco_modify_volume_shade_callback();
	Arg		args[20];
	int		n;

	Widget		label;
	Widget		slider;
	Widget		frame;
	Widget		rowcolumn;
	Widget		bboard;
	Widget		button;
	XmString	label_string;
	char		size_string[16];
	OcoVolumeInfo	*vinfo;

	
	vinfo = oco_info.volume_info[volume_index] = 
			C_New( OcoVolumeInfo );

	vinfo->volume_displayed = NULL;
	vinfo->volume_text	= NULL;
	vinfo->volume_size_x	= NULL;
	vinfo->volume_size_y	= NULL;
	vinfo->volume_size_z	= NULL;

	vinfo->data.volume_data_displayed	= NULL;
	vinfo->data.seg_info			= NULL;
	vinfo->data.volume_x_slices		= NULL;
	vinfo->data.volume_y_slices		= NULL;
	vinfo->data.volume_z_slices		= NULL;

	vinfo->color.volume_color_displayed	= NULL;
	vinfo->color.single_color_frame		= NULL;

	vinfo->shade.volume_shade_change			= NULL;
	vinfo->shade.volume_sim_shade_diffuse_coef		= NULL;
	vinfo->shade.volume_sim_shade_specular_coef		= NULL;
	vinfo->shade.volume_sim_shade_specular_power		= NULL;
	vinfo->shade.volume_sim_shade_transmit_coef		= NULL;
	vinfo->shade.volume_sim_shade_transmissitivity		= NULL;
	vinfo->shade.volume_sim_shade_index_of_refraction	= NULL;


	n=0;
        XtSetArg( args[n], XmNautoUnmanage, False ); n++;
        C_Set_Color_Dialog( args, n, window_defs );
        vinfo->volume_displayed = XmCreateBulletinBoardDialog( 
			vv_toplevel,
                       	world.volume[volume_index]->volume_name, args, n );

	n = 0;
	XtSetArg( args[n], XmNx, 0 ); n++;
	XtSetArg( args[n], XmNy, 0 ); n++;
	C_Set_Color_Frame( args, n, window_defs );
	frame = XmCreateFrame( vinfo->volume_displayed, 
			"frame", args, n );
	XtManageChild( frame );

        n = 0;
	C_Set_Color_RowColumn( args, n, window_defs );
        bboard = 
		XmCreateBulletinBoard(frame, "bboard", args, n);
        XtManageChild (bboard);



	n=0;
	XtSetArg( args[n], XmNx, 0 ); n++;
	XtSetArg( args[n], XmNy, 0 ); n++;
	XtSetArg( args[n], XmNeditable, FALSE ); n++;
	XtSetArg( args[n], XmNeditMode, XmMULTI_LINE_EDIT ); n++;
	XtSetArg( args[n], XmNsensitive, FALSE ); n++;
	XtSetArg( args[n], XmNcursorPositionVisible, FALSE ); n++;
	XtSetArg( args[n], XmNrows, 12 ); n++;
	XtSetArg( args[n], XmNcolumns, 45 ); n++;
	C_Set_Color_Bboard( args, n, window_defs );

	vinfo->volume_text = XmCreateText(bboard,
			"Volume Text", args, n );

	XtManageChild( vinfo->volume_text );

        label_string = XmStringCreate("Data Size ( in units ):", 
			              XmSTRING_DEFAULT_CHARSET );
        n=0;
        XtSetArg( args[n], XmNx, 15 ); n++;
        XtSetArg( args[n], XmNy, 230); n++;
        XtSetArg( args[n], XmNlabelString, label_string ); n++;
        label = XmCreateLabelGadget( bboard, 
					     "Data Size", 
					     args, n );
        XtManageChild( label );
        XmStringFree( label_string );

        label_string = XmStringCreate("X Size:", 
			              XmSTRING_DEFAULT_CHARSET );
        n=0;
        XtSetArg( args[n], XmNx, 15 ); n++;
        XtSetArg( args[n], XmNy, 275); n++;
        XtSetArg( args[n], XmNlabelString, label_string ); n++;
        label = XmCreateLabelGadget( bboard, 
					     "X Size:", 
					     args, n );
        XtManageChild( label );
        XmStringFree( label_string );

        n=0;
        XtSetArg( args[n], XmNx, 80 ); n++;
        XtSetArg( args[n], XmNy, 265 ); n++;
        XtSetArg( args[n], XmNcolumns, 15 ); n++;
	sprintf( size_string, "%f", world.volume[volume_index]->x_size_units );
        XtSetArg( args[n], XmNvalue, size_string ); n++;
        C_Set_Color_Text( args, n, window_defs );
        vinfo->volume_size_x = XmCreateTextField( bboard, 
						"volume_size_x", args, n );
	XtManageChild(  vinfo->volume_size_x );


        label_string = XmStringCreate("Y Size:", 
			              XmSTRING_DEFAULT_CHARSET );
        n=0;
        XtSetArg( args[n], XmNx, 15 ); n++;
        XtSetArg( args[n], XmNy, 315); n++;
        XtSetArg( args[n], XmNlabelString, label_string ); n++;
        label = XmCreateLabelGadget( bboard, 
					     "Y Size:", 
					     args, n );
        XtManageChild( label );
        XmStringFree( label_string );

        n=0;
        XtSetArg( args[n], XmNx, 80 ); n++;
        XtSetArg( args[n], XmNy, 305 ); n++;
        XtSetArg( args[n], XmNcolumns, 15 ); n++;
	sprintf( size_string, "%f", world.volume[volume_index]->y_size_units );
        XtSetArg( args[n], XmNvalue, size_string ); n++;
        C_Set_Color_Text( args, n, window_defs );
        vinfo->volume_size_y = XmCreateTextField( bboard, 
						"volume_size_y", args, n );
	XtManageChild(  vinfo->volume_size_y );

        label_string = XmStringCreate("Z Size:", 
			              XmSTRING_DEFAULT_CHARSET );
        n=0;
        XtSetArg( args[n], XmNx, 15 ); n++;
        XtSetArg( args[n], XmNy, 350); n++;
        XtSetArg( args[n], XmNlabelString, label_string ); n++;
        label = XmCreateLabelGadget( bboard, 
					     "Z Size:", 
					     args, n );
        XtManageChild( label );
        XmStringFree( label_string );

        n=0;
        XtSetArg( args[n], XmNx, 80 ); n++;
        XtSetArg( args[n], XmNy, 340); n++;
        XtSetArg( args[n], XmNcolumns, 15 ); n++;
	sprintf( size_string, "%f", world.volume[volume_index]->z_size_units );
        XtSetArg( args[n], XmNvalue, size_string ); n++;
        C_Set_Color_Text( args, n, window_defs );
        vinfo->volume_size_z = XmCreateTextField( bboard, 
						"volume_size_z", args, n );
	XtManageChild(  vinfo->volume_size_z );

	n = 0;
	XtSetArg( args[n], XmNx, 0 ); n++;
	XtSetArg( args[n], XmNy, 470 ); n++;
	C_Set_Color_Frame( args, n, window_defs );
	frame = XmCreateFrame( vinfo->volume_displayed,
			"frame", args, n );
	XtManageChild( frame );

        n = 0;
	XtSetArg( args[n], XmNpacking, XmPACK_COLUMN ); n++;
	XtSetArg( args[n], XmNorientation, XmVERTICAL ); n++;
	XtSetArg( args[n], XmNnumColumns, 2 ); n++;
	C_Set_Color_RowColumn( args, n, window_defs );
        rowcolumn = 
		XmCreateRowColumn(frame, "rowcolumn", args, n);
        XtManageChild (rowcolumn);

	n = 0;
	C_Set_Color_Button( args, n, window_defs );
	button = XtCreateManagedWidget("Modify Volume Color", 
			xmPushButtonWidgetClass, rowcolumn, args, n );

	XtAddCallback( button, XmNactivateCallback,
                       oco_modify_volume_color_callback, volume_index);

	n = 0;
	C_Set_Color_Button( args, n, window_defs );
	button = XtCreateManagedWidget("Modify Volume Shading", 
			xmPushButtonWidgetClass, rowcolumn, args, n );

	XtAddCallback( button, XmNactivateCallback,
                       oco_modify_volume_shade_callback, volume_index);
	
	n=0;
	C_Set_Color_Button( args, n, window_defs );
	button = XtCreateManagedWidget( "Modify Volume Texture", 
		xmPushButtonWidgetClass, rowcolumn, args, n );

	n = 0;
	C_Set_Color_Button( args, n, window_defs );
	button = XtCreateManagedWidget("Modify Data Properties", 
			xmPushButtonWidgetClass, rowcolumn, args, n );

	XtAddCallback( button, XmNactivateCallback,
		       oco_data_prop_callback, volume_index);


	n = 0;
	XtSetArg( args[n], XmNx, 0 ); n++;
	XtSetArg( args[n], XmNy, 600 ); n++;
	C_Set_Color_Frame( args, n, window_defs );
	frame = XmCreateFrame( vinfo->volume_displayed,
			"frame", args, n );
	XtManageChild( frame );

	/********************************************************/		
	/*	Create a RowColumn for Close and Help		*/
	/********************************************************/		
        n = 0;
	XtSetArg( args[n], XmNorientation, XmHORIZONTAL ); n++;
	C_Set_Color_RowColumn( args, n, window_defs );
        rowcolumn = 
		XmCreateRowColumn(frame, "rowcolumn", args, n);
        XtManageChild (rowcolumn);

	n = 0;
	C_Set_Color_Button( args, n, window_defs );
	button = XtCreateManagedWidget("Accept", 
			xmPushButtonWidgetClass, rowcolumn, args, n );

	XtAddCallback( button, XmNactivateCallback, 
		       oco_accept_volume_properties, volume_index );
	
	n = 0;
	C_Set_Color_Button( args, n, window_defs );
	button = XtCreateManagedWidget("Cancel", 
			xmPushButtonWidgetClass, rowcolumn, args, n );

	XtAddCallback( button, XmNactivateCallback, 
		       oco_reset_volume_properties, volume_index );
	
	n=0;
	C_Set_Color_Button( args, n, window_defs );
	button = XtCreateManagedWidget( "Close", 
		xmPushButtonWidgetClass, rowcolumn, args, n );

	XtAddCallback( button, XmNactivateCallback,
		       close_callback, vinfo->volume_displayed);

	n = 0;
	C_Set_Color_Button( args, n, window_defs );
	button = XtCreateManagedWidget("Help", 
			xmPushButtonWidgetClass, rowcolumn, args, n );

	XtAddCallback( button, XmNactivateCallback,
		       help_callback, C_OCO_MODIFY_VOLUME_HELP );


	XtManageChild( vinfo->volume_displayed );

	oco_update_volume_display(volume_index);
}

void oco_update_volume_display(volume_index)
{
	extern C_World			world;
	extern C_ObjectControlInfo	oco_info;

	XmTextPosition	last;
	char		string[100];

	OcoVolumeInfo	*vinfo;

	vinfo = oco_info.volume_info[volume_index];

	if (!vinfo->volume_text) return;

	last = XmTextGetLastPosition( vinfo->volume_text );

	sprintf( string, "Coordinate System:\n\n" );

	XmTextInsert( vinfo->volume_text, last, string );	

	last = XmTextGetLastPosition( vinfo->volume_text );

	sprintf( string, "     Origin: (%3.2f, %3.2f, %3.2f)\n",
		world.volume[volume_index]->c_sys.origin.x,
		world.volume[volume_index]->c_sys.origin.y,
		world.volume[volume_index]->c_sys.origin.z );

	XmTextInsert( vinfo->volume_text, last, string );	

	last = XmTextGetLastPosition( vinfo->volume_text );

	sprintf( string, "     X Axis: (%3.2f, %3.2f, %3.2f)\n", 
		world.volume[volume_index]->c_sys.x_axis.x,
		world.volume[volume_index]->c_sys.x_axis.y,
		world.volume[volume_index]->c_sys.x_axis.z );

	XmTextInsert( vinfo->volume_text, last, string );	

	last = XmTextGetLastPosition( vinfo->volume_text );

	sprintf( string, "     Y Axis: (%3.2f, %3.2f, %3.2f)\n", 
		world.volume[volume_index]->c_sys.y_axis.x,
		world.volume[volume_index]->c_sys.y_axis.y,
		world.volume[volume_index]->c_sys.y_axis.z );

	XmTextInsert( vinfo->volume_text, last, string );	

	last = XmTextGetLastPosition( vinfo->volume_text );

	sprintf( string, "     Z Axis: (%3.2f, %3.2f, %3.2f)\n\n", 
		world.volume[volume_index]->c_sys.z_axis.x,
		world.volume[volume_index]->c_sys.z_axis.y,
		world.volume[volume_index]->c_sys.z_axis.z );

	XmTextInsert( vinfo->volume_text, last, string );	

	last = XmTextGetLastPosition( vinfo->volume_text );

	sprintf( string, "Data Size ( in voxels ):\n\n" );

	XmTextInsert( vinfo->volume_text, last, string );	

	last = XmTextGetLastPosition( vinfo->volume_text );

	sprintf( string, "     X Size: %d\n", 
		world.volume[volume_index]->x_size_voxels );

	XmTextInsert( vinfo->volume_text, last, string );	

	last = XmTextGetLastPosition( vinfo->volume_text );

	sprintf( string, "     Y Size: %d\n", 
		world.volume[volume_index]->y_size_voxels );

	XmTextInsert( vinfo->volume_text, last, string );	

	last = XmTextGetLastPosition( vinfo->volume_text );

	sprintf( string, "     Z Size: %d\n", 
		world.volume[volume_index]->z_size_voxels );

	XmTextInsert( vinfo->volume_text, last, string );	

}



void oco_accept_volume_properties( w, volume_index, call_data )
Widget			w;
int			volume_index;
XtPointer		call_data;
{
	extern C_World			world;
	extern C_ObjectControlInfo	oco_info;

	extern  C_create_volume_matrices();
	extern  C_create_plane_equations();
	extern  void C_update_system();
	
	char		*string;
	OcoVolumeInfo	*vinfo;

	vinfo = oco_info.volume_info[volume_index];

	string = (char *)XmTextGetString(vinfo->volume_size_x);
	world.volume[volume_index]->x_size_units = atof( string );

	string = (char *)XmTextGetString(vinfo->volume_size_y);
	world.volume[volume_index]->y_size_units = atof( string );

	string = (char *)XmTextGetString(vinfo->volume_size_z);
	world.volume[volume_index]->z_size_units = atof( string );

	C_create_volume_matrices( world.volume[volume_index] );
	C_create_plane_equations( world.volume[volume_index] );

	C_update_system( C_VOLUME_MODIFIED );
}

void oco_reset_volume_properties( w, volume_index, call_data )
Widget			w;
int			volume_index;
XtPointer		call_data;
{
	extern C_World			world;
	extern C_ObjectControlInfo	oco_info;

	Arg		args[1];
	char		string[100];
	OcoVolumeInfo	*vinfo;

	vinfo = oco_info.volume_info[volume_index];


	sprintf(string,"%f", world.volume[volume_index]->x_size_units);
	XtSetArg( args[0], XmNvalue, string );
	XtSetValues( vinfo->volume_size_x, args, 1 ); 

	sprintf(string,"%f", world.volume[volume_index]->y_size_units);
	XtSetArg( args[0], XmNvalue, string );
	XtSetValues( vinfo->volume_size_y, args, 1 ); 

	sprintf(string,"%f", world.volume[volume_index]->z_size_units);
	XtSetArg( args[0], XmNvalue, string );
	XtSetValues( vinfo->volume_size_z, args, 1 ); 

	printf("resetting properties\n");
}

