// -*- C++ -*-

//<copyright>
//
// Copyright (c) 1995
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>

//<file>
//
// Name:        remote.h
//
// Purpose:     interface to VRweb remote calls
//
// Created:      6 Dec 1995   Michael Pichler
//
// Changed:      7 Dec 1995   Michael Pichler
//
// $Id: remote.h,v 1.1 1995/12/20 14:20:23 mpichler Exp $
//
//</file>



#ifndef harmony_scene_remote_h
#define harmony_scene_remote_h

#include <IV-X11/xdisplay.h>
class EventRep;
class RString;


// program identification:

extern const char* const RemoteVersionProperty;  // e.g. "_PROGRAM_VERSION"
extern const char* const RemoteCommandProperty;  // e.g. "_PROGRAM_COMMAND"


// identification:

void remoteSetVersion (DisplayRep* d, WindowRep* w, const char* version);

// sets X-property RemoteVersionProperty for this program,
// in case version is NULL, RemoteVersionProperty is deleted;
// requires a bound window


// sender:

int remoteSendCommand (DisplayRep*, const char* command);

// sets X-property RemoteCommandProperty on a window with
// RemoteVersionProperty set;
// to be called before window mapping or identification;
// returns non-zero if successful


// receiver:

int remoteReceiveCommand (DisplayRep* d, WindowRep* w, const EventRep* e, RString& command);

// reads RemoteCommandProperty (usually called on property_notify)
// or nil if another property notify event arrived
// returns non-zero if successful and sets cmd string
// 0 otherwise (other property notify event)

#endif
