#
# core.spec,v 2.2 1992/08/11 00:22:27 pete Exp
#
class Simple = 
{
	superclass = Core;
	class_prefix = "o";
	class_name = Simple;
	public_pre_defines = "#ifndef _XO_XO_H_
#include <X11/Xo/Xo.h>
#endif
";
	public_post_defines = "#define XtRBackingStore \"BackingStore\"
";
	private_pre_defines = "#ifndef _XO_XOP_H_
#include <X11/Xo/XoP.h>
#endif
";
	private_post_defines = "#define XtInheritSet NULL";
	purpose = "This provides the base class for non-manager and
		  non-gadget widgets in this widget set.  In plainer
		  terms, most widgets in this widget set inherit
		  appearance and behaviour from this class.  It's
		  function is similar to that provided by \class{Core}
		  but is specific for this widget set.

		  The border gadget is sized to the same width and
		  height as this widget.  It is assumed that
		  \code{border\_width} space is used by to draw the
		  border.";
	# Define the names of the class and instance record
	class_record  simple =
	{
		field = ("", XtProc, "set", XtInheritSet,
			 "Called from Set() action", XtInheritSet);
		field = (static, "", "Core.initialize", "Initialize", "", "");
		field = (static, "", "Core.expose", "Redisplay", "", "");
		field = (static, "", "Core.realize", "Realize", "", "");
		field = (static, "", "Core.class_initialize", ClassInit,
			 "", "");
		field = (static, "", "Core.set_values", SetValues, "", "");
	}
	instance simple =
	{
		(WidgetClass, border_class, "Widget Class of border object",
		 borderClass, Class, ObjectClass, String, "\"None\"",
		 "Object class that implements drawing the border.")
		(Widget, border_widget, "draws the border",
		 "borderWidget", "BorderWidget", "Pointer", Immediate, NULL,
		 "This is the instance of the widget that draws the
		  border You have two choices, either set the
		  \res{WidgetClass} at initialization time or create
		  an object with this widget as it's parent and then
		  use \code{XtSetValues()} to set this resource.  The
		  old widget is destroyed.")
		(Pixel, fg, "foreground color",
		 foreground, Foreground,  Pixel, String, XtDefaultForeground,
		 "The color for drawing primary objects such as text
		  and lines.  Changing this during execution causes
		  the object to change color.")
		(Cursor, cursor, "cursor pattern",
		 cursor, Cursor, Cursor, String, "\"cross\"",
		 "The cursor to use when in this window.  There are
		  several ways to create cursors: font, bitmap or
		  glyph.  We should provide access to all three ways
		  in the converter.  Font is the easiest, although we
		  should provide a string to cursor name.

		  Cursor color should just be based on
		  \res{foreground} color, although we could certainly
		  add another resource but it hardly seems
		  necessary.")
		(int, backing_store, "backing store",
		 backingStore, BackingStore, BackingStore, String,
		 "\"NotUseful\"",
		 "Gives a hint to the server if it would be useful to
		  maintain a copy of this widget to allow faster
		  refreshes.  The cost is additional resources
		  consumed (which can add up to a great deal).  Most
		  widgets are simple enough that it is faster for the
		  widget to just redraw -- although there are plenty
		  exceptions especially when bandwidth and
		  transmission delays are included.  Possible values
		  are NotUseful, WhenMapped, Always.")
		(XtCallbackList, inherit_set, "to set inherited values",
		 inheritSet, InheritSet, Callback, Immediate, NULL,
		 "This list of callbacks is executed to allow gadgets
		  to update their instance variables when values in
		  the parent would change.  It allows gadgets to be
		  transparent to the application and user.  It can be
		  viewed as a way of a child adding additional
		  resources to the parent.

		  Internally, the function \code{\_xoInheritSet()}
		  implements this ability by getting the value of
		  \res{XtNinheritResources} and scanning the argument
		  list for corresponding values.  The new values are
		  collected and \code{XtSetValues()} executed on the
		  gadget.

		  Similar capabilities are provided by
		  \code{\_xoInheritInit()} which queries the resource
		  database pretending to be the parent widget.")
		(Boolean, traverse_accept, "if accept focus",
		 traverseAccept, TraverseAccept, Boolean, Immediate,
		 "(XtPointer) True",
		 "Indicates if this widget accepts the input
		  focus.  The core\-\_class\-.accept\_focus method should
		  examine this value to determine if it should even
		  try to accept keyboard input.  If it is false, it
		  should not.")
	}
}

class Label =
{
	superclass = Simple;
	class_prefix = "o";
	class_name = Label;
	purpose = "
This displays either text or a picture that is used to label other
fields.  It has no input behaviour.  It is drawn with minimal
decoration so as not to distract from other fields.

Much of the appearance of a \class{Label} widget is determined by the
object class set in \res{drawClass}.  A typical example is
\wswidgetclass{ObjText}.  You will need to refer to the resources of
that gadget to determine the possible variations.  For example,
\wswidgetclass{ObjText} defines \res{label} and \res{font} for
defining the text to display and how it should look.  One is free to
choose other gadgets such as a \wswidgetclass{Checkmark} or
\wswidgetclass{ObjPixmap} to implement entirely different drawing
characterstics.

The preferred size of the \class{Label} widget is set to the size of the
\res{drawClass} widget plus the space used by the borderClass widget.
In other words:
$$
width = draw\_widget's width + 2 * border\_widget's border\_width
$$
and the preferred height:
$$
height = draw\_widget's height + 2 * border\_widget's border\_width
$$

The size of the \res{drawWidget} is never changed.  The size of the
\res{borderWidget} is kept the same size as the \class{Label} widget.
";

	# Define the names of the class and instance record
	class_record  label =
	{
		field = ("", XtProc, "set2", XtInheritSet,
			 "Called from bogus() action", XtInheritSet);
		field = (static, "", "Core.expose", Redisplay, "", "");
		field = (static, "", "Core.initialize", Initialize, "", "");
		field = (static, "", "Core.class_initialize",
			 ClassInit, "", "");
		field = (static, "", "Core.resize", Resize, "", "");
		field = (static, "", "Core.set_values", SetValues, "", "");
		field = (static, "", "Core.query_geometry",
			 GeometryQuery, "", "");
		field = (static, "", "Core.class_part_initialize",
			 ClassPartInitialize, "", "");
	}
	instance label =
	{
		("", "Core.border_width", "",
		 "", "", "", "Immediate", "0", "")
		(Boolean, resize_draw, "if resize draw widget",
		 resizeDraw, ResizeDraw, Boolean, Immediate, False,
		 "If true, then the drawing widget is resized to be
		  the same as the label widget.  Otherwise, it is kept
		  at whatever the QueryGeometry returns.")
		(XoGravity, gravity, "how to place the label",
		 gravity, Gravity, Gravity, String, "\"Center\"",
		 "Gravity controls the placement of the object within
		  the widget.  Values are specified in points of the
		  compass with North being up \footnote{my apologies
		  to those from down under} and West to the left.
		  Possible values are (moving clockwise) North,
		  NorthEast, East, SouthEast, South, SouthWest, West,
		  NorthWest and Center.  Center gives the intuitive
		  result although may not always be what is desired.

		  To make text that is flush to the right side of the
		  widget, set \res{justify} to right and \res{gravity}
		  to West.")
		(WidgetClass, draw_class, "Widget class that draws",
		 drawClass, Class, ObjectClass, String, "\"ObjText\"",
		 "The class of the object that implements drawing the
		  the label.  The label widget creates one of these
		  objects The width and the height are used to place
		  the object according to the value of
		  \res{gravity}.")
		(Widget, draw_widget, "Widget for drawing text.",
		 "drawWidget", "DrawWidget", "Pointer", Immediate, NULL,
		 "This is the instance of the widget that actually
		  does the drawing.  You have two choices, either set
		  the \res{WidgetClass} at initialization time or
		  create an object with this widget as it's parent and
		  then use \code{XtSetValues()} to set this resource.
		  The old widget is destroyed.")
		(WidgetClass, flag_class, "indicates current state",
		 flagClass, Class, ObjectClass, Immediate, NULL,
		 "The class of the object that indicates current state
		  of the label.  The label widget creates one of these
		  objects and sets flag_widget.  The width and the
		  height are used to place the object according to the value of
		  \res{flagGravity}.")
		(Widget, flag_widget, "Widget for current state.",
		 "flagWidget", "FlagWidget", "Pointer", Immediate, NULL,
		 "This is the instance of the widget that actually
		  indicates the state.  You have two choices, either set
		  the \res{flagClass} at initialization time or
		  create an object with this widget as it's parent and
		  then use \code{XtSetValues()} to set this resource.
		  The old widget is destroyed.")
		(XoJustify, flag_justify, "how to place the flag",
		 flagJustify, Justify, Justify, String, "\"Right\"",
		 "flagJustify controls where the flag widget is placed
		  within the label.")
	}
}

class Button =
{
	superclass = Label;
	class_prefix = "o";
	class_name = Button;
	purpose = "This allows the user to click a button.  A 3d
		   border is provided to make the widget look like a
		   button that one pushes.

		   Note that all the appearance is inherited from
		   \wswidgetclass{Label} except \res{borderClass} is
		   set to ``ObjBorder'' by default.";

	# Define the names of the class and instance record
	class_record  button =
	{
		field = ("", XtProc, "set2", XtInheritSet,
			 "Called from bogus() action", XtInheritSet);
		field = (static, "", "Core.class_initialize", ClassInit,
			 "", "");
		field = (static, "", "Core.initialize", Initialize, "", "");
		field = (static, "", "Core.set_values", SetValues, "", "");
		field = ("", "", "Core.tm_table", "translations", "", "");
		field = ("", extern, "Core.accept_focus", XoFocusAccept, "", "");
	}
	instance button =
	{
		("", "Core.border_width", "",
		 "", "", "", "Immediate", "0", "")
		("", "Simple.border_class", "",
		 "", "", "", "String", "\"DefaultBorder\"", "")
		(XtCallbackList, callbacks, "executed when activated",
		 callback, Callback, Callback, Immediate, NULL,
		 "A list of functions to call when the button is
		  activated.  \code{call\_data} is set to \res{set} to
		  indicate it is activated (this is done for
		  compatibility with toggles and radiobuttons).")
		(int, repeat_interval, "milli. sec. between executions",
		 repeatInterval, RepeatInterval, Int, Immediate,
		 "(XtPointer) 100",
		 "Number of milliseconds between each execution of the
		  activate list.  This takes effect after
		  \res{repeatDelay} milliseconds and the first action
		  is executed.")
		(int, repeat_delay, "ms delay before executions",
		 repeatDelay, RepeatDelay, Int, Immediate,
		 "(XtPointer) 300",
		 "Number of milliseconds to delay between each
		  repeat action.  When the button is initially set
		  (activated) a timer is started.  If the button has
		  not been unset when this timer expires, the
		  \res{callbacks} are executed.  If this timer fires
		  then the normal action that activates the callback
		  is ignored (typically the button up).  After the
		  initialy delay, \res{repeatInterval} is used to
		  install the next timer event.  These two values
		  allow an initial delay before starting the action
		  which allows the user a chance to not start the
		  repeating action but still have fast enough response
		  once it starts.  Setting this to a large number
		  effectively eliminates the repeating.")
		(int, set, "current state of the button",
		 "", "", "", "", "",
		 "This private instance variable indicates the current
		  state of the widget.  Typicall 0 indicates it is off
		  and 1 indicates it is on.")
		(XtIntervalId, timer_id, "current timer for repeating",
		 "", "", "", "", "",
		 "This private instance variable contains the timer id
		  used when starting the repeat action.  When the user
		  unsets the button, this timeout should be removed.")
		(Boolean, timer_ran, "indicates if a timer was actived",
		 "", "", "", "", "",
		 "This private instance variable indicates if a timer
		  was executed.  It should be cleared when the initial
		  timer interval is installed and set when the first
		  timer executes.  The normal notify action should not
		  execute if this is set.  {\it Actually, it might be
		  nice if the timer callback used the intrinsics to
		  execute the notify action, this way subclasses could
		  override the action and the appropriate functions
		  would still get called.  If that's the case, we
		  should use some other convention such as a NULL
		  event or a certain argument passed to the notify
		  action.\/}")
		(Boolean, temp, "temporary holder for set",
		 "", "", "", "", "",
		 "When the pointer temporarily leaves the window (i.e.
		  it is initially pressed but the mouse moves out of
		  the window), this is used to save the current state
		  of the \code{set} flag.")
	}
	actions =
	{
		(Set, Set,
		 "Indicates the button is currently selected.  When a
		  button is set, the background and foreground should
		  be reversed.")
		(Unset, Unset,
		 "Indicates the button is no longer selected.  This
		  should cause the background and foreground to be
		  displayed normally.")

		(UnsetTemp, UnsetTemp,
		 "Sets unset\_temp if set is already True.  Should
		  cause the display to go back to the normal
		  foreground and background.  This allows the mouse to
		  leave the window when it is depressed.")
		(SetTemp, SetTemp,
		 "If unset\_temp is true, sets set = True.  This allows
		  the mouse to reenter the window when the button is down.")
		(Notify, Notify,
		 "Calls the XtNcallCallbacks if button is set.  Passes
		  the set flag as the call\_data.")
		(Highlight, Highlight,
		 "Indicates focus is in this window.  This should draw
		  the 3d border so it looks like the button has been pushed.")
		(Unhighlight, Unhighlight,
		 "Indicates focus is not in window.  This is done by
		  drawing the 3d border it its normal condition to
		  indicate the button protrudes.")
		(RepeatStart, RepeatStart,
		 "Set up timer for repeating.")
		(RepeatEnd, RepeatEnd,
		 "Cancel the timer for repeating.")
		(KeyIgnore, KeyIgnore,
		 "Skip keyboard events.")
		(KeyAccept, KeyAccept,
		 "Keyboard events are ok.")
		(ClipStart, ClipStart,
		 "Starts making selection at current location")
		(ClipEnd, ClipEnd,
		 "Indicates the end of the selection point")
		(ClipStuff, ClipStuff,
		 "Asserts ownership of the current cut buffer.  Name
		  of the cut buffer can be specified.  The current
		  value can be returned either as a String or Pixmap.
		  If displaying a pixmap, that is the only
		  possibility.  Allow a parameter to indicate if the
		  entire item should be selected.  This is for a
		  ``quick'' cut.")
		(ClipGet, ClipGet,
		 "Insert current selection from the specified cut
		  buffer.  If displaying text, requests it as a
		  string.  If displaying as a pixmap, requests it in
		  that form.")
		(ItemNext, ItemNext,
		 "Tells parent to move the location cursor to the next
		  item.  ``Next'' is defined by the parent.  A simple
		  implementationn would treat the next item as the
		  next managed child.  A more involved implementation
		  (and far better) should move the location cursor in
		  a left to right, top to bottom manner.  When the
		  location is at the end of the group, the parent
		  should ask to move the focus to it's (this widgets
		  grandparent) to the next field.

		  (This, and the other traversals, should either use a
		  callback list on the parent or use a XtGetValues()
		  to get the function pointer to dereference.  The
		  traversals should not rely on the parent being a
		  certain class.)")
		(ItemPrev, ItemPrev,
		 "Tells parent to move the location cursor to the
		  previous item.  ``Previous'' is defined by the
		  parent.  A simple implementationn would treat the
		  previous item as the prior managed child.  A more
		  involved implementation (and far better) should move
		  the location cursor in a right to left, bottom to
		  top manner.  When the location is at the end of the
		  group, the parent should ask to move the focus to
		  it's (this widgets grandparent) to the previous
		  widget.")
		(ItemUp, ItemUp,
		 "Tells parent to move the location cursor up an item.
		  ``Up'' is defined by the parent.  Behaves the same
		  as ItemNext except it does wraps around to the last
		  child of the parent when the first child is
		  reached.")
		(ItemDown, ItemDown,
		 "Tells the parent to move the location cursor down an
		  item.  ``Down'' is defined by the parent.  Behaves
		  the same as ItemNext except it does wraps around to
		  the first child of the parent when the last child is
		  reached.")
		(LineEnd, LineEnd,
		 "Tells the parent to move the location cursor to the
rightmost edge.  The rightmost edge is defined by the parent.")
		(LineBegin, LineBegin,
		 "Tells the parent to move the location cursor to the
		  leftmost edge.  The leftmost edge is defined by the parent.")
		(DataBegin, DataBegin,
		 "Tells the parent to move the location cursor to the
		  first item.  ``First'' is determined by the parent.")
		(DataEnd, DataEnd,
		 "Tells the parent to move the locatin cursor to the
		  last item.  \"Last\" is determined by the parent.")
		(GrabFocus, GrabFocus,
		 "Changes the keyboard focus to this widget, but only
		  if traverseAccept resource is True.")
	}
	translations =
	{
		("<FocusIn>", "Highlight()",
		 "Provides a visual feedback that the current input
		  focus is set to this widget.  The usual visual
		  feedback is to place a black border around the
		  widget.")
		("<FocusOut>", "Unhighlight()",
		 "Should undo the visual effects from Highlight().")
		("<Leave>", "UnsetTemp()", "")
		("<Enter>", "SetTemp()", "")
		("<Btn1Down>", "GrabFocus() Highlight() Set() RepeatStart() KeyIgnore()",
		 "")
		("<Btn1Up>", "Notify() Unset() RepeatEnd() KeyAccept()", "")
		("<Key>Return", "Set() Notify() Unset()", "")
		("!<Key>Tab", "ItemNext()", "")
		("!Ctrl<Key>Tab", "ItemNext()", "")
		("!Shift<Key>Tab", "ItemPrev()", "")
		("!Shift Ctrl <Key>Tab", "ItemPrev()", "")
		("!<Key>Up", "ItemUp()", "")
		("!<Key>Left", "ItemUp()", "")
		("!<Key>Down", "ItemDown()", "")
		("!<Key>Right", "ItemDown()", "")
		("!<Key>Home", "LineBegin()", "")
		("!<Key>Begin", "LineBegin()", "")
		("!<Key>End", "LineEnd()", "")
		("!Ctrl<Key>Home", "DataBegin()", "")
		("!Ctrl<Key>Begin", "DataBegin()", "")
		("!Ctrl<Key>End", "DataEnd()", "")
	}
}
class Grip =
{
	superclass = Button;
	class_prefix = "o";
	class_name = Grip;
	purpose = "Implements a small region the user can ``grip''
		   with the mouse to change the size of a window.
		   This is intended to be used by other widgets, such
		   as \wswidgetclass{Vpane}.

		   The \wswidgetclass{Grip} executes the
		   \res{moveCallback} callback list as the mouse moves
		   with the left mouse button pressed.  It passes as
		   data the initial x and y coordinates and the
		   current x and y coordinates both expressed relative
		   to the the parent of the grip.";
	public_pre_defines = "
/*
 * Passed as the call_data to the moveCallback.  Note that all
 * the positions are relative to the parent.  Then event contains
 * the original event.
 */

typedef struct _XoMoveCBdata
{
	XEvent		*mcbd_event;	/* original, unmodified event */
	Position	mcbd_x_first;	/* movement started, parent relative */
	Position	mcbd_y_first;
	Position	mcbd_x;		/* current position, parent relative */
	Position	mcbd_y;
} XoMoveCBdata;
";

	# Define the names of the class and instance record
	class_record  grip =
	{
		field = (static, "", "Core.initialize", Initialize, "", "");
		field = (static, "", "Core.class_initialize", ClassInit,
			 "", "");
		field = (static, "", "Core.expose", Redisplay, "", "");
		field = ("", "", "Core.tm_table", "translations", "", "");
		field = ("", extern, "Core.accept_focus", XoFocusAccept,
			 "", "");
	}
	instance grip =
	{
		("", "Core.border_width", "",
		 "", "", "", "Immediate", "0", "")
		("", "Core.width", "",
		 "", "", "", "Immediate", "(XtPointer) 10", "")
		("", "Core.height", "",
		 "", "", "", "Immediate", "(XtPointer) 10", "")
		("", "Simple.border_class", "",
		 "", "", "", "String", "\"DefaultBorder\"", "")
		(Position, "x_first", "movement started here",
		"", "", "", "", "",
		"The initial position movement started from.  This is
		 relative to the parent widget.  Should be initialized
		 by the Set action on a button down.  Passed in an
		 XoMoveCBdata structure for the moveCallback.")
		(Position, "y_first", "movement started here",
		"", "", "", "", "",
		"The initial position movement started from.  This is
		 relative to the parent widget.  Should be initialized
		 by the Set action on a button down.  Passed in an
		 XoMoveCBdata structure for the moveCallback.")
		(XtCallbackList, callbacks, "executed when activated",
		 callback, Callback, Callback, Immediate, NULL,
		 "A list of function to executed when the mouse moves
		  with a button down.  The \code{call\_data} is
		  packaged as follows:

		  \begin{verbatim}

		  \end{verbatim}
")
		(XtCallbackList, "move_callbacks", "executed when activated",
		 moveCallback, MoveCallback, Callback, Immediate, NULL,
		 "A list of function to executed when the mouse moves
		  with a button down.  The \code{call\_data} is
		  packaged as follows:

		  \begin{verbatim}

		  \end{verbatim}
")
	}
	actions =
	{
		(Set, Set,
		 "Initializes the starting position as used in MoveNotify.")
		(Unset, Unset,
		 "Indicates the button is no longer selected.  This
		  should cause the background and foreground to be
		  displayed normally.")
		(Notify, Notify,
		 "Calls the XtNcallCallbacks to indicate no more
		  motion events are going to happen.")
		(MoveNotify, MoveNotify,
		 "Executes the \res{moveCallback} and passes the
		  starting position as determined in \code{Set} and
		  the current position -- both are parent relative.
		  Uses the XoMoveCBdata structure as the call\_data
		  part of the callback.")
	}
	translations =
	{
		("<Btn1Down>", "Highlight() Set()", "")
		("<Btn1Motion>", "MoveNotify()", "")
		("<Btn1Up>", "Notify() Unset()", "")
		("<FocusIn>", "Highlight()",
		 "Provides a visual feedback that the current input
		  focus is set to this widget.  The usual visual
		  feedback is to place a black border around the
		  widget.")
		("<FocusOut>", "Unhighlight()",
		 "Should undo the visual effects from Highlight().")
		("<Leave>", "UnsetTemp()", "")
		("<Enter>", "SetTemp()", "")
		("<Key>Return", "Set() Notify() Unset()", "")
		("!<Key>Tab", "ItemNext()", "")
		("!Ctrl<Key>Tab", "ItemNext()", "")
		("!Shift<Key>Tab", "ItemPrev()", "")
		("!Shift Ctrl <Key>Tab", "ItemPrev()", "")
		("!<Key>Up", "ItemUp()", "")
		("!<Key>Left", "ItemUp()", "")
		("!<Key>Down", "ItemDown()", "")
		("!<Key>Right", "ItemDown()", "")
		("!<Key>Home", "LineBegin()", "")
		("!<Key>Begin", "LineBegin()", "")
		("!<Key>End", "LineEnd()", "")
		("!Ctrl<Key>Home", "DataBegin()", "")
		("!Ctrl<Key>Begin", "DataBegin()", "")
		("!Ctrl<Key>End", "DataEnd()", "")
	}
}

class MenuButton =
{
	superclass = Button;
	class_prefix = "o";
	class_name = MenuButton;
	purpose = "Should be used in a menu to allow an action to be executed.
		   Understands about hierarchical menus.";
	class_record menu_button =
	{
		field = ("", "", "Core.tm_table", "translations", "", "");
		field = (static, "", "Core.class_initialize", ClassInit,
			 "", "");
		field = (static, "", "Core.initialize", Initialize, "", "");
		field = (static, "", "Core.set_values", SetValues, "", "");
		field = ("", "int", filler, "0", "keep compiler happy", "0");
	}
	instance menu_button =
	{
		("", "Simple.backing_store", "",
		 "", "", "", "String", "\"Always\"", "")
		("", "Label.flag_class", "",
		 "", "", "", "String", "\"ObjArrow\"", "")
		(XoPointing, "direction", "which way arrow points",
		 "direction", "Direction", Pointing, String, "\"Right\"",
		 "Which way the arrow points to indicate a submenu.")
		(int, move_delta, "delta for popups",
		 moveDelta, Delta, Int, Immediate, "(caddr_t) 5",
		 "The amount of horizontal pointer motion necessary before
		  displaying any associated walking menu.")
		(Widget, submenu, "submenu to popup",
		 subMenu, SubMenu, Widget, Immediate, "(caddr_t) NULL",
		 "A menu widget to implement a submenu off of this
		  widgets.  The parent of this widget should be a
		  subclass Shell.  When the WalkMenu action executes,
		  it calls the newPopup callbacks on this submenu
		  widget.")
		(Position, start_x, "initial x location",
		"", "", "", "", "",
		"The initial x coordinate for determining when any submenu
		 should be displayed.  This is set when the widget
		  receieves the focus.")
		(Boolean, draw_border, "if draw the border",
		"", "", "", "", "",
		"Set by Highlight() and cleared by Unhighlight().  Tells
		 the expose procedure if the border should be drawn.")
	}
	actions =
	{
		(WalkMenu, WalkMenu,
		 "Popup the one and only popup child of this widget.
		  The widget is popped up spring loaded.  It is an
		  error if there is more than one popup child.  If
		  there are no popup children, this is a no-op.

		  The horizontal motion must be $>= move\_delta$
		  before the walking menu is moved up.  Setting
		  \res{moveDelta} to $0$ causes the menu to be popped
		  up as soon as mouse moves in the widget.

		  If the value of \res{moveDelta} is negative, the
		  pointer must move to the left by that amount.  If
		  \res{moveDelta} is positive, the pointer must move
		  right by that amount.")
		(Highlight, Highlight,
		 "If this widget does not have a submenu or it has a
		  submenu which is not popped up, then it executes the
		  \res{newPopup} callback of the parent with the
		  \code{call\_data} set to \code{NULL}.  This causes
		  the parent to popdown any currently displayed menu
		  but only if that menu is from another
		  \class{menuButton}.

		  The \code{x} coordinate of the event is then used to
		  determine when the user has moved enough to activate
		  the menu.  See \res{moveDelta} for the amount and
		  the \code{WalkMenu()} action that implements this.

		  The \res{draw\_border} flag is set to true and the
		  widget is redrawn.  This should cause a the border
		  to become active and instead of being drawn flat, a
		  raised appearance (assuming a 3d border object is
		  used) should be used for the borders.")
		(Notify, Notify,
		 "If this widget has a submenu, it executes the
		  \res{newPopup} callback of the parent with the
		  \code{call\_data} set to NULL.  This should popdown
		  any submenus currently displayed.

		  It then executes the \res{callback} callbacks with
		  the \code{call\_data} set to \code{True}.

		  Note that it is possible to execute MenuButtons that
		  have submenus.  This should probably be an optional
		  feature.")
		(Unhighlight, Unhighlight,
		 "Sets the \code{draw\_border} flag to \code{False}
		  and and causes the widget to redisplay itself.  The
		  widget should then have a ``flat'' apperance to
		  indicate it is inactive")
		(ItemNext, ItemNext,
		 "If this menubutton has a submenu, pop that menu up.  If
		  there is not a submenu, then remain here.")
		(ItemPrev, ItemPrev,
		 "If this menubutton has a submenu, pop that menu up.  If
		  there is not a submenu, then remain here.")
	}
	translations =
	{
		("<FocusIn>", "Set() Highlight()",
		 "Provides a visual feedback that the current input
		  focus is set to this widget.  If there are any other
		  submenus displayed, they should be popped down at
		  this point.")
		("<FocusOut>", "Unhighlight() Unset()",
		 "Undoes the visual effects from Highlight().  The
		  display of submenus is not changed.")
		("<Enter>", "Highlight() Set() ", "Same as FocusIn")
		("<Leave>", "Unhighlight() Unset()", "Same as FocusOut")
		("<Btn1Down>", "Unhighlight()",
		 "Display any associated submenu if one exists.  This
		  is an experimental action to support MenuBars.")
		("<Btn1Up>", "Notify() Unhighlight() Unset()",
		 "Executes the callbacks associated with
		  \res{callback} and pop's down any other submenus.")
		("<Btn1Motion>", "WalkMenu()",
		"Causes a submenu to be displayed when \res{moveDelta} is
		 exceeded.")
		("<Key>Return", "Notify() Unhighlight() Unset()", "")
		("!<Key>Up", "ItemUp()", "")
		("!<Key>Down", "ItemDown()", "")
		("!<Key>Left", "ItemPrev()", "")
		("!<Key>Right", "ItemNext()", "")
		("!<Key>Home", "LineBegin()", "")
		("!<Key>Begin", "LineBegin()", "")
		("!<Key>End", "LineEnd()", "")
	}
}

class MenuBarButton =
{
	superclass = MenuButton;
	class_prefix = "o";
	class_name = MenuBarButton;
	class_record menu_bar_button =
	{
		field = ("", "", "Core.tm_table", "translations", "", "");
		field = ("", extern, "Core.class_initialize",
		         _XoClassInit, "", "");
		field = (static, "", "Core.set_values", SetValues, "", "");
		field = ("", "int", filler, "0", "keep compiler happy", "0");
	}
	instance menu_bar_button =
	{
		("", "MenuButton.direction", "",
		 "", "", "", String, "\"Down\"",
		 "")
		("", "MenuButton.move_delta", "",
		 "", "", "", Immediate, "0", "")
		(Boolean, enable_popup, "if popup are enabled",
		 enablePopup, EnablePopup, Boolean, Immediate, "False",
		 "True if it's ok to execute the new popup on the
		  parent.  This is used as a flag between the parent
		  menubar and the other widgets to indicate when they
		  can actually popup on highlight events.")
	}
	actions =
	{
		(WalkMenu, WalkMenu,
		 "Popup the one and only popup child of this widget.
		  The widget is popped up spring loaded.  It is an
		  error if there is more than one popup child.  If
		  there are no popup children, this is a no-op.  The
		  enable\_popup flag must be True, otherwise this is a
		  no-op.")

		(Highlight, Highlight,
		 "If this widget does not have a submenu or it has a
		  submenu which is not popped up, then it executes the
		  \res{newPopup} callback of the parent with the
		  \code{call\_data} set to \code{NULL}.  This causes
		  the parent to popdown any currently displayed menu
		  but only if that menu is from another
		  \class{menuButton}.

		  The \res{draw\_border} flag is set to true and the
		  widget is redrawn.  This should cause the border to
		  become active and instead of being drawn flat.  A
		  raised appearance (assuming a 3d border object is
		  used) should be used for the borders.")

		(Unhighlight, Unhighlight,
		 "Sets the \code{draw\_border} flag to \code{False}
		  and and causes the widget to redisplay itself.  The
		  widget should then have a ``flat'' apperance to
		  indicate it is inactive")

		(SubmenuPopup, SubmenuPopup,
		 "Display the submenu.  This is an experimental action
		  to be used for MenuButtons that are a child of a
		  MenuBar widget.")

		(GrabFocus, GrabFocus,
		 "Changes the keyboard focus to this widget, but only
		  if traverseAccept resource is True.")

		(EnableMenus, EnableMenus,
		 "Calls XoEnablePopups() on our parent so that menus
		  can be popped up.")

		(ItemUp, ItemUp,
		 "Tells parent to move the location cursor up an item.
		  ``Up'' is defined by the parent.  Behaves the same
		  as ItemNext except it does wraps around to the last
		  child of the parent when the first child is
		  reached.")

		(ItemDown, ItemDown,
		 "Tells the parent to move the location cursor down an
		  item.  ``Down'' is defined by the parent.  Behaves
		  the same as ItemNext except it does wraps around to
		  the first child of the parent when the last child is
		  reached.")

		(MenuRight, MenuRight,
		 "Move right to the next menu bar button.  If this
		  menu is popped up, then the next menu bar button's
		  menu is popped up.  If this menu is not popped up,
		  then neither is the next one.  If at the right hand
		  edge we wrap to the next line.  If there is only one
		  line, then it is back to the beginning.")

		(MenuLeft, MenuLeft,
		 "Move left to the next menu bar button.  If this menu
		  is popped up, then the next menu bar button's menu
		  is popped up.  If this menu is not popped up, then
		  neither is the next one.  If at the left hand edge
		  we wrap to the previous line.  If there is only one
		  line, then it is back to the beginning.")

		(DataBegin, DataBegin,
		 "Tells the parent to move the location cursor to the
		  first item.  ``First'' is determined by the
		  parent.")

		(DataEnd, DataEnd,
		 "Tells the parent to move the locatin cursor to the
		  last item.  \"Last\" is determined by the parent.")

		(LineBegin, LineBegin,
		 "Tells the parent to move the location cursor to the
		  leftmost edge.  The leftmost edge is defined by the
		  parent.")

		(LineEnd, LineEnd,
		 "Tells the parent to move the location cursor to the
		  rightmost edge.  The rightmost edge is defined by
		  the parent.")
	}
	translations =
	{
		("<Btn1Motion>", "WalkMenu()",
		 "Causes a submenu to be displayed
		 when \res{moveDelta} is exceeded.")
		("<FocusIn>", "Highlight()",
		 "Provides a visual feedback that the current input
		  focus is set to this widget.  If there are any other
		  submenus displayed, they should be popped down at
		  this point.")
		("<FocusOut>", "Unhighlight()",
		 "Undoes the visual effects from Highlight().  The
		  display of submenus is not changed.")
		("<Leave>", "Unhighlight()", "Same as FocusOut")
		("<Btn1Down>", "GrabFocus() EnableMenus(True) SubmenuPopup()",
		 "Display any associated submenu if one exists.  This
		  is an experimental action to support MenuBars.")
		("<Btn1Up>", "Notify() Unhighlight()",
		 "Executes the callbacks associated with
		  \res{callback} and pop's down any other submenus.")
		("!<Key>Up", "ItemUp()", "")
		("!<Key>Left", "MenuLeft()", "")
		("!<Key>Down", "ItemDown()", "")
		("!<Key>Right", "MenuRight()", "")
		("!<Key>Home", "LineBegin()", "")
		("!<Key>Begin", "LineBegin()", "")
		("!<Key>End", "LineEnd()", "")
	}
}

class Scrollbar =
{
	superclass = "Simple";
	class_prefix = "o";
	class_name = Scrollbar;
	purpose = "Implements a vertical or horizontal scrollbar.  The
		   scrollbar contains a Grip that indicates the amount
		   of a working area visible and the relative location
		   of the visible working area.  The user can either
		   grab the Grip directly to move the visible working
		   area or cause the Grip to jump to a new working area.

		   There are also arrows at either end of the
		   scrollbar to allow smooth scrolling by a fixed amount.

		   It is the responsibility of either the application
		   or other components to implement the semantics of
		   any scrolling.  The scrollbar executes a callback
		   list to indicate the new position of the top of
		   the Grip and the Grip's size -- both expressed as a
		   percentage of the Scrollbar's size.";
	class_record scrollbar =
	{
		field = (static, "", "Core.class_initialize", ClassInit,
			 "", "");
		field = (static, "", "Core.initialize", "Initialize", "", "");
		field = (static, "", "Core.realize", "Realize", "", "");
		field = (static, "", "Core.set_values", SetValues, "", "");
		field = (static, "", "Core.resize", Resize, "", "");
		field = (static, "", "Core.destroy", Destroy, "", "");
		field = ("", "", "Core.tm_table", "translations", "", "");
		field = (static, "", "Core.query_geometry",
			 GeometryQuery, "", "");
		}
	instance scrollbar =
	{
		("", "Core.width", "",
		 "", "", "", "Immediate", "(XtPointer) 15", "")
		("", "Core.height", "",
		 "", "", "", "Immediate", "(XtPointer) 15", "")
		(Boolean, direction, "True if forward.",
		 "", "", "", "", "",
		 "Flag used to keep track of which side of the Grip the mouse
		 was previously on.   This is used so we know which
		 way to move the grip when the mouse is over the grip.")
		(WidgetClass, grip_class, "widget class of Grip",
		 gripClass, Class, ObjectClass, String, "\"Grip\"",
		 "Widget class that implements the grip.  This class
		  must implement a callback, XtNmoveCallback, that passes
		  a XoMoveCB structure when the user is moving the
		  Grip.  When the user is finished, it must execute an
		  XtNcallback again passing an XoMoveCB structure.")
		(Dimension, orig_width, "preferred width",
		 "", "", "", "", "",
		 "The original width of the scrollbar.  This is used
		  when querying the widget for the preferred size.
		  This is returned as the goal width.

		  Using XtSetValues() to change the width updates this
		  value to the new dimension.")
		(Dimension, orig_height, "preferred height",
		 "", "", "", "", "",
		 "The original height of the scrollbar.  This is used
		  when querying the widget for the preferred size.
		  This is returned as the goal height.

		  Using XtSetValues() to change the height updates this
		  value to the new dimension.")
		(Widget, grip_widget, "draws the grip",
		 "gripWidget", "GripWidget", "Pointer", Immediate, NULL,
		 "This is the instance of the widget that allows the
		  user to interactively move the scrollbar up and
		  down.  You have two choices, either set the
		  \res{WidgetClass} at initialization time or create
		  an object with this widget as it's parent and then
		  use \code{XtSetValues()} to set this resource.  The
		  old widget is destroyed.

		  Note that this widget class must use certain
		  callbacks to communicate with the scrollbar.  See
		  the description of the the gripClass resource for
		  those details.")
		(WidgetClass, scroller_class, "class for scrollers",
		 "scrollerClass", "ScrollerClass", ObjectClass, String,
		 "\"Button\"",
		 "Widget class that implments the Scroller buttons.
		  At both ends of the scrollbar a widget is placed
		  that allows the user to move the Grip forward or
		  backward (down/up if the orientation is vertical,
		  right/left is the orientation is horizontal) a fixed
		  increment at a time.

		  This widget class must use a XtNcallback to
		  communicate with the scrollbar.  The data from the
		  the callback is ignored.

		  There are two ways that Scroller widgets can be
		  created: either the scrollbar creates them at
		  initialization time or something external (the
		  application or another widget) creates them and uses
		  XtSetValues() to notify the scrollbar about the new
		  scrollers.  If the scrollbar creates the Scroller
		  widgets, it passes in the value of left, right, top,
		  bottom class as the value XtNdrawClass when creating
		  the widget. If the Scroller is created outside the
		  scrollbar, it is the responsibilty of that external
		  code to set this appropriately.

		  Whichever way is used to create the Scroller
		  widgets, a XtNcallback callback is added to the
		  scroller.  Each time the callback is executed the
		  grip is moved forward or backward by
		  \code{XtNincrement} percent.  It is up to the
		  external code to insure that \code{XtNincrement} is
		  set to a reasonable value.  Ideally, this value
		  should change so that the data being scrolled always
		  moves a constant number of pixels.")
		(WidgetClass, scroller_draw, "what scroller displays",
		 scrollerDraw, ScrollerDraw, ObjectClass,
		 String, "\"ObjArrow\"",
		 "The widget class passed to the forward and reverse
		  scroller as the type to draw.  On of XoLEFT,
		  XoRIGHT, XoUP, XoDOWN is passed as the value of
		  XtNdirection depending on the orientation of the
		  scrollbar and whether it is a reverse or forward scroller.")
		(Widget, reverse_scroller, "causes reverse scrolling",
		 "reverseScroller", "Scroller", "Pointer", Immediate,NULL,
		 "This is the instance of the widget that allows the
		  user to interactively move the grip either up or to
		  the left a small increment at a time.  To change
		  this you have two choices: either set the
		  \res{WidgetClass} at initialization time or create a
		  widget with the scrollbar as it's parent and then
		  use \code{XtSetValues()} to set this resource.  The
		  old widget is destroyed.  With the second method you
		  must use \code{XtCreateWidget} and not
		  \code{XtCreateManagedWidget} to create the scroller.

		  Note that this widget class must use certain
		  callbacks to communicate with the scrollbar.  See
		  the description of the the scrollerClass resource for
		  those details.")
		(Widget, forward_scroller, "causes forward scrolling",
		 "forwardScroller", "Scroller", "Pointer", Immediate,NULL,
		 "This is the instance of the widget that allows the
		  user to interactively move the grip either down or to
		  the right a small increment at a time.  To change
		  this you have two choices: either set the
		  \res{WidgetClass} at initialization time or create a
		  widget with the scrollbar as it's parent and then
		  use \code{XtSetValues()} to set this resource.  The
		  old widget is destroyed.  With the second method you
		  must use \code{XtCreateWidget} and not
		  \code{XtCreateManagedWidget} to create the scroller.

		  Note that this widget class must use certain
		  callbacks to communicate with the scrollbar.  See
		  the description of the the scrollerClass resource for
		  those details.")
		(double, increment, "amount to move grip",
		 increment, Increment, Double, String, "\".05\"",
		 "When the XtNcallback is executed by one of the
		  Scroller widgets, the grip is moved by this amount.")
		(double, size, "size of Grip, as percent",
		 size, Size, Double, String, "\"0.2\"",
		 "The size of the grip widget expressed as a
		  percentage of the size of the scrollbar.  This
		  should indicate how much of the possible area is
		  currently being viewed.  Changing this causes the
		  Grip to resize but it the top remains at \code{XtNcenter}.

		  The actual physical size of the Grip is never
		  allowed to be less then the value of
		  \code{XtNminGrip} pixels or 1, whichever is larger.")
		(Dimension, min_grip, "minimum size of Grip",
		 "minGrip", "MinGrip", Dimension, Immediate,
		  "(XtPointer) 15",
		  "The minimum physical size of the Grip in Pixels.
		   Even though the value of \code{XtNsize} would result
		   in a Grip smaller than this, the grip will not
		   become smaller.  This insures the user is able to
		   find the Grip.

		   If this value is set to 0, it is automatically set
		   to 1 since it is not possible to have a window with a
		   dimension of 0.")
		(double, top, "location of Grip's top",
		 top, Top, Double, String, "\"0.0\"",
		 "The location of the grip expressed as a percentage
		  of the scrollbar size.  When the Grip is
		  interactively moved by the user, this value is
		  updated before the application is notified of the
		  Grip's new position.  Similarly, when this value is
		  changed using XtSetValues(), the callbacks are
		  executed to notify the application of the change.

		  If changing the top position of the grip ever
		  causes the grip to be not fully visible, the value
		  is adjusted to keep the grip fully visible.")
		(XoOrientation, orientation, "vertical or horizontal",
		 orientation, Orientation, Orientation, String, "\"Vertial\"",
		 "Either XoVERTICAL or XoHORIZONTAL.  Indicates if the
		  scrollbar is displayed horizontally or vertically.

		  Actually, this could probably just be determined by
		  the ration of the width to height but we use this instead.")
		(XtCallbackList, callbacks, "executed on grip movement",
		 callback, Callback, Callback, Immediate, NULL,
		 "A list of functions to call when the Grip is moved.
		  \code{call\_data} is set to the address of \res{top} to
		  indicate the center of the grip.  Do not change this value.")
	}
	actions =
	{
		(GripGoto, GripGoto,
		 "Move the Grip to the location of the event.  The
		 XtNcallbacks are executed, just as for any other
		 action that causes the grip to move.")
	}
	translations =
	{
		("<Btn1Down>", "GripGoto()",
		 "Make the Grip jump to the initial mouse click position.")
		("<Btn1Motion>", "GripGoto()",
		 "Moves the grip so it follows the mouse")
		("<Btn1Up>", "GripGoto()",
		 "And when the mouse is released, make sure we are at
		 that position.")
	}
}
