#
# rectobj.spec,v 2.2 1992/08/11 00:22:30 pete Exp
#
class ObjDraw = {
	superclass = RectObj;
	class_prefix = "o";
	class_name = ObjDraw;
	purpose = "Provides a basic framework for all subclasses of
RectObj in the Xo widget set.  Adds resources for foreground color,
insensitive foreground color, a flag to indicate if the object should
not do any drawing and finally a list of resources that should be
inherited by from the parent widget.

Such are the common features to all objects.
";
	public_pre_defines = "#ifndef _XO_XO_H_
#include <X11/Xo/Xo.h>
#endif
";
	private_pre_defines = "
#ifndef _XO_XOP_H_
#include <X11/Xo/XoP.h>
#endif
";

	class_record obj_draw = {
		field = ("", XtProc, "print", NULL, "Called by PrintCallback", NULL);
		field = (static, "", "RectObj.initialize", "Initialize", "", "");
		field = (static, "", "RectObj.set_values", "SetValues", "", "");
	}
	instance obj_draw = {
		(Pixel, fg, "foreground color",
		 foreground, Foreground,  Pixel, String, XtDefaultForeground,
		 "The color for drawing primary objects such as text
and lines.  Changing this during execution causes the object to change
color.")
		(XoShading, insensitive_stipple, "insensitive stipple",
		 insensitiveStipple, Shading, Shading, String, "\"gray4\"",
		 "How to stipple when insensitive.")
		(Pixmap, stipple, "stipple to use",
		 "", "", "", "", "",
		 "Pixmap to use as the stipple when insensitive.")
		(Boolean, no_draw, "should it not draw",
		 noDraw, DoDraw, Boolean, String, "\"False\"",
		 "Use this flag to temporarily turn off drawing of the
object.  Actually, I'm not sure why not just destroy the object, but anyway.")
		("XrmQuark *", inherit_resources, "resources to inherit",
		 inheritResources, QuarkSortedList, SortedQuarkList,
		 Immediate, NULL,
		 "The list of resources that this widget should
inherit from it's parent.")
	}
}

class ObjLabel =
{
	superclass = ObjDraw;
	class_prefix = "o";
	class_name = "ObjLabel";
	purpose = "This provides an object for drawing text.
		   Currently only 8-bit text is supported.  Multiple
		   lines may be used by including either an ASCII
		   newline or embedding the string \verb|\n| in the
		   actual text.  The lines of text are either left,
		   right or center justified.

		   A default width and height can be set with
		   defaultLabel.  The maximum width and height of this
		   and the displayed label are returned for any
		   geometry requests.  This is useful if a label is
		   going to have many different values but one does
		   not want it constantly resizing. ";
	private_pre_defines = "
typedef struct _XoLine 
{
	XtPointer	label;		/* the text to display on this line */
	Position	offset_x;	/* offset from left edge of object */
	Position	offset_y;	/* baseline of the text */
	Dimension	height;		/* height of the text (includes interline space) */
	Dimension	width;		/* width of the text */
} XoLines;

typedef struct _xo_text_info
{
	int		ti_num_lines;	/* how many lines */
	XoLines		*ti_lines;	/* list of lines; */
} _XoTextInfo;

typedef void (*XoLabelMake)(
#if NeedFunctionPrototypes
    Widget	gw,
    String	line,
    XoLines	*l
#endif
);

typedef void (*XoLabelDraw) (
#if NeedFunctionPrototypes
    Widget	gw,
    int		i,
    int		y
#endif
);

typedef void (*XoLabelFree) (
#if NeedFunctionPrototypes
    Widget	gw,
    _XoTextInfo	*tinfo,
    int		i
#endif
);

/*
 * Provide some macros to make it easier to execute the above class
 * methods.
 */
#define CallLabelMake(w,line,l) (*ThisClass ((Widget) w).obj_label_class.label_make) ((Widget) w,line,l)
#define CallLabelDraw(w,i,y) (*ThisClass ((Widget) w).obj_label_class.label_draw) ((Widget) w,i,y)
#define CallLabelFree(w,tinfo,l) (*ThisClass ((Widget) w).obj_label_class.label_free) ((Widget) w, tinfo,l)
";
	class_record obj_label = {
		field = (static, "", "RectObj.expose", Redisplay, "", "");
		field = (static, "", "RectObj.initialize", Initialize, "", "");
		field = (static, "", "RectObj.destroy", Destroy, "", "");
		field = (static, "", "RectObj.set_values", SetValues, "", "");
		field = (static, "", "RectObj.resize", Resize, "", "");
		field = (static, "", "RectObj.class_part_initialize",
				 ClassPartInitialize, "", "");
		field = (static, "", "RectObj.query_geometry", GeometryQuery,
				 "", "");
 		field = (static, XoLabelMake, "label_make", LabelMake,
			 "Creates the label", "XtInheritLabelMake");
  		field = (static, XoLabelDraw, "label_draw", LabelDraw,
			 "draws the label", "XtInheritLabelDraw");
  		field = (static, XoLabelFree, "label_free", LabelFree,
			 "deallocates the label", "XtInheritLabelFree");
	}
	instance obj_label = {
		("", "ObjDraw.inherit_resources", "",
		 "", "", "", "String",
		 "\"label, sensitive, ancestorSensitive, font\"",
		 "")
		("XFontStruct *", font, "font to draw with",
		 "font", "Font", "FontStruct", String,
		 "\"*-times-bold-r-*-*-140-*\"",
		 "The font to draw the label.")
		(XoJustify, justify, "justifcation for muli-lines",
		 justify, Justify, Justify, String, "\"Left\"",
		 "Controls how multiple lines of text are layed out
		  with respect to each other.  See \res{gravity} to
		  place the block of lines within the widget.
		  Possible values are Left, Center, and Right.  Left
		  justify causes each line of text to start at the
		  same x coordinate.  Right justify causes each line
		  of text to finish at the same x coordinate.  Center
		  justify causes each line of text to be centered with
		  respect to the widest line of of text.")
		(String, label, "the label string",
		 label, Label, String, Immediate, NULL,
		 "The text to display using \res{foreground} as the
		  color and \res{font} as the typeface for the string.
		  If the string contains newlines (ascii character 10)
		  or the two character sequence \verb|\n|, the text
		  occupies multiple lines.  Each text line is then
		  justified according to \res{justify} relative to the
		  other text lines.")
		("GC", gc, "for drawing the text",
		"", "", "", "", "",
		"This gc is created to display the text.  The font and
		 foreground colors are set in GetGC().")
		("_XoTextInfo *", "lines", "lines of text",
		"", "", "", "", "",
		"An array of lines of text.  Each entry has a copy of
		 the corresponding string, width, height, x offset (used for
		 justification) and y offset (used to establish the
		  baseline).")
		("String", "default_label", "default label",
		 "defaultLabel", DefaultLabel, String, Immediate, NULL,
		 "Provides the default size of this text box.  When
		  the widget is asked to determine it's size, the
		  maximum width and height of this
		  \code{default\_label} and the normal \code{label}
		  are returned.  This is useful if this is going to be
		  set to a number of different values but you only
		  want it to remain a constant size.  To do so, just
		  set \code{default\_label} to the largest string.")
		("_XoTextInfo *", "default_lines", "default text for size",
		 "", "", "", "", "",
		 "An array of lines of text.  This is used to
		  determine the default size of this text.")
		("Dimension", "default_width", "normal width",
		 "", "", "", "", "",
		 "The default calculated width.")
		("Dimension", "default_height", "normal height",
		 "", "", "", "", "",
		 "The default calculated height.")
	}
	function void label_make = {
		 args =
		 {
		 	(Widget, gw, "ObjLabel being changed")
			(String, line, "line to add")
			("XoLines*", l, "list of lines")
		}
	}
	function void label_draw =
	{
		args =
		{
			(Widget, gw, "Widget to draw text from")
			(int, i, "line")
			(int, y, "y coordinate of baseline")
		}
	}
	function void label_free =
	{
		args =
		{
			(Widget, gw, "ObjLabel being changed")
			("_XoTextInfo *", tinfo, "TextInfo to free")
			(int, i, "current line")
		}
	}
}

class ObjLabelFormat =
{
	superclass = ObjLabel;
	class_prefix = "o";
	class_name = "ObjLabelFormat";
	purpose = "This provides an object for drawing text.
		   Currently only 8-bit text is supported.  Multiple
		   lines may be used by including either an ASCII
		   newline or embedding the string \verb|\n| in the
		   actual text.  The lines of text are either left,
		   right or center justified.

		   A default width and height can be set with
		   defaultLabel.  The maximum width and height of this
		   and the displayed label are returned for any
		   geometry requests.  This is useful if a label is
		   going to have many different values but one does
		   not want it constantly resizing.

		   This includes additional features compared to
		   ObjLabel such as the ability to switch to italic,
		   bold, sub and superscripts, math symbols, etc.  ";
	private_pre_defines = "
#include <X11/Xo/text.h>
";
	class_record obj_label_format = {
		field = (static, "", "RectObj.initialize", Initialize, "", "");
		field = (static, "", "RectObj.destroy", Destroy, "", "");
		field = (static, "", "RectObj.set_values", SetValues, "", "");
		field = (static, "", "RectObj.class_part_initialize",
				 ClassPartInitialize, "", "");
		field = (static, "", "ObjLabel.label_make", LabelMake, "", "");
		field = (static, "", "ObjLabel.label_draw", LabelDraw, "", "");
		field = (static, "", "ObjLabel.label_free", LabelFree, "", "");
	}
	instance obj_label_format = {
		("", "ObjDraw.inherit_resources", "",
		 "", "", "", "String",
		 "\"label, sensitive, ancestorSensitive, defaultLabel,fontFamily,fontStyle,fontSize,rotate\"",
		 "")
		(String, "font_family", "family of fonts",
		 "fontFamily", FontFamily, String, String,
		 "\"times\"",
		 "The family of fonts this text should use.  Based on
		  font size and font style a particular font is
		  displayed.")
		("AtFontFamily *", family, "the family",
		 "private", "Private", "Private", "Immediate", NULL,
		 "The actual family to use when doing any drawing.
		  The \code{font\_family} is converted to this type.")
		(int, "font_size", "size of the label",
		 "fontSize", "FontSize", Int, Immediate,
		 "(XtPointer) AtFontNORMAL",
		 "The size of the font to use for this label, in points.")
		(int, "font_style", "bold, italic, etc",
		 "fontStyle", "FontStyle", FontStyle, Immediate,
		 "(XtPointer) AtFontBOLD",
		 "If this text is bold, italic, normal etc. by default")
		(Boolean, "rotate", "if rotate 90 degrees",
		 "rotate", "Rotate", Boolean, Immediate, False,
		 "Indicates if text should be rotated 90 degrees
		  counter clockwise")
	}
}

class ObjPixmap = {
	superclass = ObjDraw;
	class_prefix = "o";
	class_name = ObjPixmap;
	purpose = "Displays a pixmap.  Currently, this is
unimplemented.  It should, however, eventualy use XPM3 to read bitmaps
and color pixmaps.  These will be scalabel to fit the current size.";
	class_record obj_pixmap = {
	}
	instance obj_pixmap = {
		(Boolean, tile, "tile pixmap",
		 tile, Tile, Boolean, Immediate, False,
		 "If True and a pixmap is being displayed, then the
pixmap is displayed across the entire widget.  Tiling starts in the
upper left corner regardless of the values of \res{gravity} and
\res{justify}.")
		(Boolean, scale, "scale object to widget size",
		 scale, Scale, Boolean, Immediate, False,
		 "If True, the displayed object (either text or
pixmap) should be scaled to fit the size of the widget.  For text, the
\res{fontPattern} resource is used to obtain a list of fonts.  From
that list, one is selected based on avg\_x and avg\_y to fit the text
within the widget.  The text is then changed to use this new font.

For Pixmap's, some unknown algorithm is used to scale the pixmap to
fit the entire widget.")
		(Pixmap, pixmap, "picture to draw",
		 pixmap, Pixmap, Pixmap, Immediate, NULL,
		 "A picture to display instead of \res{label}.  If
this is set, then \res{label} is not used.  The \res{gravity} resource
is used to place this pixmap.  In addition, if the \res{tile} resource
is set, then this pixmap is tiled accros the entire widget.  However,
if \res{scale} is True, then that takes precedence over tiling and the
pixmap is scaled to fit the size of the widget.

We should use XPM2 format for the converters into this data.")
	}
}

class ObjBorder = {
	superclass = ObjDraw;
	class_prefix = "o";
	class_name = ObjBorder;
	purpose = "There are several possible border types such as
simple rectangles, beveled edges, oval shapes and drop shadows.  This
widget class provides the basic features that all the above inherit
from.  This class should not be instantiated since it has no real
implementation.

All border objects support clearInverted and inverted resources.
Inverted should be True to indicate this is currently selected.
clearInverted is set to indicate when inverted is False a very mild,
preferably no, border is displayed.  ClearInverted is mostly usueful
for menus.";
	class_record obj_border = {
		field = (static, "", "RectObj.set_values", SetValues, "", "");
 	}
	instance obj_border = {
		(Boolean, clear_inverted, "clear when inverted",
		 clearInverted, ClearInverted, Boolean, Immediate, False,
		 "Flag that indicates the inverted state should be
shown by not drawing a border.  This is useful for menus and menubars
that have a better visual appearance when the highlighted state is
very distinct from the unhighlighted state.

When the inverted value changes from True to False, this causes an
XClearArea() to be executed with no expose events generated.")
		(Boolean, inverted, "draw edges depressed",
		 "inverted", Inverted, Boolean, String, "False",
		 "This flag should be set when the border should be
drawn with the shadow and highlight edges reversed.  This makes the
object look like it has been pressed.")
	}
}
class Obj3dBorder = {
	superclass = ObjBorder;
	class_prefix = "o";
	class_name = Obj3dBorder;
	purpose = "Provides a 3 dimensional appearance.  This is
looks like the Motif 3d borders.  The edge are called beveled, much as
if a chisel had cut the area out.  The colors for the highlight bevel
and shadow bevels can be set.

When the border is inverted, the colors of the highlight and beveled
edges are exchanged.  This causes a widget to appear to have been
pushed down.";
	class_record obj_3d_border = {
		field = (static, "", "RectObj.expose", Redisplay, "", "");
		field = (static, "", "RectObj.initialize", Initialize, "", "");
		field = (static, "", "RectObj.destroy", Destroy, "", "");
		field = (static, "", "RectObj.set_values", SetValues, "", "");
		field = ("", XtPointer, "extension", NULL,
			 "pointer to extension record", "");
	}
	instance obj_3d_border = {
		("", "ObjDraw.inherit_resources", "",
		 "", "", "", String, "\"foreground, bevelShadow, bevelHighlight, sensitive, ancestorSensitive, clearInverted, insensitiveColor, background\"",
		 "")
		(Pixel, def_background, "background color",
		 "defBackground", Background, Pixel, String, "\"grey80\"",
		 "The default color for drawing the background.  The background
of the parent widget is initially set to this value when the 3d border
object is created  (irrespective of what the parent's background color
is supposed to be).  Thereafter, this follows the value of the parents
background.")
		("", "RectObj.border_width", "",
		 "", "", "", Immediate, "(XtPointer) 2", "")
		(Pixel, bevel_highlight, "Color for highlighted edge",
		 bevelHighlight, BevelHighlight, Pixel, String, "\"gray85\"",
		 "Color for drawing the lighter (upper and left) edges
of the border.  Should be the same hue as the background but a
higher intensity.  Note that all four colors, \res{foreground},
\res{background}, \res{bevelHighlight}, and \res{bevelShadow} must be
chosen in concert to produce an appealing appearance.  The
\res{borderWidth} determines the width of the bevels.")
		(Pixel, bevel_shadow, "Color for shadowed edge",
		 bevelShadow, BevelShadow, Pixel, String, "\"gray65\"",
		 "Color for drawing the darker (lower and right) edges
of the border.  Should be the same hue as the background but a
lower intensity.  Note that all four colors, \res{foreground},
\res{background}, \res{bevelHighlight}, and \res{bevelShadow} must be
chosen in concert to produce an appealing appearance.\footnote{We
should provide an utility to help select such values.  Does an hsv
model work well for makeing such choices?}")
		(GC, highlight_gc, "GC for upper edge",
		 "", "", "", "", "",
		 "This GC has the foreground color set to
\res{bevelHighlight}.  It is used for the XFillPolygon() of the upper
and left edges.")
		(GC, shadow_gc, "GC for lower edge",
		 "", "", "", "", "",
		 "This GC has the foreground color set to
\res{bevelShadow}.  It is used for the XFillPolygon() of the lower
and right edges.")
	}
}

class Obj2dBorder = {
	superclass = ObjBorder;
	class_prefix = "o";
	class_name = Obj2dBorder;
	purpose = "Provides a simple square border.  This is
particularly suitable for monochrome displays since a 3 dimension
border does not look nearly as good.

When the inverted resource is set to true, the border width is
increased by partWidth (for partial width)";
	private_post_defines = "
/*
 * Return the normal border width.  Leave it as a macro in case we
 * later decide to use a floating point value for part_width.  This must
 * return an integer, 0 indicates do not draw a border.
 */
#define BORDER_WIDTH(w)	(w->obj_border.inverted?\
			w->rectangle.border_width+w->obj_2d_border.part_width:\
			w->rectangle.border_width)
";
	class_record obj_2d_border = {
		field = (static, "", "RectObj.expose", Redisplay, "", "");
		field = (static, "", "RectObj.initialize", Initialize, "", "");
		field = (static, "", "RectObj.destroy", Destroy, "", "");
		field = (static, "", "RectObj.set_values", SetValues, "", "");
		field = ("", XtPointer, "extension", NULL,
			 "pointer to extension record", "");
	}
	instance obj_2d_border = {
		("", "ObjDraw.inherit_resources", "",
		 "", "", "", String, "\"foreground, background, sensitive, ancestorSensitive, clearInverted, insensitiveColor\"",
		 "")
		("", "RectObj.border_width", "",
		 "", "", "", Immediate, "(XtPointer) 2", "")
		(int, "part_width", "divisor of border_width",
		 "partWidth", "PartWidth", Int, Immediate, "(caddr_t) 2",
		 "To get the normal drawing border width, divide the
border\_width by this value.  If the result is zero, do not draw a border")
		(GC, gc, "GC for drawing the border",
		 "", "", "", "", "",
		 "This GC has the foreground color set to
\res{foreground} and the line width set to either border\_width or border\_width/part\_width.  It is used for the XDrawLine() of the border.")
	}
}

class ObjArrow = {
	superclass = ObjDraw;
	class_prefix = "o";
	class_name = ObjArrow;
	purpose = "Draws an isoceles triangle.";
	class_record obj_arrow = {
		field = (static, "", "RectObj.expose", Redisplay, "", "");
		field = (static, "", "RectObj.initialize", Initialize, "", "");
		field = (static, "", "RectObj.destroy", Destroy, "", "");
		field = (static, "", "RectObj.set_values", SetValues, "", "");
		field = ("", XtPointer, "extension", NULL,
			 "pointer to extension record", "");
	}
	instance obj_arrow = {
		("", "ObjDraw.inherit_resources", "",
		 "", "", "", String, "\"foreground, background, sensitive, ancestorSensitive, insensitiveColor, direction\"",
		 "")
		(XoPointing, "direction", "which way arrow points",
		 "direction", "Direction", Pointing, String, "\"Left\"",
		 "The direction the arrow points -- the line drawn
		 from the base, the longest dimension, to the apex
		 goes in this direction.")
		(GC, gc, "GC for drawing the border",
		 "", "", "", "", "",
		 "This GC has the foreground color set to
		  \res{foreground} and the line width set to
		  border\_width.  It is used for the XDrawLine() of
		  the triangle.")
	}
}
