/*
 * Menu is a widget which provides layout and semantics for popup
 * menus.  Typically, this is used as a child of a MenuShell.
 *
 * Menu.c,v 2.2 1992/07/22 15:59:31 pete Exp
 * Menu.c,v
 * Revision 2.2  1992/07/22  15:59:31  pete
 * Popdown submenu on keyboard traversal to left
 *
 * Revision 2.1  1992/06/23  00:28:48  pete
 * Changed interface to _XoMenuNew and _XoMenuDone.
 *
 * Revision 2.0  1992/04/23  02:51:09  ware
 * First public release.
 *
 * Revision 1.22  1992/02/27  14:30:29  ware
 * Compiled with GCC 2.0 and very strict checks.  Fixed Warnings
 *
 * Revision 1.21  1992/02/20  17:00:47  ware
 * Removed a duplicate case statement.
 *
 * Revision 1.20  1992/02/20  15:11:09  ware
 * Applied new indentation
 *
 * Revision 1.19  92/02/04  21:22:46  pete
 * Release 44
 *
 * Revision 1.18  1991/11/30  15:51:19  pete
 * Cleaned up some nitpicky compile time warnings.
 *
 * Revision 1.17  1991/08/30  18:02:25  pete
 * Removed unused methods.
 *
 * Revision 1.16  91/08/30  17:38:07  pete
 * Changed to use the new XtNCallbackMenu callback protocol.  Changed
 * Menu to be a subclass of Column.
 *
 * Revision 1.15  91/08/26  17:17:17  pete
 * Make the geometry_handler work.  The previous one was incredibly wrong
 * and passed the request on to the parent.
 *
 * Revision 1.14  91/08/26  11:57:49  pete
 * Use XoProto() for conditional prototypes.  Working on getting traversals
 * and menus to work more efficiently.  Changed to following naming
 * conventions.
 *
 * Revision 1.13  1991/07/19  00:59:55  pete
 * Use shorter file names.  Various speedups.
 *
 * Revision 1.12  1991/06/14  17:36:30  pete
 * Cleaning up the code some -- removed unused methods and added some
 * comments.
 *
 * Revision 1.11  91/06/14  10:20:36  pete
 * Use the class method handle_button and inherit it properly.  Implement
 * the "below" resource so that menus can popup just under there
 * grandparent.
 *
 * Revision 1.10  1991/06/14  04:43:23  pete
 * Added DBUG macros.  Made handle_popup and class method.  Moved majority
 * of popup placement code to XoPlacePopup.  Much more work towards getting
 * menubar's to work.
 *
 * Revision 1.9  91/06/01  10:03:16  pete
 * Working on menubar
 *
 * Revision 1.8  91/05/29  14:42:16  pete
 * Working on getting the menubar to work.
 *
 * Revision 1.7  1991/05/25  11:02:53  pete
 * Adding external menus
 *
 * Revision 1.6  91/05/23  16:49:45  pete
 * An actually working version of popup menus.
 *
 * Revision 1.5  91/05/23  15:23:00  pete
 * Pop submenus down on notify
 *
 * Revision 1.4  1991/05/22  17:49:39  pete
 * Get it to compile cleanely.  Menus almost work.
 *
 * Revision 1.3  91/05/21  17:15:32  pete
 * Working on getting popup's and downs to work correctly.
 *
 * Revision 1.2  91/05/21  15:08:55  pete
 * A minimally working walking menu implementation.
 *
 * Revision 1.1  1991/05/20  17:54:43  pete
 * Initial revision
 *
 */

#include <stdio.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xo/MenuP.h>
#include <X11/Xo/MenuShell.h>		/* needed for XtNpopupStarter */
#include <X11/Xo/dbug.h>

XoProto (static void, CallbackMenu, (Widget gw, XtPointer client_data, XtPointer call_data));

#include <X11/Xo/MenuRec.h>

/*
 *----------------------------------------------------------------------
 * Core Class Methods
 *----------------------------------------------------------------------
 */

/*
 * ClassPartInit - Inherit some class methods appropriately.
 */

static void
ClassPartInit (class)
	WidgetClassRec *class;
{
	XoMenuClassRec *c = (XoMenuClassRec *) class;
	XoMenuClassRec *super;

	DBUG_ENTER ("Menu.ClassPartInit");
	super = (XoMenuClassRec *) c->core_class.superclass;
	if (c->menu_class.callback_menu == XtInheritCallbackMenu)
		c->menu_class.callback_menu =
			super->menu_class.callback_menu;
	DBUG_VOID_RETURN;
}

/*
 * Initialize - Install the callback for XtNcallbackMenu.
 */

static void
Initialize (request, new, arglist, num_args)
	Widget          request;	/* as first created */
	Widget          new;		/* after other parent classes */
	ArgList         arglist;	/* list of arguments */
	Cardinal       *num_args;	/* how many */
{

	DBUG_ENTER ("Menu.Initialize");

	/*
	 * Add a callback for children to execute when they want to pop up or
	 * down a submenu.  This allows us to popdown any other submenus that
	 * may have been displayed.
	 */
	if (ThisClass (new).menu_class.callback_menu)
	{
		XtAddCallback (new, XtNcallbackMenu,
			       ThisClass (new).menu_class.callback_menu,
			       (XtPointer) new);
	}
	DBUG_VOID_RETURN;
}

/*
 *----------------------------------------------------------------------
 * Composite Class Methods
 *----------------------------------------------------------------------
 */

/*
 *----------------------------------------------------------------------
 * Constraint Class Methods
 *----------------------------------------------------------------------
 */

/*
 *----------------------------------------------------------------------
 * ConsBase Class Methods
 *----------------------------------------------------------------------
 */

static void
Traverse (gw, client_data, call_data)
	Widget          gw;
	XtPointer       client_data;	/* data from the application */
	XtPointer       call_data;	/* data from the widget */
{
	XoTraverseInfo *info;
	int             i;		/* where this widget is located */
	Widget          next = NULL;	/* widget to try setting focus to */
	XoMenuWidget    w = (XoMenuWidget) gw;
	Arg		args[10];
	Cardinal	cnt;

	DBUG_ENTER ("Menu.Traverse");
	if (!(info = (XoTraverseInfo *) call_data))
	{
		_XoWarn (gw, "Traverse", "badArgument", "call data is null");
		DBUG_VOID_RETURN;
	}
	DBUG_PRINT ("menufocus", ("Traversing in %s direction %s",
				  XoName (gw),
				  _XoStringFromDirection (info->t_direction)));
	switch (info->t_direction)
	{
	case XoTRAVERSE_NEXT:
	case XoTRAVERSE_PREVIOUS:
	case XoTRAVERSE_RIGHT:
		break;
	case XoTRAVERSE_LEFT:
		if (w->menu.popup && _XoIsPoppedUp (w->menu.popup))
		{
			cnt = 0;
			XtSetArg (args[cnt], XtNpopupStarter, &next); ++cnt;
			XtGetValues (w->menu.popup, args, cnt);
			if (!XoFocusAccept (next, &info->t_time))
				next = NULL;
			else
				_XoMenuNew (w->menu.popup, (Widget) NULL,
					    (Widget) NULL,
					    info->t_direction,
					    (XEvent *) NULL,
					    XoPOPUP_NEW);
		}
		break;
	case XoTRAVERSE_HOME:
		next = _XoTraverseAfter (gw, 0, info->t_time);
		break;
	case XoTRAVERSE_END:
		next = _XoTraverseBefore (gw, (int) w->composite.num_children - 1, info->t_time);
		break;
	case XoTRAVERSE_UP:
		i = _XoChildFind (gw, info->t_start);
		DBUG_PRINT ("menufocus", ("Currently at %s(%d)", XoName (info->t_start), i));
		next = _XoTraverseBefore (gw, i - 1, info->t_time);
		DBUG_PRINT ("menufocus", ("Going to %s", XoName (next)));
		if (!next)
			next = _XoTraverseBefore (gw, (int) w->composite.num_children - 1, info->t_time);
		break;
	case XoTRAVERSE_DOWN:
		i = _XoChildFind (gw, info->t_start);
		DBUG_PRINT ("menufocus", ("Currently at %s(%d)", XoName (info->t_start), i));
		next = _XoTraverseAfter (gw, i + 1, info->t_time);
		DBUG_PRINT ("menufocus", ("Going to %s", XoName (next)));
		if (!next)
			next = _XoTraverseAfter (gw, 0, info->t_time);
		break;
	}
	if (!next)
	{
		DBUG_PRINT ("menufocus", ("Trying traversal again"));
		info->t_found = XoTraverse (gw, info->t_direction, info->t_time);
	}
	else
	{
		info->t_found = True;
	}
	DBUG_PRINT ("menufocus", ("Done with traversals"));
	DBUG_VOID_RETURN;
}

/*
 *----------------------------------------------------------------------
 * Column Class Methods
 *----------------------------------------------------------------------
 */

/*
 *----------------------------------------------------------------------
 * Menu Class Methods
 *----------------------------------------------------------------------
 */

static void
CallbackMenu (gw, client_data, call_data)
	Widget          gw;
	XtPointer       client_data;
	XtPointer       call_data;
{
	XoMenuWidget    w = (XoMenuWidget) gw;
	XoPopupInfo    *cb = (XoPopupInfo *) call_data;
	XoPopupInfo     info;

	DBUG_ENTER ("Menu.CallbackMenu");
	if (!cb)
		DBUG_VOID_RETURN;
	info = *cb;
	if (cb->pi_action == XoPOPUP_NONE)
	{
		info.pi_submenu = NULL;
		XoEnablePopups (gw, False);
		_XoMenuDone (XtParent (gw), info.pi_submenu, info.pi_start,
			     info.pi_where, info.pi_event, XoPOPUP_NONE);
	}
	else if (!cb->pi_submenu)
	{
		info.pi_submenu = NULL;
		_XoMenuNew (w->menu.popup, info.pi_submenu, info.pi_start,
			    info.pi_where, info.pi_event, info.pi_action);
	}
	else
	{
		XoEnablePopups (gw, True);
		_XoMenuNew (w->menu.popup,  info.pi_submenu, info.pi_start,
			    info.pi_where, info.pi_event, info.pi_action);
	}
	DBUG_VOID_RETURN;
}

/*
 *----------------------------------------------------------------------
 * Private Utilities
 *----------------------------------------------------------------------
 */
