/*
 * toggles.c,v 2.3 1992/07/22 16:06:57 pete Exp
 * toggles.c,v
 * Revision 2.3  1992/07/22  16:06:57  pete
 * Added stdio.
 *
 * Revision 2.2  1992/07/11  20:45:16  pete
 * Incorrect type passed to free.  Use local variable for points if possible.
 *
 * Revision 2.1  1992/07/11  20:05:55  pete
 * From Markus Stumpf <stumpf@informatik.tu-muenchen.de>
 *
 *
 *
 * Support for drawing various figures.  This is based on code from
 * Markus Stumpf <stumpf@informatik.tu-muenchen.de> posted to the FWF
 * mailing list on 7 July 1992.
 */
#include <stdio.h>
#include <math.h>
#include <X11/Xo/Xo.h>
#include <X11/Xmu/Drawing.h>

int 
XoMaybeScale (value, ref)
	double          value;
	int             ref;
{
	return nint ((fabs (value) <= 1) ? value * ref : value);
}

void 
XoScaleTranslate (from, npoints, to, x, y, width, height)
	float           (*from)[2];
	int             npoints;
	XPoint         *to;
	int             x, y;
	int             width, height;
{
	int             i;

	for (i = 0; i < npoints; i++)
	{
		to[i].x = x + nint (width * from[i][0]);
		to[i].y = y + nint (height * from[i][1]);
	}
}


void 
XoDrawToggleBox (disp, win, gc, x, y, width, height,
		   boxwidth, boxheight, boxthick)
	Display        *disp;
	Window          win;
	GC              gc;
	int             x, y;
	int             width, height;
	double          boxwidth, boxheight;
	int             boxthick;
{
	int             bwidth, bheight;
	XGCValues       backup, xgcv;

	if (boxthick < 0)
		return;

	bwidth = XoMaybeScale (boxwidth, width);
	bheight = XoMaybeScale (boxheight, height);

	XGetGCValues (disp, gc, GCLineWidth, &backup);
	if (backup.line_width != boxthick)
	{
		xgcv.line_width = boxthick;
		XChangeGC (disp, gc, GCLineWidth, &xgcv);
	}
	XDrawRectangle (disp, win, gc, (width - bwidth) / 2, (height - bheight) / 2,
			bwidth, bheight);
	if (backup.line_width != boxthick)
		XChangeGC (disp, gc, GCLineWidth, &backup);
}


void 
XoOutlineShape (disp, win, gc, shape, npoints, x, y, width, height)
	Display        *disp;
	Window          win;
	GC              gc;
	float           (*shape)[2];
	int             npoints;
	int             x, y;
	int             width, height;
{
#define DEFAULT_NUM_POINTS	80
	XPoint         *points;
	XPoint		local[DEFAULT_NUM_POINTS];
	Boolean		allocated = False;

	if (npoints > XtNumber(local))
	{
		allocated = True;
		points = (XPoint *) malloc (npoints * sizeof (*points));
	}
	else
		points = local;
	XoScaleTranslate (shape, npoints, points, x, y, width, height);
	XDrawLines (disp, win, gc, points, npoints, CoordModeOrigin);
	if (allocated)
		free ((char *) points);
}

void 
XoFillShape (disp, win, gc, shape, npoints, x, y, width, height)
	Display        *disp;
	Window          win;
	GC              gc;
	float           (*shape)[2];
	int             npoints;
	int             x, y;
	int             width, height;
{
	XPoint         *points;
	XPoint		local[DEFAULT_NUM_POINTS];
	Boolean		allocated = False;

	if (npoints > XtNumber(local))
	{
		allocated = True;
		points = (XPoint *) malloc (npoints * sizeof (*points));
	}
	else
		points = local;

	points = (XPoint *) malloc (npoints * sizeof (*points));
	XoScaleTranslate (shape, npoints, points, x, y, width, height);
	XFillPolygon (disp, win, gc, points, npoints, Complex, CoordModeOrigin);
	if (allocated)
		free ((char *) points);
}

void 
XoDrawShape (disp, win, gc, shape, npoints, x, y, width, height)
	Display        *disp;
	Window          win;
	GC              gc;
	float           (*shape)[2];
	int             npoints;
	int             x, y;
	int             width, height;
{
	XPoint         *points;
	XPoint		local[DEFAULT_NUM_POINTS];
	Boolean		allocated = False;

	if (npoints > XtNumber(local))
	{
		allocated = True;
		points = (XPoint *) malloc (npoints * sizeof (*points));
	}
	else
		points = local;

	points = (XPoint *) malloc (npoints * sizeof (*points));
	XoScaleTranslate (shape, npoints, points, x, y, width, height);
	XDrawLines (disp, win, gc, points, npoints, CoordModeOrigin);
	XFillPolygon (disp, win, gc, points, npoints, Complex, CoordModeOrigin);
	if (allocated)
		free ((char *) points);
}


#define CMNPOINTS	7
static float    cmpoints[CMNPOINTS][2] = {
	{0, 0.6},
	{0.25, 0.6},
	{0.5, 0.8},
	{1, 0},
	{1, 0.2},
	{0.5, 1},
	{0, 0.6}
};

void 
XoOutlineCheckmark (disp, win, gc, x, y, width, height)
	Display        *disp;
	Window          win;
	GC              gc;
	int             x, y;
	int             width, height;
{
	XoOutlineShape (disp, win, gc, cmpoints, CMNPOINTS, x, y, width, height);
}

void 
XoFillCheckmark (disp, win, gc, x, y, width, height)
	Display        *disp;
	Window          win;
	GC              gc;
	int             x, y;
	int             width, height;
{
	XoFillShape (disp, win, gc, cmpoints, CMNPOINTS, x, y, width, height);
}

void 
XoDrawCheckmark (disp, win, gc, x, y, width, height)
	Display        *disp;
	Window          win;
	GC              gc;
	int             x, y;
	int             width, height;
{
	XoDrawShape (disp, win, gc, cmpoints, CMNPOINTS, x, y, width, height);
}

void 
XoDrawBoxedCheckmark (disp, win, gc, x, y, width, height,
			cmsize, cmar)
	Display        *disp;
	Window          win;
	GC              gc;
	int             x, y;
	int             width, height;
	double          cmsize, cmar;
{
	int             cmwidth, cmheight;
	XGCValues       backup, xgcv;

	if (cmar < 0 || cmsize <= 0)
		return;

	if (cmar == 0)
		cmar = CHECKMARK_AR;
	cmwidth = XoMaybeScale (cmsize, (CHECKMARK_AR2 * cmar * width >
		    height) ? nint (height / cmar / CHECKMARK_AR2) : width);
	cmheight = nint (cmar * cmwidth);

	XGetGCValues (disp, gc, GCLineWidth, &backup);
	if (backup.line_width != 0)
	{
		xgcv.line_width = 0;
		XChangeGC (disp, gc, GCLineWidth, &xgcv);
	}

	XoDrawCheckmark (disp, win, gc,
			   x + (width - cmwidth) / 2,
			 nint (y + (height - CHECKMARK_AR2 * cmheight) / 2),
			   cmwidth, cmheight);

	if (backup.line_width != 0)
	{
		XChangeGC (disp, gc, GCLineWidth, &backup);
	}
}

void 
XoDrawBoxWithCheckmark (disp, win, gc, x, y, width, height,
			  boxwidth, boxheight, boxthick,
			  cmsize, cmar)
	Display        *disp;
	Window          win;
	GC              gc;
	int             x, y;
	int             width, height;
	double          boxwidth, boxheight;
	int             boxthick;
	double          cmsize, cmar;
{
	XoDrawToggleBox (disp, win, gc, x, y, width, height,
			   boxwidth, boxheight, boxthick);

	XoDrawBoxedCheckmark (disp, win, gc, x, y, width, height,
				cmsize, cmar);
}

/* the clipmask for the gcs are destroyed.  Sorry */
void 
XoDrawBoxedXlogo (disp, win, gc, x, y, width, height,
		    xlsize, xlar)
	Display        *disp;
	Window          win;
	GC              gc;
	int             x, y;
	int             width, height;
	double          xlsize, xlar;
{
	int             xlwidth, xlheight;
	XGCValues       xgcv;
	GC              fore, back;
	Pixmap          mask;

	if (xlar < 0 || xlsize <= 0)
		return;

	if (xlar == 0)
		xlar = 1;
	xlwidth = XoMaybeScale (xlsize, width);
	xlheight = XoMaybeScale (xlsize, height);

	mask = XCreatePixmap (disp, win, xlwidth, xlheight, 1);
	xgcv.foreground = 1;
	fore = XCreateGC (disp, mask, GCForeground, &xgcv);
	xgcv.foreground = 0;
	back = XCreateGC (disp, mask, GCForeground, &xgcv);
	XFillRectangle (disp, mask, back, 0, 0, xlwidth, xlheight);
	XmuDrawLogo (disp, mask, fore, back, 0, 0, xlwidth, xlheight);

	XSetClipMask (disp, gc, mask);
	XFillRectangle (disp, win, gc,
	      x + (width - xlwidth) / 2, nint (y + (height - xlheight) / 2),
			xlwidth, xlheight);
	XSetClipMask (disp, gc, None);

	XFreeGC (disp, fore);
	XFreeGC (disp, back);
	XFreePixmap (disp, mask);
}

void 
XoDrawBoxWithXlogo (disp, win, gc, x, y, width, height,
		      boxwidth, boxheight, boxthick,
		      xlsize, xlar)
	Display        *disp;
	Window          win;
	GC              gc;
	int             x, y;
	int             width, height;
	double          boxwidth, boxheight;
	int             boxthick;
	double          xlsize, xlar;
{
	XoDrawToggleBox (disp, win, gc, x, y, width, height,
			   boxwidth, boxheight, boxthick);

	XoDrawBoxedXlogo (disp, win, gc, x, y, width, height,
			    xlsize, xlar);
}


#define XMNPOINTS	5
static float    xmpoints1[XMNPOINTS][2] = {
	{0, 0.95},
	{0.05, 1},
	{1, 0.1},
	{0.9, 0},
	{0, 0.95},
};
static float    xmpoints2[XMNPOINTS][2] = {
	{1, 0.95},
	{0.95, 1},
	{0, 0.1},
	{0.1, 0},
	{1, 0.95},
};


void 
XoOutlineXmark (disp, win, gc, x, y, width, height)
	Display        *disp;
	Window          win;
	GC              gc;
	int             x, y;
	int             width, height;
{
	XoOutlineShape (disp, win, gc, xmpoints1, XMNPOINTS, x, y, width, height);
	XoOutlineShape (disp, win, gc, xmpoints2, XMNPOINTS, x, y, width, height);
}

void 
XoFillXmark (disp, win, gc, x, y, width, height)
	Display        *disp;
	Window          win;
	GC              gc;
	int             x, y;
	int             width, height;
{
	XoFillShape (disp, win, gc, xmpoints1, XMNPOINTS, x, y, width, height);
	XoFillShape (disp, win, gc, xmpoints2, XMNPOINTS, x, y, width, height);
}

void 
XoDrawXmark (disp, win, gc, x, y, width, height)
	Display        *disp;
	Window          win;
	GC              gc;
	int             x, y;
	int             width, height;
{
	XoDrawShape (disp, win, gc, xmpoints1, XMNPOINTS, x, y, width, height);
	XoDrawShape (disp, win, gc, xmpoints2, XMNPOINTS, x, y, width, height);
}

void 
XoDrawBoxedXmark (disp, win, gc, x, y, width, height,
		    xmsize, xmar)
	Display        *disp;
	Window          win;
	GC              gc;
	int             x, y;
	int             width, height;
	double          xmsize, xmar;
{
	int             xmwidth, xmheight;
	XGCValues       backup, xgcv;

	if (xmar < 0 || xmsize <= 0)
		return;

	if (xmar == 0)
		xmar = 1;
	xmwidth = XoMaybeScale (xmsize, (xmar * width > height) ?
				  nint (height / xmar) : width);
	xmheight = nint (xmar * xmwidth);

	XGetGCValues (disp, gc, GCLineWidth, &backup);
	if (backup.line_width != 0)
	{
		xgcv.line_width = 0;
		XChangeGC (disp, gc, GCLineWidth, &xgcv);
	}

	XoDrawXmark (disp, win, gc,
	      x + (width - xmwidth) / 2, nint (y + (height - xmheight) / 2),
		       xmwidth, xmheight);

	if (backup.line_width != 0)
	{
		XChangeGC (disp, gc, GCLineWidth, &backup);
	}
}

void 
XoDrawBoxWithXmark (disp, win, gc, x, y, width, height,
		      boxwidth, boxheight, boxthick,
		      xmsize, xmar)
	Display        *disp;
	Window          win;
	GC              gc;
	int             x, y;
	int             width, height;
	double          boxwidth, boxheight;
	int             boxthick;
	double          xmsize, xmar;
{
	XoDrawToggleBox (disp, win, gc, x, y, width, height,
			   boxwidth, boxheight, boxthick);

	XoDrawBoxedXmark (disp, win, gc, x, y, width, height,
			    xmsize, xmar);
}

/*
 *
 * Note:
 *
 * "For both EvenOddRule and WindingRule, a point is infinitely
 * small, and the path is an infinitely thin line. A pixel is
 * inside if the center point of the pixel is inside and the
 * center point is not on the boundary. If the center point is
 * on the boundary, the pixel is inside if and only if the
 * polygon interior is immediately to its right (x increasing
 * direction). Pixels with centers on a horizontal edge are a
 * special case and are inside if and only if the polygon inte-
 * rior is immediately below (y increasing direction)."
 *
 * the xadj and yadj terms are used to compensate for the insideness of
 * border pixels.
 */

void 
XoDrawShadowRect (disp, win, brightgc, darkgc,
		    x, y, width, height, thick, sunshine, outnotin)
	Display        *disp;
	Window          win;
	GC              brightgc, darkgc;
	int             x, y;
	int             width, height;
	int             thick;
	int             sunshine, outnotin;

#define PUR(i,xadj,yadj) verts[i].x = x+xadj+width-1; \
				verts[i].y = y+yadj
#define PUL(i,xadj,yadj) verts[i].x = x+xadj; \
				verts[i].y = y+yadj
#define PLL(i,xadj,yadj) verts[i].x = x+xadj; \
				verts[i].y = y+yadj+height-1
#define PLR(i,xadj,yadj) verts[i].x = x+xadj+width-1; \
				verts[i].y = y+yadj+height-1
#define PURI(i,xadj,yadj) verts[i].x = x+xadj+width-thick; \
				verts[i].y = y+yadj+thick-1
#define PULI(i,xadj,yadj) verts[i].x = x+xadj+thick-1; \
				verts[i].y = y+yadj+thick-1
#define PLLI(i,xadj,yadj) verts[i].x = x+xadj+thick-1; \
				verts[i].y = y+yadj+height-thick
#define PLRI(i,xadj,yadj) verts[i].x = x+xadj+width-thick; \
				verts[i].y = y+yadj+height-thick
{
	XPoint          verts[5];
	XGCValues       back1, back2, xgcv;
	GC              whichgc;

	outnotin = (outnotin != 0);	/* convert to true boolean quantity */
	sunshine = sunshine % (360 * 64);
	if (sunshine < 0)
		sunshine += 360 * 64;

	xgcv.line_width = 0;

	if (brightgc)
	{
		XGetGCValues (disp, brightgc, GCLineWidth, &back1);
		if (back1.line_width != 0)
			XChangeGC (disp, brightgc, GCLineWidth, &xgcv);
	}

	if (darkgc)
	{
		XGetGCValues (disp, darkgc, GCLineWidth, &back2);
		if (back2.line_width != 0)
			XChangeGC (disp, darkgc, GCLineWidth, &xgcv);
	}

	/*
	 * /| / | | | | | \ | \|
	 */
	whichgc = (outnotin == (sunshine <= 90 * 64 || sunshine > 270 * 64)) ?
		brightgc : darkgc;
	if (whichgc)
	{
		PLR (0, 1, 1);
		PUR (1, 1, 0);
		PURI (2, 0, 1);
		PLRI (3, 0, 0);
		PLR (4, 1, 1);
		XFillPolygon (disp, win, whichgc, verts, 5, Convex, CoordModeOrigin);
	}

	/*
	 * _______ \_____/
	 */
	whichgc = (outnotin == (sunshine <= 180 * 64 && sunshine > 0 * 64)) ?
		brightgc : darkgc;
	if (whichgc)
	{
		PUR (0, 1, 0);
		PUL (1, 1, 0);
		PULI (2, 2, 1);
		PURI (3, 0, 1);
		PUR (4, 1, 0);
		XFillPolygon (disp, win, whichgc, verts, 5, Convex, CoordModeOrigin);
	}

	/*
	 * |\ | \ | | | | | / |/
	 */
	whichgc = (outnotin == (sunshine <= 270 * 64 && sunshine > 90 * 64)) ?
		brightgc : darkgc;
	if (whichgc)
	{
		PUL (0, 0, -1);
		PLL (1, 0, 0);
		PLLI (2, 1, -1);
		PULI (3, 1, 0);
		PUL (4, 0, -1);
		XFillPolygon (disp, win, whichgc, verts, 5, Convex, CoordModeOrigin);
	}

	/*
	 * _______ /_______\
	 */
	whichgc = (outnotin == (sunshine <= 0 * 64 || sunshine > 180 * 64)) ?
		brightgc : darkgc;
	if (whichgc)
	{
		PLL (0, -1, 1);
		PLR (1, 1, 1);
		PLRI (2, 0, 0);
		PLLI (3, 0, 0);
		PLL (4, -1, 1);
		XFillPolygon (disp, win, whichgc, verts, 5, Convex, CoordModeOrigin);
	}

	if (brightgc && back1.line_width != 0)
		XChangeGC (disp, brightgc, GCLineWidth, &back1);
	if (darkgc && back2.line_width != 0)
		XChangeGC (disp, darkgc, GCLineWidth, &back2);
}


/* with the diamond, we draw lines where the XFillPolygon would fail
   to draw points on the edge of the polygon.  This way we get the full
   polygon, edge points and all.  I'm sure some servers have screwy or
   non-standard semantics and this ends up looking stupid, I don't really
   care.
   */

void 
XoDrawShadowDiamond (disp, win, brightgc, darkgc,
		       x, y, width, height, thick, sunshine, outnotin)
	Display        *disp;
	Window          win;
	GC              brightgc, darkgc;
	int             x, y;
	int             width, height;
	int             thick;
	int             sunshine, outnotin;
{
	XPoint          verts[5];
	XGCValues       back1, back2, xgcv;
	GC              whichgc;

	outnotin = (outnotin != 0);	/* convert to true boolean quantity */
	sunshine = sunshine % (360 * 64);
	if (sunshine < 0)
		sunshine += 360 * 64;

	xgcv.line_width = 0;
	if (brightgc)
	{
		XGetGCValues (disp, brightgc, GCLineWidth, &back1);
		if (back1.line_width != 0)
			XChangeGC (disp, brightgc, GCLineWidth, &xgcv);
	}
	if (darkgc)
	{
		XGetGCValues (disp, darkgc, GCLineWidth, &back2);
		if (back2.line_width != 0)
			XChangeGC (disp, darkgc, GCLineWidth, &xgcv);
	}

	/*
	 * |\ \ \ \_\
	 */
	whichgc = (outnotin == (sunshine <= 135 * 64 || sunshine > 315 * 64)) ?
		brightgc : darkgc;
	if (whichgc)
	{
		verts[0].x = x + width - thick;
		verts[0].y = y + (height - 1) / 2;
		verts[1].x = x + width - 1;
		verts[1].y = verts[0].y;
		verts[2].x = x + width / 2;
		verts[2].y = y;
		verts[3].x = verts[2].x;
		verts[3].y = y + thick - 1;
		verts[4].x = verts[0].x;
		verts[4].y = verts[0].y;
		XFillPolygon (disp, win, brightgc, verts, 5, Convex, CoordModeOrigin);
		XDrawLines (disp, win, brightgc, verts, 3, CoordModeOrigin);
	}

	/*
	 * /| / / /_/
	 */
	whichgc = (outnotin == (sunshine <= 225 * 64 && sunshine > 45 * 64)) ?
		brightgc : darkgc;
	if (whichgc)
	{
		verts[0].x = x;
		verts[0].y = y + (height - 1) / 2;
		verts[1].x = x + thick - 1;
		verts[1].y = verts[0].y;
		verts[2].x = x + (width - 1) / 2;
		verts[2].y = y + thick - 1;
		verts[3].x = verts[2].x;
		verts[3].y = y;
		verts[4].x = verts[0].x;
		verts[4].y = verts[0].y;
		XFillPolygon (disp, win, brightgc, verts, 5, Convex, CoordModeOrigin);
		XDrawLines (disp, win, brightgc, verts, 4, CoordModeOrigin);
	}

	/*
	 * __ \ \ \ | \|
	 */
	whichgc = (outnotin == (sunshine <= 315 * 64 && sunshine > 135 * 64)) ?
		brightgc : darkgc;
	if (whichgc)
	{
		verts[0].x = x + (width - 1) / 2;
		verts[0].y = y + height - 1;
		verts[1].x = verts[0].x;
		verts[1].y = y + height - thick;
		verts[2].x = x + thick - 1;
		verts[2].y = y + height / 2;
		verts[3].x = x;
		verts[3].y = verts[2].y;
		verts[4].x = verts[0].x;
		verts[4].y = verts[0].y;
		XFillPolygon (disp, win, darkgc, verts, 5, Convex, CoordModeOrigin);
		XDrawLines (disp, win, darkgc, verts, 3, CoordModeOrigin);
	}

	/*
	 * __ / / | / |/
	 */
	whichgc = (outnotin == (sunshine <= 45 * 64 || sunshine > 225 * 64)) ?
		brightgc : darkgc;
	if (whichgc)
	{
		verts[0].x = x + width / 2;
		verts[0].y = y + height - 1;
		verts[1].x = x + width - 1;
		verts[1].y = y + height / 2;
		verts[2].x = x + width - thick;
		verts[2].y = verts[1].y;
		verts[3].x = verts[0].x;
		verts[3].y = y + height - thick;
		verts[4].x = verts[0].x;
		verts[4].y = verts[0].y;
		XFillPolygon (disp, win, darkgc, verts, 5, Convex, CoordModeOrigin);
		XDrawLines (disp, win, darkgc, verts, 2, CoordModeOrigin);
	}

	if (brightgc && back1.line_width != 0)
		XChangeGC (disp, brightgc, GCLineWidth, &back1);
	if (darkgc && back2.line_width != 0)
		XChangeGC (disp, darkgc, GCLineWidth, &back2);
}


void 
XoDrawShadowEllipse (disp, win, brightgc, darkgc,
		       x, y, width, height, thick, sunshine, outnotin)
	Display        *disp;
	Window          win;
	GC              brightgc, darkgc;
	int             x, y;
	int             width, height;
	int             thick;
	int             sunshine, outnotin;
{
	GC              temp;
	XGCValues       back1, back2, xgcv;
	long            gcm;

	gcm = GCCapStyle | GCLineWidth;
	xgcv.line_width = thick;
	xgcv.cap_style = CapNotLast;
	if (!outnotin)
	{
		temp =  brightgc;
		brightgc = darkgc;
		darkgc = temp;
	}
	if (brightgc)
	{
		XGetGCValues (disp, brightgc, gcm, &back1);
		if (back1.line_width != xgcv.line_width || back1.cap_style != xgcv.cap_style)
			XChangeGC (disp, brightgc, gcm, &xgcv);
	}
	if (darkgc)
	{
		XGetGCValues (disp, darkgc, gcm, &back2);
		if (back2.line_width != xgcv.line_width || back2.cap_style != xgcv.cap_style)
			XChangeGC (disp, darkgc, gcm, &xgcv);
	}

	if (brightgc)
		XDrawArc (disp, win, brightgc, x + thick / 2, y + thick / 2,
			  width - thick, height - thick,
			  sunshine - 90 * 64, 180 * 64);

	if (darkgc)
		XDrawArc (disp, win, darkgc, x + thick / 2, y + thick / 2,
			  width - thick, height - thick,
			  sunshine + 90 * 64, 180 * 64);

	if (brightgc &&
	    (back1.line_width != xgcv.line_width || back1.cap_style != xgcv.cap_style))
		XChangeGC (disp, brightgc, gcm, &back1);
	if (darkgc &&
	    (back2.line_width != xgcv.line_width || back2.cap_style != xgcv.cap_style))
		XChangeGC (disp, darkgc, gcm, &back2);
}
